/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.actions;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.menu.CidsUiAction;
import de.cismet.tools.gui.menu.CidsUiActionProvider;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class MapMenuActionProvider
implements CidsUiActionProvider {
    private static final Logger LOG = Logger.getLogger(MapMenuActionProvider.class);
    private static String cismapDirectory;

    public static void setCismapDirectory(String cismapDirectory) {
        MapMenuActionProvider.cismapDirectory = cismapDirectory;
    }

    public List<CidsUiAction> getActions() {
        ArrayList<CidsUiAction> actionList = new ArrayList<CidsUiAction>();
        actionList.add(new RemoveAllObjectsAction());
        actionList.add(new RemoveSelectedObjectAction());
        actionList.add(new ZoomToAllAction());
        actionList.add(new ZoomToSelectionAction());
        return actionList;
    }

    private static class RemoveAllObjectsAction
    extends AbstractAction
    implements CidsUiAction {
        public RemoveAllObjectsAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/removeAll.png")));
            this.putValue("Name", NbBundle.getMessage(MapMenuActionProvider.class, (String)"MapMenuActionProvider.RemoveAllObjectsAction.initAction.title"));
            this.putValue("ShortDescription", NbBundle.getMessage(MapMenuActionProvider.class, (String)"MapMenuActionProvider.RemoveAllObjectsAction.initAction.tooltip"));
            this.putValue("CidsActionKey", "cismap.remove.all");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
            if (mapC != null) {
                ArrayList v = new ArrayList(mapC.getFeatureCollection().getAllFeatures());
                mapC.getFeatureCollection().removeFeatures(v);
            }
        }
    }

    private static class RemoveSelectedObjectAction
    extends AbstractAction
    implements CidsUiAction {
        public RemoveSelectedObjectAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/removerow.png")));
            this.putValue("Name", NbBundle.getMessage(MapMenuActionProvider.class, (String)"MapMenuActionProvider.RemoveSelectedObjectAction.initAction.title"));
            this.putValue("ShortDescription", NbBundle.getMessage(MapMenuActionProvider.class, (String)"MapMenuActionProvider.RemoveSelectedObjectAction.initAction.tooltip"));
            this.putValue("CidsActionKey", "cismap.remove.selection");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
            if (mapC != null) {
                ArrayList v = new ArrayList(mapC.getFeatureCollection().getSelectedFeatures());
                mapC.getFeatureCollection().removeFeatures(v);
            }
        }
    }

    private static class ZoomToAllAction
    extends AbstractAction
    implements CidsUiAction {
        public ZoomToAllAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/zoomToAll.png")));
            this.putValue("Name", NbBundle.getMessage(MapMenuActionProvider.class, (String)"MapMenuActionProvider.ZoomToAllAction.initAction.title"));
            this.putValue("ShortDescription", NbBundle.getMessage(MapMenuActionProvider.class, (String)"MapMenuActionProvider.ZoomToAllAction.initAction.tooltip"));
            this.putValue("CidsActionKey", "cismap.zoom.all");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
            if (mapC != null) {
                mapC.zoomToFeatureCollection();
            }
        }
    }

    private static class ZoomToSelectionAction
    extends AbstractAction
    implements CidsUiAction {
        public ZoomToSelectionAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/zoomToSelection.png")));
            this.putValue("Name", NbBundle.getMessage(MapMenuActionProvider.class, (String)"MapMenuActionProvider.ZoomToSelectionAction.initAction.title"));
            this.putValue("ShortDescription", NbBundle.getMessage(MapMenuActionProvider.class, (String)"MapMenuActionProvider.ZoomToSelectionAction.initAction.tooltip"));
            this.putValue("CidsActionKey", "cismap.zoom.selection");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
            if (mapC != null) {
                mapC.zoomToSelection();
            }
        }
    }
}

