/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.actions;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.menu.CidsUiAction;
import de.cismet.tools.gui.menu.CidsUiActionProvider;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class NodeActionProvider
implements CidsUiActionProvider {
    private static final Logger LOG = Logger.getLogger(NodeActionProvider.class);
    private static String cismapDirectory;

    public static void setCismapDirectory(String cismapDirectory) {
        NodeActionProvider.cismapDirectory = cismapDirectory;
    }

    public List<CidsUiAction> getActions() {
        ArrayList<CidsUiAction> actionList = new ArrayList<CidsUiAction>();
        actionList.add(new NodeAddAction());
        actionList.add(new NodeMoveAction());
        actionList.add(new NodeReflectAction());
        actionList.add(new NodeRemoveAction());
        actionList.add(new NodeRotateAction());
        return actionList;
    }

    private static class NodeReflectAction
    extends AbstractAction
    implements CidsUiAction {
        public NodeReflectAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/mirror.png")));
            this.putValue("ShortDescription", NbBundle.getMessage(NodeActionProvider.class, (String)"NodeActionProvider.NodeReflectAction.initAction.tooltip"));
            this.putValue("SwingSelectedKey", true);
            this.putValue("CidsActionKey", "NodeReflectAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
            if (mapC != null) {
                mapC.setHandleInteractionMode("REFLECT_POLYGON");
                mapC.setInteractionMode("SELECT");
            }
        }
    }

    private static class NodeRotateAction
    extends AbstractAction
    implements CidsUiAction {
        public NodeRotateAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/rotate.png")));
            this.putValue("ShortDescription", NbBundle.getMessage(NodeActionProvider.class, (String)"NodeActionProvider.NodeRotateAction.initAction.tooltip"));
            this.putValue("SwingSelectedKey", true);
            this.putValue("CidsActionKey", "NodeRotateAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
            if (mapC != null) {
                mapC.setHandleInteractionMode("ROTATE_POLYGON");
                mapC.setInteractionMode("SELECT");
            }
        }
    }

    private static class NodeRemoveAction
    extends AbstractAction
    implements CidsUiAction {
        public NodeRemoveAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/removeNodes.png")));
            this.putValue("ShortDescription", NbBundle.getMessage(NodeActionProvider.class, (String)"NodeActionProvider.NodeRemoveAction.initAction.tooltip"));
            this.putValue("SwingSelectedKey", true);
            this.putValue("CidsActionKey", "NodeRemoveAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
            if (mapC != null) {
                mapC.setHandleInteractionMode("REMOVE_HANDLE");
                mapC.setInteractionMode("SELECT");
            }
        }
    }

    private static class NodeAddAction
    extends AbstractAction
    implements CidsUiAction {
        public NodeAddAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/insertNodes.png")));
            this.putValue("ShortDescription", NbBundle.getMessage(NodeActionProvider.class, (String)"NodeActionProvider.NodeAddAction.initAction.tooltip"));
            this.putValue("SwingSelectedKey", true);
            this.putValue("CidsActionKey", "NodeAddAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
            if (mapC != null) {
                mapC.setHandleInteractionMode("ADD_HANDLE");
                mapC.setInteractionMode("SELECT");
            }
        }
    }

    private static class NodeMoveAction
    extends AbstractAction
    implements CidsUiAction {
        public NodeMoveAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/moveNodes.png")));
            this.putValue("ShortDescription", NbBundle.getMessage(NodeActionProvider.class, (String)"NodeActionProvider.NodeMoveAction.initAction.tooltip"));
            this.putValue("SwingSelectedKey", true);
            this.putValue("CidsActionKey", "NodeMoveAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
            if (mapC != null) {
                mapC.setHandleInteractionMode("MOVE_HANDLE");
                mapC.setInteractionMode("SELECT");
            }
        }
    }
}

