/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.actions;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.CustomAction;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.menu.CidsUiComponent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class RedoComponent
extends JButton
implements CidsUiComponent,
Observer {
    private static final Logger LOG = Logger.getLogger(RedoComponent.class);

    public RedoComponent() {
        this.setAction(new RedoAction());
        this.setEnabled(false);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
        if (mapC != null) {
            ((Observable)mapC.getMemRedo()).addObserver(this);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
        if (o.equals(mapC.getMemRedo())) {
            if (arg.equals("ACTIVATE") && !this.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"activate REDO button");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RedoComponent.this.setEnabled(true);
                    }
                });
            } else if (arg.equals("DEACTIVATE") && this.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"deactivate REDO button");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RedoComponent.this.setEnabled(false);
                    }
                });
            }
        }
    }

    public String getValue(String key) {
        return "RedoAction";
    }

    public Component getComponent() {
        return this;
    }

    private class RedoAction
    extends AbstractAction {
        public RedoAction() {
            String tooltip = NbBundle.getMessage(RedoComponent.class, (String)"RedoAction.toolTipText");
            this.putValue("ShortDescription", tooltip);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/redo.png")));
            this.putValue("SwingLargeIconKey", new ImageIcon(this.getClass().getResource("/images/redo.png")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
            if (mapC != null) {
                LOG.info((Object)"REDO");
                CustomAction a = mapC.getMemRedo().getLastAction();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("... execute action: " + a.info()));
                }
                try {
                    a.doAction();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while executing an action", (Throwable)ex);
                }
                CustomAction inverse = a.getInverse();
                mapC.getMemUndo().addAction(inverse);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("... new action on UNDO stack: " + inverse));
                    LOG.debug((Object)"... completed");
                }
            }
        }
    }
}

