/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.actions;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.CustomAction;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.menu.CidsUiComponent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class UndoComponent
extends JButton
implements CidsUiComponent,
Observer {
    private static final Logger LOG = Logger.getLogger(UndoComponent.class);

    public UndoComponent() {
        this.setAction(new UndoAction());
        this.setEnabled(false);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
        if (mapC != null) {
            ((Observable)mapC.getMemUndo()).addObserver(this);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
        if (o.equals(mapC.getMemUndo())) {
            if (arg.equals("ACTIVATE") && !this.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"activate UNDO button");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UndoComponent.this.setEnabled(true);
                    }
                });
            } else if (arg.equals("DEACTIVATE") && this.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"deactivate UNDO button");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UndoComponent.this.setEnabled(false);
                    }
                });
            }
        }
    }

    public String getValue(String key) {
        return "UndoAction";
    }

    public Component getComponent() {
        return this;
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            String tooltip = NbBundle.getMessage(UndoComponent.class, (String)"UndoAction.toolTipText");
            this.putValue("ShortDescription", tooltip);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/undo.png")));
            this.putValue("SwingLargeIconKey", new ImageIcon(this.getClass().getResource("/images/undo.png")));
            this.putValue("CidsActionKey", "UndoAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
            if (mapC != null) {
                LOG.info((Object)"UNDO");
                CustomAction a = mapC.getMemUndo().getLastAction();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("... execute action: " + a.info()));
                }
                try {
                    a.doAction();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while executing action", (Throwable)ex);
                }
                CustomAction inverse = a.getInverse();
                mapC.getMemRedo().addAction(inverse);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("... new action on REDO stack: " + inverse));
                    LOG.debug((Object)"... completed");
                }
            }
        }
    }
}

