/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.export_map_actions;

import Sirius.navigator.ui.ComponentRegistry;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.ClipboardWaitDialog;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.PixelDPICalculator;
import de.cismet.cismap.navigatorplugin.export_map_actions.DefaultExportMapDataProvider;
import de.cismet.cismap.navigatorplugin.export_map_actions.ExportMapDataProvider;
import java.awt.Frame;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public abstract class AbstractExportMapAction
extends AbstractAction {
    private static final ImageIcon clipboardIcon = new ImageIcon(AbstractExportMapAction.class.getResource("/images/clipboard.png"));
    private static final ImageIcon clipboardIcon16 = new ImageIcon(AbstractExportMapAction.class.getResource("/images/clipboard16.png"));
    private static final Logger LOG = Logger.getLogger(AbstractExportMapAction.class);
    ClipboardWaitDialog clipboarder;
    ExportMapDataProvider exportMapDataProvider;
    private MappingComponent mapC;

    public AbstractExportMapAction(ExportMapDataProvider exportMapDataProvider) {
        JFrame mainWindow;
        this.exportMapDataProvider = exportMapDataProvider == null ? new DefaultExportMapDataProvider() : exportMapDataProvider;
        this.putValue("SmallIcon", clipboardIcon16);
        this.putValue("SwingLargeIconKey", clipboardIcon);
        try {
            mainWindow = ComponentRegistry.getRegistry().getMainWindow();
        }
        catch (Exception ex) {
            LOG.error((Object)"An exception occured in the constructor of AbstractExportMapAction", (Throwable)ex);
            mainWindow = null;
        }
        this.clipboarder = new ClipboardWaitDialog((Frame)mainWindow, true);
    }

    Object[] getFutureImageFromMapViaHeadlessMapProvider() {
        PixelDPICalculator pixelDPICalculator = new PixelDPICalculator(this.getMapC().getWidth(), this.getMapC().getHeight(), 72);
        HeadlessMapProvider headlessMapProvider = HeadlessMapProvider.createHeadlessMapProviderAndAddLayers((MappingComponent)this.getMapC());
        headlessMapProvider.setDominatingDimension(HeadlessMapProvider.DominatingDimension.BOUNDINGBOX);
        headlessMapProvider.setBoundingBox((XBoundingBox)this.getMapC().getCurrentBoundingBoxFromCamera());
        int newDpi = this.exportMapDataProvider.getDpi();
        if (newDpi != 72) {
            pixelDPICalculator.setDPI(newDpi);
        }
        Future futureImage = headlessMapProvider.getImage(pixelDPICalculator.getWidthPixel(), pixelDPICalculator.getHeightPixel());
        return new Object[]{futureImage, headlessMapProvider};
    }

    public MappingComponent getMapC() {
        if (this.mapC == null) {
            this.mapC = CismapBroker.getInstance().getMappingComponent();
        }
        return this.mapC;
    }
}

