/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.metasearch;

import Sirius.navigator.resource.PropertyManager;
import Sirius.navigator.search.CidsSearchExecutor;
import Sirius.navigator.ui.RightStickyToolbarItem;
import de.cismet.cids.navigator.utils.CidsClientToolbarItem;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.server.search.SearchResultListener;
import de.cismet.cids.server.search.SearchResultListenerProvider;
import de.cismet.cids.server.search.builtin.FullTextSearch;
import de.cismet.cismap.navigatorplugin.metasearch.MetaSearch;
import de.cismet.cismap.navigatorplugin.metasearch.MetaSearchListener;
import de.cismet.cismap.navigatorplugin.metasearch.MetaSearchListenerEvent;
import de.cismet.cismap.navigatorplugin.metasearch.SearchSearchTopicsDialog;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopic;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopicsDialogModel;
import de.cismet.cismap.navigatorplugin.protocol.FulltextSearchProtocolStepImpl;
import de.cismet.commons.gui.protocol.ProtocolHandler;
import de.cismet.commons.gui.protocol.ProtocolStep;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.JSearchTextField;
import de.cismet.tools.gui.menu.CidsUiComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FulltextSearchToolbarItem
extends JPanel
implements CidsClientToolbarItem,
RightStickyToolbarItem,
ConnectionContextStore,
CidsUiComponent {
    public static final ImageIcon ICON_SEARCH = new ImageIcon(FulltextSearchToolbarItem.class.getResource("/de/cismet/cismap/navigatorplugin/metasearch/search.png"));
    public static final ImageIcon ICON_SEARCH_CASE = new ImageIcon(FulltextSearchToolbarItem.class.getResource("/de/cismet/cismap/navigatorplugin/metasearch/search_casesensitive.png"));
    public static final ImageIcon ICON_SEARCH_GEOM = new ImageIcon(FulltextSearchToolbarItem.class.getResource("/de/cismet/cismap/navigatorplugin/metasearch/search_geom.png"));
    public static final ImageIcon ICON_SEARCH_BOTH = new ImageIcon(FulltextSearchToolbarItem.class.getResource("/de/cismet/cismap/navigatorplugin/metasearch/search_geom_casesensitive.png"));
    private JSearchTextField jSearchTextField1;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        Collection<SearchTopic> searchTopics = MetaSearch.instance().getSelectedSearchTopics();
        String tooltipText = this.determineTooltipText(searchTopics);
        String emptyText = this.determineEmptyText(searchTopics);
        this.jSearchTextField1.setEmptyText(emptyText);
        this.jSearchTextField1.setToolTipText(tooltipText);
        this.jSearchTextField1.setEnabled(!searchTopics.isEmpty());
        ImageIcon icon = this.determineSearchIcon(SearchSearchTopicsDialog.instance().getModel().isCaseSensitiveEnabled(), SearchSearchTopicsDialog.instance().getModel().isSearchGeometryEnabled());
        this.jSearchTextField1.setSearchIcon((Icon)icon);
        MetaSearch.instance().addMetaSearchListener(new MetaSearchListener(){

            @Override
            public void topicAdded(MetaSearchListenerEvent event) {
                FulltextSearchToolbarItem.this.refreshSelectedSearchTopics();
            }

            @Override
            public void topicsAdded(MetaSearchListenerEvent event) {
                FulltextSearchToolbarItem.this.refreshSelectedSearchTopics();
            }

            @Override
            public void topicRemoved(MetaSearchListenerEvent event) {
                FulltextSearchToolbarItem.this.refreshSelectedSearchTopics();
            }

            @Override
            public void topicsRemoved(MetaSearchListenerEvent event) {
                FulltextSearchToolbarItem.this.refreshSelectedSearchTopics();
            }

            @Override
            public void topicSelectionChanged(MetaSearchListenerEvent event) {
                FulltextSearchToolbarItem.this.refreshSelectedSearchTopics();
            }
        });
        SearchSearchTopicsDialog.instance().getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String prop = evt.getPropertyName();
                if ("caseSensitiveEnabled".equals(prop)) {
                    ImageIcon icon = FulltextSearchToolbarItem.this.determineSearchIcon(((SearchTopicsDialogModel)evt.getSource()).isCaseSensitiveEnabled(), ((SearchTopicsDialogModel)evt.getSource()).isSearchGeometryEnabled());
                    FulltextSearchToolbarItem.this.jSearchTextField1.setSearchIcon((Icon)icon);
                    FulltextSearchToolbarItem.this.jSearchTextField1.repaint();
                } else if ("searchGeometryEnabled".equals(prop)) {
                    ImageIcon icon = FulltextSearchToolbarItem.this.determineSearchIcon(((SearchTopicsDialogModel)evt.getSource()).isCaseSensitiveEnabled(), ((SearchTopicsDialogModel)evt.getSource()).isSearchGeometryEnabled());
                    FulltextSearchToolbarItem.this.jSearchTextField1.setSearchIcon((Icon)icon);
                    FulltextSearchToolbarItem.this.jSearchTextField1.repaint();
                } else if ("searchText".equals(prop)) {
                    FulltextSearchToolbarItem.this.jSearchTextField1.setText(((SearchTopicsDialogModel)evt.getSource()).getSearchText());
                    FulltextSearchToolbarItem.this.jSearchTextField1.repaint();
                }
            }
        });
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private void refreshSelectedSearchTopics() {
        Collection<SearchTopic> searchTopics = MetaSearch.instance().getSelectedSearchTopics();
        String tooltipText = this.determineTooltipText(searchTopics);
        String emptyText = this.determineEmptyText(searchTopics);
        this.jSearchTextField1.setEmptyText(emptyText);
        this.jSearchTextField1.setToolTipText(tooltipText);
        this.jSearchTextField1.setEnabled(!searchTopics.isEmpty());
        this.jSearchTextField1.repaint();
    }

    private void initComponents() {
        this.jSearchTextField1 = new JSearchTextField();
        this.setMaximumSize(new Dimension(200, 31));
        this.setMinimumSize(new Dimension(200, 27));
        this.setPreferredSize(new Dimension(200, 27));
        this.setLayout(new GridBagLayout());
        this.jSearchTextField1.setText(NbBundle.getMessage(FulltextSearchToolbarItem.class, (String)"FulltextSearchToolbarItem.jSearchTextField1.text"));
        this.jSearchTextField1.setAbortIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cismap/navigatorplugin/metasearch/search_abort.png")));
        this.jSearchTextField1.setSearchIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cismap/navigatorplugin/metasearch/search.png")));
        this.jSearchTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FulltextSearchToolbarItem.this.jSearchTextField1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSearchTextField1, gridBagConstraints);
    }

    private ImageIcon determineSearchIcon(boolean caseSensitiveEnabled, boolean mapSearchEnabled) {
        if (caseSensitiveEnabled && mapSearchEnabled) {
            return ICON_SEARCH_BOTH;
        }
        if (caseSensitiveEnabled && !mapSearchEnabled) {
            return ICON_SEARCH_CASE;
        }
        if (mapSearchEnabled) {
            return ICON_SEARCH_GEOM;
        }
        return ICON_SEARCH;
    }

    final String determineTooltipText(Collection<SearchTopic> searchTopics) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (SearchTopic searchTopic : searchTopics) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(searchTopic.getName());
        }
        String searchTopicsString = sb.toString();
        if (searchTopicsString.isEmpty()) {
            return NbBundle.getMessage(FulltextSearchToolbarItem.class, (String)"FulltextSearchToolbarItem.notopicsselected.text");
        }
        return NbBundle.getMessage(FulltextSearchToolbarItem.class, (String)"FulltextSearchToolbarItem.searchwithin.text") + searchTopicsString;
    }

    final String determineEmptyText(Collection<SearchTopic> searchTopics) {
        if (searchTopics.isEmpty()) {
            return NbBundle.getMessage(FulltextSearchToolbarItem.class, (String)"FulltextSearchToolbarItem.notopicsselected.text");
        }
        if (searchTopics.size() == 1) {
            return NbBundle.getMessage(FulltextSearchToolbarItem.class, (String)"FulltextSearchToolbarItem.onetopicselected.text");
        }
        return searchTopics.size() + NbBundle.getMessage(FulltextSearchToolbarItem.class, (String)"FulltextSearchToolbarItem.numoftopicsselected.text");
    }

    private void jSearchTextField1ActionPerformed(ActionEvent evt) {
        String searchText = this.jSearchTextField1.getText();
        Collection<String> searchTopics = MetaSearch.instance().getSelectedSearchClassesForQuery();
        if (searchText != null && !searchText.trim().isEmpty() && searchTopics.size() > 0) {
            SearchTopicsDialogModel model = SearchSearchTopicsDialog.instance().getModel();
            final FullTextSearch fullTextSearch = (FullTextSearch)Lookup.getDefault().lookup(FullTextSearch.class);
            fullTextSearch.setSearchText(this.jSearchTextField1.getText());
            fullTextSearch.setCaseSensitive(model.isCaseSensitiveEnabled());
            fullTextSearch.setGeometry(SearchSearchTopicsDialog.instance().createSearchGeometry());
            fullTextSearch.setValidClassesFromStrings(searchTopics);
            if (fullTextSearch instanceof SearchResultListenerProvider) {
                ((SearchResultListenerProvider)fullTextSearch).setSearchResultListener(new SearchResultListener(){

                    public void searchDone(List results) {
                        if (ProtocolHandler.getInstance().isRecordEnabled()) {
                            ProtocolHandler.getInstance().recordStep((ProtocolStep)new FulltextSearchProtocolStepImpl(fullTextSearch, MetaSearch.instance().getSelectedSearchTopics(), results));
                        }
                    }
                });
            }
            CidsSearchExecutor.searchAndDisplayResultsWithDialog((MetaObjectNodeServerSearch)fullTextSearch, (ConnectionContext)this.getConnectionContext());
        }
    }

    public String getSorterString() {
        return "ZZZ";
    }

    @Override
    public boolean isVisible() {
        return PropertyManager.getManager().isFulltextSearchToolbarItemEnabled();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setContentPane(new FulltextSearchToolbarItem());
        frame.setVisible(true);
    }

    public String getValue(String key) {
        if (key.equals("CidsActionKey")) {
            return "FulltextSearchToolbarItem";
        }
        return null;
    }

    public Component getComponent() {
        return this;
    }
}

