/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.metasearch;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.utils.MetaClassCacheService;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.MetaSearchFacade;
import de.cismet.cismap.navigatorplugin.metasearch.MetaSearchListener;
import de.cismet.cismap.navigatorplugin.metasearch.MetaSearchListenerEvent;
import de.cismet.cismap.navigatorplugin.metasearch.MetaSearchTooltip;
import de.cismet.cismap.navigatorplugin.metasearch.SearchClass;
import de.cismet.cismap.navigatorplugin.metasearch.SearchSearchTopicsDialog;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopic;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopicListener;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopicListenerEvent;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JDialog;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.Lookup;

public class MetaSearch
implements Configurable,
MetaSearchFacade,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(MetaSearch.class);
    private static final String CONF_METASEARCH = "metaSearch";
    private static final String CONF_SEARCHTOPIC = "searchTopic";
    private static final String CONF_SEARCHTOPIC_ATTR_NAME = "name";
    private static final String CONF_SEARCHTOPIC_ATTR_DESCRIPTION = "description";
    private static final String CONF_SEARCHTOPIC_ATTR_KEY = "key";
    private static final String CONF_SEARCHTOPIC_ATTR_ICON = "icon";
    private static final String CONF_SEARCHTOPIC_ATTR_SELECTED = "selected";
    private static final String CONF_SEARCHTOPIC_ATTR_CHECKACTIONTAG = "check-action-tag";
    private static final String CONF_SEARCHCLASS = "searchClass";
    private static final String CONF_SEARCHCLASS_ATTR_DOMAIN = "domain";
    private static final String CONF_SEARCHCLASS_ATTR_CIDSCLASS = "cidsClass";
    private static MetaSearch instance;
    private final Collection<SearchTopic> searchTopics = new LinkedList<SearchTopic>();
    private final MetaClassCacheService metaClassCacheService;
    private final Collection<MetaSearchListener> listeners = new ArrayList<MetaSearchListener>();
    private final ListenerHandler listenerHandler = new ListenerHandler();
    private final SearchTopicListener searchTopicListener = new SearchTopicListenerImpl();
    private final ConnectionContext connectionContext;

    private MetaSearch(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.metaClassCacheService = (MetaClassCacheService)Lookup.getDefault().lookup(MetaClassCacheService.class);
    }

    public static MetaSearch instance() {
        if (instance == null) {
            instance = new MetaSearch(ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.INSTANCE, (String)MetaSearch.class.getSimpleName()));
        }
        return instance;
    }

    public void addMetaSearchListener(MetaSearchListener listener) {
        this.listeners.add(listener);
    }

    public void removeMetaSearchListener(MetaSearchListener listener) {
        this.listeners.remove(listener);
    }

    public Collection<SearchTopic> getSearchTopics() {
        return this.searchTopics;
    }

    public Collection<SearchTopic> getSelectedSearchTopics() {
        LinkedList<SearchTopic> result = new LinkedList<SearchTopic>();
        for (SearchTopic searchTopic : this.searchTopics) {
            if (!searchTopic.isSelected()) continue;
            result.add(searchTopic);
        }
        return result;
    }

    public Collection<SearchClass> getSelectedSearchClasses() {
        LinkedList<SearchClass> result = new LinkedList<SearchClass>();
        for (SearchTopic searchTopic : this.searchTopics) {
            if (!searchTopic.isSelected()) continue;
            for (SearchClass searchClass : searchTopic.getSearchClasses()) {
                result.add(searchClass);
            }
        }
        return result;
    }

    public Collection<String> getSelectedSearchClassesForQuery() {
        LinkedList<String> result = new LinkedList<String>();
        if (this.metaClassCacheService == null) {
            LOG.error((Object)"There is no MetaClassCacheService available. Conversion from table names to CidsClass ids is not possible.");
            return result;
        }
        for (SearchTopic searchTopic : this.searchTopics) {
            if (!searchTopic.isSelected()) continue;
            for (SearchClass searchClass : searchTopic.getSearchClasses()) {
                MetaClass metaClass = this.metaClassCacheService.getMetaClass(searchClass.getCidsDomain(), searchClass.getCidsClass(), this.getConnectionContext());
                if (metaClass != null) {
                    result.add(metaClass.getKey().toString());
                    continue;
                }
                LOG.warn((Object)("Could not convert searchClass '" + searchClass.toString() + "' to a MetaClass. This searchClass will not be included in the search."));
            }
        }
        return result;
    }

    public boolean hasSearchTopics() {
        return !this.searchTopics.isEmpty();
    }

    public boolean hasSelectedSearchTopics() {
        return !this.getSelectedSearchTopics().isEmpty();
    }

    public PNode generatePointerAnnotationForSelectedSearchTopics() {
        return new MetaSearchTooltip(this.getSelectedSearchTopics());
    }

    public boolean isSearchTopicSelectedEvent(String changedPropertyName) {
        return CONF_SEARCHTOPIC_ATTR_SELECTED.equalsIgnoreCase(changedPropertyName);
    }

    public JDialog getSearchDialog() {
        return SearchSearchTopicsDialog.instance();
    }

    public void configure(Element parent) {
        if (parent == null) {
            LOG.info((Object)"There is no local configuration for meta search.");
            return;
        }
        Element metaSearch = parent.getChild(CONF_METASEARCH);
        if (metaSearch == null) {
            LOG.info((Object)"There is no local configuration for meta search.");
            return;
        }
        List<Element> searchTopicElements = this.getChildren(metaSearch, CONF_SEARCHTOPIC);
        if (searchTopicElements.isEmpty()) {
            LOG.info((Object)"There is no local configuration for meta search.");
            return;
        }
        for (Element searchTopicElement : searchTopicElements) {
            String name = searchTopicElement.getAttributeValue(CONF_SEARCHTOPIC_ATTR_NAME);
            String description = searchTopicElement.getAttributeValue(CONF_SEARCHTOPIC_ATTR_DESCRIPTION);
            String key = searchTopicElement.getAttributeValue(CONF_SEARCHTOPIC_ATTR_KEY);
            String icon = searchTopicElement.getAttributeValue(CONF_SEARCHTOPIC_ATTR_ICON);
            String selected = searchTopicElement.getAttributeValue(CONF_SEARCHTOPIC_ATTR_SELECTED);
            if (name == null || name.trim().length() == 0) {
                LOG.info((Object)("There is a search topic without a valid name. Description: '" + description + "', key: '" + key + "', icon: '" + icon + "', selected: '" + selected + "'."));
                continue;
            }
            boolean isSelected = true;
            if (selected != null && selected.trim().length() > 0 && ("false".equalsIgnoreCase(selected) || "0".equalsIgnoreCase(selected))) {
                isSelected = false;
            }
            SearchTopic searchTopic = new SearchTopic(name, description, key, icon, isSelected);
            for (SearchTopic searchTopicFromServer : this.searchTopics) {
                if (!searchTopicFromServer.equals(searchTopic)) continue;
                searchTopicFromServer.setSelected(isSelected);
            }
        }
    }

    private void clearTopics() {
        ArrayList<SearchTopic> removedTopics = new ArrayList<SearchTopic>(this.searchTopics);
        this.searchTopics.clear();
        for (SearchTopic topic : removedTopics) {
            topic.removeSearchTopicListener(this.searchTopicListener);
        }
        this.listenerHandler.topicsRemoved(new MetaSearchListenerEvent(this, 4, removedTopics));
    }

    private void removeTopic(SearchTopic topic) {
        if (this.searchTopics.remove(topic)) {
            this.listenerHandler.topicRemoved(new MetaSearchListenerEvent(this, 3, topic));
            topic.removeSearchTopicListener(this.searchTopicListener);
        }
    }

    private void addTopic(SearchTopic topic) {
        if (this.searchTopics.add(topic)) {
            topic.addSearchTopicListener(this.searchTopicListener);
            this.listenerHandler.topicAdded(new MetaSearchListenerEvent(this, 1, topic));
        }
    }

    private void addTopics(Collection<SearchTopic> topics) {
        if (this.searchTopics.addAll(topics)) {
            for (SearchTopic topic : topics) {
                topic.addSearchTopicListener(this.searchTopicListener);
            }
            this.listenerHandler.topicsAdded(new MetaSearchListenerEvent(this, 2, topics));
        }
    }

    public void masterConfigure(Element parent) {
        User currentUser;
        this.clearTopics();
        if (this.metaClassCacheService == null) {
            LOG.info((Object)"There is no MetaClassCacheService available. It's not possible to check if the current user is allowed to search for the specified classes.");
        }
        if (SessionManager.isInitialized() && SessionManager.isConnected()) {
            currentUser = SessionManager.getSession().getUser();
        } else {
            LOG.info((Object)"Could not determine current user. All search classes will be added to search.");
            currentUser = null;
        }
        if (parent == null) {
            LOG.info((Object)"The meta search isn't configured.");
            return;
        }
        Element metaSearch = parent.getChild(CONF_METASEARCH);
        if (metaSearch == null) {
            LOG.info((Object)"The meta search isn't configured.");
            return;
        }
        List<Element> searchTopicElements = this.getChildren(metaSearch, CONF_SEARCHTOPIC);
        if (searchTopicElements.isEmpty()) {
            LOG.info((Object)"There are no search topics specified. Add 'searchTopic' tags to specify search topics.");
            return;
        }
        ArrayList<SearchTopic> searchTopics = new ArrayList<SearchTopic>();
        for (Element searchTopicElement : searchTopicElements) {
            String name = searchTopicElement.getAttributeValue(CONF_SEARCHTOPIC_ATTR_NAME);
            String description = searchTopicElement.getAttributeValue(CONF_SEARCHTOPIC_ATTR_DESCRIPTION);
            String key = searchTopicElement.getAttributeValue(CONF_SEARCHTOPIC_ATTR_KEY);
            String icon = searchTopicElement.getAttributeValue(CONF_SEARCHTOPIC_ATTR_ICON);
            String selected = searchTopicElement.getAttributeValue(CONF_SEARCHTOPIC_ATTR_SELECTED);
            String checkActionTag = searchTopicElement.getAttributeValue(CONF_SEARCHTOPIC_ATTR_CHECKACTIONTAG);
            if (name == null || name.trim().length() == 0) {
                LOG.info((Object)("There is a search topic without a valid name. Description: '" + description + "', key: '" + key + "', icon: '" + icon + "', selected: '" + selected + "'."));
                continue;
            }
            boolean isSelected = false;
            if (selected != null && selected.trim().length() > 0 && ("true".equalsIgnoreCase(selected) || "1".equalsIgnoreCase(selected))) {
                isSelected = true;
            }
            SearchTopic searchTopic = new SearchTopic(name, description, key, icon, isSelected);
            List<Element> searchClassElements = this.getChildren(searchTopicElement, CONF_SEARCHCLASS);
            if (searchClassElements.isEmpty()) {
                LOG.info((Object)("There are no search classes specified for search topic '" + searchTopic.getName() + "'. This topic will be skipped."));
                continue;
            }
            for (Element searchClassElement : searchClassElements) {
                String domain = searchClassElement.getAttributeValue(CONF_SEARCHCLASS_ATTR_DOMAIN);
                String table = searchClassElement.getAttributeValue(CONF_SEARCHCLASS_ATTR_CIDSCLASS);
                if (domain == null || domain.trim().length() == 0 || table == null || table.trim().length() == 0) {
                    LOG.info((Object)("Search topic '" + searchTopic.getName() + "' contains at least one invalid search class. Domain: '" + domain + "', table: " + table + "'. This search class will be skipped."));
                    continue;
                }
                SearchClass searchClass = new SearchClass(domain, table);
                if (this.metaClassCacheService == null || currentUser == null) continue;
                MetaClass metaClass = this.metaClassCacheService.getMetaClass(searchClass.getCidsDomain(), searchClass.getCidsClass(), this.getConnectionContext());
                if (metaClass != null && metaClass.getPermissions() != null && metaClass.getPermissions().hasReadPermission(currentUser)) {
                    searchTopic.insert(searchClass);
                    continue;
                }
                LOG.info((Object)("Could not determine if user '" + currentUser + "' has read permission on '" + searchClass + "'."));
            }
            String actionTag = "st://" + key;
            boolean isEnabled = true;
            if (checkActionTag != null && checkActionTag.trim().length() > 0) {
                try {
                    boolean actionCheck = SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), actionTag, this.getConnectionContext());
                    if ("enable".equalsIgnoreCase(checkActionTag) || "1".equalsIgnoreCase(checkActionTag)) {
                        isEnabled = actionCheck;
                    } else if ("disable".equalsIgnoreCase(checkActionTag) || "0".equalsIgnoreCase(checkActionTag)) {
                        isEnabled = !actionCheck;
                    } else {
                        LOG.warn((Object)("check-action-tag neither enable nor disable: " + actionTag + ". searchtopic is disabled."));
                        isEnabled = false;
                    }
                }
                catch (ConnectionException ex) {
                    LOG.warn((Object)("could not check action tag " + actionTag + ". searchtopic is disabled."), (Throwable)ex);
                    isEnabled = false;
                }
            }
            if (isEnabled && !searchTopics.contains(searchTopic) && !searchTopic.getSearchClasses().isEmpty()) {
                searchTopics.add(searchTopic);
                continue;
            }
            LOG.info((Object)("Search topic '" + searchTopic.getName() + "' already exists or the user isn't allowed to read its classes. The search topic won't be added."));
        }
        this.addTopics(searchTopics);
    }

    public Element getConfiguration() throws NoWriteError {
        Element result = new Element(CONF_METASEARCH);
        for (SearchTopic searchTopic : this.searchTopics) {
            Element searchTopicElement = new Element(CONF_SEARCHTOPIC);
            searchTopicElement.setAttribute(CONF_SEARCHTOPIC_ATTR_NAME, searchTopic.getName());
            searchTopicElement.setAttribute(CONF_SEARCHTOPIC_ATTR_DESCRIPTION, searchTopic.getDescription());
            searchTopicElement.setAttribute(CONF_SEARCHTOPIC_ATTR_KEY, searchTopic.getKey());
            searchTopicElement.setAttribute(CONF_SEARCHTOPIC_ATTR_ICON, searchTopic.getIconName() != null ? searchTopic.getIconName() : "");
            searchTopicElement.setAttribute(CONF_SEARCHTOPIC_ATTR_SELECTED, Boolean.toString(searchTopic.isSelected()));
            result.addContent((Content)searchTopicElement);
        }
        return result;
    }

    private List<Element> getChildren(Element parent, String childrenTag) {
        LinkedList<Element> result = new LinkedList<Element>();
        List children = parent.getChildren(childrenTag);
        if (children != null) {
            for (Object child : children) {
                if (!(child instanceof Element)) continue;
                result.add((Element)child);
            }
        }
        return result;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    class SearchTopicListenerImpl
    implements SearchTopicListener {
        SearchTopicListenerImpl() {
        }

        @Override
        public void selectionChanged(SearchTopicListenerEvent event) {
            MetaSearch.this.listenerHandler.topicSelectionChanged(new MetaSearchListenerEvent(MetaSearch.this, 5, event.getSource()));
        }
    }

    class ListenerHandler
    implements MetaSearchListener {
        ListenerHandler() {
        }

        @Override
        public void topicAdded(MetaSearchListenerEvent event) {
            for (MetaSearchListener listener : MetaSearch.this.listeners) {
                listener.topicAdded(event);
            }
        }

        @Override
        public void topicsAdded(MetaSearchListenerEvent event) {
            for (MetaSearchListener listener : MetaSearch.this.listeners) {
                listener.topicsAdded(event);
            }
        }

        @Override
        public void topicRemoved(MetaSearchListenerEvent event) {
            for (MetaSearchListener listener : MetaSearch.this.listeners) {
                listener.topicRemoved(event);
            }
        }

        @Override
        public void topicsRemoved(MetaSearchListenerEvent event) {
            for (MetaSearchListener listener : MetaSearch.this.listeners) {
                listener.topicsRemoved(event);
            }
        }

        @Override
        public void topicSelectionChanged(MetaSearchListenerEvent event) {
            for (MetaSearchListener listener : MetaSearch.this.listeners) {
                listener.topicSelectionChanged(event);
            }
        }
    }
}

