/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.metasearch;

import Sirius.navigator.search.dynamic.SearchControlListener;
import Sirius.navigator.search.dynamic.SearchControlPanel;
import Sirius.navigator.ui.ComponentRegistry;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.server.search.SearchResultListener;
import de.cismet.cids.server.search.SearchResultListenerProvider;
import de.cismet.cids.server.search.builtin.FullTextSearch;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.metasearch.MetaSearch;
import de.cismet.cismap.navigatorplugin.metasearch.MetaSearchAdapter;
import de.cismet.cismap.navigatorplugin.metasearch.MetaSearchListenerEvent;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopicsDialogModel;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopicsPanel;
import de.cismet.cismap.navigatorplugin.protocol.FulltextSearchProtocolStepImpl;
import de.cismet.commons.gui.protocol.ProtocolHandler;
import de.cismet.commons.gui.protocol.ProtocolStep;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SearchSearchTopicsDialog
extends JDialog
implements SearchControlListener,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(SearchSearchTopicsDialog.class);
    private static SearchSearchTopicsDialog instance;
    private final SearchControlPanel pnlSearchCancel;
    private boolean searchRunning = false;
    private final SearchTopicsDialogModel model = new SearchTopicsDialogModel();
    private final ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JButton btnClose;
    private JCheckBox chkCaseSensitive;
    private JCheckBox chkHere;
    private Box.Filler gluBottom;
    private Box.Filler gluFiller;
    private Box.Filler gluTop;
    private JLabel lblSearchParameter;
    private JPanel pnlButtons;
    private SearchTopicsPanel pnlSearchTopics;
    private JScrollPane scpSearchTopics;
    private JSeparator sepButtons;
    private JSeparator sepSearchTopics;
    private JTextField txtSearchParameter;

    private SearchSearchTopicsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.pnlSearchCancel = new SearchControlPanel((SearchControlListener)this, this.connectionContext);
        this.pnlSearchCancel.setEnabled(false);
        this.pnlButtons.remove(this.btnClose);
        this.pnlButtons.add((Component)this.pnlSearchCancel);
        this.pnlButtons.add(this.btnClose);
        MetaSearchAdapter metaSearchListener = new MetaSearchAdapter(){

            @Override
            public void topicAdded(MetaSearchListenerEvent event) {
                SearchSearchTopicsDialog.this.refreshSearchTopics();
            }

            @Override
            public void topicsAdded(MetaSearchListenerEvent event) {
                SearchSearchTopicsDialog.this.refreshSearchTopics();
            }

            @Override
            public void topicRemoved(MetaSearchListenerEvent event) {
                SearchSearchTopicsDialog.this.refreshSearchTopics();
            }

            @Override
            public void topicsRemoved(MetaSearchListenerEvent event) {
                SearchSearchTopicsDialog.this.refreshSearchTopics();
            }
        };
        MetaSearch.instance().addMetaSearchListener(metaSearchListener);
        this.refreshSearchTopics();
        EnableSearchListener listener = new EnableSearchListener();
        this.pnlSearchTopics.registerItemListener(listener);
        this.txtSearchParameter.getDocument().addDocumentListener(listener);
        this.chkHere.addItemListener(listener);
        Dimension searchTopicsDimension = this.pnlSearchTopics.getPreferredSize();
        Dimension searchParameterDimension = this.txtSearchParameter.getPreferredSize();
        this.setMinimumSize(new Dimension((int)(searchTopicsDimension.getWidth() + searchParameterDimension.getWidth() + 75.0), (int)searchTopicsDimension.getHeight() + 100));
    }

    private void refreshSearchTopics() {
        this.pnlSearchTopics.setSearchTopics(MetaSearch.instance().getSearchTopics());
        this.pack();
    }

    public static SearchSearchTopicsDialog instance() {
        if (instance == null) {
            instance = new SearchSearchTopicsDialog((Frame)ComponentRegistry.getRegistry().getMainWindow(), true);
            instance.setLocationRelativeTo(null);
        }
        return instance;
    }

    private void initComponents() {
        this.lblSearchParameter = new JLabel();
        this.pnlButtons = new JPanel();
        this.btnClose = new JButton();
        this.chkCaseSensitive = new JCheckBox();
        this.sepButtons = new JSeparator();
        this.txtSearchParameter = new JTextField();
        this.chkHere = new JCheckBox();
        this.gluFiller = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.sepSearchTopics = new JSeparator();
        this.scpSearchTopics = new JScrollPane();
        this.pnlSearchTopics = new SearchTopicsPanel();
        this.gluTop = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.gluBottom = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.setDefaultCloseOperation(0);
        this.setTitle(NbBundle.getMessage(SearchSearchTopicsDialog.class, (String)"SearchSearchTopicsDialog.title"));
        this.setMinimumSize(new Dimension(500, 300));
        this.setModal(true);
        this.setPreferredSize(new Dimension(500, 300));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SearchSearchTopicsDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblSearchParameter.setText(NbBundle.getMessage(SearchSearchTopicsDialog.class, (String)"SearchSearchTopicsDialog.lblSearchParameter.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        this.getContentPane().add((Component)this.lblSearchParameter, gridBagConstraints);
        this.pnlButtons.setLayout(new FlowLayout(2, 5, 0));
        this.btnClose.setText(NbBundle.getMessage(SearchSearchTopicsDialog.class, (String)"SearchSearchTopicsDialog.btnClose.text"));
        this.btnClose.setFocusPainted(false);
        this.btnClose.setMaximumSize(new Dimension(100, 25));
        this.btnClose.setMinimumSize(new Dimension(59, 25));
        this.btnClose.setPreferredSize(new Dimension(100, 25));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSearchTopicsDialog.this.btnCloseActionPerformed(evt);
            }
        });
        this.pnlButtons.add(this.btnClose);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 26;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.pnlButtons, gridBagConstraints);
        this.chkCaseSensitive.setText(NbBundle.getMessage(SearchSearchTopicsDialog.class, (String)"SearchSearchTopicsDialog.chkCaseSensitive.text"));
        this.chkCaseSensitive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSearchTopicsDialog.this.chkCaseSensitiveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        this.getContentPane().add((Component)this.chkCaseSensitive, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.sepButtons, gridBagConstraints);
        this.txtSearchParameter.setText(NbBundle.getMessage(SearchSearchTopicsDialog.class, (String)"SearchSearchTopicsDialog.txtSearchParameter.text"));
        this.txtSearchParameter.setMinimumSize(new Dimension(250, 25));
        this.txtSearchParameter.setPreferredSize(new Dimension(250, 25));
        this.txtSearchParameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSearchTopicsDialog.this.txtSearchParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.getContentPane().add((Component)this.txtSearchParameter, gridBagConstraints);
        this.chkHere.setText(NbBundle.getMessage(SearchSearchTopicsDialog.class, (String)"SearchSearchTopicsDialog.chkHere.text"));
        this.chkHere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchSearchTopicsDialog.this.chkHereActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.getContentPane().add((Component)this.chkHere, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.gluFiller, gridBagConstraints);
        this.sepSearchTopics.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.sepSearchTopics, gridBagConstraints);
        this.scpSearchTopics.setBorder(null);
        this.scpSearchTopics.setViewportView(this.pnlSearchTopics);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.scpSearchTopics, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.getContentPane().add((Component)this.gluTop, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.getContentPane().add((Component)this.gluBottom, gridBagConstraints);
        this.pack();
    }

    private void txtSearchParameterActionPerformed(ActionEvent evt) {
        if (this.pnlSearchCancel.isEnabled()) {
            this.pnlSearchCancel.startSearch();
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void formWindowClosing(WindowEvent evt) {
        if (!this.searchRunning) {
            this.setVisible(false);
        }
    }

    private void chkCaseSensitiveActionPerformed(ActionEvent evt) {
        this.model.setCaseSensitiveEnabled(this.chkCaseSensitive.isSelected());
    }

    private void chkHereActionPerformed(ActionEvent evt) {
        this.model.setSearchGeometryEnabled(this.chkHere.isSelected());
    }

    public SearchTopicsDialogModel getModel() {
        return this.model;
    }

    private void switchControls() {
        if (this.searchRunning) {
            this.btnClose.setEnabled(false);
            this.txtSearchParameter.setEnabled(false);
            this.chkCaseSensitive.setEnabled(false);
            this.chkHere.setEnabled(false);
        } else {
            this.btnClose.setEnabled(true);
            this.txtSearchParameter.setEnabled(true);
            this.chkCaseSensitive.setEnabled(true);
            this.chkHere.setEnabled(true);
        }
    }

    public Geometry createSearchGeometry() {
        Geometry searchGeometry = null;
        if (this.chkHere.isSelected()) {
            BoundingBox boundingBox = CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBoxFromCamera();
            int srid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getMappingComponent().getMappingModel().getSrs().getCode());
            searchGeometry = CrsTransformer.transformToDefaultCrs((Geometry)boundingBox.getGeometry(srid));
            searchGeometry.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        }
        return searchGeometry;
    }

    public boolean isCaseSensitiveEnabled() {
        return this.chkCaseSensitive.isSelected();
    }

    public boolean isGeometryEnabled() {
        return this.chkHere.isSelected();
    }

    public SearchTopicsPanel getPnlSearchTopics() {
        return this.pnlSearchTopics;
    }

    public MetaObjectNodeServerSearch assembleSearch() {
        Collection<String> selectedSearchClasses = MetaSearch.instance().getSelectedSearchClassesForQuery();
        LOG.info((Object)("Starting search for '" + this.txtSearchParameter.getText() + "' in '" + selectedSearchClasses + "'. Case sensitive? " + this.chkCaseSensitive.isSelected() + ", Only in cismap? " + this.chkHere.isSelected()));
        this.model.setSearchText(this.txtSearchParameter.getText());
        Geometry searchGeometry = this.createSearchGeometry();
        final FullTextSearch fullTextSearch = (FullTextSearch)Lookup.getDefault().lookup(FullTextSearch.class);
        fullTextSearch.setSearchText(this.txtSearchParameter.getText());
        fullTextSearch.setCaseSensitive(this.chkCaseSensitive.isSelected());
        fullTextSearch.setGeometry(searchGeometry);
        fullTextSearch.setValidClassesFromStrings(selectedSearchClasses);
        if (fullTextSearch instanceof SearchResultListenerProvider) {
            ((SearchResultListenerProvider)fullTextSearch).setSearchResultListener(new SearchResultListener(){

                public void searchDone(List results) {
                    if (ProtocolHandler.getInstance().isRecordEnabled()) {
                        ProtocolHandler.getInstance().recordStep((ProtocolStep)new FulltextSearchProtocolStepImpl(fullTextSearch, MetaSearch.instance().getSelectedSearchTopics(), results));
                    }
                }
            });
        }
        return fullTextSearch;
    }

    public void searchStarted() {
        this.searchRunning = true;
        this.switchControls();
    }

    public void searchDone(int results) {
        this.searchRunning = false;
        this.switchControls();
        if (results > 0) {
            this.setVisible(false);
        }
    }

    public void searchCanceled() {
        this.searchRunning = false;
        this.switchControls();
    }

    public boolean suppressEmptyResultMessage() {
        return false;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private class EnableSearchListener
    implements DocumentListener,
    ItemListener {
        private EnableSearchListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.enableSearchButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.enableSearchButton();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.enableSearchButton();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.enableSearchButton();
        }

        private void enableSearchButton() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean enableSearchButton = true;
                    enableSearchButton &= SearchSearchTopicsDialog.this.txtSearchParameter.getText() != null && SearchSearchTopicsDialog.this.txtSearchParameter.getText().trim().length() > 0;
                    SearchSearchTopicsDialog.this.pnlSearchCancel.setEnabled(enableSearchButton &= MetaSearch.instance().getSelectedSearchTopics().size() > 0);
                }
            });
        }
    }
}

