/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.protocol;

import Sirius.navigator.search.CidsServerSearchMetaObjectNodeWrapper;
import Sirius.navigator.search.CidsServerSearchProtocolStepImpl;
import Sirius.navigator.search.CidsServerSearchProtocolStepReexecutor;
import Sirius.server.middleware.types.MetaObjectNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.server.search.builtin.GeoSearch;
import de.cismet.cismap.commons.features.SearchFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateSearchGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.MetaSearchCreateSearchGeometryListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsBeansSearchFeature;
import de.cismet.cismap.navigatorplugin.metasearch.MetaSearch;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopic;
import de.cismet.cismap.navigatorplugin.protocol.GeoSearchProtocolStep;
import de.cismet.cismap.navigatorplugin.protocol.GeoSearchProtocolStepPanel;
import de.cismet.cismap.navigatorplugin.protocol.GeoSearchProtocolStepSearchTopic;
import de.cismet.cismap.navigatorplugin.protocol.GeometryProtocolStepImpl;
import de.cismet.cismap.navigatorplugin.protocol.SearchTopicsProtocolStepImpl;
import de.cismet.commons.gui.protocol.AbstractProtocolStep;
import de.cismet.commons.gui.protocol.AbstractProtocolStepPanel;
import de.cismet.commons.gui.protocol.ProtocolStepMetaInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public class GeoSearchProtocolStepImpl
extends AbstractProtocolStep
implements GeoSearchProtocolStep {
    private static final ProtocolStepMetaInfo META_INFO = new ProtocolStepMetaInfo("GeoSearch", "GeoSearchProtocolStep");
    @JsonProperty(required=true)
    protected String wkt;
    @JsonProperty(required=true)
    private final String mode;
    @JsonProperty(required=true)
    private List<CidsServerSearchMetaObjectNodeWrapper> searchResults;
    @JsonProperty(required=true)
    private Set<GeoSearchProtocolStepSearchTopic> searchTopicInfos;
    @JsonProperty(required=true)
    private Collection<CidsServerSearchMetaObjectNodeWrapper> searchObjects;
    @JsonIgnore
    private final CidsServerSearchProtocolStepImpl cidsServerSearchProtocolStep;
    @JsonIgnore
    private final GeometryProtocolStepImpl geometryProtocolStep;
    @JsonIgnore
    private final SearchTopicsProtocolStepImpl searchTopicsProtocolStep;
    @JsonIgnore
    private final List<MetaObjectNode> searchObjectNodes;

    public GeoSearchProtocolStepImpl(GeoSearch geoSearch, MetaSearchCreateSearchGeometryListener searchListener, Collection<SearchTopic> searchTopics, List<MetaObjectNode> resultNodes) {
        ArrayList<MetaObjectNode> searchObjectNodes;
        this.cidsServerSearchProtocolStep = new CidsServerSearchProtocolStepImpl((CidsServerSearch)geoSearch, resultNodes);
        this.geometryProtocolStep = new GeometryProtocolStepImpl(geoSearch.getGeometry());
        this.searchTopicsProtocolStep = new SearchTopicsProtocolStepImpl(searchTopics);
        if (searchListener.getSearchFeature() instanceof CidsBeansSearchFeature) {
            CidsBeansSearchFeature cidsBeansSearchFeature = (CidsBeansSearchFeature)searchListener.getSearchFeature();
            searchObjectNodes = new ArrayList<MetaObjectNode>();
            for (CidsBean bean : cidsBeansSearchFeature.getBeans()) {
                MetaObjectNode searchObjectNode = new MetaObjectNode(bean);
                searchObjectNodes.add(searchObjectNode);
            }
        } else {
            searchObjectNodes = null;
        }
        this.searchObjectNodes = searchObjectNodes;
        this.mode = searchListener.getMode();
        this.getCidsServerSearchProtocolStep().setReexecutor((CidsServerSearchProtocolStepReexecutor)this);
    }

    @JsonCreator
    public GeoSearchProtocolStepImpl(@JsonProperty(value="wkt") String wkt, @JsonProperty(value="mode") String mode, @JsonProperty(value="searchTopicInfos") Set<GeoSearchProtocolStepSearchTopic> searchTopicInfos, @JsonProperty(value="searchObjects") Collection<CidsServerSearchMetaObjectNodeWrapper> searchObjects, @JsonProperty(value="searchResults") List<CidsServerSearchMetaObjectNodeWrapper> searchResults) {
        this.cidsServerSearchProtocolStep = new CidsServerSearchProtocolStepImpl(searchResults);
        this.geometryProtocolStep = new GeometryProtocolStepImpl(wkt);
        this.searchTopicsProtocolStep = new SearchTopicsProtocolStepImpl(searchTopicInfos);
        this.mode = mode;
        this.searchTopicInfos = searchTopicInfos;
        this.searchObjects = searchObjects;
        ArrayList<MetaObjectNode> searchObjectNodes = new ArrayList<MetaObjectNode>();
        if (searchObjects != null) {
            for (CidsServerSearchMetaObjectNodeWrapper searchObject : searchObjects) {
                searchObjectNodes.add(new MetaObjectNode(searchObject.getDomain(), searchObject.getObjectId(), searchObject.getClassId(), searchObject.getName(), null, null));
            }
        }
        this.searchObjectNodes = searchObjectNodes;
        this.wkt = this.getGeometryProtocolStep().getWkt();
        this.searchResults = this.getCidsServerSearchProtocolStep().getSearchResults();
        this.getCidsServerSearchProtocolStep().setReexecutor((CidsServerSearchProtocolStepReexecutor)this);
    }

    protected ProtocolStepMetaInfo createMetaInfo() {
        return META_INFO;
    }

    public void initParameters() {
        ArrayList<CidsServerSearchMetaObjectNodeWrapper> searchObjects;
        super.initParameters();
        this.getGeometryProtocolStep().initParameters();
        this.getCidsServerSearchProtocolStep().initParameters();
        this.getSearchTopicsProtocolStep().initParameters();
        if (this.getSearchObjectNodes() != null) {
            searchObjects = new ArrayList<CidsServerSearchMetaObjectNodeWrapper>();
            for (MetaObjectNode searchObjectNode : this.getSearchObjectNodes()) {
                searchObjects.add(new CidsServerSearchMetaObjectNodeWrapper(searchObjectNode));
            }
        } else {
            searchObjects = null;
        }
        this.searchObjects = searchObjects;
        this.wkt = this.getGeometryProtocolStep().getWkt();
        this.searchResults = this.getCidsServerSearchProtocolStep().getSearchResults();
        this.searchTopicInfos = this.getSearchTopicsProtocolStep().getSearchTopicInfos();
    }

    public AbstractProtocolStepPanel visualize() {
        return new GeoSearchProtocolStepPanel(this);
    }

    public boolean isReExecuteSearchEnabled() {
        return true;
    }

    public void reExecuteSearch() {
        for (SearchTopic searchTopic : MetaSearch.instance().getSearchTopics()) {
            searchTopic.setSelected(this.getSearchTopicsProtocolStep().getSearchTopics().contains(searchTopic));
        }
        CreateSearchGeometryListener inputListener = (CreateSearchGeometryListener)CismapBroker.getInstance().getMappingComponent().getInputListener("SEARCH_POLYGON");
        inputListener.setMode(this.getMode());
        inputListener.search(new SearchFeature(this.getGeometry(), "SEARCH_POLYGON"));
    }

    public List<MetaObjectNode> getSearchResultNodes() {
        return this.getCidsServerSearchProtocolStep().getSearchResultNodes();
    }

    @Override
    public Geometry getGeometry() {
        return this.getGeometryProtocolStep().getGeometry();
    }

    @Generated
    public String getWkt() {
        return this.wkt;
    }

    @Generated
    public String getMode() {
        return this.mode;
    }

    @Generated
    public List<CidsServerSearchMetaObjectNodeWrapper> getSearchResults() {
        return this.searchResults;
    }

    @Override
    @Generated
    public Set<GeoSearchProtocolStepSearchTopic> getSearchTopicInfos() {
        return this.searchTopicInfos;
    }

    @Generated
    public Collection<CidsServerSearchMetaObjectNodeWrapper> getSearchObjects() {
        return this.searchObjects;
    }

    @Generated
    public CidsServerSearchProtocolStepImpl getCidsServerSearchProtocolStep() {
        return this.cidsServerSearchProtocolStep;
    }

    @Generated
    public GeometryProtocolStepImpl getGeometryProtocolStep() {
        return this.geometryProtocolStep;
    }

    @Generated
    public SearchTopicsProtocolStepImpl getSearchTopicsProtocolStep() {
        return this.searchTopicsProtocolStep;
    }

    @Generated
    public List<MetaObjectNode> getSearchObjectNodes() {
        return this.searchObjectNodes;
    }
}

