/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.protocol;

import de.cismet.commons.gui.protocol.ProtocolStepConfiguration;
import de.cismet.tools.configuration.NoWriteError;
import lombok.Generated;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class GeometryProtocolStepConfiguration
implements ProtocolStepConfiguration {
    public static final String PROTOCOL_STEP_KEY = "GeometryProtocolStep";
    private static final String DEFAULT_WMS_MAP_URL = "http://www3.demis.nl/wms/wms.asp?wms=WorldMap&&VERSION=1.1.0&REQUEST=GetMap&BBOX=<cismap:boundingBox>&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&SRS=EPSG:4326&FORMAT=image/png&TRANSPARENT=TRUE&BGCOLOR=0xF0F0F0&EXCEPTIONS=application/vnd.ogc.se_xml&LAYERS=Bathymetry,Countries,Topography,Hillshading,Builtup%20areas,Coastlines,Waterbodies,Inundated,Rivers,Streams,Railroads,Highways,Roads,Trails,Borders,Cities,Settlements,Spot%20elevations,Airports,Ocean%20features&TYLES=";
    private static final String DEFAULT_SRS = "EPSG:4326";
    private static final double DEFAULT_ZOOM_FACTOR = 0.2;
    private String wmsMapUrl = "http://www3.demis.nl/wms/wms.asp?wms=WorldMap&&VERSION=1.1.0&REQUEST=GetMap&BBOX=<cismap:boundingBox>&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&SRS=EPSG:4326&FORMAT=image/png&TRANSPARENT=TRUE&BGCOLOR=0xF0F0F0&EXCEPTIONS=application/vnd.ogc.se_xml&LAYERS=Bathymetry,Countries,Topography,Hillshading,Builtup%20areas,Coastlines,Waterbodies,Inundated,Rivers,Streams,Railroads,Highways,Roads,Trails,Borders,Cities,Settlements,Spot%20elevations,Airports,Ocean%20features&TYLES=";
    private String srs = "EPSG:4326";
    private double zoomFactor = 0.2;

    public String getProtocolStepKey() {
        return PROTOCOL_STEP_KEY;
    }

    public void configure(Element parent) {
        Element root = parent.getChild(this.getProtocolStepKey());
        try {
            Element backgroundlayer = root.getChild("backgroundlayer");
            String wmsMapUrl = backgroundlayer.getAttributeValue("wmsMapUrl");
            String srs = backgroundlayer.getAttributeValue("srs");
            this.wmsMapUrl = wmsMapUrl;
            this.srs = srs;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            double zoomFactor;
            this.zoomFactor = zoomFactor = Double.valueOf(root.getChildText("zoomFactor")).doubleValue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void masterConfigure(Element parent) {
        this.configure(parent);
    }

    public Element getConfiguration() throws NoWriteError {
        Element root = new Element(this.getProtocolStepKey());
        Element backgroundlayerElement = new Element("backgroundlayer");
        backgroundlayerElement.setAttribute(new Attribute("wmsMapUrl", this.wmsMapUrl));
        backgroundlayerElement.setAttribute(new Attribute("srs", this.srs));
        root.addContent((Content)backgroundlayerElement);
        Element zoomFactorElement = new Element("zoomFactor");
        zoomFactorElement.setText(Double.toString(this.zoomFactor));
        root.addContent((Content)zoomFactorElement);
        return root;
    }

    @Generated
    public String getWmsMapUrl() {
        return this.wmsMapUrl;
    }

    @Generated
    public String getSrs() {
        return this.srs;
    }

    @Generated
    public double getZoomFactor() {
        return this.zoomFactor;
    }
}

