/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.protocol;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.protocol.GeometryProtocolStep;
import de.cismet.cismap.navigatorplugin.protocol.GeometryProtocolStepConfiguration;
import de.cismet.cismap.navigatorplugin.protocol.GeometryProtocolStepPanel;
import de.cismet.commons.cismap.io.converters.GeomFromWktConverter;
import de.cismet.commons.converter.ConversionException;
import de.cismet.commons.gui.protocol.AbstractProtocolStep;
import de.cismet.commons.gui.protocol.AbstractProtocolStepPanel;
import de.cismet.commons.gui.protocol.ProtocolHandler;
import de.cismet.commons.gui.protocol.ProtocolStepMetaInfo;
import lombok.Generated;

public class GeometryProtocolStepImpl
extends AbstractProtocolStep
implements GeometryProtocolStep {
    public static ProtocolStepMetaInfo META_INFO = new ProtocolStepMetaInfo("Geometry", "GeometryProtocolStep");
    private static GeomFromWktConverter GEOM_EWKT_CONVERTER = new GeomFromWktConverter();
    @JsonProperty(required=true)
    protected String wkt;
    @JsonIgnore
    private final transient Geometry geometry;

    public GeometryProtocolStepImpl(String wkt) {
        this.wkt = wkt;
        Geometry geometry = null;
        if (wkt != null) {
            try {
                geometry = GEOM_EWKT_CONVERTER.convertForward(wkt, new String[]{CismapBroker.getInstance().getDefaultCrs()});
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
        this.geometry = geometry;
    }

    public GeometryProtocolStepImpl(Geometry geometry) {
        this.geometry = geometry;
    }

    public GeometryProtocolStepConfiguration getConfiguration() {
        return (GeometryProtocolStepConfiguration)ProtocolHandler.getInstance().getProtocolStepConfiguration("GeometryProtocolStep");
    }

    protected ProtocolStepMetaInfo createMetaInfo() {
        return META_INFO;
    }

    public void initParameters() {
        super.initParameters();
        if (this.geometry != null) {
            String wkt = null;
            try {
                wkt = GEOM_EWKT_CONVERTER.convertBackward(this.geometry, new String[0]);
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
            this.wkt = wkt;
        } else {
            this.wkt = null;
        }
    }

    public AbstractProtocolStepPanel visualize() {
        return new GeometryProtocolStepPanel(this);
    }

    @Generated
    public String getWkt() {
        return this.wkt;
    }

    @Override
    @Generated
    public Geometry getGeometry() {
        return this.geometry;
    }
}

