/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.protocol;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.SearchFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.cismap.navigatorplugin.protocol.GeometryProtocolStep;
import de.cismet.cismap.navigatorplugin.protocol.GeometryProtocolStepConfiguration;
import de.cismet.commons.gui.protocol.AbstractProtocolStepPanel;
import de.cismet.commons.gui.protocol.ProtocolStep;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GeometryProtocolStepPanel
extends AbstractProtocolStepPanel<GeometryProtocolStep> {
    private JXHyperlink jXHyperlink1;
    private MappingComponent mappingComponent1;

    public GeometryProtocolStepPanel() {
        this(null);
    }

    public GeometryProtocolStepPanel(GeometryProtocolStep geomSearchProtocolStep) {
        this(geomSearchProtocolStep, true);
    }

    public GeometryProtocolStepPanel(GeometryProtocolStep geomSearchProtocolStep, boolean showSearchGeometry) {
        super((ProtocolStep)geomSearchProtocolStep);
        this.initComponents();
        if (geomSearchProtocolStep != null && geomSearchProtocolStep.getGeometry() != null) {
            this.initMap(geomSearchProtocolStep.getGeometry(), this.mappingComponent1, showSearchGeometry);
        }
    }

    public final void initMap(Geometry geom, MappingComponent map, boolean showSearchGeometry) {
        GeometryProtocolStepConfiguration configuration = (GeometryProtocolStepConfiguration)((GeometryProtocolStep)this.getProtocolStep()).getConfiguration();
        String srs = configuration.getSrs();
        String wmsMapUrl = configuration.getWmsMapUrl();
        double zoomFactor = configuration.getZoomFactor();
        Geometry transformedGeom = CrsTransformer.transformToGivenCrs((Geometry)geom, (String)srs);
        XBoundingBox bbox = new XBoundingBox(transformedGeom.getEnvelope(), srs, true);
        if (showSearchGeometry) {
            bbox.setX1(bbox.getX1() - zoomFactor * bbox.getWidth());
            bbox.setX2(bbox.getX2() + zoomFactor * bbox.getWidth());
            bbox.setY1(bbox.getY1() - zoomFactor * bbox.getHeight());
            bbox.setY2(bbox.getY2() + zoomFactor * bbox.getHeight());
        }
        ActiveLayerModel mappingModel = new ActiveLayerModel();
        mappingModel.setSrs(srs);
        mappingModel.addHome(bbox);
        SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(wmsMapUrl));
        mappingModel.addLayer((RetrievalServiceLayer)swms);
        map.setMappingModel((MappingModel)mappingModel);
        map.setInteracting(false);
        map.setInteractionMode("OVERVIEW");
        if (showSearchGeometry) {
            SearchFeature searchFeature = new SearchFeature(transformedGeom, null);
            map.getFeatureCollection().addFeature((Feature)searchFeature);
        }
        map.unlock();
        map.gotoInitialBoundingBox();
    }

    private void initComponents() {
        this.mappingComponent1 = new MappingComponent();
        this.jXHyperlink1 = new JXHyperlink();
        this.setMinimumSize(new Dimension(29, 150));
        this.setPreferredSize(new Dimension(300, 200));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.mappingComponent1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jXHyperlink1, (String)NbBundle.getMessage(GeometryProtocolStepPanel.class, (String)"GeometryProtocolStepPanel.jXHyperlink1.text"));
        this.jXHyperlink1.setHorizontalAlignment(11);
        this.jXHyperlink1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeometryProtocolStepPanel.this.jXHyperlink1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jXHyperlink1, gridBagConstraints);
    }

    private void jXHyperlink1ActionPerformed(ActionEvent evt) {
        CismapBroker.getInstance().getMappingComponent().gotoBoundingBoxWithHistory((BoundingBox)new XBoundingBox(((GeometryProtocolStep)this.getProtocolStep()).getGeometry()));
    }
}

