/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.printing.templateinscriber;

import de.cismet.cismap.commons.gui.printing.AbstractPrintingInscriber;
import de.cismet.cismap.commons.gui.printing.FileNameChangedEvent;
import de.cismet.cismap.commons.gui.printing.FilenamePrintingInscriber;
import de.cismet.cismap.commons.gui.printing.FilenamePrintingInscriberListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CismetThreadPool;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class A4HPersistent
extends AbstractPrintingInscriber
implements FilenamePrintingInscriber {
    public static final String FIRST_LINE = "FIRST_LINE";
    public static final String SECOND_LINE = "SECOND_LINE";
    private static final Logger log = Logger.getLogger(A4HPersistent.class);
    String cacheFile = "";
    Properties cache = new Properties();
    private List<FilenamePrintingInscriberListener> listeners = new ArrayList<FilenamePrintingInscriberListener>();
    private String oldText = "";
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField txtZeile1;
    private JTextField txtZeile2;

    public A4HPersistent() {
        this.initComponents();
        this.cacheFile = CismapBroker.getInstance().getCismapFolderPath() + System.getProperty("file.separator") + "inscriberCache";
        this.readInscriberCache();
        this.oldText = this.txtZeile1.getText();
        this.txtZeile1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.onChange(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.onChange(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.onChange(e);
            }

            private void onChange(DocumentEvent e) {
                FileNameChangedEvent event = new FileNameChangedEvent(A4HPersistent.this.oldText, A4HPersistent.this.txtZeile1.getText());
                for (FilenamePrintingInscriberListener listener : A4HPersistent.this.listeners) {
                    listener.fileNameChanged(event);
                }
                A4HPersistent.this.oldText = A4HPersistent.this.txtZeile1.getText();
            }
        });
    }

    public HashMap<String, String> getValues() {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("Ueberschrift", this.txtZeile1.getText());
        hm.put("Unterschrift", this.txtZeile2.getText());
        this.cache.setProperty(FIRST_LINE, this.txtZeile1.getText());
        this.cache.setProperty(SECOND_LINE, this.txtZeile2.getText());
        this.writeInscriberCache();
        return hm;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.txtZeile1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.txtZeile2 = new JTextField();
        this.jLabel1.setText(NbBundle.getMessage(A4HPersistent.class, (String)"A4HPersistent.jLabel1.text"));
        this.txtZeile1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                A4HPersistent.this.txtZeile1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText(NbBundle.getMessage(A4HPersistent.class, (String)"A4HPersistent.jLabel2.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.txtZeile1, -1, 232, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.txtZeile2, -1, 166, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.txtZeile1, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.txtZeile2, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void txtZeile1ActionPerformed(ActionEvent evt) {
    }

    private void readInscriberCache() {
        try {
            this.cache.load(new FileInputStream(this.cacheFile));
            String z1 = this.cache.getProperty(FIRST_LINE);
            String z2 = this.cache.getProperty(SECOND_LINE);
            this.txtZeile1.setText(z1);
            this.txtZeile2.setText(z2);
        }
        catch (Throwable t) {
            log.warn((Object)"Error while reading the InscriberCache", t);
        }
    }

    private void writeInscriberCache() {
        Thread t = new Thread("A4HPersistent writeInscriberCache()"){

            @Override
            public void run() {
                try {
                    A4HPersistent.this.cache.store(new FileOutputStream(A4HPersistent.this.cacheFile), "Saved: " + System.currentTimeMillis());
                }
                catch (Throwable t) {
                    log.warn((Object)"Error while writing the InscriberCache", t);
                }
            }
        };
        CismetThreadPool.execute((Runnable)t);
    }

    protected void setTextOfJLabel1(String newText) {
        this.jLabel1.setText(newText);
    }

    protected void setTextOfJLabel2(String newText) {
        this.jLabel2.setText(newText);
    }

    public void addFilenameChangeListener(FilenamePrintingInscriberListener listener) {
        this.listeners.add(listener);
    }

    public String getFileName() {
        return this.txtZeile1.getText();
    }
}

