/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.tools.gui;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.search.QuerySearch;
import de.cismet.cids.search.QuerySearchMethod;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureWithId;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceUtilities;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.featureservice.factory.AbstractFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToLayerWorker;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.commons.concurrency.CismetExecutors;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.openide.util.NbBundle;

public class SelectInAttributeTableSearchMethod
implements QuerySearchMethod {
    private static final Logger LOG = Logger.getLogger(SelectInAttributeTableSearchMethod.class);
    private QuerySearch querySearch;
    private boolean searching = false;
    private SearchAndSelectThread searchThread;
    private Object lastLayer;
    private AttributeTable table;

    public SelectInAttributeTableSearchMethod(AttributeTable table) {
        this.table = table;
    }

    public void setQuerySearch(QuerySearch querySearch) {
        this.querySearch = querySearch;
    }

    public void actionPerformed(Object layer, String query) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)((this.searching ? "Cancel" : "Search") + " button was clicked."));
        }
        if (this.searching) {
            if (this.searchThread != null) {
                FeatureFactory ff;
                if (this.lastLayer instanceof AbstractFeatureService && (ff = ((AbstractFeatureService)this.lastLayer).getFeatureFactory()) instanceof AbstractFeatureFactory) {
                    ((AbstractFeatureFactory)ff).waitUntilInterruptedIsAllowed();
                }
                this.searchThread.cancel(true);
            }
        } else {
            this.lastLayer = layer;
            this.searchThread = new SearchAndSelectThread(layer, query);
            CismetExecutors.newSingleThreadExecutor().submit(this.searchThread);
            this.searching = true;
            this.querySearch.setControlsAccordingToState(this.searching);
        }
    }

    public String toString() {
        return NbBundle.getMessage(SelectInAttributeTableSearchMethod.class, (String)"SelectInAttributeTableSearchMethod.toString");
    }

    private class SearchAndSelectThread
    extends SwingWorker<List<Feature>, Void> {
        private Object layer;
        private String query;

        public SearchAndSelectThread(Object layer, String query) {
            this.layer = layer;
            this.query = query;
        }

        @Override
        protected List<Feature> doInBackground() throws Exception {
            List features = null;
            if (this.layer instanceof WebFeatureService) {
                WebFeatureService wfs = (WebFeatureService)this.layer;
                try {
                    Element e = (Element)wfs.getQueryElement().clone();
                    Element queryElement = e.getChild("Query", Namespace.getNamespace((String)"wfs", (String)"http://www.opengis.net/wfs"));
                    queryElement.removeChild("Filter", Namespace.getNamespace((String)"ogc", (String)"http://www.opengis.net/ogc"));
                    Element filterElement = new Element("Filter", Namespace.getNamespace((String)"ogc", (String)"http://www.opengis.net/ogc"));
                    SAXBuilder builder = new SAXBuilder();
                    Document d = builder.build((Reader)new StringReader(this.query));
                    filterElement.addContent((Content)((Element)d.getRootElement().clone()));
                    queryElement.addContent(0, (Content)filterElement);
                    features = wfs.getFeatureFactory().createFeatures((Object)FeatureServiceUtilities.elementToString((Element)e), (BoundingBox)this.getServiceBounds(), null, 0, 0, null);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while retrieving features", (Throwable)ex);
                }
            } else if (this.layer instanceof AbstractFeatureService) {
                AbstractFeatureService fs = (AbstractFeatureService)this.layer;
                features = fs.getFeatureFactory().createFeatures((Object)this.query, (BoundingBox)this.getServiceBounds(), null, 0, 0, null);
            }
            return features;
        }

        @Override
        protected void done() {
            try {
                List features = (List)this.get();
                if (this.isCancelled()) {
                    return;
                }
                if (features != null && this.layer instanceof AbstractFeatureService) {
                    SelectionManager.getInstance().setSelectedFeaturesForService((AbstractFeatureService)this.layer, features);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while selecting features", (Throwable)e);
            }
            SelectInAttributeTableSearchMethod.this.searching = false;
            SelectInAttributeTableSearchMethod.this.querySearch.setControlsAccordingToState(SelectInAttributeTableSearchMethod.this.searching);
        }

        private boolean isFeatureInList(FeatureWithId f, List<FeatureWithId> list) {
            for (FeatureWithId tmp : list) {
                if (tmp.getId() != f.getId()) continue;
                return true;
            }
            return false;
        }

        private XBoundingBox getServiceBounds() {
            Geometry g = ZoomToLayerWorker.getServiceBounds((RetrievalServiceLayer)((RetrievalServiceLayer)this.layer));
            XBoundingBox bounds = null;
            if (g != null) {
                bounds = new XBoundingBox(g);
                String crs = CismapBroker.getInstance().getSrs().getCode();
                try {
                    CrsTransformer trans = new CrsTransformer(crs);
                    bounds = trans.transformBoundingBox(bounds);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while transforming the bounding box of the service bounds.", (Throwable)e);
                }
            }
            return bounds;
        }
    }
}

