/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cismap.commons.gui.options;

import org.jdom.Element;

import org.openide.util.NbBundle;
import org.openide.util.lookup.ServiceProvider;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.capabilitywidget.CapabilityWidget;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateGeometryListenerInterface;
import de.cismet.cismap.commons.interaction.CismapBroker;

import de.cismet.lookupoptions.*;

import de.cismet.tools.configuration.NoWriteError;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
@ServiceProvider(service = OptionsPanelController.class)
public class CapabilityWidgetOptionsPanel extends AbstractOptionsPanel implements OptionsPanelController {

    //~ Static fields/initializers ---------------------------------------------

    private static final String OPTION_NAME = NbBundle.getMessage(
            CapabilityWidgetOptionsPanel.class,
            "CapabilityWidgetOptionsPanel.OPTION_NAME");
    private static CapabilityWidget capabilityWidget;

    //~ Instance fields --------------------------------------------------------

    private final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(this.getClass());

    private boolean searchActive;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JCheckBox jcSearch;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new GeometryOptionsPanel object.
     */
    public CapabilityWidgetOptionsPanel() {
        super(OPTION_NAME, CismapOptionsCategory.class);
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public int getOrder() {
        return 2;
    }

    @Override
    public void update() {
        final CapabilityWidget widget = getCapabilityWidget();

        if (widget != null) {
            searchActive = widget.isSearchEnabled();
            jcSearch.setSelected(searchActive);
        }
    }

    @Override
    public void applyChanges() {
        final CapabilityWidget widget = getCapabilityWidget();

        if (widget != null) {
            searchActive = jcSearch.isSelected();
            widget.setSearchEnabled(searchActive);
        }
    }

    @Override
    public boolean isChanged() {
        final boolean active = jcSearch.isSelected();

        return searchActive != active;
    }

    @Override
    public String getTooltip() {
        return org.openide.util.NbBundle.getMessage(
                CapabilityWidgetOptionsPanel.class,
                "CapabilityWidgetOptionsPanel.tooltip"); // NOI18N
    }

    @Override
    public void configure(final Element parent) {
    }

    @Override
    public Element getConfiguration() throws NoWriteError {
        final Element conf = new Element("test");

        return conf;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static CapabilityWidget getCapabilityWidget() {
        return capabilityWidget;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  globalCapabilityWidget  DOCUMENT ME!
     */
    public static void setCapabilityWidget(final CapabilityWidget globalCapabilityWidget) {
        capabilityWidget = globalCapabilityWidget;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        jcSearch = new javax.swing.JCheckBox();

        jLabel1.setText(org.openide.util.NbBundle.getMessage(
                CapabilityWidgetOptionsPanel.class,
                "CapabilityWidgetOptionsPanel.jLabel1.text")); // NOI18N

        jcSearch.setText(org.openide.util.NbBundle.getMessage(
                CapabilityWidgetOptionsPanel.class,
                "CapabilityWidgetOptionsPanel.jcSearch.text")); // NOI18N

        final javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(
                layout.createSequentialGroup().addContainerGap().addGroup(
                    layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addComponent(jLabel1)
                                .addComponent(jcSearch)).addContainerGap(152, Short.MAX_VALUE)));
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(
                layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(
                    javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(jcSearch).addContainerGap(
                    39,
                    Short.MAX_VALUE)));
    } // </editor-fold>//GEN-END:initComponents
}
