/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
/*
 * AddHandleDialog.java
 *
 * Created on 05.11.2009, 15:38:03
 */
package de.cismet.cismap.commons.gui.piccolo;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicSliderUI;

import de.cismet.cismap.commons.interaction.CismapBroker;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class AddHandleDialog extends javax.swing.JDialog {

    //~ Static fields/initializers ---------------------------------------------

    public static final int STATUS_NONE = -1;
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCELED = 1;

    private static final double PRECISION = 100; // => "1/PRECISION"

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(AddHandleDialog.class);
    private static final AddHandleDialog INSTANCE = new AddHandleDialog();

    //~ Instance fields --------------------------------------------------------

    private int returnStatus = STATUS_NONE;

    private boolean allLocked = false;
    private boolean sliderLocked = false;
    private boolean updateLeftLocked = false;
    private boolean updateRightLocked = false;

    private double distanceToLeft = 0d;

    private double distanceTotal;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCancel;
    private javax.swing.JButton btnOK;
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JSpinner jSpinner1;
    private javax.swing.JSpinner jSpinner2;
    private javax.swing.JLabel lblDescription;
    private javax.swing.JLabel lblDescriptionImage;
    private javax.swing.JLabel lblDistanceLeft;
    private javax.swing.JLabel lblLeftNeighbour;
    private javax.swing.JLabel lblLeftPoint;
    private javax.swing.JLabel lblRightDistance;
    private javax.swing.JLabel lblRightNeighbour;
    private javax.swing.JLabel lblRightPoint;
    private javax.swing.JPanel panButtons;
    private javax.swing.JPanel panFooter;
    private javax.swing.JSlider sliDistance;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form AddHandleDialog.
     */
    private AddHandleDialog() {
        super(StaticSwingTools.getParentFrame(CismapBroker.getInstance().getMappingComponent()), true);

        allLocked = true;
        initComponents();
        sliDistance.setUI(new mySliderUI(sliDistance));
        getRootPane().setDefaultButton(btnOK);
        StaticSwingTools.doClickButtonOnKeyStroke(btnOK, KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), getRootPane());
        StaticSwingTools.doClickButtonOnKeyStroke(
            btnCancel,
            KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0),
            getRootPane());
        pack();
        allLocked = false;
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static AddHandleDialog getInstance() {
        return INSTANCE;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        sliDistance = new javax.swing.JSlider();
        lblLeftNeighbour = new javax.swing.JLabel();
        lblRightNeighbour = new javax.swing.JLabel();
        lblDistanceLeft = new javax.swing.JLabel();
        lblRightDistance = new javax.swing.JLabel();
        lblLeftPoint = new javax.swing.JLabel();
        lblRightPoint = new javax.swing.JLabel();
        panFooter = new javax.swing.JPanel();
        lblDescriptionImage = new javax.swing.JLabel();
        lblDescription = new javax.swing.JLabel();
        jSpinner1 = new javax.swing.JSpinner();
        jSpinner2 = new javax.swing.JSpinner();
        jButton1 = new javax.swing.JButton();
        panButtons = new javax.swing.JPanel();
        btnOK = new javax.swing.JButton();
        btnCancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(AddHandleDialog.class, "AddHandleDialog.title")); // NOI18N
        setResizable(false);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        sliDistance.setMajorTickSpacing((int)PRECISION);
        sliDistance.setValue(0);
        sliDistance.setFocusable(false);
        sliDistance.setMaximumSize(new java.awt.Dimension(206, 54));
        sliDistance.setMinimumSize(new java.awt.Dimension(206, 54));
        sliDistance.addChangeListener(new javax.swing.event.ChangeListener() {

                @Override
                public void stateChanged(final javax.swing.event.ChangeEvent evt) {
                    sliDistanceStateChanged(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(sliDistance, gridBagConstraints);

        lblLeftNeighbour.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        lblLeftNeighbour.setText(org.openide.util.NbBundle.getMessage(
                AddHandleDialog.class,
                "AddHandleDialog.lblLeftNeighbour.text")); // NOI18N
        lblLeftNeighbour.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);
        lblLeftNeighbour.setMaximumSize(new java.awt.Dimension(150, 17));
        lblLeftNeighbour.setMinimumSize(new java.awt.Dimension(150, 17));
        lblLeftNeighbour.setPreferredSize(new java.awt.Dimension(150, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LAST_LINE_START;
        jPanel1.add(lblLeftNeighbour, gridBagConstraints);

        lblRightNeighbour.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lblRightNeighbour.setText(org.openide.util.NbBundle.getMessage(
                AddHandleDialog.class,
                "AddHandleDialog.lblRightNeighbour.text")); // NOI18N
        lblRightNeighbour.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);
        lblRightNeighbour.setMaximumSize(new java.awt.Dimension(150, 17));
        lblRightNeighbour.setMinimumSize(new java.awt.Dimension(150, 17));
        lblRightNeighbour.setPreferredSize(new java.awt.Dimension(150, 17));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LAST_LINE_END;
        jPanel1.add(lblRightNeighbour, gridBagConstraints);

        lblDistanceLeft.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lblDistanceLeft.setText(org.openide.util.NbBundle.getMessage(
                AddHandleDialog.class,
                "AddHandleDialog.lblDistanceLeft.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        jPanel1.add(lblDistanceLeft, gridBagConstraints);

        lblRightDistance.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        lblRightDistance.setText(org.openide.util.NbBundle.getMessage(
                AddHandleDialog.class,
                "AddHandleDialog.lblDistanceRight.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        jPanel1.add(lblRightDistance, gridBagConstraints);

        lblLeftPoint.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblLeftPoint.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/neighbourPoint.png"))); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        jPanel1.add(lblLeftPoint, gridBagConstraints);

        lblRightPoint.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblRightPoint.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/neighbourPoint.png"))); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        jPanel1.add(lblRightPoint, gridBagConstraints);

        panFooter.setLayout(new java.awt.GridBagLayout());

        lblDescriptionImage.setText(org.openide.util.NbBundle.getMessage(
                AddHandleDialog.class,
                "AddHandleDialog.lblDescriptionImage.text")); // NOI18N
        lblDescriptionImage.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);
        lblDescriptionImage.setPreferredSize(new java.awt.Dimension(250, 120));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        panFooter.add(lblDescriptionImage, gridBagConstraints);

        lblDescription.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/addHandle.png"))); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        panFooter.add(lblDescription, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        jPanel1.add(panFooter, gridBagConstraints);

        jSpinner1.setModel(new javax.swing.SpinnerNumberModel(
                Double.valueOf(0.0d),
                Double.valueOf(0.0d),
                null,
                Double.valueOf(1.0d)));
        jSpinner1.setMinimumSize(new java.awt.Dimension(75, 26));
        jSpinner1.setPreferredSize(new java.awt.Dimension(75, 26));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_END;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        jPanel1.add(jSpinner1, gridBagConstraints);
        ((JSpinner.DefaultEditor)jSpinner1.getEditor()).getTextField()
                .getDocument()
                .addDocumentListener(new LeftDocumentListener());

        jSpinner2.setModel(new javax.swing.SpinnerNumberModel(
                Double.valueOf(0.0d),
                Double.valueOf(0.0d),
                null,
                Double.valueOf(1.0d)));
        jSpinner2.setMinimumSize(new java.awt.Dimension(75, 26));
        jSpinner2.setPreferredSize(new java.awt.Dimension(75, 26));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_END;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        jPanel1.add(jSpinner2, gridBagConstraints);
        ((JSpinner.DefaultEditor)jSpinner2.getEditor()).getTextField()
                .getDocument()
                .addDocumentListener(new RightDocumentListener());

        jButton1.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/arrow-step.png")));                       // NOI18N
        jButton1.setText(org.openide.util.NbBundle.getMessage(AddHandleDialog.class, "AddHandleDialog.jButton1.text")); // NOI18N
        jButton1.setToolTipText(org.openide.util.NbBundle.getMessage(
                AddHandleDialog.class,
                "AddHandleDialog.jButton1.toolTipText"));                                                               // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton1ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_END;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        jPanel1.add(jButton1, gridBagConstraints);

        panButtons.setLayout(new java.awt.GridLayout(1, 0, 10, 0));

        btnOK.setText(org.openide.util.NbBundle.getMessage(AddHandleDialog.class, "AddHandleDialog.btnOK.text")); // NOI18N
        btnOK.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnOKActionPerformed(evt);
                }
            });
        panButtons.add(btnOK);

        btnCancel.setText(org.openide.util.NbBundle.getMessage(
                AddHandleDialog.class,
                "AddHandleDialog.btnCancel.text")); // NOI18N
        btnCancel.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnCancelActionPerformed(evt);
                }
            });
        panButtons.add(btnCancel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        jPanel1.add(panButtons, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnOKActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnOKActionPerformed
        returnStatus = STATUS_OK;
        dispose();
    }                                                                         //GEN-LAST:event_btnOKActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnCancelActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnCancelActionPerformed
        returnStatus = STATUS_CANCELED;
        dispose();
    }                                                                             //GEN-LAST:event_btnCancelActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void sliDistanceStateChanged(final javax.swing.event.ChangeEvent evt) { //GEN-FIRST:event_sliDistanceStateChanged
        sliderValueChanged();
    }                                                                               //GEN-LAST:event_sliDistanceStateChanged

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton1ActionPerformed
        setDistanceToLeft(distanceTotal / 2d);
    }                                                                            //GEN-LAST:event_jButton1ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param   value  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private double cut(final double value) {
        return (int)(value * PRECISION) / PRECISION;
    }

    /**
     * DOCUMENT ME!
     */
    private void sliderValueChanged() {
        // update für den Slider kurzfristig deaktivieren (sonst endlos-Schleife)
        sliderLocked = true;
        try {
            setDistanceToLeft((sliDistance.getValue() / (double)sliDistance.getMaximum()) * distanceTotal);
        } finally {
            // update für den Slider wieder aktivieren
            sliderLocked = false;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  distanceToLeft  DOCUMENT ME!
     */
    public void setDistanceToLeft(final double distanceToLeft) {
        if (!allLocked) { // Ungenauigkeit durch Rückkopplung vermeiden
            // (Rückkopplung = setzen auf genauen wert löst das setzen
            // des gerundeten spinners ein, welches das setzen eines
            // ungenauen werts durchsetzt.
            allLocked = true;
            this.distanceToLeft = distanceToLeft;
            try {
                if (!sliderLocked) {      // Endlos-Schleife vermeiden
                    sliDistance.setValue((int)((this.distanceToLeft / this.distanceTotal) * sliDistance.getMaximum()));
                }
                if (!updateLeftLocked) {  // Endlos-Schleife vermeiden
                    jSpinner1.setValue(cut(this.distanceToLeft));
                }
                if (!updateRightLocked) { // Endlos-Schleife vermeiden
                    jSpinner2.setValue(cut(this.distanceTotal) - cut(this.distanceToLeft));
                }
            } finally {
                allLocked = false;
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  distanceToRight  DOCUMENT ME!
     */
    public void setDistanceToRight(final double distanceToRight) {
        setDistanceToLeft(this.distanceTotal - distanceToRight);
    }

    /**
     * DOCUMENT ME!
     */
    private void leftTextChanged() {
        // update für das linke Feld kurzfristig deaktivieren (sonst endlos-Schleife)
        updateLeftLocked = true;
        try {
            final double value = (Double)jSpinner1.getValue();
            if (cut(this.distanceToLeft) != value) {
                // Abstand vom linken Punkt anhand des linken Feldes setzen
                setDistanceToLeft(value);
            }
        } finally {
            // update für das linke Feld wieder aktivieren
            updateLeftLocked = false;
        }
    }

    /**
     * DOCUMENT ME!
     */
    private void rightTextChanged() {
        // update für das rechte Feld kurzfristig deaktivieren (sonst endlos-Schleife)
        updateRightLocked = true;
        try {
            final double value = (Double)jSpinner2.getValue();
            if (cut(getDistanceToRight()) != value) {
                // Abstand vom linken Punkt anhand des Wertes im linken Feld berechnen
                setDistanceToRight(value);
            }
        } finally {
            // update für das rechte Feld wieder aktivieren
            updateRightLocked = false;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public int getReturnStatus() {
        return returnStatus;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public double getDistanceTotal() {
        return distanceTotal;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public double getDistanceToLeft() {
        return distanceToLeft;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public double getDistanceToRight() {
        return this.distanceTotal - this.distanceToLeft;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  distanceTotal  DOCUMENT ME!
     */
    public void setDistanceTotal(final double distanceTotal) {
        // sliDistance.setMaximum((int)(distanceTotal * PRECISION));
        this.distanceTotal = distanceTotal;
        allLocked = true;
        try {
            sliDistance.setMaximum(sliDistance.getWidth());
            ((SpinnerNumberModel)jSpinner1.getModel()).setMaximum(distanceTotal);
            ((SpinnerNumberModel)jSpinner2.getModel()).setMaximum(distanceTotal);
        } finally {
            allLocked = false;
        }
        setDistanceToLeft(distanceTotal / 2d);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  args  the command line arguments
     */
    public static void main(final String[] args) {
        java.awt.EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    final AddHandleDialog dialog = getInstance();
                    dialog.pack();
                    dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                            @Override
                            public void windowClosing(final java.awt.event.WindowEvent e) {
                                System.exit(0);
                            }
                        });
                    dialog.setVisible(true);
                }
            });
    }

    @Override
    public void setVisible(final boolean visible) {
        super.setVisible(visible);
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class LeftDocumentListener implements DocumentListener {

        //~ Methods ------------------------------------------------------------

        @Override
        public void insertUpdate(final DocumentEvent e) {
            leftTextChanged();
        }

        @Override
        public void removeUpdate(final DocumentEvent e) {
            leftTextChanged();
        }

        @Override
        public void changedUpdate(final DocumentEvent e) {
            leftTextChanged();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class RightDocumentListener implements DocumentListener {

        //~ Methods ------------------------------------------------------------

        @Override
        public void insertUpdate(final DocumentEvent e) {
            rightTextChanged();
        }

        @Override
        public void removeUpdate(final DocumentEvent e) {
            rightTextChanged();
        }

        @Override
        public void changedUpdate(final DocumentEvent e) {
            rightTextChanged();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class mySliderUI extends BasicSliderUI {

        //~ Instance fields ----------------------------------------------------

        private final Image newPointImage;

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new mySliderUI object.
         *
         * @param  aSlider  DOCUMENT ME!
         */
        public mySliderUI(final JSlider aSlider) {
            super(aSlider);
            this.newPointImage = new javax.swing.ImageIcon(getClass().getResource(
                        "/de/cismet/cismap/commons/gui/piccolo/newPoint.png")).getImage();
        }

        //~ Methods ------------------------------------------------------------

        @Override
        public void paintThumb(final Graphics g) {
            g.drawImage(this.newPointImage, thumbRect.x, thumbRect.y, 8, 8, null);
        }
    }
}
