/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cismap.commons.gui.piccolo;

import edu.umd.cs.piccolo.PNode;

import java.awt.Color;
import java.awt.Graphics;

import javax.swing.ImageIcon;
import javax.swing.JPanel;

/**
 * DOCUMENT ME!
 *
 * @version  $Revision$, $Date$
 */
public class LinearReferencedPointInfoPanel extends JPanel {

    //~ Static fields/initializers ---------------------------------------------

    private static final Color COLOR_BORDER = new Color(0, 0, 0);
    private static final Color COLOR_BACKGROUND = new Color(210, 210, 210);

    //~ Instance fields --------------------------------------------------------

    private ImageIcon icoRuler = new ImageIcon(getClass().getResource(
                "/de/cismet/cismap/commons/gui/res/ruler-triangle.png")); // NOI18N

    private final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(this.getClass());
    private PNode pNodeParent;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lblLength;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form InfoPanel.
     */
    public LinearReferencedPointInfoPanel() {
        super();
        try {
            initComponents();
        } catch (Throwable t) {
            log.error("Error in InfoPanel", t); // NOI18N
        }
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        final java.awt.GridBagConstraints gridBagConstraints;

        lblLength = new javax.swing.JLabel();

        setBackground(java.awt.Color.lightGray);
        setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 4, 1, 4));
        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        lblLength.setBackground(javax.swing.UIManager.getDefaults().getColor("Nb.Desktop.background"));
        lblLength.setFont(new java.awt.Font("Tahoma", 0, 12));
        lblLength.setIcon(icoRuler);
        lblLength.addMouseListener(new java.awt.event.MouseAdapter() {

                @Override
                public void mouseClicked(final java.awt.event.MouseEvent evt) {
                    lblLengthMouseClicked(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 6, 4);
        add(lblLength, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void lblLengthMouseClicked(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_lblLengthMouseClicked
    }                                                                         //GEN-LAST:event_lblLengthMouseClicked

    @Override
    public void paintComponent(final Graphics g) {
        super.paintComponent(g);

        g.setColor(COLOR_BACKGROUND);
        g.fillRoundRect(2, 1, getWidth() - 4, getHeight() - 2, 10, 10);
        g.setColor(COLOR_BORDER);
        g.drawRoundRect(2, 1, getWidth() - 4, getHeight() - 2, 10, 10);

        if (pNodeParent != null) {
            pNodeParent.setWidth(getWidth());
            pNodeParent.setHeight(getHeight());
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  text  DOCUMENT ME!
     */
    public void setLengthInfo(final String text) {
        lblLength.setText(text);
        revalidate();
        repaint();
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public PNode getPNodeParent() {
        return pNodeParent;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  pNodeParent  DOCUMENT ME!
     */
    public void setPNodeParent(final PNode pNodeParent) {
        this.pNodeParent = pNodeParent;
    }
}
