/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cismap.commons.rasterservice.georeferencing;

import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

import java.awt.event.KeyEvent;

import java.util.logging.Level;

import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

import de.cismet.cismap.commons.interaction.CismapBroker;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class RasterGeoReferencingDialog extends javax.swing.JDialog {

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel panButtons;
    private de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingPanel rasterGeoReferencingPanel1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form RasterGeoReferencingDialog.
     *
     * @param  parent  DOCUMENT ME!
     * @param  modal   DOCUMENT ME!
     */
    private RasterGeoReferencingDialog(final java.awt.Frame parent, final boolean modal) {
        super(parent, modal);
        initComponents();
        getRootPane().setDefaultButton(jButton4);
        StaticSwingTools.doClickButtonOnKeyStroke(
            jButton4,
            KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
            getRootPane());
        StaticSwingTools.doClickButtonOnKeyStroke(
            jButton5,
            KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0),
            getRootPane());
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        final java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        rasterGeoReferencingPanel1 =
            new de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingPanel();
        panButtons = new javax.swing.JPanel();
        jButton4 = new javax.swing.JButton();
        jButton5 = new javax.swing.JButton();

        setTitle(org.openide.util.NbBundle.getMessage(
                RasterGeoReferencingDialog.class,
                "RasterGeoReferencingDialog.title")); // NOI18N
        setAlwaysOnTop(true);

        jPanel1.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        jPanel1.add(rasterGeoReferencingPanel1, gridBagConstraints);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        panButtons.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT, 10, 10));

        org.openide.awt.Mnemonics.setLocalizedText(
            jButton4,
            org.openide.util.NbBundle.getMessage(
                RasterGeoReferencingDialog.class,
                "RasterGeoReferencingDialog.jButton4.text")); // NOI18N
        jButton4.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton4ActionPerformed(evt);
                }
            });
        panButtons.add(jButton4);

        org.openide.awt.Mnemonics.setLocalizedText(
            jButton5,
            org.openide.util.NbBundle.getMessage(
                RasterGeoReferencingDialog.class,
                "RasterGeoReferencingDialog.jButton5.text")); // NOI18N
        jButton5.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton5ActionPerformed(evt);
                }
            });
        panButtons.add(jButton5);

        getContentPane().add(panButtons, java.awt.BorderLayout.SOUTH);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton5ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton5ActionPerformed
        setVisible(false);
    }                                                                            //GEN-LAST:event_jButton5ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton4ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton4ActionPerformed
        try {
            RasterGeoReferencingBackend.getInstance().save(RasterGeoReferencingWizard.getInstance().getHandler());
            setVisible(false);
            JOptionPane.showMessageDialog(this.getParent(), "Das zugehörige WorldFile wurde erfolgreich geschrieben.");
        } catch (final Exception ex) {
            final ErrorInfo errorInfo = new ErrorInfo(
                    "Fehler beim Anwenden",
                    "Das zugehörige WorldFile konte nicht geschrieben werden.",
                    null,
                    null,
                    ex,
                    Level.ALL,
                    null);
            JXErrorPane.showDialog(CismapBroker.getInstance().getMappingComponent(), errorInfo);
        }
    }                                                                            //GEN-LAST:event_jButton4ActionPerformed

    @Override
    public void setVisible(final boolean visible) {
        super.setVisible(visible);

        if (visible) {
            RasterGeoReferencingWizard.getInstance().refreshPointZoomMap();
            RasterGeoReferencingWizard.getInstance().refreshCoordinateZoomMap();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static RasterGeoReferencingDialog getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    private static final class LazyInitialiser {

        //~ Static fields/initializers -----------------------------------------

        private static final RasterGeoReferencingDialog INSTANCE = new RasterGeoReferencingDialog(StaticSwingTools
                        .getParentFrame(CismapBroker.getInstance().getMappingComponent()),
                false);

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new LazyInitialiser object.
         */
        private LazyInitialiser() {
        }
    }
}
