/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.commons.cismap.io.converters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;

import org.openide.util.NbBundle;
import org.openide.util.lookup.ServiceProvider;

import de.cismet.commons.converter.ConversionException;
import de.cismet.commons.converter.Converter.MatchRating;

/**
 * Creates a line string geometry from the provided coordinates. At least two coordinates are expected.
 *
 * @author   martin.scholl@cismet.de
 * @version  1.0
 */
@ServiceProvider(service = TextToGeometryConverter.class)
public final class PolylineFromTextConverter extends AbstractGeometryFromTextConverter implements MatchRating<String> {

    //~ Methods ----------------------------------------------------------------

    @Override
    protected Geometry createGeometry(final Coordinate[] coordinates, final GeometryFactory geomFactory)
            throws ConversionException {
        if (coordinates.length < 2) {
            throw new ConversionException("cannot create linestring lnfrom empty coordinate array"); // NOI18N
        }

        return geomFactory.createLineString(coordinates);
    }

    @Override
    public String getFormatName() {
        return "PolylineFromTextConverter"; // NOI18N
    }

    @Override
    public String getFormatDisplayName() {
        return NbBundle.getMessage(
                PolylineFromTextConverter.class,
                "PolylineFromTextConverter.getFormatDisplayName().returnValue"); // NOI18N
    }

    @Override
    public String getFormatHtmlName() {
        return null;
    }

    @Override
    public String getFormatDescription() {
        final String desc = NbBundle.getMessage(
                PointFromTextConverter.class,
                "PolylineFromTextConverter.getFormatDescription().returnValue"); // NOI18N
        final String superDesc = super.getFormatDescription();

        return desc + "\n" + superDesc;
    }

    @Override
    public String getFormatHtmlDescription() {
        final String desc = NbBundle.getMessage(
                    PointFromTextConverter.class,
                    "PolylineFromTextConverter.getFormatHtmlDescription().returnValue")
                    .replaceAll("<[/]?html>", "");                                              // NOI18N
        final String superDesc = super.getFormatHtmlDescription().replaceAll("<[/]?html>", ""); // NOI18N;

        return "<html>" + desc + "<br/>" + superDesc + "</html>"; // NOI18N
    }

    @Override
    public Object getFormatExample() {
        return NbBundle.getMessage(
                PointFromTextConverter.class,
                "PolylineFromTextConverter.getFormatExample().returnValue",
                getDecimalSeparator()); // NOI18N
    }

    @Override
    public int rate(final String from, final String... params) {
        final int superRating = super.rate(from, params);
        if (superRating == 0) {
            return 0;
        }

        final String[] tokens = from.split(getTokenRegex());

        if (tokens.length < 6) {
            return 0;
        } else {
            if (tokens[0].equals(tokens[tokens.length - 2]) && tokens[1].equals(tokens[tokens.length - 1])) {
                // could be polygon
                return 80;
            } else {
                return 100;
            }
        }
    }
}
