/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.deegree.framework.xml.XMLParsingException;
import org.deegree.model.feature.Feature;
import org.deegree.model.feature.FeatureCollection;
import org.deegree.model.feature.FeatureProperty;
import org.deegree.model.feature.GMLFeatureCollectionDocument;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xml.sax.SAXException;

public class GMLFeatureCollectionTest {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void test010SLDParser() throws XMLStreamException, IOException, SAXException, XMLParsingException {
        Assert.assertNotNull((Object)this.getClass().getResource("/wfsResponse.xml"));
        InputStreamReader inputStreamReader = new InputStreamReader(this.getClass().getResourceAsStream("/wfsResponse.xml"));
        Assert.assertTrue((boolean)inputStreamReader.ready());
        String wfsResponse = IOUtils.toString((Reader)inputStreamReader);
        Assert.assertFalse((boolean)wfsResponse.isEmpty());
        GMLFeatureCollectionDocument featureCollectionDocument = new GMLFeatureCollectionDocument();
        StringReader stringReader = new StringReader(wfsResponse);
        featureCollectionDocument.load((Reader)stringReader, "http://dummyID");
        Assert.assertFalse((featureCollectionDocument.getFeatureCount() == 0 ? 1 : 0) != 0);
        FeatureCollection featureCollection = featureCollectionDocument.parse();
        Assert.assertTrue((featureCollection.size() == 2 ? 1 : 0) != 0);
        Feature feature = featureCollection.getFeature(0);
        Assert.assertEquals((Object)"ID_9699", (Object)feature.getId());
        Assert.assertEquals((Object)"route", (Object)feature.getFeatureType().getName().getLocalName());
        Assert.assertEquals((long)6L, (long)feature.getProperties().length);
        FeatureProperty featureProperty = feature.getProperties()[1];
        Assert.assertEquals((Object)"gwk", (Object)featureProperty.getName().getLocalName());
        Assert.assertEquals((Object)"345328242123", (Object)featureProperty.getValue());
    }
}

