/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap;

import de.cismet.cismap.commons.rasterservice.HTTPImageRetrieval;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.security.WebAccessManager;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ImageRetrievalTest
implements RetrievalListener {
    final String wmsURL = "http://www2.demis.nl/wms/wms.asp?wms=WorldMap&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&BBOX=-184,-90,180,90&SRS=EPSG:4326&WIDTH=1471&HEIGHT=728&LAYERS=Countries&STYLES=&FORMAT=image/png&DPI=96&MAP_RESOLUTION=96&FORMAT_OPTIONS=dpi:96&TRANSPARENT=TRUE";
    HTTPImageRetrieval imageRetrieval = null;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        boolean canRead = true;
        this.imageRetrieval = new HTTPImageRetrieval((RetrievalListener)this);
        try {
            WebAccessManager.getInstance().doRequest(new URL("http://www2.demis.nl/wms/wms.asp?wms=WorldMap&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&BBOX=-184,-90,180,90&SRS=EPSG:4326&WIDTH=1471&HEIGHT=728&LAYERS=Countries&STYLES=&FORMAT=image/png&DPI=96&MAP_RESOLUTION=96&FORMAT_OPTIONS=dpi:96&TRANSPARENT=TRUE"));
        }
        catch (Exception ex) {
            System.out.println("WARNING: test010ImageRetieval NOT COMPLETED due to Exception: " + ex.getMessage());
            canRead = false;
        }
        Assume.assumeTrue((String)"Can read from http://www2.demis.nl/wms/wms.asp?wms=WorldMap&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&BBOX=-184,-90,180,90&SRS=EPSG:4326&WIDTH=1471&HEIGHT=728&LAYERS=Countries&STYLES=&FORMAT=image/png&DPI=96&MAP_RESOLUTION=96&FORMAT_OPTIONS=dpi:96&TRANSPARENT=TRUE", (boolean)canRead);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void test010ImageRetieval() throws MalformedURLException, IOException {
        Assert.assertNotNull((Object)this.imageRetrieval);
        this.imageRetrieval.setUrl("http://www2.demis.nl/wms/wms.asp?wms=WorldMap&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&BBOX=-184,-90,180,90&SRS=EPSG:4326&WIDTH=1471&HEIGHT=728&LAYERS=Countries&STYLES=&FORMAT=image/png&DPI=96&MAP_RESOLUTION=96&FORMAT_OPTIONS=dpi:96&TRANSPARENT=TRUE");
        Assert.assertEquals((Object)"http://www2.demis.nl/wms/wms.asp?wms=WorldMap&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&BBOX=-184,-90,180,90&SRS=EPSG:4326&WIDTH=1471&HEIGHT=728&LAYERS=Countries&STYLES=&FORMAT=image/png&DPI=96&MAP_RESOLUTION=96&FORMAT_OPTIONS=dpi:96&TRANSPARENT=TRUE", (Object)this.imageRetrieval.getUrl());
        this.imageRetrieval.start();
        try {
            this.imageRetrieval.join(6000L);
        }
        catch (InterruptedException ex) {
            System.out.println("test010ImageRetieval(): Image Retrieval aborted: " + ex.getMessage());
            Assume.assumeTrue((String)"Can read from http://www2.demis.nl/wms/wms.asp?wms=WorldMap&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&BBOX=-184,-90,180,90&SRS=EPSG:4326&WIDTH=1471&HEIGHT=728&LAYERS=Countries&STYLES=&FORMAT=image/png&DPI=96&MAP_RESOLUTION=96&FORMAT_OPTIONS=dpi:96&TRANSPARENT=TRUE", (boolean)false);
        }
    }

    public void retrievalStarted(RetrievalEvent e) {
        Assert.assertFalse((boolean)e.isIsComplete());
    }

    public void retrievalProgress(RetrievalEvent e) {
        Assert.assertFalse((boolean)e.isIsComplete());
    }

    public void retrievalComplete(RetrievalEvent e) {
        Assert.assertTrue((String)"isComplete", (boolean)e.isIsComplete());
        Assert.assertFalse((String)"isHasErrors", (boolean)e.isHasErrors());
        Assert.assertNotNull((String)"getRetrievedObject not null", (Object)e.getRetrievedObject());
    }

    public void retrievalAborted(RetrievalEvent e) {
        Assert.assertFalse((String)"retrievalAborted", (boolean)e.isIsComplete());
    }

    public void retrievalError(RetrievalEvent e) {
        Assert.assertTrue((String)"e.getErrorType()", (boolean)e.isHasErrors());
    }
}

