/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io.converters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.commons.cismap.io.converters.PolylineFromTextConverter;
import de.cismet.commons.converter.ConversionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PolylineFromTextConverterTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private String getCurrentMethodName() {
        return new Throwable().getStackTrace()[1].getMethodName();
    }

    @Test
    public void testCreateGeometry() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        PolylineFromTextConverter conv = new PolylineFromTextConverter();
        PrecisionModel pm = new PrecisionModel(PrecisionModel.FLOATING);
        GeometryFactory gf = new GeometryFactory(pm, 4326);
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        Geometry result = conv.createGeometry(coords, gf);
        Assert.assertNotNull((Object)result);
        Object[] resCoords = result.getCoordinates();
        Object[] expCoords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        Assert.assertArrayEquals((Object[])expCoords, (Object[])resCoords);
        Assert.assertEquals((Object)"LineString", (Object)result.getGeometryType());
    }

    @Test(expected=ConversionException.class)
    public void testCreateGeometryTooFewCoords() throws Exception {
        System.out.println("TEST " + this.getCurrentMethodName());
        PolylineFromTextConverter conv = new PolylineFromTextConverter();
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0)};
        conv.createGeometry(coords, null);
    }
}

