/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons;

import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class Crs {
    private static final Logger log = Logger.getLogger(Crs.class);
    private String code;
    private String shortname;
    private String name;
    private boolean metric;
    private boolean selected;
    private boolean hideInCrsSwitcher;
    private String esriDefinition;
    private boolean defaultCrs;

    public Crs() {
    }

    public Crs(Element elem) {
        Attribute attr;
        this.shortname = elem.getAttribute("shortname").getValue();
        this.name = elem.getAttribute("name").getValue();
        this.code = elem.getAttribute("code").getValue();
        try {
            this.metric = elem.getAttribute("metric").getBooleanValue();
        }
        catch (DataConversionException e) {
            log.error((Object)("attribute metric of element crs must be e boolean. The current value is " + elem.getAttribute("selected").getValue()), (Throwable)e);
        }
        try {
            this.selected = elem.getAttribute("selected").getBooleanValue();
        }
        catch (DataConversionException e) {
            log.error((Object)("attribute selected of element crs must be e boolean. The current value is " + elem.getAttribute("selected").getValue()), (Throwable)e);
        }
        try {
            attr = elem.getAttribute("defaultCrs");
            if (attr != null) {
                this.defaultCrs = attr.getBooleanValue();
            }
        }
        catch (DataConversionException e) {
            log.error((Object)("attribute defaultCrs of element crs must be e boolean. The current value is " + elem.getAttribute("defaultCrs").getValue()), (Throwable)e);
        }
        try {
            attr = elem.getAttribute("hideInCrsSwitcher");
            if (attr != null) {
                this.hideInCrsSwitcher = elem.getAttribute("hideInCrsSwitcher").getBooleanValue();
            }
        }
        catch (DataConversionException e) {
            log.error((Object)("attribute hideForChooser of element crs must be e boolean. The current value is " + elem.getAttribute("hideInCrsSwitcher").getValue()), (Throwable)e);
        }
        this.esriDefinition = elem.getTextTrim();
    }

    public Crs(String code, String shortname, String name, boolean metric, boolean selected) {
        this.code = code;
        this.shortname = shortname;
        this.name = name;
        this.metric = metric;
        this.selected = selected;
    }

    public Element getJDOMElement() {
        Element e = new Element("crs");
        e.setAttribute("shortname", this.shortname);
        e.setAttribute("name", this.name);
        e.setAttribute("code", this.code);
        e.setAttribute("metric", String.valueOf(this.metric));
        e.setAttribute("selected", String.valueOf(this.selected));
        e.setAttribute("defaultCrs", String.valueOf(this.defaultCrs));
        e.setAttribute("hideInCrsSwitcher", String.valueOf(this.hideInCrsSwitcher));
        e.setText(this.esriDefinition);
        return e;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getShortname() {
        return this.shortname;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isMetric() {
        return this.metric;
    }

    public void setMetric(boolean metric) {
        this.metric = metric;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String toString() {
        return this.code;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Crs) {
            Crs other = (Crs)obj;
            return other.code.equals(this.code);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.code != null ? this.code.hashCode() : 0);
        return hash;
    }

    public boolean isHideInCrsSwitcher() {
        return this.hideInCrsSwitcher;
    }

    public void setHideInCrsSwitcher(boolean hideInCrsSwitcher) {
        this.hideInCrsSwitcher = hideInCrsSwitcher;
    }

    public String getEsriDefinition() {
        return this.esriDefinition;
    }

    public void setEsriDefinition(String esriDefinition) {
        this.esriDefinition = esriDefinition;
    }

    public boolean hasEsriDefinition() {
        return this.esriDefinition != null && !this.esriDefinition.equals("");
    }

    public boolean isDefaultCrs() {
        return this.defaultCrs;
    }

    public void setDefaultCrs(boolean defaultCrs) {
        this.defaultCrs = defaultCrs;
    }
}

