/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons;

import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.MappingModelListener;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.featureservice.SimplePostgisFeatureService;
import de.cismet.cismap.commons.featureservice.SimpleUpdateablePostgisFeatureService;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.DataConversionException;
import org.jdom.Element;

@Deprecated
public class DefaultMappingModel
implements MappingModel,
Configurable {
    public static final int UP = -1;
    public static final int DOWN = 1;
    TreeMap mapServices = new TreeMap();
    TreeMap featureServices = new TreeMap();
    FeatureCollection featureCollection;
    Vector mappingModelListeners = new Vector();
    BoundingBox initialBoundingBox;
    private final Logger log = Logger.getLogger(this.getClass());

    public int moveRasterServiceUp(MapService rs) {
        return this.moveRasterService(rs, -1);
    }

    public int moveRasterServiceDown(MapService rs) {
        return this.moveRasterService(rs, 1);
    }

    public int moveRasterService(MapService rs, int step) {
        return this.moveObjectInTreeMap(this.mapServices, rs, step);
    }

    private int moveObjectInTreeMap(TreeMap tm, Object o, int step) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"moveObjectInTreeMap");
            }
            Vector v = new Vector(tm.values());
            int currentPosition = v.indexOf(o);
            int newPosition = currentPosition + step;
            Object objectToBeShifted = v.get(newPosition);
            v.set(newPosition, o);
            v.set(currentPosition, objectToBeShifted);
            tm.clear();
            for (int i = 0; i < v.size(); ++i) {
                tm.put(i, v.get(i));
            }
            return newPosition;
        }
        catch (Exception e) {
            this.log.warn((Object)"No moving", (Throwable)e);
            return -1;
        }
    }

    @Override
    public void addMappingModelListener(MappingModelListener mml) {
        if (!this.mappingModelListeners.contains(mml)) {
            this.mappingModelListeners.add(mml);
        }
    }

    @Override
    public void removeMappingModelListener(MappingModelListener mml) {
        this.mappingModelListeners.remove(mml);
    }

    public void setInitialBoundingBox(BoundingBox bb) {
        this.initialBoundingBox = bb;
    }

    public void removeMapService(MapService rasterService) {
        this.mapServices.remove(rasterService);
    }

    public void putMapService(int position, MapService rasterService) {
        this.mapServices.put(new Integer(position), rasterService);
    }

    @Deprecated
    public FeatureCollection getFeatureCollection() {
        return this.featureCollection;
    }

    public TreeMap getMapServices() {
        return this.featureServices;
    }

    @Override
    public BoundingBox getInitialBoundingBox() {
        return this.initialBoundingBox;
    }

    @Override
    public TreeMap getRasterServices() {
        return this.mapServices;
    }

    @Override
    public void addLayer(RetrievalServiceLayer layer) {
    }

    @Override
    public void removeLayer(RetrievalServiceLayer layer) {
    }

    public void configure(Element parent) {
        Element prefs = parent.getChild("cismapMappingPreferences");
        Object xBox = null;
    }

    public void masterConfigure(Element parent) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("masterConfigure im DefaultmappingModel:" + parent));
        }
        Element prefs = parent.getChild("cismapMappingPreferences");
        Iterator it = prefs.getChildren("home").iterator();
        XBoundingBox xBox = null;
        while (it.hasNext()) {
            Element elem = (Element)it.next();
            String srs = elem.getAttribute("srs").getValue();
            boolean metric = false;
            try {
                metric = elem.getAttribute("metric").getBooleanValue();
            }
            catch (DataConversionException dce) {
                this.log.warn((Object)"Metric has invalid syntax", (Throwable)dce);
            }
            boolean defaultVal = false;
            try {
                defaultVal = elem.getAttribute("default").getBooleanValue();
            }
            catch (DataConversionException dce) {
                this.log.warn((Object)"defaulthas invalid syntax", (Throwable)dce);
            }
            if (!defaultVal) continue;
            try {
                xBox = new XBoundingBox(elem, srs, metric);
                this.setInitialBoundingBox(xBox);
            }
            catch (Throwable t) {
                this.log.fatal((Object)"The home bounding box cannot be set. This will probably fail :-7", t);
            }
        }
        this.getInitialBoundingBox();
        prefs = parent.getChild("cismapActiveLayerConfiguration");
        List simpleWmsList = prefs.getChild("rasterLayers").getChildren("simpleWms");
        for (Object o : simpleWmsList) {
            if (!(o instanceof Element)) continue;
            Element el = (Element)o;
            try {
                boolean skip = false;
                try {
                    skip = el.getAttribute("skip").getBooleanValue();
                }
                catch (Exception t) {
                    // empty catch block
                }
                if (skip) continue;
                SimpleWMS swms = new SimpleWMS(el);
                this.mapServices.put(new Integer(swms.getLayerPosition()), swms);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Rasterservice added:" + swms + "(" + swms.getLayerPosition() + ")"));
            }
            catch (Exception ex) {
                this.log.warn((Object)"Read Preferences. Error. create SimpleWMS  ", (Throwable)ex);
            }
        }
        List simplePostgisFeatureServiceList = prefs.getChild("featureLayers").getChildren("simplePostgisFeatureService");
        it = simplePostgisFeatureServiceList.iterator();
        while (it.hasNext()) {
            Object o;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"new SimplePostgisService");
            }
            if (!((o = it.next()) instanceof Element)) continue;
            Element el = (Element)o;
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"SimplePostgisFeatureService added");
                }
                boolean skip = false;
                boolean updateable = false;
                try {
                    skip = el.getAttribute("skip").getBooleanValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    updateable = el.getAttribute("updateable").getBooleanValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (skip) continue;
                SimplePostgisFeatureService spfs = null;
                spfs = updateable ? new SimpleUpdateablePostgisFeatureService(el) : new SimplePostgisFeatureService(el);
                this.featureServices.put(new Integer(spfs.getLayerPosition()), spfs);
            }
            catch (Exception ex) {
                this.log.warn((Object)"Read Preferences. Error. Create SimplePostgisFeatureService ", (Throwable)ex);
            }
        }
    }

    public Element getConfiguration() throws NoWriteError {
        return null;
    }

    @Override
    public TreeMap getFeatureServices() {
        return this.featureServices;
    }

    @Override
    public Crs getSrs() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

