/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons;

import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.ErroneousRetrievalServiceProvider;
import de.cismet.cismap.commons.ModeLayer;
import de.cismet.cismap.commons.PNodeProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.PrintTemplateFeature;
import de.cismet.cismap.commons.gui.printing.PrintingWidget;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.raster.wms.SlidableWMSServiceLayerGroup;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.retrieval.AbstractRetrievalService;
import de.cismet.cismap.commons.retrieval.RepaintEvent;
import de.cismet.cismap.commons.retrieval.RepaintListener;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalService;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class HeadlessMapProvider {
    private static final Logger LOG = Logger.getLogger(HeadlessMapProvider.class);
    private static final double FEATURE_RESOLUTION_FACTOR = 125.0;
    MappingComponent map = new MappingComponent(false);
    ActiveLayerModel mappingModel = new ActiveLayerModel();
    XBoundingBox boundingBox = null;
    private double minimumScaleDenominator = 0.0;
    private double imgScaleDenominator;
    private List<PropertyChangeListener> propertyChangeListener = new ArrayList<PropertyChangeListener>();
    private DominatingDimension dominatingDimension = DominatingDimension.SIZE;
    private RoundingPrecision roundScaleTo = RoundingPrecision.NO_ROUNDING;
    private boolean centerMapOnResize = false;
    private double printingResolution = 0.0;
    private double resolution = 72.0;
    private double featureResolutionFactor = 125.0;
    private Object requestingObject;

    public HeadlessMapProvider() {
        this.map.setResizeEventActivated(false);
        this.map.setInternalLayerWidgetAvailable(false);
        if (CismapBroker.getInstance().getMappingComponent() != null) {
            List<Crs> crsList = CismapBroker.getInstance().getMappingComponent().getCrsList();
            String defaultCrs = CismapBroker.getInstance().getDefaultCrs();
            XBoundingBox homeBoundingBox = null;
            boolean defaultCrsFound = false;
            for (Crs crs : crsList) {
                if (!crs.getCode().equals(defaultCrs)) continue;
                this.mappingModel.setSrs(crs);
                defaultCrsFound = true;
                break;
            }
            if (!defaultCrsFound) {
                LOG.warn((Object)"Default crs not found. Use EPSG:25832");
                this.mappingModel.setSrs(new Crs("EPSG:25832", "", "", true, true));
            }
            if (CismapBroker.getInstance().getMappingComponent().getMappingModel().getInitialBoundingBox() instanceof XBoundingBox) {
                this.boundingBox = (XBoundingBox)CismapBroker.getInstance().getMappingComponent().getMappingModel().getInitialBoundingBox();
            }
            HashMap homeMap = ((ActiveLayerModel)CismapBroker.getInstance().getMappingComponent().getMappingModel()).getHomeBoundingBoxes();
            Set keys = homeMap.keySet();
            for (Object key : keys) {
                homeBoundingBox = (XBoundingBox)homeMap.get(key);
                this.mappingModel.addHome(homeBoundingBox);
            }
            if (this.mappingModel.getInitialBoundingBox() == null) {
                LOG.error((Object)"Default home boundingBox not found");
                if (homeBoundingBox != null) {
                    LOG.warn((Object)("Calculate home bounding box from " + homeBoundingBox));
                    try {
                        CrsTransformer transformer = new CrsTransformer(defaultCrs);
                        homeBoundingBox = transformer.transformBoundingBox(homeBoundingBox);
                        this.mappingModel.addHome(homeBoundingBox);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot calculate home bounding box", (Throwable)e);
                    }
                }
            }
        } else {
            this.mappingModel.setSrs(new Crs("EPSG:35833", "EPSG:35833", "EPSG:35833", true, true));
            this.boundingBox = new XBoundingBox(3.32986531E7, 5994912.610934, 3.3308958598E7, 5999709.97916, "EPSG:35833", true);
            this.mappingModel.addHome(this.boundingBox);
        }
        this.map.setMappingModel(this.mappingModel);
        this.map.setSize(500, 500);
        this.map.setAnimationDuration(0);
    }

    public Object getRequestingObject() {
        return this.requestingObject;
    }

    public void setRequestingObject(Object requestingObject) {
        this.requestingObject = requestingObject;
    }

    public double getFeatureResolutionFactor() {
        return this.featureResolutionFactor;
    }

    public void setFeatureResolutionFactor(double featureResolutionFactor) {
        this.featureResolutionFactor = featureResolutionFactor;
    }

    public static HeadlessMapProvider createHeadlessMapProviderAndAddLayers(MappingComponent mappingComponent) {
        HeadlessMapProvider headlessMapProvider = new HeadlessMapProvider();
        ((ActiveLayerModel)headlessMapProvider.getMappingComponent().getMappingModel()).setSrs(mappingComponent.getMappingModel().getSrs());
        boolean infoNodeVisible = mappingComponent.isInfoNodesVisible();
        headlessMapProvider.getMappingComponent().setInfoNodesVisible(infoNodeVisible);
        TreeMap rasterServices = mappingComponent.getMappingModel().getRasterServices();
        ArrayList positionsRaster = new ArrayList(rasterServices.keySet());
        Collections.sort(positionsRaster);
        for (Object position : positionsRaster) {
            boolean addable = false;
            Object rasterService = rasterServices.get(position);
            if (rasterService instanceof RetrievalServiceLayer && ((RetrievalServiceLayer)rasterService).isEnabled() && rasterService instanceof PNodeProvider && ((PNodeProvider)rasterService).getPNode() != null && ((PNodeProvider)rasterService).getPNode().getVisible()) {
                addable = true;
            }
            if (addable) {
                if (rasterService instanceof ModeLayer) {
                    headlessMapProvider.addLayer(((ModeLayer)rasterService).getCurrentLayer());
                    continue;
                }
                headlessMapProvider.addLayer((RetrievalServiceLayer)rasterService);
                continue;
            }
            LOG.warn((Object)"Layer can not be added to the headlessMapProvider as it is not an instance of RetrievalServiceLayer");
        }
        TreeMap featureServices = mappingComponent.getMappingModel().getFeatureServices();
        ArrayList positionsFeatures = new ArrayList(featureServices.keySet());
        Collections.sort(positionsFeatures);
        for (Object position : positionsFeatures) {
            Object featureService = featureServices.get(position);
            if (featureService instanceof RetrievalServiceLayer) {
                headlessMapProvider.addLayer((RetrievalServiceLayer)featureService);
                continue;
            }
            LOG.warn((Object)"Feature can not be added to the headlessMapProvider as it is not an instance of RetrievalServiceLayer");
        }
        if (mappingComponent.isFeatureCollectionVisible()) {
            for (Feature f : mappingComponent.getFeatureCollection().getAllFeatures()) {
                PFeature pf;
                boolean infoNodeExpanded = mappingComponent.getPFeatureHM().get(f).isInfoNodeExpanded();
                if (f instanceof PrintTemplateFeature) continue;
                headlessMapProvider.addFeature(f);
                if (!infoNodeExpanded || (pf = headlessMapProvider.map.getPFeatureHM().get(f)) == null) continue;
                pf.setInfoNodeExpanded(true);
            }
        }
        return headlessMapProvider;
    }

    public double getPrintingResolution() {
        return this.printingResolution;
    }

    public void setPrintingResolution(double printingResolution) {
        this.printingResolution = printingResolution;
    }

    public MappingComponent getMappingComponent() {
        return this.map;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListener.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListener.remove(listener);
    }

    public void addFeature(Feature f) {
        this.map.getFeatureCollection().addFeature(f);
    }

    public void addFeatures(Collection<? extends Feature> featureCollection) {
        this.map.getFeatureCollection().addFeatures(featureCollection);
    }

    public void addLayer(RetrievalServiceLayer layer) {
        try {
            if (layer instanceof AbstractRetrievalService) {
                AbstractRetrievalService l = ((AbstractRetrievalService)((Object)layer)).cloneWithoutRetrievalListeners();
                if (l instanceof SlidableWMSServiceLayerGroup) {
                    ((SlidableWMSServiceLayerGroup)l).setPrintMode(true);
                }
                this.mappingModel.addLayer((RetrievalServiceLayer)((Object)l));
            } else {
                this.mappingModel.addLayer(layer);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Cannot add layer.", (Throwable)e);
        }
    }

    public void setBoundingBox(XBoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public void setCrs(Crs crs) {
        this.mappingModel.setSrs(crs);
    }

    public Image getImage(int dpi, double widthInMillimeters, double heightInMilimeters) {
        return null;
    }

    public Future<Image> getImage(int baseDpi, int targetDpi, double widthInPixels, double heightInPixels) {
        this.printingResolution = (double)targetDpi / CismapBroker.getInstance().getMappingComponent().getFeaturePrintingDpi();
        int imageWidth = (int)(widthInPixels / (double)baseDpi * (double)targetDpi);
        int imageHeight = (int)(heightInPixels / (double)baseDpi * (double)targetDpi);
        this.map.setStickyFeatureCorrectionFactor(this.printingResolution);
        this.resolution = targetDpi;
        return this.getImage(imageWidth, imageHeight);
    }

    public Future<Image> getImage(int widthPixels, int heightPixels) {
        if (this.boundingBox == null) {
            this.boundingBox = (XBoundingBox)this.mappingModel.getHomeBoundingBoxes().get(this.mappingModel.getDefaultHomeSrs());
            LOG.warn((Object)"No BoundingBox was set explicitly. Will use the Home-BoundingBox");
        }
        int correctedWidthPixels = widthPixels;
        int correctedHeightPixels = heightPixels;
        XBoundingBox correctedBoundingBox = this.boundingBox;
        correctedBoundingBox = new XBoundingBox(this.boundingBox.getX1(), this.boundingBox.getY1(), this.boundingBox.getX2(), this.boundingBox.getY2(), this.boundingBox.getSrs(), this.boundingBox.isMetric());
        double pixelRelation = (double)widthPixels / (double)heightPixels;
        double boundingBoxRelation = this.boundingBox.getWidth() / this.boundingBox.getHeight();
        if (pixelRelation != boundingBoxRelation) {
            if (this.dominatingDimension == DominatingDimension.SIZE) {
                if (boundingBoxRelation < pixelRelation) {
                    double boundingBoxWidth = (double)widthPixels * this.boundingBox.getHeight() / (double)heightPixels;
                    if (this.centerMapOnResize) {
                        double changedWidth = Math.abs(boundingBoxWidth - this.boundingBox.getWidth());
                        correctedBoundingBox.setX2(correctedBoundingBox.getX2() + changedWidth / 2.0);
                        correctedBoundingBox.setX1(correctedBoundingBox.getX1() - changedWidth / 2.0);
                    } else {
                        correctedBoundingBox.setX2(correctedBoundingBox.getX1() + boundingBoxWidth);
                    }
                } else {
                    double boundingBoxHeight = (double)heightPixels * this.boundingBox.getWidth() / (double)widthPixels;
                    if (this.centerMapOnResize) {
                        double changedHeight = Math.abs(boundingBoxHeight - this.boundingBox.getHeight());
                        correctedBoundingBox.setY2(correctedBoundingBox.getY2() + changedHeight / 2.0);
                        correctedBoundingBox.setY1(correctedBoundingBox.getY1() - changedHeight / 2.0);
                    } else {
                        correctedBoundingBox.setY2(correctedBoundingBox.getY1() + boundingBoxHeight);
                    }
                }
            } else if (this.dominatingDimension == DominatingDimension.BOUNDINGBOX) {
                if (boundingBoxRelation < pixelRelation) {
                    correctedHeightPixels = (int)((double)widthPixels * this.boundingBox.getHeight() / this.boundingBox.getWidth());
                } else {
                    correctedWidthPixels = (int)((double)heightPixels * this.boundingBox.getWidth() / this.boundingBox.getHeight());
                }
            }
        }
        this.map.setSize(correctedWidthPixels, correctedHeightPixels);
        this.map.setNewViewBounds(null);
        this.map.gotoBoundingBox(correctedBoundingBox, true, true, 0, false);
        this.waitUntilGotoBoundingBoxIsComplete();
        if (this.minimumScaleDenominator > 0.0 && this.map.getScaleDenominator() < this.minimumScaleDenominator) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("map scale of " + this.map.getScaleDenominator() + " is less than the configured minimum scale ( " + this.minimumScaleDenominator + "). Using minimim scale"));
            }
            BoundingBox bb = this.map.getBoundingBoxFromScale(this.minimumScaleDenominator);
            correctedBoundingBox = new XBoundingBox(bb.getX1(), bb.getY1(), bb.getX2(), bb.getY2(), this.boundingBox.getSrs(), this.boundingBox.isMetric());
            this.map.setNewViewBounds(null);
            this.map.gotoBoundingBox(correctedBoundingBox, true, true, 0, false);
            this.waitUntilGotoBoundingBoxIsComplete();
        }
        if (this.roundScaleTo != RoundingPrecision.NO_ROUNDING) {
            double scale = 0.0;
            if (this.roundScaleTo == RoundingPrecision.TENTH) {
                scale = Math.round(this.map.getScaleDenominator() / 10.0 + 0.5) * 10L;
            } else if (this.roundScaleTo == RoundingPrecision.HUNDRETH) {
                scale = Math.round(this.map.getScaleDenominator() / 100.0 + 0.5) * 100L;
            } else if (this.roundScaleTo == RoundingPrecision.THOUSANDTH) {
                scale = Math.round(this.map.getScaleDenominator() / 1000.0 + 0.5) * 1000L;
            }
            BoundingBox bb = this.map.getBoundingBoxFromScale(scale);
            correctedBoundingBox = new XBoundingBox(bb.getX1(), bb.getY1(), bb.getX2(), bb.getY2(), this.boundingBox.getSrs(), this.boundingBox.isMetric());
            this.map.setNewViewBounds(null);
            this.map.gotoBoundingBox(correctedBoundingBox, true, true, 0, false);
            this.waitUntilGotoBoundingBoxIsComplete();
        }
        this.imgScaleDenominator = this.map.getScaleDenominator();
        this.map.setFixedBoundingBox(correctedBoundingBox);
        if (this.printingResolution == 0.0) {
            this.map.setPrintingResolution(this.resolution / this.getFeatureResolutionFactor());
        } else {
            this.map.setPrintingResolution(this.printingResolution);
        }
        int invisibleServices = 0;
        for (MapService m : this.mappingModel.getMapServices().values()) {
            AbstractFeatureService afs;
            if (!(m instanceof AbstractFeatureService) || (afs = (AbstractFeatureService)m).isVisibleInBoundingBox((XBoundingBox)this.map.getCurrentBoundingBoxFromCamera())) continue;
            ++invisibleServices;
        }
        HeadlessMapProviderRetrievalListener listener = new HeadlessMapProviderRetrievalListener(correctedWidthPixels, correctedHeightPixels, this.propertyChangeListener, this.mappingModel.getFeatureServices().size() + this.mappingModel.getMapServices().size() - invisibleServices);
        this.map.addRepaintListener(listener);
        this.map.unlockWithoutReload();
        if (this.mappingModel.getMapServices().size() - invisibleServices > 0) {
            this.map.queryServices();
        } else {
            listener.createImageFromFeatures();
        }
        return listener;
    }

    private void waitUntilGotoBoundingBoxIsComplete() {
        while (this.map.getViewBounds() == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Image getImageAndWait(int widthPixels, int heightPixels) throws ExecutionException, InterruptedException {
        return this.getImage(widthPixels, heightPixels).get();
    }

    public Image getImageAndWait(int basedpi, int targetDpi, double widthInPixels, double heightInPixels) throws ExecutionException, InterruptedException {
        return this.getImage(basedpi, targetDpi, widthInPixels, heightInPixels).get();
    }

    public DominatingDimension getDominatingDimension() {
        return this.dominatingDimension;
    }

    public void setDominatingDimension(DominatingDimension dominatingDimension) {
        this.dominatingDimension = dominatingDimension;
    }

    public void setMinimumScaleDenomimator(double minimumScaleDenominator) {
        this.minimumScaleDenominator = minimumScaleDenominator;
    }

    public void setCenterMapOnResize(boolean b) {
        this.centerMapOnResize = b;
    }

    public void setRoundScaleTo(RoundingPrecision rp) {
        this.roundScaleTo = rp;
    }

    public double getImageScaleDenominator() {
        return this.imgScaleDenominator;
    }

    public BoundingBox getCurrentBoundingBoxFromMap() {
        return this.map.getCurrentBoundingBoxFromCamera();
    }

    public class NotificationMessage {
        private String msg;
        private NotificationLevel level;

        public NotificationMessage() {
        }

        public NotificationMessage(String msg, NotificationLevel level) {
            this.msg = msg;
            this.level = level;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public NotificationLevel getLevel() {
            return this.level;
        }

        public void setLevel(NotificationLevel level) {
            this.level = level;
        }
    }

    class HeadlessMapProviderRetrievalListener
    implements Future<Image>,
    RepaintListener,
    ErroneousRetrievalServiceProvider {
        int imageWidth;
        int imageHeight;
        private HashSet<RetrievalService> services;
        private HashSet<Object> results;
        private HashSet<RetrievalService> erroneous;
        private boolean cancel = false;
        private volatile boolean done = false;
        private final ReentrantLock lock = new ReentrantLock();
        private Condition condition = this.lock.newCondition();
        private List<PropertyChangeListener> listener = new ArrayList<PropertyChangeListener>();
        private int serviceCount = 0;

        public HeadlessMapProviderRetrievalListener(int imageWidth, int imageHeight, List<PropertyChangeListener> listener, int serviceCount) {
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.services = new HashSet();
            this.results = new HashSet();
            this.erroneous = new HashSet();
            this.listener = listener;
            this.serviceCount = serviceCount;
        }

        @Override
        public synchronized void repaintStart(RepaintEvent repaintEvent) {
            RetrievalEvent e = repaintEvent.getRetrievalEvent();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"start");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("retrievalStarted" + e.getRetrievalService()));
            }
            if (e.isInitialisationEvent()) {
                LOG.error((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalStarted ignored, initialisation event"));
                return;
            }
            this.sendNotification(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.retrievalStarted(RetrievalEvent).msg", (Object[])new Object[]{e.getRetrievalService()}), NotificationLevel.INFO);
            if (e.getRetrievalService() == null) {
                System.out.println("service is null");
            }
            if (e.getRetrievalService() instanceof ServiceLayer) {
                this.services.add(e.getRetrievalService());
            }
        }

        @Override
        public void repaintError(RepaintEvent repaintEvent) {
            RetrievalEvent e = repaintEvent.getRetrievalEvent();
            if (e != null) {
                LOG.error((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalError"));
                if (e.isInitialisationEvent()) {
                    LOG.error((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalError ignored, initialisation event"));
                    return;
                }
            } else {
                LOG.error((Object)"repaint error and RetrievalEvent is null", (Throwable)new Exception());
            }
            this.sendNotification(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.retrievalError(RetrievalEvent).msg1", (Object[])new Object[]{e.getRetrievalService()}), NotificationLevel.ERROR);
            this.sendNotification(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.retrievalError(RetrievalEvent).msg2"), NotificationLevel.ERROR_REASON, e);
            repaintEvent.getRetrievalEvent().setHasErrors(true);
            this.repaintComplete(repaintEvent);
        }

        @Override
        public synchronized void repaintComplete(RepaintEvent repaintEvent) {
            RetrievalEvent e = repaintEvent.getRetrievalEvent();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalComplete"));
            }
            if (e.isInitialisationEvent()) {
                LOG.error((Object)(e.getRetrievalService() + "[" + e.getRequestIdentifier() + "]: retrievalComplete ignored, initialisation event"));
                return;
            }
            if (e.getRetrievalService() instanceof ServiceLayer) {
                if (!e.isHasErrors()) {
                    this.results.add(e.getRetrievalService());
                    this.sendNotification(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.retrievalComplete(RetrievalEvent).msg", (Object[])new Object[]{e.getRetrievalService()}), NotificationLevel.SUCCESS);
                } else {
                    this.erroneous.add(e.getRetrievalService());
                    if (e.getRetrievedObject() instanceof Image) {
                        this.sendNotification(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.retrievalComplete(RetrievalEvent).msg2", (Object[])new Object[]{e.getRetrievalService()}), NotificationLevel.ERROR_REASON, e);
                    }
                }
            }
            if (this.results.size() + this.erroneous.size() == this.serviceCount) {
                if (this.results.size() == this.serviceCount) {
                    this.sendNotification(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.retrievalComplete(RetrievalEvent).msg6"), NotificationLevel.SUCCESS);
                } else if (this.services.isEmpty()) {
                    this.sendNotification(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.retrievalComplete(RetrievalEvent).msg7"), NotificationLevel.WARN);
                } else {
                    this.sendNotification(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.retrievalComplete(RetrievalEvent).msg8"), NotificationLevel.WARN);
                }
                this.addFeaturesToTopLevelLayer();
                if (this.erroneous.size() < this.results.size()) {
                    this.sendNotification(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.retrievalComplete(RetrievalEvent).msg4"), NotificationLevel.SUCCESS);
                } else {
                    this.sendNotification(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.retrievalComplete(RetrievalEvent).msg5"), NotificationLevel.INFO);
                }
                LOG.info((Object)("Following layers were painted: " + this.results));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("services:" + this.services));
                }
                this.unlock();
            }
        }

        @Override
        public HashSet<RetrievalService> getErroneousLayer() {
            return this.erroneous;
        }

        public void createImageFromFeatures() {
            this.addFeaturesToTopLevelLayer();
            this.unlock();
        }

        private void addFeaturesToTopLevelLayer() {
            if (HeadlessMapProvider.this.map.isFeatureCollectionVisible()) {
                try {
                    this.sendNotification(NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.retrievalComplete(RetrievalEvent).msg3"), NotificationLevel.INFO);
                }
                catch (Throwable t) {
                    LOG.error((Object)"Error while adding local features to the map", t);
                }
            } else {
                String localFeaturesNotAddedMessage = NbBundle.getMessage(PrintingWidget.class, (String)"PrintingWidget.retrievalComplete(RetrievalEvent).msg9");
                this.sendNotification(localFeaturesNotAddedMessage, NotificationLevel.INFO);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)localFeaturesNotAddedMessage);
                }
            }
        }

        private void unlock() {
            this.lock.lock();
            try {
                this.done = true;
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
                this.sendNotification("", NotificationLevel.UNLOCKED);
            }
        }

        private void sendNotification(String msg, NotificationLevel level) {
            this.sendNotification(msg, level, null);
        }

        private void sendNotification(String msg, NotificationLevel level, RetrievalEvent e) {
            String prefix = msg != null && msg.trim().length() > 0 && HeadlessMapProvider.this.requestingObject instanceof PrintTemplateFeature && HeadlessMapProvider.this.map.getSpecialFeatureCollection(PrintTemplateFeature.class).size() > 1 ? ((PrintTemplateFeature)HeadlessMapProvider.this.requestingObject).getName() + ": " : "";
            PropertyChangeEvent evt = new PropertyChangeEvent(HeadlessMapProvider.this, "notification", e, new NotificationMessage(prefix + msg, level));
            for (PropertyChangeListener tmpListener : this.listener) {
                tmpListener.propertyChange(evt);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancel = true;
            return !this.done;
        }

        @Override
        public boolean isCancelled() {
            return this.cancel;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public Image get() throws InterruptedException, ExecutionException {
            this.lock.lock();
            try {
                if (!this.isDone()) {
                    this.condition.await();
                }
                Image image = HeadlessMapProvider.this.map.getImage();
                return image;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Image get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.lock.lock();
            try {
                if (!this.isDone() && !this.condition.await(timeout, unit)) {
                    throw new TimeoutException();
                }
                Image image = HeadlessMapProvider.this.map.getImage();
                return image;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public static enum RoundingPrecision {
        NO_ROUNDING,
        TENTH,
        HUNDRETH,
        THOUSANDTH;

    }

    public static enum NotificationLevel {
        TIP,
        INFO,
        SUCCESS,
        EXPERT,
        WARN,
        ERROR,
        ERROR_REASON,
        UNLOCKED;

    }

    public static enum DominatingDimension {
        SIZE,
        BOUNDINGBOX;

    }
}

