/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.drophandler.builtin;

import de.cismet.cismap.commons.drophandler.MappingComponentDropHandler;
import de.cismet.cismap.commons.drophandler.MappingComponentDropHandlerFileMatcher;
import de.cismet.cismap.commons.drophandler.filematcher.builtin.MappingComponentDropHandlerFileExtensionMatcher;
import de.cismet.cismap.commons.gui.layerwidget.LayerDropUtils;
import de.cismet.cismap.commons.gui.layerwidget.LayerWidget;
import de.cismet.cismap.commons.gui.layerwidget.LayerWidgetProvider;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;

public class MappingComponentShapeFileDropHandler
implements MappingComponentDropHandler,
LayerWidgetProvider {
    private static final Collection<String> EXTENSIONS = Arrays.asList(".shp".substring(1), ".dbf".substring(1), ".csv".substring(1));
    private final MappingComponentDropHandlerFileMatcher fileMatcher = new MappingComponentDropHandlerFileExtensionMatcher(EXTENSIONS);
    private LayerWidget layerWidget;

    @Override
    public int getPriority() {
        return 10000;
    }

    @Override
    public void dropFiles(Collection<File> files) {
        for (File file : files) {
            LayerDropUtils.handleFeatureServiceFile(file, this.layerWidget.getMappingModel(), -1, this.layerWidget);
        }
    }

    @Override
    public MappingComponentDropHandlerFileMatcher getFileMatcher() {
        return this.fileMatcher;
    }

    @Override
    public LayerWidget getLayerWidget() {
        return this.layerWidget;
    }

    @Override
    public void setLayerWidget(LayerWidget layerWidget) {
        this.layerWidget = layerWidget;
    }
}

