/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.drophandler.builtin;

import de.cismet.cismap.commons.drophandler.MappingComponentDropHandler;
import de.cismet.cismap.commons.drophandler.MappingComponentDropHandlerFileMatcher;
import de.cismet.cismap.commons.gui.layerwidget.LayerDropUtils;
import de.cismet.cismap.commons.gui.layerwidget.LayerWidget;
import de.cismet.cismap.commons.gui.layerwidget.LayerWidgetProvider;
import de.cismet.cismap.commons.rasterservice.ImageFileUtils;
import java.io.File;
import java.util.Collection;

public class MappingComponentWorldFileDropHandler
implements MappingComponentDropHandler,
LayerWidgetProvider {
    private final MappingComponentDropHandlerFileMatcher fileMatcher = new WorldFileMatcher();
    private LayerWidget layerWidget;

    @Override
    public int getPriority() {
        return 10000;
    }

    @Override
    public void dropFiles(Collection<File> files) {
        for (File file : files) {
            LayerDropUtils.handleImageFile(file, this.layerWidget.getMappingModel(), -1, this.layerWidget, ImageFileUtils.Mode.WORLDFILE);
        }
    }

    @Override
    public MappingComponentDropHandlerFileMatcher getFileMatcher() {
        return this.fileMatcher;
    }

    @Override
    public LayerWidget getLayerWidget() {
        return this.layerWidget;
    }

    @Override
    public void setLayerWidget(LayerWidget layerWidget) {
        this.layerWidget = layerWidget;
    }

    class WorldFileMatcher
    implements MappingComponentDropHandlerFileMatcher {
        WorldFileMatcher() {
        }

        @Override
        public boolean isMatching(File file) {
            File worldFile = ImageFileUtils.getWorldFile(file);
            return ImageFileUtils.isImageFileEnding(file.getName()) && worldFile != null && !ImageFileUtils.checkIfRasterGeoRef(worldFile);
        }
    }
}

