/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.drophandler.filematcher.builtin;

import de.cismet.cismap.commons.drophandler.MappingComponentDropHandlerFileMatcher;
import java.io.File;
import java.util.regex.Pattern;

public class MappingComponentDropHandlerFileNameMatcher
implements MappingComponentDropHandlerFileMatcher {
    private final String matchString;
    private final boolean regex;

    public MappingComponentDropHandlerFileNameMatcher(String matchString, boolean regex) {
        this.regex = regex;
        this.matchString = matchString;
    }

    @Override
    public boolean isMatching(File file) {
        if (file == null) {
            return false;
        }
        if (this.regex) {
            return Pattern.matches(this.matchString, file.getName());
        }
        return file.getName().equals(this.matchString);
    }

    public String getMatchString() {
        return this.matchString;
    }

    public boolean isRegex() {
        return this.regex;
    }
}

