/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.features;

import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureGroup;
import de.cismet.cismap.commons.features.FeatureGroups;
import de.cismet.cismap.commons.features.PreventNamingDuplicates;
import de.cismet.cismap.commons.gui.MapListener;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.tools.CurrentStackTrace;
import de.cismet.veto.VetoException;
import de.cismet.veto.VetoListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class DefaultFeatureCollection
implements FeatureCollection,
MapListener {
    protected List<Feature> features = new ArrayList<Feature>();
    protected final Set<FeatureCollectionListener> listeners = new HashSet<FeatureCollectionListener>();
    protected LinkedHashSet<Feature> holdFeatures = new LinkedHashSet();
    protected Set<Feature> selectedFeatures = Collections.newSetFromMap(new ConcurrentHashMap());
    protected boolean holdAll = false;
    private final Logger log = Logger.getLogger(this.getClass());
    private boolean singleSelection = false;
    private ArrayList<VetoListener> vetoListeners = new ArrayList();

    public void setFeatureAt(Feature feature, int index) {
        if (!this.features.contains(feature)) {
            this.features.add(index, feature);
        }
    }

    @Override
    public Feature getFeature(int index) {
        try {
            if (index < this.features.size()) {
                return this.features.get(index);
            }
            this.log.warn((Object)("feature does not exist anymore:" + index));
            return null;
        }
        catch (Exception e) {
            this.log.fatal((Object)("error in getFeature:" + index), (Throwable)e);
            return null;
        }
    }

    public void addVetoableSelectionListener(VetoListener vetoListener) {
        if (vetoListener != null) {
            this.vetoListeners.add(vetoListener);
        }
    }

    public void removeVetoableSelectionListener(VetoListener vetoListener) {
        if (vetoListener != null) {
            this.vetoListeners.remove(vetoListener);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public void addFeatureCollectionListener(FeatureCollectionListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeFeatureCollectionListener(FeatureCollectionListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setTranslucency(float t) {
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    @Override
    public List<Feature> getAllFeatures() {
        return this.features;
    }

    @Override
    public int getFeatureCount() {
        return this.features.size();
    }

    @Override
    public void setLayerPosition(int layerPosition) {
    }

    @Override
    public int getLayerPosition() {
        return 0;
    }

    @Override
    public String getName() {
        return "DefaultFeatureCollection";
    }

    @Override
    public float getTranslucency() {
        return 1.0f;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean areFeaturesEditable() {
        ArrayList<Feature> vf = new ArrayList<Feature>(this.features);
        for (Feature f : vf) {
            if (!f.isEditable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unholdFeature(Feature f) {
        this.holdFeatures.remove(f);
        HashSet<Feature> v = new HashSet<Feature>(2);
        v.add(f);
        this.fireFeaturesChanged(v);
    }

    @Override
    public void holdFeature(Feature f) {
        try {
            this.holdFeatures.add(f);
            HashSet<Feature> v = new HashSet<Feature>(2);
            v.add(f);
            this.fireFeaturesChanged(v);
        }
        catch (Throwable t) {
            this.log.error((Object)"Error during hold", t);
        }
    }

    @Override
    public boolean isHoldFeature(Feature f) {
        return this.holdFeatures.contains(f);
    }

    @Override
    public void setHoldAll(boolean holdAll) {
        this.holdAll = holdAll;
        if (holdAll) {
            this.holdFeatures.addAll(this.features);
        } else {
            this.holdFeatures.clear();
        }
        this.fireFeaturesChanged(this.features);
    }

    private boolean assertNoVeto() {
        for (VetoListener curVetoListener : this.vetoListeners) {
            try {
                curVetoListener.veto();
            }
            catch (VetoException ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void select(Feature f) {
        if (!this.assertNoVeto()) {
            return;
        }
        this.enforceSelect(f);
    }

    private void enforceSelect(Feature f) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("select(Feature f):" + f));
        }
        this.enforceUnselectAll();
        this.selectedFeatures.add(f);
        this.fireSelectionChanged(f);
    }

    @Override
    public void select(Collection<Feature> cf) {
        if (!this.assertNoVeto()) {
            return;
        }
        this.enforceSelect(cf);
    }

    private void enforceSelect(Collection<Feature> cf) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("select(Collection<Feature> cf):" + cf));
        }
        this.enforceUnselectAll(true);
        this.selectedFeatures.addAll(cf);
        this.fireSelectionChanged(cf);
    }

    @Override
    public void addToSelection(Feature f) {
        if (!this.assertNoVeto()) {
            return;
        }
        this.enforceAddToSelection(f);
    }

    private void enforceAddToSelection(Feature f) {
        HashSet<Feature> v = new HashSet<Feature>(2);
        v.add(f);
        this.enforceAddToSelection(v);
    }

    @Override
    public void addToSelection(Collection<Feature> cf) {
        if (this.assertNoVeto()) {
            this.enforceAddToSelection(cf);
        }
    }

    private void enforceAddToSelection(Collection<Feature> cf) {
        this.selectedFeatures.addAll(cf);
        this.fireSelectionChanged(cf);
    }

    @Override
    public void unselect(Feature f) {
        if (this.assertNoVeto()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("unselect(Feature f):" + f));
            }
            this.enforceUnselect(f);
        }
    }

    private void enforceUnselect(Feature f) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("unselect(Feature f):" + f));
        }
        this.selectedFeatures.remove(f);
        this.fireSelectionChanged(f);
    }

    @Override
    public void unselectAll() {
        if (this.assertNoVeto()) {
            this.enforceUnselectAll();
        }
    }

    private void enforceUnselectAll() {
        this.enforceUnselectAll(false);
    }

    @Override
    public void unselectAll(boolean quiet) {
        if (this.assertNoVeto()) {
            this.enforceUnselectAll(quiet);
        }
    }

    private void enforceUnselectAll(boolean quiet) {
        if (this.selectedFeatures.size() > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"unselectAll()");
            }
            LinkedHashSet<Feature> lhs = new LinkedHashSet<Feature>(this.selectedFeatures);
            this.selectedFeatures.clear();
            if (!quiet) {
                this.fireSelectionChanged(lhs);
            }
        }
    }

    @Override
    public void unselect(Collection<Feature> cf) {
        if (this.assertNoVeto()) {
            this.enforceUnselect(cf);
        }
    }

    private void enforceUnselect(Collection<Feature> cf) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("unselect(Collection<Feature> cf):" + cf));
        }
        this.selectedFeatures.removeAll(cf);
        this.fireSelectionChanged();
    }

    @Override
    public Collection getSelectedFeatures() {
        return new LinkedHashSet<Feature>(this.selectedFeatures);
    }

    @Override
    public boolean isSelected(Feature f) {
        return this.selectedFeatures.contains(f);
    }

    @Override
    public void removeFeature(Feature f) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("before removal:" + this.features));
        }
        boolean removed = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("featureToRemove: " + f));
            this.log.debug((Object)("Feature sizes: " + this.features.size()));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Features: " + this.features));
        }
        removed = this.features.remove(f);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("feature removed: " + removed));
        }
        removed = this.holdFeatures.remove(f);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("holdFeature removed: " + removed));
        }
        removed = this.selectedFeatures.remove(f);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("selected removed: " + removed));
        }
        HashSet<Feature> v = new HashSet<Feature>(2);
        v.add(f);
        this.fireFeaturesRemoved(v);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("after removal:" + this.features));
        }
    }

    @Override
    public void removeFeatures(Collection<Feature> cf) {
        this.features.removeAll(cf);
        this.holdFeatures.removeAll(cf);
        this.fireFeaturesRemoved(cf);
    }

    @Override
    public void addFeature(Feature f) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("addFeature(Feature f):" + f));
        }
        if (f != null && f.getGeometry() != null && !this.features.contains(f)) {
            this.features.add(f);
            HashSet<Feature> v = new HashSet<Feature>(2);
            v.add(f);
            this.checkForAndCorrectDoubleNaming(f);
            this.fireFeaturesAdded(v);
        } else {
            this.log.warn((Object)"Feature was not added. It is either null or getGeometry() is null or it is already in the Collection.");
        }
    }

    @Override
    public void addFeatures(Collection<? extends Feature> cf) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("addFeatures(Collection<Feature> cf):" + cf));
        }
        ArrayList<Feature> v = new ArrayList<Feature>();
        for (Feature feature : cf) {
            if (this.features.contains(feature)) continue;
            this.features.add(feature);
            if (this.holdAll) {
                this.holdFeatures.add(feature);
            }
            v.add(feature);
            this.checkForAndCorrectDoubleNaming(feature);
        }
        if (v.size() > 0) {
            this.fireFeaturesAdded(v);
        }
    }

    @Override
    public void substituteFeatures(Collection<Feature> cf) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"substitute: delete all");
            }
            this.removeAllFeatures();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("substitute: add:" + cf));
            }
            this.addFeatures(cf);
        }
        catch (Exception e) {
            this.log.error((Object)("Error in substituteFeatures new features:" + cf), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkForAndCorrectDoubleNaming(Feature feature) {
        if (feature instanceof PreventNamingDuplicates) {
            PreventNamingDuplicates changeableFeature = (PreventNamingDuplicates)((Object)feature);
            ArrayList<PreventNamingDuplicates> list = new ArrayList<PreventNamingDuplicates>();
            for (Feature feature2 : this.features) {
                if (!feature2.getClass().equals(feature.getClass()) || !(feature2 instanceof PreventNamingDuplicates)) continue;
                list.add((PreventNamingDuplicates)((Object)feature2));
            }
            if (list.size() > 1) {
                HashMap<PreventNamingDuplicates, Integer> sameNames = new HashMap<PreventNamingDuplicates, Integer>();
                for (PreventNamingDuplicates f : list) {
                    if (!f.getOriginalName().equals(changeableFeature.getOriginalName())) continue;
                    sameNames.put(f, f.getNumber());
                }
                if (sameNames.size() < 2) {
                    changeableFeature.setNumber(1);
                } else {
                    void var5_8;
                    boolean bl = true;
                    sameNames.remove(changeableFeature);
                    while (var5_8 < 10000 && sameNames.containsValue((int)var5_8)) {
                        ++var5_8;
                    }
                    changeableFeature.setNumber((int)var5_8);
                }
            } else {
                changeableFeature.setNumber(1);
            }
        }
    }

    public void clear() {
        this.holdFeatures.clear();
        this.removeAllFeatures();
    }

    public Collection<Feature> getHoldFeatures() {
        return this.holdFeatures;
    }

    @Override
    public void removeAllFeatures() {
        HashSet<Feature> cf = new HashSet<Feature>(this.features);
        this.features.clear();
        this.fireAllFeaturesRemoved(cf);
        ArrayList<? extends Feature> list = new ArrayList<Feature>();
        for (Feature f : this.holdFeatures) {
            if (f instanceof FeatureGroup) {
                list.addAll(FeatureGroups.expandAll((FeatureGroup)f));
                continue;
            }
            list.add(f);
        }
        this.addFeatures(list);
    }

    @Override
    public void reconsiderFeature(Feature f) {
        HashSet<Feature> reconsiderF = new HashSet<Feature>(2);
        reconsiderF.add(f);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("reconsiderFeature(Feature f):" + f), (Throwable)new CurrentStackTrace());
        }
        this.checkForAndCorrectDoubleNaming(f);
        Iterator<FeatureCollectionListener> it = this.getListenerIterator();
        while (it.hasNext()) {
            it.next().featureReconsiderationRequested(new FeatureCollectionEvent(this, reconsiderF));
        }
    }

    public void fireFeaturesAdded(Collection<Feature> cf) {
        Iterator<FeatureCollectionListener> it = this.getListenerIterator();
        while (it.hasNext()) {
            FeatureCollectionListener curListener = it.next();
            if (!(curListener instanceof MappingComponent)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"adding featuresTo Map");
            }
            ((MappingComponent)curListener).addFeaturesToMap(cf.toArray(new Feature[0]));
        }
    }

    public void fireFeaturesRemoved(Collection<Feature> cf) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"fireFeaturesRemoved");
        }
        Iterator<FeatureCollectionListener> it = this.getListenerIterator();
        while (it.hasNext()) {
            it.next().featuresRemoved(new FeatureCollectionEvent(this, cf));
        }
    }

    public void fireAllFeaturesRemoved(Collection<Feature> cf) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"fireAllFeaturesRemoved");
        }
        Iterator<FeatureCollectionListener> it = this.getListenerIterator();
        while (it.hasNext()) {
            it.next().allFeaturesRemoved(new FeatureCollectionEvent(this, cf));
        }
    }

    public void fireFeaturesChanged(Collection<Feature> cf) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"fireFeaturesChanged");
        }
        Iterator<FeatureCollectionListener> it = this.getListenerIterator();
        while (it.hasNext()) {
            it.next().featuresChanged(new FeatureCollectionEvent(this, cf));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<FeatureCollectionListener> getListenerIterator() {
        Iterator<FeatureCollectionListener> it;
        Set<FeatureCollectionListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<FeatureCollectionListener>(this.listeners).iterator();
        }
        return it;
    }

    public void fireSelectionChanged() {
        this.fireSelectionChanged((Collection<Feature>)null);
    }

    public void fireSelectionChanged(Collection<Feature> cf) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"fireSelectionChanged");
        }
        Iterator<FeatureCollectionListener> it = this.getListenerIterator();
        while (it.hasNext()) {
            it.next().featureSelectionChanged(new FeatureCollectionEvent(this, cf));
        }
    }

    public void fireSelectionChanged(Feature f) {
        HashSet<Feature> v = new HashSet<Feature>(2);
        v.add(f);
        this.fireSelectionChanged(v);
    }

    @Override
    public void setName(String name) {
    }

    public void removeFeaturesByInstance(Class c) {
        ArrayList<Feature> af = new ArrayList<Feature>(this.features);
        for (Feature f : af) {
            if (!c.isInstance(f)) continue;
            this.removeFeature(f);
        }
    }

    public boolean isSingleSelection() {
        return this.singleSelection;
    }

    public void setSingleSelection(boolean singleSelection) {
        this.singleSelection = singleSelection;
    }

    @Override
    public void featuresAddedToMap(Collection<Feature> cf) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"fireFeaturesAddedToMap");
        }
        Iterator<FeatureCollectionListener> it = this.getListenerIterator();
        while (it.hasNext()) {
            it.next().featuresAdded(new FeatureCollectionEvent(this, cf));
        }
    }

    @Override
    public boolean contains(Feature feature) {
        return this.features.contains(feature);
    }
}

