/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.ConvertableToXML;
import de.cismet.cismap.commons.featureservice.FeatureServiceUtilities;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class FeatureServiceAttribute
implements ConvertableToXML,
Cloneable {
    public static final String IS_SELECTED = "isSelected";
    private final Logger log = Logger.getLogger(this.getClass());
    private String type;
    private String name;
    private boolean geometry;
    private boolean selected;
    private boolean visible = true;
    private boolean nameElement = false;
    private String alias;
    private boolean ascOrder = true;

    public FeatureServiceAttribute(Element e) throws Exception {
        this.initFromElement(e);
    }

    public FeatureServiceAttribute(String name, String type, boolean isSelected) {
        this.setName(name);
        if (FeatureServiceUtilities.isElementOfGeometryType(type)) {
            this.setGeometry(true);
        }
        this.setSelected(isSelected);
        this.setType(type);
    }

    protected FeatureServiceAttribute(FeatureServiceAttribute featureServiceAttribute) {
        this(new String(featureServiceAttribute.getName()), String.valueOf(featureServiceAttribute.getType()), featureServiceAttribute.isSelected());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        if (this.alias == null) {
            return "";
        }
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setGeometry(boolean isGeometry) {
        this.geometry = isGeometry;
    }

    public boolean isGeometry() {
        return this.geometry;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean isSelected) {
        this.selected = isSelected;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isNameElement() {
        return this.nameElement;
    }

    public void setNameElement(boolean nameElement) {
        this.nameElement = nameElement;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureServiceAttribute other = (FeatureServiceAttribute)obj;
        if (!(this.type == other.type || this.type != null && this.type.equals(other.type))) {
            return false;
        }
        if (!(this.name == other.name || this.name != null && this.name.equals(other.name))) {
            return false;
        }
        if (!(this.alias == other.alias || this.alias != null && this.alias.equals(other.alias))) {
            return false;
        }
        if (this.geometry != other.geometry) {
            return false;
        }
        if (this.selected != other.selected) {
            return false;
        }
        if (this.visible != other.visible) {
            return false;
        }
        return this.nameElement == other.nameElement;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 71 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 71 * hash + (this.geometry ? 1 : 0);
        hash = 71 * hash + (this.selected ? 1 : 0);
        return hash;
    }

    @Override
    public Element toElement() {
        Element featureServiceAttribute = new Element(FeatureServiceAttribute.class.getSimpleName());
        featureServiceAttribute.setAttribute("type", this.getClass().getCanonicalName());
        featureServiceAttribute.setAttribute("name", this.getName());
        featureServiceAttribute.setAttribute("alias", this.getAlias());
        featureServiceAttribute.setAttribute("isGeometry", String.valueOf(this.isGeometry()));
        featureServiceAttribute.setAttribute(IS_SELECTED, String.valueOf(this.selected));
        featureServiceAttribute.setAttribute("isVisible", String.valueOf(this.visible));
        featureServiceAttribute.setAttribute("isNameElement", String.valueOf(this.nameElement));
        featureServiceAttribute.setAttribute("type", this.getType());
        return featureServiceAttribute;
    }

    @Override
    public void initFromElement(Element element) throws Exception {
        if (element.getAttribute("type") == null) {
            this.log.warn((Object)"fromElement: restoring object from deprecarted xml element");
        }
        this.setName(element.getAttributeValue("name"));
        this.setAlias(element.getAttributeValue("alias"));
        this.setType(element.getAttributeValue("type"));
        boolean newSelected = element.getAttributeValue(IS_SELECTED) != null ? Boolean.valueOf(element.getAttributeValue(IS_SELECTED)) : true;
        this.setSelected(newSelected);
        boolean newVisible = element.getAttributeValue("isVisible") != null ? Boolean.valueOf(element.getAttributeValue("isVisible")) : true;
        this.setVisible(newVisible);
        boolean newNameElement = element.getAttributeValue("isNameElement") != null ? Boolean.valueOf(element.getAttributeValue("isNameElement")) : false;
        this.setNameElement(newNameElement);
        boolean newGeometry = this.getType() != null && FeatureServiceUtilities.isElementOfGeometryType(this.type);
        this.setGeometry(newGeometry);
    }

    public FeatureServiceAttribute clone() {
        return new FeatureServiceAttribute(this);
    }

    public boolean isAscOrder() {
        return this.ascOrder;
    }

    public void setAscOrder(boolean ascOrder) {
        this.ascOrder = ascOrder;
    }
}

