/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.featureservice.LinearReferencingInfo;
import de.cismet.cismap.commons.gui.attributetable.DefaultAttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.linearreferencing.tools.StationTableCellEditorInterface;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import org.openide.util.Lookup;

public class H2AttributeTableRuleSet
extends DefaultAttributeTableRuleSet {
    private static final Logger LOG = Logger.getLogger(H2AttributeTableRuleSet.class);
    private final List<LinearReferencingInfo> refInfos;
    private Map<String, LinearReferencingInfo> refInfoMap;
    private final String geometryType;

    public H2AttributeTableRuleSet(List<LinearReferencingInfo> refInfos, String geometryType) {
        this.refInfos = refInfos;
        this.geometryType = geometryType;
        if (refInfos != null) {
            this.refInfoMap = new HashMap<String, LinearReferencingInfo>();
            for (LinearReferencingInfo info : refInfos) {
                this.refInfoMap.put(info.getFromField(), info);
                if (info.getTillField() == null) continue;
                this.refInfoMap.put(info.getTillField(), info);
            }
        }
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        StationTableCellEditorInterface editor;
        StationTableCellEditorInterface editorCopy;
        Collection cellEditor;
        LinearReferencingInfo refInfo = this.getInfoForColumn(columnName);
        if (refInfo != null && (cellEditor = Lookup.getDefault().lookupAll(StationTableCellEditorInterface.class)) != null && cellEditor.size() > 0 && (editorCopy = this.createNewInstance(editor = cellEditor.toArray(new StationTableCellEditorInterface[1])[0])) != null) {
            editorCopy.setLinRefInfos(this.refInfos);
            editorCopy.setColumnName(columnName);
            return editorCopy;
        }
        return super.getCellEditor(columnName);
    }

    @Override
    public FeatureCreator getFeatureCreator() {
        if (this.refInfos == null || this.refInfos.isEmpty()) {
            if (this.geometryType.equalsIgnoreCase("Point")) {
                return new PrimitiveGeometryCreator("POINT", false);
            }
            if (this.geometryType.equalsIgnoreCase("MultiPoint")) {
                return new PrimitiveGeometryCreator("POINT", true);
            }
            if (this.geometryType.equalsIgnoreCase("LineString")) {
                return new PrimitiveGeometryCreator("LINESTRING", false);
            }
            if (this.geometryType.equalsIgnoreCase("MultiLineString")) {
                return new PrimitiveGeometryCreator("LINESTRING", true);
            }
            if (this.geometryType.equalsIgnoreCase("Polygon")) {
                return new PrimitiveGeometryCreator("POLYGON", false);
            }
            if (this.geometryType.equalsIgnoreCase("MultiPolygon")) {
                return new PrimitiveGeometryCreator("POLYGON", true);
            }
        }
        return super.getFeatureCreator();
    }

    private StationTableCellEditorInterface createNewInstance(StationTableCellEditorInterface editor) {
        try {
            Constructor<?> c = editor.getClass().getConstructor(new Class[0]);
            return (StationTableCellEditorInterface)c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot create a new instance of class " + editor.getClass().getName()), (Throwable)e);
            return null;
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    public LinearReferencingInfo getInfoForColumn(String columnName) {
        if (this.refInfoMap == null) {
            return null;
        }
        return this.refInfoMap.get(columnName);
    }

    public List<LinearReferencingInfo> getAllLinRefInfos() {
        return this.refInfos;
    }
}

