/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.exceptions.ShapeFileImportAborted;
import de.cismet.cismap.commons.features.ShapeFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.DocumentFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.ShapeFeatureFactory;
import de.cismet.cismap.commons.featureservice.style.BasicStyle;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.DefaultQueryButtonAction;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.deegree.style.se.unevaluated.Style;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ShapeFileFeatureService
extends DocumentFeatureService<ShapeFeature, String> {
    private static final transient Logger LOG = Logger.getLogger(ShapeFileFeatureService.class);
    public static final Map<Integer, Icon> layerIcons = new HashMap<Integer, Icon>();
    public static final String SHAPE_FEATURELAYER_TYPE = "ShapeFeatureServiceLayer";
    public static final List<DefaultQueryButtonAction> SQL_QUERY_BUTTONS = new ArrayList<DefaultQueryButtonAction>();
    protected List<DefaultQueryButtonAction> queryButtons = new ArrayList<DefaultQueryButtonAction>(SQL_QUERY_BUTTONS);
    private boolean noGeometryRecognised = false;
    private boolean errorInGeometryFound = false;
    private boolean fileNotFound = false;
    private String geometryType = UNKNOWN;
    private String shapeCrs;
    private Crs crs;

    public ShapeFileFeatureService(Element e) throws Exception {
        super(e);
        this.checkFile();
    }

    public ShapeFileFeatureService(String name, URI documentURI, long documentSize, List<FeatureServiceAttribute> attributes) throws Exception {
        super(name, documentURI, documentSize, attributes);
        this.maxFeatureCount = Integer.MAX_VALUE;
        this.checkFile();
    }

    protected ShapeFileFeatureService(ShapeFileFeatureService sfs) {
        super(sfs);
        this.geometryType = sfs.geometryType;
        this.checkFile();
    }

    private void checkFile() {
        File file = new File(this.documentURI);
        this.fileNotFound = !file.exists();
    }

    @Override
    public Icon getLayerIcon(int type) {
        return layerIcons.get(type);
    }

    @Override
    protected LayerProperties createLayerProperties() {
        DefaultLayerProperties defaultLayerProperties = new DefaultLayerProperties();
        defaultLayerProperties.setIdExpression(null, -1);
        defaultLayerProperties.setFeatureService(this);
        return defaultLayerProperties;
    }

    @Override
    protected FeatureFactory createFeatureFactory() throws Exception {
        try {
            String sldString;
            ShapeFeatureFactory sff = new ShapeFeatureFactory(this.getLayerProperties(), this.getDocumentURI(), this.maxSupportedFeatureCount, this.layerInitWorker, this.parseSLD(this.getSLDDefiniton()), this.shapeCrs);
            this.noGeometryRecognised = sff.isNoGeometryRecognised();
            this.errorInGeometryFound = sff.isErrorInGeometryFound();
            this.geometryType = sff.getGeometryType();
            if (this.crs != null) {
                sff.setCrs(this.crs);
            }
            if ((sldString = sff.getSldDefinition()) != null && !sldString.isEmpty()) {
                if (sldString.contains("StyleHistoryElement")) {
                    SAXBuilder saxBuilder = new SAXBuilder(false);
                    StringReader stringReader = new StringReader(sldString);
                    Document document = saxBuilder.build((Reader)stringReader);
                    BasicStyle style = new BasicStyle(document.getRootElement());
                    if (this.getLayerProperties() != null) {
                        this.getLayerProperties().setStyle(style);
                    }
                } else {
                    this.sldDefinition = sldString;
                    Map<String, LinkedList<Style>> styles = this.parseSLD(new StringReader(sldString));
                    if (styles != null && !styles.isEmpty()) {
                        sff.setSLDStyle(styles);
                    }
                }
            }
            return sff;
        }
        catch (ShapeFileImportAborted e) {
            CismapBroker.getInstance().getMappingComponent().getMappingModel().removeLayer(this);
            throw e;
        }
    }

    @Override
    public String getQuery() {
        return null;
    }

    @Override
    public void setQuery(String query) {
        LOG.warn((Object)("unexpected call to setQuery, not supported by this service:\n" + query));
    }

    @Override
    protected void initConcreteInstance() throws Exception {
    }

    @Override
    public void setDocumentURI(URI documentURI) {
        super.setDocumentURI(documentURI);
        if (this.getFeatureFactory() != null) {
            ((ShapeFeatureFactory)this.getFeatureFactory()).setDocumentURI(documentURI);
        }
        this.checkFile();
    }

    @Override
    protected String getFeatureLayerType() {
        return SHAPE_FEATURELAYER_TYPE;
    }

    @Override
    public Object clone() {
        LOG.info((Object)("cloning service " + this.getName()));
        return new ShapeFileFeatureService(this);
    }

    public boolean isNoGeometryRecognised() {
        return this.noGeometryRecognised;
    }

    public boolean isErrorInGeometryFound() {
        return this.errorInGeometryFound;
    }

    public boolean isFileNotFound() {
        return this.fileNotFound;
    }

    public void setCrs(Crs crs) {
        if (this.featureFactory != null) {
            ((ShapeFeatureFactory)this.featureFactory).setCrs(crs);
        } else {
            this.crs = crs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLayerProperties(LayerProperties layerProperties, boolean refreshFeatures) {
        super.setLayerProperties(layerProperties, refreshFeatures);
        if ((this.sldDefinition == null || this.sldDefinition.isEmpty()) && layerProperties != null && layerProperties.getStyle() != null) {
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            StringWriter writer = new StringWriter();
            try {
                Element e = layerProperties.getStyle().toElement();
                out.output(e, (Writer)writer);
                this.writeStyleFile(writer.toString());
            }
            catch (IOException e) {
                LOG.error((Object)"Error while saving style", (Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    LOG.error((Object)"Error while closing string writer", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public List<DefaultQueryButtonAction> getQueryButtons() {
        return this.queryButtons;
    }

    @Override
    public void setSLDInputStream(String inputStream) {
        super.setSLDInputStream(inputStream);
        if (inputStream != null && !inputStream.isEmpty()) {
            this.writeStyleFile(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStyleFile(String content) {
        String filename = null;
        if (this.documentURI.getPath().toLowerCase().endsWith(".shp")) {
            filename = this.documentURI.getPath().substring(0, this.documentURI.getPath().length() - 4);
            filename = filename + ".sld";
        } else if (!this.documentURI.getPath().contains(".")) {
            filename = this.documentURI.getPath() + ".sld";
        }
        if (filename != null) {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(filename));
                writer.write(content);
                writer.close();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while writing sld file", (Throwable)e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ex) {
                        LOG.error((Object)"Error while closing sld file", (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public String getGeometryType() {
        return this.geometryType;
    }

    @Override
    public void initFromElement(Element element) throws Exception {
        super.initFromElement(element);
        if (element.getAttributeValue("shapeCrs") != null) {
            String crs = element.getAttributeValue("shapeCrs");
            this.shapeCrs = CismapBroker.getInstance().crsFromCode(crs).getCode();
        }
    }

    @Override
    public Element toElement() {
        Element e = super.toElement();
        String crs = null;
        if (this.getFeatureFactory() != null) {
            crs = ((ShapeFeatureFactory)this.getFeatureFactory()).getShapeCrs();
        } else if (this.shapeCrs != null) {
            crs = this.shapeCrs;
        }
        if (crs != null) {
            e.setAttribute("shapeCrs", crs);
        }
        return e;
    }

    static {
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("=="));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("!="));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction(">"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction(">="));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("&&", "And"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("<"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("<="));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("||", "Or"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("()"){
            {
                this.posCorrection = -1;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.queryTextArea.getSelectionEnd() == 0) {
                    super.actionPerformed(e);
                } else {
                    int start = this.queryTextArea.getSelectionStart();
                    int end = this.queryTextArea.getSelectionEnd();
                    this.queryTextArea.insert("(", start);
                    this.queryTextArea.insert(")", end + 1);
                    if (start == end) {
                        this.CorrectCarret(this.posCorrection);
                    } else {
                        this.CorrectCarret(2);
                    }
                }
            }
        });
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("!", "Not"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("null"));
        layerIcons.put(0, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerShape.png")));
        layerIcons.put(2, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerShapeInvisible.png")));
        layerIcons.put(1, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerShape.png")));
        layerIcons.put(3, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerShapeInvisible.png")));
    }
}

