/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.LayerInfoProvider;
import de.cismet.cismap.commons.features.PostgisFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.SimpleFeatureServiceSqlStatement;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.PostgisFeatureFactory;
import de.cismet.commons.wms.capabilities.Layer;
import de.cismet.tools.ConnectionInfo;
import java.awt.Color;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

public class SimplePostgisFeatureService
extends AbstractFeatureService<PostgisFeature, SimpleFeatureServiceSqlStatement>
implements LayerInfoProvider {
    private static final transient Logger LOG = Logger.getLogger(SimplePostgisFeatureService.class);
    public static final String POSTGIS_FEATURELAYER_TYPE = "simplePostgisFeatureService";
    public static final HashMap<Integer, Icon> layerIcons = new HashMap();
    private SimpleFeatureServiceSqlStatement sqlStatement;
    private ConnectionInfo connectionInfo;

    public SimplePostgisFeatureService(SimplePostgisFeatureService spfs) {
        super(spfs);
        this.connectionInfo = spfs.getConnectionInfo();
        this.sqlStatement = spfs.getQuery();
    }

    public SimplePostgisFeatureService(Element element) throws Exception {
        super(element);
    }

    @Override
    public void initFromElement(Element element) throws Exception {
        super.initFromElement(element);
        if (element.getChild("dbConnectionInfo") != null) {
            ConnectionInfo newConnectionInfo = new ConnectionInfo(element.getChild("dbConnectionInfo"));
            this.setConnectionInfo(newConnectionInfo);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SimplePostgisFeatureService initialised with connection: \n" + this.getConnectionInfo().getUrl() + ", " + this.getConnectionInfo().getDriver() + ", " + this.getConnectionInfo().getUser()));
            }
        } else {
            LOG.error((Object)"missing element 'dbConnectionInfo' in xml configuration");
        }
        this.sqlStatement = new SimpleFeatureServiceSqlStatement(element.getChild("statement").getTextTrim());
        this.sqlStatement.setAllFields(element.getChild("allFields").getTextTrim());
        this.sqlStatement.setOrderBy(element.getChild("orderBy").getTextTrim());
    }

    @Override
    public Element toElement() {
        Element e = super.toElement();
        if (this.sqlStatement != null) {
            Element stmnt = new Element("statement");
            stmnt.addContent((Content)new CDATA(this.sqlStatement.getSqlTemplate()));
            e.addContent((Content)stmnt);
            Element allFields = new Element("allFields");
            allFields.addContent((Content)new CDATA(this.sqlStatement.getAllFields()));
            e.addContent((Content)allFields);
            Element orderBy = new Element("orderBy");
            orderBy.addContent((Content)new CDATA(this.sqlStatement.getOrderBy()));
            e.addContent((Content)orderBy);
        } else {
            LOG.warn((Object)"sql statement is null and cannot be saved");
        }
        if (this.connectionInfo != null) {
            Element connectionElement = new Element("dbConnectionInfo");
            connectionElement.addContent((Content)new Element("driverClass").addContent(this.getConnectionInfo().getDriver()));
            connectionElement.addContent((Content)new Element("dbUrl").addContent(this.getConnectionInfo().getUrl()));
            connectionElement.addContent((Content)new Element("user").addContent(this.getConnectionInfo().getUser()));
            connectionElement.addContent((Content)new Element("pass").addContent(this.getConnectionInfo().getPass()));
            e.addContent((Content)connectionElement);
        } else {
            LOG.warn((Object)"connection info is null and cannot be saved");
        }
        return e;
    }

    @Override
    protected LayerProperties createLayerProperties() {
        DefaultLayerProperties defaultLayerProperties = new DefaultLayerProperties();
        defaultLayerProperties.getStyle().setLineColor(new Color(0.6f, 0.6f, 0.6f, 0.7f));
        defaultLayerProperties.getStyle().setFillColor(new Color(0.2f, 0.2f, 0.2f, 0.7f));
        defaultLayerProperties.setQueryType(-1);
        defaultLayerProperties.setFeatureService(this);
        return defaultLayerProperties;
    }

    @Override
    protected FeatureFactory createFeatureFactory() throws Exception {
        return new PostgisFeatureFactory(this.getLayerProperties(), this.getConnectionInfo(), null, this);
    }

    @Override
    public SimpleFeatureServiceSqlStatement getQuery() {
        return this.sqlStatement;
    }

    @Override
    public void setQuery(SimpleFeatureServiceSqlStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    @Override
    protected void initConcreteInstance() throws Exception {
    }

    @Override
    protected String getFeatureLayerType() {
        return POSTGIS_FEATURELAYER_TYPE;
    }

    @Override
    public Icon getLayerIcon(int type) {
        return layerIcons.get(type);
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    @Override
    public SimplePostgisFeatureService clone() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("cloning SimplePostgisFeatureService " + this.getName()));
        }
        return new SimplePostgisFeatureService(this);
    }

    @Override
    public String getLayerURI() {
        return this.sqlStatement.getSqlTemplate();
    }

    @Override
    public String getServerURI() {
        return this.connectionInfo.toString();
    }

    @Override
    public boolean isLayerQuerySelected() {
        return false;
    }

    @Override
    public void setLayerQuerySelected(boolean selected) {
    }

    @Override
    public boolean isQueryable() {
        return false;
    }

    @Override
    public Layer getLayerInformation() {
        return null;
    }

    static {
        layerIcons.put(0, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerPostgis.png")));
        layerIcons.put(2, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerPostgisInvisible.png")));
        layerIcons.put(1, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerPostgis.png")));
        layerIcons.put(3, new ImageIcon(AbstractFeatureService.class.getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disabled/layerPostgisInvisible.png")));
    }
}

