/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.featureservice.SimplePostgisFeatureService;
import de.cismet.cismap.commons.featureservice.factory.PostgisAction;
import de.cismet.cismap.commons.featureservice.factory.PostgisFeatureFactory;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class SimpleUpdateablePostgisFeatureService
extends SimplePostgisFeatureService {
    private static final transient Logger LOG = Logger.getLogger(SimpleUpdateablePostgisFeatureService.class);
    protected PostgisAction postgisAction;

    public SimpleUpdateablePostgisFeatureService(SimpleUpdateablePostgisFeatureService supfs) {
        super(supfs);
        this.postgisAction = supfs.getPostgisAction();
    }

    public SimpleUpdateablePostgisFeatureService(Element element) throws Exception {
        super(element);
    }

    @Override
    public Element toElement() {
        Element element = super.toElement();
        element.setAttribute("updateable", "true");
        Element actionElement = new Element("action");
        actionElement.setAttribute("text", this.postgisAction.getActionText());
        actionElement.setAttribute("icon", this.postgisAction.getIconPath());
        actionElement.addContent((Content)new CDATA(this.postgisAction.getAction()));
        element.addContent((Content)actionElement);
        return element;
    }

    @Override
    public void initFromElement(Element element) throws Exception {
        super.initFromElement(element);
        Element actionElement = null;
        this.postgisAction = new PostgisAction();
        try {
            actionElement = element.getChild("action");
            this.postgisAction.setAction(actionElement.getText());
        }
        catch (Exception e) {
            LOG.warn((Object)("No action in updateable Service: " + e.getMessage()));
        }
        try {
            this.postgisAction.setActionText(actionElement.getAttribute("text").getValue());
            this.postgisAction.setIconPath(actionElement.getAttribute("icon").getValue());
            this.postgisAction.setIcon(new ImageIcon(this.getClass().getResource(this.postgisAction.getIconPath())));
        }
        catch (Exception e) {
            LOG.warn((Object)("No actiontext in updateable Service: " + e.getMessage()));
            this.postgisAction.setActionText(NbBundle.getMessage(SimpleUpdateablePostgisFeatureService.class, (String)"SimpleUpdateablePostgisFeatureService.initFromElement(Element).postgisAction.actionText"));
        }
    }

    public PostgisAction getPostgisAction() {
        return this.postgisAction;
    }

    @Override
    public SimpleUpdateablePostgisFeatureService clone() {
        return new SimpleUpdateablePostgisFeatureService(this);
    }

    @Override
    protected PostgisFeatureFactory createFeatureFactory() throws Exception {
        return new PostgisFeatureFactory(this.getLayerProperties(), this.getConnectionInfo(), this.postgisAction, this);
    }
}

