/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice;

import de.cismet.cismap.commons.capabilities.AbstractCapabilitiesTreeModel;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.FeatureServiceUtilities;
import de.cismet.cismap.commons.wfs.capabilities.FeatureType;
import de.cismet.cismap.commons.wfs.capabilities.WFSCapabilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class WFSCapabilitiesTreeModel
extends AbstractCapabilitiesTreeModel {
    private final transient Logger log = Logger.getLogger(this.getClass());
    private WFSCapabilities capabilities;
    private TreeMap<FeatureType, Vector<FeatureServiceAttribute>> nodes;
    private Vector listener = new Vector();

    public WFSCapabilitiesTreeModel(WFSCapabilities capabilities) throws IOException, Exception {
        this.nodes = FeatureServiceUtilities.getElementDeclarations(capabilities);
        this.capabilities = capabilities;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("nodes: " + this.nodes.size()));
        }
    }

    public Vector<FeatureServiceAttribute> getChildren(FeatureType feature) {
        return this.nodes.get(feature);
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof WFSCapabilities) {
            return false;
        }
        return !(node instanceof FeatureType) || this.nodes.get(node) == null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof WFSCapabilities) {
            if (this.filterString != null) {
                return this.getFilteredNodes().size();
            }
            return this.nodes.size();
        }
        return parent instanceof FeatureType && this.nodes.get(parent) != null ? this.nodes.get(parent).size() : 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listener.remove(l);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listener.add(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        int childs = this.getChildCount(parent);
        if (childs <= 0) {
            return null;
        }
        if (parent instanceof WFSCapabilities) {
            int correctedIndex = index;
            if (index >= childs) {
                correctedIndex = index - childs;
            }
            if (this.filterString != null) {
                List<FeatureType> allValidNodes = this.getFilteredNodes();
                return allValidNodes.get(correctedIndex);
            }
            return this.nodes.keySet().toArray()[correctedIndex];
        }
        if (index < childs) {
            return parent instanceof FeatureType && this.nodes.get(parent) != null ? this.nodes.get(parent).get(index) : null;
        }
        return parent instanceof FeatureType && this.nodes.get(parent) != null ? this.nodes.get(parent).get(index - childs) : null;
    }

    @Override
    public Object getRoot() {
        return this.capabilities;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return 0;
    }

    public WFSCapabilities getCapabilities() {
        return this.capabilities;
    }

    private List<FeatureType> getFilteredNodes() {
        ArrayList<FeatureType> allValidNodes = new ArrayList<FeatureType>();
        for (FeatureType feature : this.nodes.keySet()) {
            if (!(feature.getTitle() != null && feature.getTitle().toLowerCase().indexOf(this.filterString.toLowerCase()) != -1 || feature.getName() != null && feature.getName().toString().toLowerCase().indexOf(this.filterString.toLowerCase()) != -1) && !this.containsFilterString(feature.getKeywords())) continue;
            allValidNodes.add(feature);
        }
        return allValidNodes;
    }

    private boolean containsFilterString(String[] keywords) {
        if (keywords != null) {
            for (String tmp : keywords) {
                if (tmp == null || tmp.toLowerCase().indexOf(this.filterString.toLowerCase()) == -1) continue;
                return true;
            }
        }
        return false;
    }
}

