/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.style;

import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.SLDStyledLayer;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.featureservice.style.StyleDialog;
import de.cismet.cismap.commons.featureservice.style.StyleDialogInterface;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerTableCellEditor;
import de.cismet.cismap.commons.wfs.WFSFacade;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class BasicFeatureStyleDialogFactory
implements StyleDialogInterface {
    private static final boolean DEBUG = false;
    public static final String KEY = "basic";
    private final Logger logger = Logger.getLogger(this.getClass());
    private StyleDialog dialog;
    private AbstractFeatureService selectedService;
    private Frame parent;

    @Override
    public JDialog configureDialog(AbstractFeatureService FeatureService, Frame parentFrame, MappingComponent mappingComponent, ArrayList<String> configTabs) {
        this.selectedService = FeatureService;
        this.parent = parentFrame;
        this.dialog = new StyleDialog(parentFrame, true);
        this.dialog.configureDialog(FeatureService.getSLDDefiniton(), FeatureService.getName(), FeatureService.getLayerProperties(), FeatureService.getFeatureServiceAttributes(), FeatureService.getQuery());
        return this.dialog;
    }

    @Override
    public Runnable createResultTask() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    boolean forceUpdate = false;
                    if (BasicFeatureStyleDialogFactory.this.selectedService instanceof WebFeatureService) {
                        int i;
                        if (BasicFeatureStyleDialogFactory.this.dialog.isGeoAttributeChanged() || BasicFeatureStyleDialogFactory.this.dialog.isAttributeSelectionChanged()) {
                            Element query = ((WebFeatureService)BasicFeatureStyleDialogFactory.this.selectedService).getQueryElement();
                            WebFeatureService service = (WebFeatureService)BasicFeatureStyleDialogFactory.this.selectedService;
                            WFSFacade.setGeometry(query, BasicFeatureStyleDialogFactory.this.dialog.getSelectedGeoAttribute(), service.getVersion());
                            WFSFacade.changePropertyNames(query, BasicFeatureStyleDialogFactory.this.dialog.getSelectedAttributes(), service.getVersion());
                            service.setQueryElement(query);
                            forceUpdate = true;
                        }
                        if (BasicFeatureStyleDialogFactory.this.dialog.isQueryStringChanged() && (i = JOptionPane.showConfirmDialog(BasicFeatureStyleDialogFactory.this.parent, NbBundle.getMessage(ActiveLayerTableCellEditor.class, (String)"ActiveLayerTableCellEditor.mouseClicked(MouseEvent).showConfirmDialog.message"), NbBundle.getMessage(ActiveLayerTableCellEditor.class, (String)"ActiveLayerTableCellEditor.mouseClicked(MouseEvent).showConfirmDialog.title"), 0, 2)) == 0) {
                            BasicFeatureStyleDialogFactory.this.selectedService.setQuery(BasicFeatureStyleDialogFactory.this.dialog.getQueryString());
                            forceUpdate = true;
                        }
                    }
                    BasicFeatureStyleDialogFactory.this.selectedService.setFeatureServiceAttributes(BasicFeatureStyleDialogFactory.this.dialog.getFeatureServiceAttributes());
                    if (forceUpdate) {
                        ((WebFeatureService)BasicFeatureStyleDialogFactory.this.selectedService).setLayerPropertiesWithoutUpdate(BasicFeatureStyleDialogFactory.this.dialog.getLayerProperties());
                        BasicFeatureStyleDialogFactory.this.selectedService.retrieve(forceUpdate);
                    } else {
                        BasicFeatureStyleDialogFactory.this.selectedService.setLayerProperties(BasicFeatureStyleDialogFactory.this.dialog.getLayerProperties(), false);
                        if (BasicFeatureStyleDialogFactory.this.selectedService instanceof SLDStyledLayer) {
                            BasicFeatureStyleDialogFactory.this.selectedService.setSLDInputStream(BasicFeatureStyleDialogFactory.this.dialog.getSLDStyle());
                        }
                        BasicFeatureStyleDialogFactory.this.selectedService.refreshFeatures();
                    }
                }
                catch (Throwable t) {
                    BasicFeatureStyleDialogFactory.this.logger.error((Object)t.getMessage(), t);
                }
            }
        };
    }

    @Override
    public boolean isAccepted() {
        return this.dialog.isAccepted();
    }

    @Override
    public String getKey() {
        return KEY;
    }
}

