/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.style;

import de.cismet.cismap.commons.featureservice.style.Style;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.tools.gui.PointSymbolCreator;
import java.awt.Color;
import java.awt.Font;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class BasicStyle
implements Style {
    protected static final Font DEFAULT_FONT = new Font("SansSerif", 0, 12);
    protected static final String POINTSYMBOL_FOLDER = "/de/cismet/cismap/commons/featureservice/res/pointsymbols/";
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected boolean drawFill;
    protected boolean drawLine;
    protected Color colorFill;
    protected Color colorLine;
    protected int lineWidth;
    protected boolean highlightFeature;
    protected float alpha;
    protected String pointSymbolFilename = "Keins";
    protected int pointSymbolSize;
    protected boolean drawLabel;
    protected Font font;
    protected Color fontColor;
    protected String attribute;
    protected float alignment;
    protected int minScale;
    protected int maxScale;
    protected double multiplier;
    protected boolean autoscale;
    protected FeatureAnnotationSymbol pointSymbol;
    protected Color halo;

    public BasicStyle() {
        this.setDefaultValues();
    }

    public BasicStyle(Element element) throws Exception {
        this.initFromElement(element);
    }

    public BasicStyle(boolean drawFill, Color colorFill, boolean drawLine, Color colorLine, int lineWidth, boolean highlightFeature, float alpha, String pointSymbolName, int pointSymbolSize, boolean drawLabel, Font font, Color fontColor, String attribute, float alignment, int minScale, int maxScale, double multiplier, boolean autoscale, Color halo) {
        this.drawFill = drawFill;
        this.drawLine = drawLine;
        this.highlightFeature = highlightFeature;
        this.colorFill = colorFill;
        this.colorLine = colorLine;
        this.lineWidth = lineWidth;
        this.alpha = alpha;
        this.pointSymbolSize = pointSymbolSize;
        this.drawLabel = drawLabel;
        this.font = font;
        this.fontColor = fontColor;
        this.attribute = attribute;
        this.alignment = alignment;
        this.minScale = minScale;
        this.maxScale = maxScale;
        this.multiplier = multiplier;
        this.autoscale = autoscale;
        this.halo = halo;
        this.setPointSymbolFilename(pointSymbolName);
    }

    public void setDefaultValues() {
        Color defaultColor = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
        this.drawFill = true;
        this.drawLine = true;
        this.highlightFeature = true;
        this.colorFill = defaultColor;
        this.colorLine = BasicStyle.darken(defaultColor);
        this.lineWidth = 1;
        this.alpha = 1.0f;
        this.pointSymbolFilename = "Keins";
        this.pointSymbolSize = 5;
        this.drawLabel = false;
        this.font = DEFAULT_FONT;
        this.fontColor = Color.BLACK;
        this.attribute = "";
        this.alignment = 0.0f;
        this.minScale = 0;
        this.maxScale = 2500;
        this.multiplier = 1.0;
        this.autoscale = true;
        this.pointSymbol = null;
        this.halo = null;
    }

    @Override
    public Element toElement() {
        Element e = new Element("StyleHistoryElement");
        Element fill = new Element("Fill");
        Element line = new Element("Line");
        Element point = new Element("Pointsymbol");
        Element label = new Element("Label");
        e.setAttribute("type", this.getClass().getCanonicalName());
        fill.setAttribute("paint", Boolean.toString(this.drawFill));
        if (this.colorFill != null) {
            fill.setAttribute("color", Integer.toString(this.colorFill.getRGB()));
        }
        fill.setAttribute("alpha", Float.toString(this.alpha));
        fill.setAttribute("highlight", Boolean.toString(this.highlightFeature));
        line.setAttribute("paint", Boolean.toString(this.drawLine));
        if (this.colorLine != null) {
            line.setAttribute("color", Integer.toString(this.colorLine.getRGB()));
        }
        line.setAttribute("width", Integer.toString(this.lineWidth));
        point.setAttribute("name", this.pointSymbolFilename);
        point.setAttribute("size", Integer.toString(this.pointSymbolSize));
        label.setAttribute("paint", Boolean.toString(this.drawLabel));
        label.setAttribute("family", this.font.getFamily());
        if (this.font != null) {
            label.setAttribute("style", Integer.toString(this.font.getStyle()));
        }
        if (this.font != null) {
            label.setAttribute("size", Integer.toString(this.font.getSize()));
        }
        if (this.fontColor != null) {
            label.setAttribute("color", Integer.toString(this.fontColor.getRGB()));
        }
        if (this.halo != null) {
            label.setAttribute("halo", Integer.toString(this.halo.getRGB()));
        }
        label.setAttribute("attribute", this.attribute);
        label.setAttribute("alignment", Float.toString(this.alignment));
        label.setAttribute("minscale", Integer.toString(this.minScale));
        label.setAttribute("maxscale", Integer.toString(this.maxScale));
        label.setAttribute("multiplier", Double.toString(this.multiplier));
        label.setAttribute("autoscale", Boolean.toString(this.autoscale));
        e.addContent((Content)fill);
        e.addContent((Content)line);
        e.addContent((Content)point);
        e.addContent((Content)label);
        return e;
    }

    public int compareTo(Object o) {
        if (o instanceof BasicStyle) {
            BasicStyle bs = (BasicStyle)o;
            if (this.highlightFeature == bs.isHighlightFeature() && this.drawFill == bs.isDrawFill() && this.colorFill == bs.getFillColor() && this.drawLine == bs.isDrawLine() && this.colorLine == bs.getLineColor() && this.lineWidth == bs.getLineWidth() && this.alpha == bs.getAlpha() && this.pointSymbolFilename.equals(bs.getPointSymbolFilename()) && this.drawLabel == bs.isDrawLabel() && this.font.getFamily().equals(bs.getFont().getFamily()) && this.font.getStyle() == bs.getFont().getStyle() && this.font.getSize() == bs.getFont().getSize() && this.fontColor == bs.getFontColor() && this.maxScale == bs.getMaxScale() && this.minScale == bs.getMinScale() && this.alignment == bs.getAlignment() && this.autoscale == bs.isAutoscale() && this.multiplier == bs.getMultiplier() && this.halo == bs.getHalo()) {
                if (this.pointSymbolFilename.equals("Keins")) {
                    if (this.pointSymbolSize == bs.getPointSymbolSize()) {
                        return 0;
                    }
                    return -1;
                }
                return 0;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new BasicStyle(this.drawFill, this.colorFill, this.drawLine, this.colorLine, this.lineWidth, this.highlightFeature, this.alpha, this.pointSymbolFilename, this.pointSymbolSize, this.drawLabel, this.font, this.fontColor, this.attribute, this.alignment, this.minScale, this.maxScale, this.multiplier, this.autoscale, this.halo);
    }

    @Override
    public boolean isDrawFill() {
        return this.drawFill;
    }

    @Override
    public void setDrawFill(boolean drawFill) {
        boolean oldDrawFill = this.drawFill;
        this.drawFill = drawFill;
        if (this.drawFill != oldDrawFill && this.pointSymbolFilename.equals("Punkt")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"setDrawFill changed, recreating autogenerated pointsymbol");
            }
            this.pointSymbol = this.createAutoPointSymbol();
        }
    }

    @Override
    public boolean isDrawLine() {
        return this.drawLine;
    }

    @Override
    public void setDrawLine(boolean drawLine) {
        boolean oldDrawLine = this.drawLine;
        this.drawLine = drawLine;
        if (this.drawLine != oldDrawLine && this.pointSymbolFilename.equals("Punkt")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"setDrawLine changed, recreating autogenerated pointsymbol");
            }
            this.pointSymbol = this.createAutoPointSymbol();
        }
    }

    @Override
    public boolean isHighlightFeature() {
        return this.highlightFeature;
    }

    @Override
    public void setHighlightFeature(boolean highlightFeature) {
        this.highlightFeature = highlightFeature;
    }

    @Override
    public Color getFillColor() {
        return this.colorFill;
    }

    @Override
    public void setFillColor(Color colorFill) {
        Color oldColorFill = this.colorFill;
        this.colorFill = colorFill;
        if (!this.colorFill.equals(oldColorFill) && this.pointSymbolFilename.equals("Punkt")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"setcolorFill changed, recreating autogenerated pointsymbol");
            }
            this.pointSymbol = this.createAutoPointSymbol();
        }
    }

    @Override
    public Color getLineColor() {
        return this.colorLine;
    }

    @Override
    public void setLineColor(Color colorLine) {
        Color oldColorLine = this.colorLine;
        this.colorLine = colorLine;
        if (!this.colorLine.equals(oldColorLine) && this.pointSymbolFilename.equals("Punkt")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"setcolorLine  changed, recreating autogenerated pointsymbol");
            }
            this.pointSymbol = this.createAutoPointSymbol();
        }
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(int lineWidth) {
        int oldLineWidth = this.lineWidth;
        this.lineWidth = lineWidth;
        if (this.lineWidth != oldLineWidth && this.pointSymbolFilename.equals("Punkt")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"setLineWidth changed, recreating autogenerated pointsymbol");
            }
            this.pointSymbol = this.createAutoPointSymbol();
        }
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public String getPointSymbolFilename() {
        return this.pointSymbolFilename;
    }

    @Override
    public void setPointSymbolFilename(String pointSymbolFilename) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("setPointSymbolFilename: " + pointSymbolFilename));
        }
        this.pointSymbolFilename = pointSymbolFilename;
        if (pointSymbolFilename.equalsIgnoreCase("Punkt")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"auto creating new pointsymbol");
            }
            this.pointSymbol = new FeatureAnnotationSymbol(PointSymbolCreator.createPointSymbol((boolean)true, (boolean)true, (int)10, (int)1, (Color)this.colorFill, (Color)this.colorLine));
            this.pointSymbol.setSweetSpotX(0.5);
            this.pointSymbol.setSweetSpotY(0.5);
        } else if (!pointSymbolFilename.equalsIgnoreCase("Keins")) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("loading new pointsymbol '" + pointSymbolFilename + "'"));
                }
                FeatureAnnotationSymbol featureAnnotationSymbol = new FeatureAnnotationSymbol(new ImageIcon(this.getClass().getResource(POINTSYMBOL_FOLDER + pointSymbolFilename)).getImage());
                featureAnnotationSymbol.setSweetSpotX(0.14);
                featureAnnotationSymbol.setSweetSpotY(1.0);
                featureAnnotationSymbol.addAttribute("name", pointSymbolFilename);
                this.pointSymbol = featureAnnotationSymbol;
            }
            catch (Throwable t) {
                this.logger.warn((Object)("point symbol '" + this.pointSymbol + "' could not be found, setting to undefined"));
                this.pointSymbolFilename = "Keins";
                this.pointSymbol = null;
            }
        } else {
            this.pointSymbol = null;
        }
    }

    @Override
    public int getPointSymbolSize() {
        return this.pointSymbolSize;
    }

    @Override
    public void setPointSymbolSize(int pointSymbolSize) {
        int oldPointSymbolSize = this.pointSymbolSize;
        if (pointSymbolSize < 5) {
            this.logger.warn((Object)("pointSymbolSize " + pointSymbolSize + " smaller than MIN_POINTSYMBOLSIZE " + 5 + ", settign to MIN_POINTSYMBOLSIZE"));
            this.pointSymbolSize = 5;
        } else if (pointSymbolSize > 50) {
            this.logger.warn((Object)("pointSymbolSize " + pointSymbolSize + " lager than MAX_POINTSYMBOLSIZE " + 50 + ", settign to MAX_POINTSYMBOLSIZE"));
            this.pointSymbolSize = 50;
        } else {
            this.pointSymbolSize = pointSymbolSize;
        }
        if (this.pointSymbolSize != oldPointSymbolSize && this.pointSymbolFilename.equals("Punkt")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"setPointSymbolSize changed, recreating autogenerated pointsymbol");
            }
            this.pointSymbol = this.createAutoPointSymbol();
        }
    }

    @Override
    public boolean isDrawLabel() {
        return this.drawLabel;
    }

    @Override
    public void setDrawLabel(boolean drawLabel) {
        this.drawLabel = drawLabel;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public Color getFontColor() {
        return this.fontColor;
    }

    @Override
    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    @Override
    public void setHalo(Color halo) {
        this.halo = halo;
    }

    @Override
    public Color getHalo() {
        return this.halo;
    }

    @Override
    @Deprecated
    public String getLabel() {
        return this.attribute;
    }

    @Override
    @Deprecated
    public void setLabel(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public float getAlignment() {
        return this.alignment;
    }

    @Override
    public void setAlignment(float alignment) {
        this.alignment = alignment;
    }

    @Override
    public int getMinScale() {
        return this.minScale;
    }

    @Override
    public void setMinScale(int minScale) {
        this.minScale = minScale;
    }

    @Override
    public int getMaxScale() {
        return this.maxScale;
    }

    @Override
    public void setMaxScale(int maxScale) {
        this.maxScale = maxScale;
    }

    @Override
    public double getMultiplier() {
        return this.multiplier;
    }

    @Override
    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    @Override
    public boolean isAutoscale() {
        return this.autoscale;
    }

    @Override
    public void setAutoscale(boolean autoscale) {
        this.autoscale = autoscale;
    }

    @Override
    public void initFromElement(Element element) throws Exception {
        if (element.getName().equals("StyleHistoryElement")) {
            try {
                if (element.getAttribute("type") == null) {
                    this.logger.warn((Object)"fromElement: restoring object from deprecated xml element");
                }
                Element fill = element.getChild("Fill");
                this.setDrawFill(fill.getAttribute("paint").getBooleanValue());
                this.setAlpha(fill.getAttribute("alpha").getFloatValue());
                Color tmpF = new Color(fill.getAttribute("color").getIntValue());
                this.setFillColor(new Color(tmpF.getRed(), tmpF.getGreen(), tmpF.getBlue()));
                try {
                    this.setHighlightFeature(fill.getAttribute("highlight").getBooleanValue());
                }
                catch (Exception skip) {
                    this.logger.warn((Object)"property 'highlight' not found in xml element");
                    this.setHighlightFeature(false);
                }
                Element line = element.getChild("Line");
                this.setDrawLine(line.getAttribute("paint").getBooleanValue());
                Color tmpL = new Color(line.getAttribute("color").getIntValue());
                this.setLineColor(new Color(tmpL.getRed(), tmpL.getGreen(), tmpL.getBlue()));
                this.setLineWidth(line.getAttribute("width").getIntValue());
                Element point = element.getChild("Pointsymbol");
                this.setPointSymbolFilename(point.getAttributeValue("name"));
                this.setPointSymbolSize(point.getAttribute("size").getIntValue());
                Element label = element.getChild("Label");
                this.setDrawLabel(label.getAttribute("paint").getBooleanValue());
                Font tmpFont = new Font(label.getAttributeValue("family"), (int)new Integer(label.getAttributeValue("style")), new Integer(label.getAttributeValue("size")));
                this.setFont(tmpFont);
                Color tmpA = new Color(label.getAttribute("color").getIntValue());
                this.setFontColor(new Color(tmpA.getRed(), tmpA.getGreen(), tmpA.getBlue()));
                if (label.getAttribute("halo") != null) {
                    Color tmpHalo = new Color(label.getAttribute("halo").getIntValue());
                    this.setHalo(new Color(tmpHalo.getRed(), tmpHalo.getGreen(), tmpHalo.getBlue()));
                }
                if (label.getAttribute("attribute") != null) {
                    this.setLabel(label.getAttributeValue("attribute"));
                } else {
                    this.setLabel("default");
                }
                this.setAlignment(label.getAttribute("alignment").getFloatValue());
                this.setMaxScale(label.getAttribute("minscale").getIntValue());
                this.setMaxScale(label.getAttribute("maxscale").getIntValue());
                this.setMultiplier(label.getAttribute("multiplier").getDoubleValue());
                this.setAutoscale(label.getAttribute("autoscale").getBooleanValue());
            }
            catch (Exception ex) {
                this.logger.error((Object)"Fehler beim Parsen des Elements zu einem Style", (Throwable)ex);
                throw ex;
            }
        }
        this.logger.warn((Object)("the element '" + element.getName() + "' is no valid style element, '" + "StyleHistoryElement" + "' expected"));
    }

    @Override
    @Deprecated
    public void setPointSymbol(FeatureAnnotationSymbol pointSymbol) {
        this.logger.warn((Object)"deprecated operation setPointSymbol called!");
        this.pointSymbol = pointSymbol;
    }

    @Override
    public FeatureAnnotationSymbol getPointSymbol() {
        return this.pointSymbol;
    }

    public static Color darken(Color c) {
        int r = new Double(Math.floor((double)c.getRed() * 0.6)).intValue();
        int g = new Double(Math.floor((double)c.getGreen() * 0.6)).intValue();
        int b = new Double(Math.floor((double)c.getBlue() * 0.6)).intValue();
        return new Color(r, g, b);
    }

    public static Color lighten(Color c) {
        int b;
        int g;
        int r = new Double(Math.floor((double)c.getRed() / 0.6)).intValue();
        if (r > 255) {
            r = 255;
        }
        if ((g = new Double(Math.floor((double)c.getGreen() / 0.6)).intValue()) > 255) {
            g = 255;
        }
        if ((b = new Double(Math.floor((double)c.getBlue() / 0.6)).intValue()) > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public FeatureAnnotationSymbol createAutoPointSymbol() {
        FeatureAnnotationSymbol autoPointSymbol = new FeatureAnnotationSymbol(PointSymbolCreator.createPointSymbol((boolean)this.drawLine, (boolean)this.drawFill, (int)this.pointSymbolSize, (int)this.lineWidth, (Color)this.colorFill, (Color)this.colorLine));
        autoPointSymbol.setSweetSpotX(0.5);
        autoPointSymbol.setSweetSpotY(0.5);
        return autoPointSymbol;
    }
}

