/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.style;

import de.cismet.tools.CismetThreadPool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.NbBundle;

public class FontChooserDialog
extends JDialog {
    private static final String SAMPLE_TEXT = NbBundle.getMessage(FontChooserDialog.class, (String)"FontChooserDialog.SAMPLE_TEXT");
    private static final int DEFAULT_SIZE = 4;
    private Font resultFont;
    private String resultName;
    private int resultSize;
    private boolean isBold;
    private boolean isItalic;
    private JCheckBox chkBold;
    private JCheckBox chkItalic;
    private JButton cmdCancel;
    private JButton cmdOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lblPreview;
    private JList lstFontName;
    private JList lstFontSize;
    private JPanel panDialogButtons;
    private JPanel panFontAttrib;
    private JPanel panPreview;
    private JPanel panPreviewLabel;
    private JScrollPane scrFontName;
    private JScrollPane scrFontSize;
    private JScrollPane scrPreview;

    public FontChooserDialog(JFrame parent) {
        super((Frame)parent, true);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    public FontChooserDialog(JDialog parent, String title) {
        super(parent, title, true);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    protected void previewFont() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                FontChooserDialog.this.resultName = (String)FontChooserDialog.this.lstFontName.getSelectedValue();
                String resultSizeName = (String)FontChooserDialog.this.lstFontSize.getSelectedValue();
                int size = Integer.parseInt(resultSizeName);
                FontChooserDialog.this.isItalic = FontChooserDialog.this.chkItalic.isSelected();
                FontChooserDialog.this.isBold = FontChooserDialog.this.chkBold.isSelected();
                int attrs = 0;
                if (FontChooserDialog.this.isBold) {
                    attrs = 1;
                }
                if (FontChooserDialog.this.isItalic) {
                    attrs |= 2;
                }
                FontChooserDialog.this.resultFont = new Font(FontChooserDialog.this.resultName, attrs, size);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FontChooserDialog.this.lblPreview.setFont(FontChooserDialog.this.resultFont);
                    }
                });
            }
        };
        CismetThreadPool.execute((Runnable)new Thread(r, "FontChooserDialog previewFont()"));
    }

    public String getSelectedName() {
        return this.resultName;
    }

    public int getSelectedSize() {
        return this.resultSize;
    }

    public Font getReturnStatus() {
        return this.resultFont;
    }

    public void setSelectedFont(Font font, int size, boolean bold, boolean italic) {
        this.lstFontName.setSelectedValue(font.getName(), true);
        this.lstFontSize.setSelectedValue(new Integer(size).toString(), true);
        this.chkBold.setSelected(bold);
        this.chkItalic.setSelected(italic);
    }

    private void initComponents() {
        this.panFontAttrib = new JPanel();
        this.scrFontName = new JScrollPane();
        this.lstFontName = new JList<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.scrFontSize = new JScrollPane();
        this.lstFontSize = new JList();
        this.chkBold = new JCheckBox();
        this.chkItalic = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.panPreview = new JPanel();
        this.scrPreview = new JScrollPane();
        this.panPreviewLabel = new JPanel();
        this.lblPreview = new JLabel(SAMPLE_TEXT, 0){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintComponent(g2d);
            }
        };
        this.panDialogButtons = new JPanel();
        this.cmdOK = new JButton();
        this.cmdCancel = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FontChooserDialog.this.closeDialog(evt);
            }
        });
        this.panFontAttrib.setLayout(new GridBagLayout());
        this.scrFontName.setHorizontalScrollBarPolicy(31);
        this.scrFontName.setMinimumSize(new Dimension(200, 130));
        this.scrFontName.setPreferredSize(new Dimension(200, 130));
        this.lstFontName.setSelectionMode(0);
        this.lstFontName.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontChooserDialog.this.lstFontNameValueChanged(evt);
            }
        });
        this.scrFontName.setViewportView(this.lstFontName);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.panFontAttrib.add((Component)this.scrFontName, gridBagConstraints);
        this.scrFontSize.setMinimumSize(new Dimension(50, 130));
        this.scrFontSize.setPreferredSize(new Dimension(50, 130));
        this.lstFontSize.setModel(new AbstractListModel(){
            String[] strings = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "24", "30", "36", "48", "60", "72"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstFontSize.setSelectionMode(0);
        this.lstFontSize.setSelectedIndex(4);
        this.lstFontSize.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontChooserDialog.this.lstFontSizeValueChanged(evt);
            }
        });
        this.scrFontSize.setViewportView(this.lstFontSize);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 10);
        this.panFontAttrib.add((Component)this.scrFontSize, gridBagConstraints);
        this.chkBold.setText(NbBundle.getMessage(FontChooserDialog.class, (String)"FontChooserDialog.chkBold.text"));
        this.chkBold.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FontChooserDialog.this.chkBoldItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.panFontAttrib.add((Component)this.chkBold, gridBagConstraints);
        this.chkItalic.setText(NbBundle.getMessage(FontChooserDialog.class, (String)"FontChooserDialog.chkItalic.text"));
        this.chkItalic.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FontChooserDialog.this.chkItalicItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.panFontAttrib.add((Component)this.chkItalic, gridBagConstraints);
        this.jLabel1.setLabelFor(this.lstFontName);
        this.jLabel1.setText(NbBundle.getMessage(FontChooserDialog.class, (String)"FontChooserDialog.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.panFontAttrib.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.lstFontSize);
        this.jLabel2.setText(NbBundle.getMessage(FontChooserDialog.class, (String)"FontChooserDialog.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.panFontAttrib.add((Component)this.jLabel2, gridBagConstraints);
        this.getContentPane().add((Component)this.panFontAttrib, "North");
        this.panPreview.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        this.panPreview.setMinimumSize(new Dimension(400, 100));
        this.panPreview.setPreferredSize(new Dimension(400, 100));
        this.panPreview.setLayout(new BorderLayout());
        this.scrPreview.setHorizontalScrollBarPolicy(31);
        this.scrPreview.setVerticalScrollBarPolicy(21);
        this.panPreviewLabel.setBackground(new Color(255, 255, 255));
        this.panPreviewLabel.setLayout(new GridBagLayout());
        this.panPreviewLabel.add((Component)this.lblPreview, new GridBagConstraints());
        this.scrPreview.setViewportView(this.panPreviewLabel);
        this.panPreview.add((Component)this.scrPreview, "Center");
        this.getContentPane().add((Component)this.panPreview, "Center");
        this.panDialogButtons.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.panDialogButtons.setLayout(new FlowLayout(2, 5, 0));
        this.cmdOK.setText(NbBundle.getMessage(FontChooserDialog.class, (String)"FontChooserDialog.cmdOK.text"));
        this.cmdOK.setMaximumSize(new Dimension(90, 23));
        this.cmdOK.setMinimumSize(new Dimension(90, 23));
        this.cmdOK.setPreferredSize(new Dimension(90, 23));
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooserDialog.this.cmdOKActionPerformed(evt);
            }
        });
        this.panDialogButtons.add(this.cmdOK);
        this.cmdCancel.setText(NbBundle.getMessage(FontChooserDialog.class, (String)"FontChooserDialog.cmdCancel.text"));
        this.cmdCancel.setMaximumSize(new Dimension(90, 23));
        this.cmdCancel.setMinimumSize(new Dimension(90, 23));
        this.cmdCancel.setPreferredSize(new Dimension(90, 23));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooserDialog.this.cmdCancelActionPerformed(evt);
            }
        });
        this.panDialogButtons.add(this.cmdCancel);
        this.getContentPane().add((Component)this.panDialogButtons, "South");
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void cmdOKActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.resultFont = null;
        this.doClose();
    }

    private void lstFontSizeValueChanged(ListSelectionEvent evt) {
        this.previewFont();
    }

    private void lstFontNameValueChanged(ListSelectionEvent evt) {
        this.previewFont();
    }

    private void chkBoldItemStateChanged(ItemEvent evt) {
        this.previewFont();
    }

    private void chkItalicItemStateChanged(ItemEvent evt) {
        this.previewFont();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FontChooserDialog dialog = new FontChooserDialog(new JFrame());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

