/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.featureservice.style;

import de.cismet.cismap.commons.featureservice.style.Style;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class StyleHistoryListCellRenderer
implements ListCellRenderer {
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel panel = new JPanel();
        HistoryPanel histPanel = new HistoryPanel();
        if (value instanceof Style) {
            Style s = (Style)value;
            histPanel.setAttributes(s.isDrawFill() ? s.getFillColor() : null, s.getAlpha(), s.isDrawLine() ? s.getLineColor() : null, s.getLineWidth(), s.isDrawLabel() ? s.getFont() : null, s.getFontColor(), s.getLabel() != null ? s.getLabel() : null);
            histPanel.setCustomSize(new Dimension(45, 20));
            panel.setLayout(new GridBagLayout());
            panel.add((Component)histPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
            if (isSelected) {
                histPanel.setForeground(list.getSelectionForeground());
                histPanel.setBackground(list.getSelectionBackground());
                panel.setForeground(list.getSelectionForeground());
                panel.setBackground(list.getSelectionBackground());
            } else {
                histPanel.setForeground(list.getForeground());
                histPanel.setBackground(list.getBackground());
                panel.setForeground(list.getForeground());
                panel.setBackground(list.getBackground());
            }
        }
        return panel;
    }

    private class HistoryPanel
    extends JPanel {
        private Color fill;
        private Color line;
        private Color label;
        private float alpha;
        private int width;
        private BasicStroke stroke;
        private Font font;
        private String textToShow = "";

        public HistoryPanel() {
            this.setBackground(Color.WHITE);
            this.stroke = new BasicStroke(0.0f);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Color originalColor = g.getColor();
            g.setColor(this.getBackground());
            ((Graphics2D)g).setStroke(this.stroke);
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            AlphaComposite c = AlphaComposite.SrcOver.derive(this.alpha);
            ((Graphics2D)g).setComposite(c);
            if (this.fill != null) {
                g.setColor(this.fill);
                g.fillRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
            }
            if (this.line != null) {
                g.setColor(this.line);
                ((Graphics2D)g).setStroke(this.stroke);
                g.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            }
            if (this.font != null) {
                g.setColor(this.label);
                g.setFont(this.font);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
                FontMetrics metrics = g.getFontMetrics(this.font);
                int h = metrics.getHeight();
                if (h > this.getHeight() - 6) {
                    h = this.getHeight() - 6;
                }
                g.drawString(this.textToShow, 5, h);
            }
            g.setColor(originalColor);
        }

        public void setCustomSize(Dimension d) {
            this.setPreferredSize(d);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
        }

        public void setAttributes(Color fill, float alpha, Color line, int width, Font font, Color label, String text) {
            this.fill = fill;
            this.line = line;
            this.alpha = alpha;
            this.width = Double.valueOf(Math.min(2, width)).intValue();
            this.stroke = new BasicStroke(this.width);
            this.font = font;
            this.label = label == null ? Color.BLACK : label;
            this.textToShow = text;
        }
    }
}

