/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui;

import de.cismet.cismap.commons.interaction.CismapBroker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;

public class FeatureLayerTransparencyButton
extends JButton {
    public static final int POPUP_WIDTH = 35;
    private int prevValue = -1;
    private final JLabel labPercentage;
    private final JPanel panPopup;
    private final JPopupMenu popup = new JPopupMenu();
    private final JSlider slider;

    public FeatureLayerTransparencyButton() {
        this.panPopup = new JPanel();
        this.slider = new SliderMenuItem();
        this.labPercentage = new JLabel();
        this.panPopup.setLayout(new GridBagLayout());
        this.slider.setOrientation(1);
        this.slider.setValue(100);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.panPopup.add((Component)this.slider, gridBagConstraints);
        this.labPercentage.setHorizontalAlignment(0);
        this.labPercentage.setText("100 %");
        this.labPercentage.setMaximumSize(new Dimension(35, 17));
        this.labPercentage.setMinimumSize(new Dimension(35, 17));
        this.labPercentage.setPreferredSize(new Dimension(35, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.panPopup.add((Component)this.labPercentage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (CismapBroker.getInstance().getMappingComponent() != null) {
                    float transp = CismapBroker.getInstance().getMappingComponent().getFeatureLayer().getTransparency();
                    int intValue = (int)(transp * 100.0f);
                    FeatureLayerTransparencyButton.this.slider.setValue(intValue);
                }
                FeatureLayerTransparencyButton.this.updateLabel();
                FeatureLayerTransparencyButton.this.popup.show(FeatureLayerTransparencyButton.this, FeatureLayerTransparencyButton.this.getWidth() / 2 - 17, FeatureLayerTransparencyButton.this.getHeight() + 2);
            }
        });
        this.popup.add(this.panPopup);
    }

    private void updateLabel() {
        int intValue = this.slider.getValue();
        if (this.prevValue != intValue) {
            this.labPercentage.setText(String.format("%d%%", this.slider.getValue()));
        }
        this.prevValue = intValue;
    }

    class SliderPopupListener
    extends MouseAdapter {
        @Override
        public void mouseDragged(MouseEvent me) {
            int intValue = FeatureLayerTransparencyButton.this.slider.getValue();
            if (CismapBroker.getInstance().getMappingComponent() != null) {
                CismapBroker.getInstance().getMappingComponent().getFeatureLayer().setTransparency((float)intValue / 100.0f);
            }
            FeatureLayerTransparencyButton.this.updateLabel();
        }

        @Override
        public void mouseReleased(MouseEvent me) {
        }
    }

    class SliderMenuItem
    extends JSlider
    implements MenuElement {
        private final SliderPopupListener popupHandler;

        public SliderMenuItem() {
            this.popupHandler = new SliderPopupListener();
            this.addMouseMotionListener(this.popupHandler);
            this.addMouseListener(this.popupHandler);
            this.addMouseWheelListener(this.popupHandler);
        }

        @Override
        public void processMouseEvent(MouseEvent e, MenuElement[] path, MenuSelectionManager manager) {
        }

        @Override
        public void processKeyEvent(KeyEvent e, MenuElement[] path, MenuSelectionManager manager) {
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
        }

        @Override
        public MenuElement[] getSubElements() {
            return new MenuElement[0];
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }
}

