/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui;

import edu.umd.cs.piccolo.PCanvas;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;

public class SimpleBackgroundedJPanel
extends JPanel
implements PropertyChangeListener {
    PCanvas viewer;
    private boolean backgroundEnabled;

    public SimpleBackgroundedJPanel() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SimpleBackgroundedJPanel.this.formComponentResized(evt);
            }
        });
    }

    public void formComponentResized(ComponentEvent evt) {
        if (this.viewer != null) {
            this.viewer.setSize(evt.getComponent().getSize());
        }
    }

    public void setPCanvas(PCanvas v) {
        this.viewer = v;
        this.viewer.getCamera().addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void paint(Graphics g) {
        super.paintComponent(g);
        if (this.viewer != null) {
            try {
                this.viewer.paint(g);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.paintChildren(g);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleBackgroundedJPanel.this.repaint();
            }
        });
    }

    public boolean isBackgroundEnabled() {
        return this.backgroundEnabled;
    }

    public void setBackgroundEnabled(boolean enabled) {
        if (this.viewer != null) {
            if (!enabled) {
                this.viewer.getCamera().animateToTransparency(0.0f, 1000L);
            } else {
                this.viewer.getCamera().animateToTransparency(0.3f, 1000L);
            }
        }
        this.backgroundEnabled = enabled;
    }
}

