/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.attributetable;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureWithId;
import de.cismet.cismap.commons.features.JDBCFeature;
import de.cismet.cismap.commons.features.ModifiableFeature;
import de.cismet.cismap.commons.features.PermissionProvider;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.ShapeFileFeatureService;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.featureservice.style.BasicStyle;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableFactory;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableFieldCalculation;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableReportBuilder;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableSearchPanel;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableTransferHandler;
import de.cismet.cismap.commons.gui.attributetable.DefaultAttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureLockerFactory;
import de.cismet.cismap.commons.gui.attributetable.FeatureLockingInterface;
import de.cismet.cismap.commons.gui.attributetable.LockAlreadyExistsException;
import de.cismet.cismap.commons.gui.attributetable.SimpleAttributeTableModel;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToFeaturesWorker;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToLayerWorker;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.retrieval.RepaintEvent;
import de.cismet.cismap.commons.retrieval.RepaintListener;
import de.cismet.cismap.commons.tools.ExportCsvDownload;
import de.cismet.cismap.commons.tools.ExportDbfDownload;
import de.cismet.cismap.commons.tools.ExportDownload;
import de.cismet.cismap.commons.tools.ExportShapeDownload;
import de.cismet.cismap.commons.tools.ExportTxtDownload;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.cismap.commons.tools.GeometryUtils;
import de.cismet.cismap.commons.tools.SimpleFeatureCollection;
import de.cismet.cismap.commons.util.SelectionChangedEvent;
import de.cismet.cismap.commons.util.SelectionChangedListener;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.commons.concurrency.CismetConcurrency;
import de.cismet.math.geometry.StaticGeometryFunctions;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.JRViewer;
import org.apache.log4j.Logger;
import org.deegree.io.shpapi.shape_new.ShapeFile;
import org.deegree.io.shpapi.shape_new.ShapeFileWriter;
import org.deegree.model.feature.FeatureCollection;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AttributeTable
extends JPanel {
    private static final Logger LOG = Logger.getLogger(AttributeTable.class);
    private static final int MAX_COLUMN_SIZE = 200;
    private static List<FeatureServiceFeature> clipboard;
    private static final List<AttributeTable> instances;
    boolean featureDeleted = false;
    private final AbstractFeatureService featureService;
    private XBoundingBox bb;
    private int pageSize = 40;
    private int currentPage = 1;
    private int itemCount;
    private CustomTableModel model;
    private int popupColumn;
    private MappingComponent mappingComponent;
    private boolean selectionChangeFromMap = false;
    private final SelectionChangedListener featureSelectionChangedListener;
    private final ListSelectionListener listSelectionListener;
    private final RepaintListener repaintListener;
    private final HashSet<FeatureServiceFeature> lockedFeatures = new HashSet();
    private AttributeTableRuleSet tableRuleSet = new DefaultAttributeTableRuleSet();
    private final FeatureLockingInterface locker;
    private final Map<FeatureServiceFeature, Object> lockingObjects = new HashMap<FeatureServiceFeature, Object>();
    private AttributeTableSearchPanel searchPanel;
    private AttributeTableFieldCalculation calculationDialog;
    private Object query;
    private int[] lastRows;
    private final TreeSet<DefaultFeatureServiceFeature> modifiedFeatures = new TreeSet();
    private final TreeSet<FeatureServiceFeature> allFeaturesToDelete = new TreeSet();
    private final TreeSet<DefaultFeatureServiceFeature> newFeatures = new TreeSet();
    private final TreeSet<DefaultFeatureServiceFeature> rejectedNewFeatures = new TreeSet();
    private Object selectionEventSource = null;
    private List<ListSelectionListener> selectionListener = new ArrayList<ListSelectionListener>();
    private TreeSet<Feature> shownAsLocked = new TreeSet();
    private String lastExportPath = null;
    private boolean tableLock = false;
    private boolean setNewModel = false;
    private boolean makeEditable = false;
    private boolean resetSelection = false;
    private ButtonGroup bgSortOrder1;
    private ButtonGroup bgSortOrder2;
    private ButtonGroup bgSortOrder3;
    private ButtonGroup bgSortOrder4;
    private JButton btnFirstPage;
    private JButton btnLastPage;
    private JButton btnNextPage;
    private JButton btnPrevPage;
    private JButton butAttrib;
    private JButton butCancel;
    private JButton butCancel1;
    private JButton butClearSelection;
    private JButton butColWidth;
    private JButton butCopy;
    private JButton butDelete;
    private JButton butExpOk;
    private JButton butExpOk1;
    private JButton butExport;
    private JButton butInvertSelection;
    private JButton butMoveSelectedRows;
    private JButton butOk;
    private JButton butPaste;
    private JButton butPrint;
    private JButton butPrintPreview;
    private JButton butSearch;
    private JButton butSelectAll;
    private JButton butShowCols;
    private JButton butUndo;
    private JButton butZoomToSelection;
    private JComboBox cbCol1;
    private JComboBox cbCol2;
    private JComboBox cbCol3;
    private JComboBox cbCol4;
    private JDialog diaExport;
    private JDialog diaSort;
    private JDialog diaStatistic;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPopupMenu jPopupMenu1;
    private JToolBar.Separator jSeparator1;
    private JToolBar jToolBar1;
    private JComboBox jcFormat;
    private JPanel jpControl;
    private JLabel labSegHint;
    private JLabel labSortCol1;
    private JLabel labSortCol2;
    private JLabel labSortCol3;
    private JLabel labSortCol4;
    private JLabel labStat;
    private JLabel labStatCol;
    private JLabel labWaitingImage;
    private JLabel lblCountLab;
    private JLabel lblCountVal;
    private JLabel lblFormat;
    private JLabel lblMaxLab;
    private JLabel lblMaxVal;
    private JLabel lblMeanLab;
    private JLabel lblMeanVal;
    private JLabel lblMinLab;
    private JLabel lblMinVal;
    private JLabel lblNullLab;
    private JLabel lblNullVal;
    private JLabel lblStdDeviationLab;
    private JLabel lblStdDeviationVal;
    private JLabel lblSumLab;
    private JLabel lblSumVal;
    private JLabel lblTotalPages;
    private JMenuItem miFeldberechnung;
    private JMenuItem miSortieren;
    private JMenuItem miSpalteAusblenden;
    private JMenuItem miSpaltenUmbenennen;
    private JMenuItem miStatistik;
    private JMenuItem mniAdvancedSorting;
    private JPanel panHint;
    private JPanel panWaiting;
    private JRadioButton radOrderAsc1;
    private JRadioButton radOrderAsc2;
    private JRadioButton radOrderAsc3;
    private JRadioButton radOrderAsc4;
    private JRadioButton radOrderDesc1;
    private JRadioButton radOrderDesc2;
    private JRadioButton radOrderDesc3;
    private JRadioButton radOrderDesc4;
    private JXTable table;
    private JScrollPane tableScrollPane;
    private JToggleButton tbProcessing;
    private JTextField txtCurrentPage;

    public AttributeTable(final AbstractFeatureService featureService) {
        Collection calculatorList;
        this.featureService = featureService;
        this.initComponents();
        this.miFeldberechnung.setVisible(false);
        this.miSortieren.setVisible(false);
        this.butAttrib.setVisible(false);
        this.tbProcessing.setEnabled(featureService.isEditable());
        this.butSearch.setVisible(false);
        this.butUndo.setVisible(false);
        this.butDelete.setVisible(featureService.isEditable());
        this.locker = FeatureLockerFactory.getInstance().getLockerForFeatureService(featureService);
        this.table.setTransferHandler((TransferHandler)new AttributeTableTransferHandler(this));
        this.table.setDragEnabled(true);
        this.table.setAutoResizeMode(0);
        this.panWaiting.addMouseListener(new MouseAdapter(){});
        this.tableRuleSet = featureService.getLayerProperties().getAttributeTableRuleSet();
        Collection panelList = Lookup.getDefault().lookupAll(AttributeTableSearchPanel.class);
        if (panelList != null && panelList.size() > 0) {
            this.searchPanel = panelList.toArray(new AttributeTableSearchPanel[panelList.size()])[0];
            this.butAttrib.setVisible(true);
        }
        if ((calculatorList = Lookup.getDefault().lookupAll(AttributeTableFieldCalculation.class)) != null && calculatorList.size() > 0) {
            this.calculationDialog = calculatorList.toArray(new AttributeTableFieldCalculation[calculatorList.size()])[0];
            this.miFeldberechnung.setVisible(true);
        }
        this.jcFormat.setModel(new DefaultComboBoxModel<Object>(new Object[]{new ExportTxtDownload(), new ExportCsvDownload(), new ExportShapeDownload(), new ExportDbfDownload()}));
        this.setPartialTable(featureService.getMaxFeaturesPerPage() > 0);
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                this.mouseProcessed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mouseProcessed(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TableColumn col = ((JTableHeader)e.getSource()).getResizingColumn();
                if (col != null) {
                    AttributeTable.this.butColWidth.setEnabled(true);
                }
                this.mouseProcessed(e);
            }

            private void mouseProcessed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AttributeTable.this.popupColumn = AttributeTable.this.table.getTableHeader().getColumnModel().getColumnIndexAtX(e.getX());
                    AttributeTable.this.popupColumn = AttributeTable.this.table.convertColumnIndexToModel(AttributeTable.this.popupColumn);
                    AttributeTable.this.miStatistik.setEnabled(AttributeTable.this.model.isNumeric(AttributeTable.this.popupColumn));
                    AttributeTable.this.miFeldberechnung.setEnabled(AttributeTable.this.isFieldCalculationAllowed());
                    AttributeTable.this.jPopupMenu1.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        this.listSelectionListener = new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean rowsSelected = AttributeTable.this.table.getSelectedRows().length > 0;
                AttributeTable.this.butCopy.setEnabled(rowsSelected);
                AttributeTable.this.butDelete.setEnabled(rowsSelected);
                AttributeTable.this.butClearSelection.setEnabled(rowsSelected);
                AttributeTable.this.butMoveSelectedRows.setEnabled(rowsSelected);
                AttributeTable.this.butZoomToSelection.setEnabled(rowsSelected);
                AttributeTable.this.butDelete.setEnabled(AttributeTable.this.isDeleteButtonEnabled());
                AttributeTable.this.miFeldberechnung.setEnabled(AttributeTable.this.isFieldCalculationAllowed());
                if (!(e.getValueIsAdjusting() || AttributeTable.this.setNewModel || AttributeTable.this.makeEditable)) {
                    if (!AttributeTable.this.selectionChangeFromMap) {
                        SelectionManager.getInstance().setSelectedFeaturesForService(featureService, AttributeTable.this.getSelectedFeatures());
                    }
                    if (AttributeTable.this.tbProcessing.isSelected()) {
                        final int[] rows = AttributeTable.this.table.getSelectedRows();
                        if (!Arrays.equals(AttributeTable.this.lastRows, rows) && !AttributeTable.this.resetSelection) {
                            WaitingDialogThread wdt = new WaitingDialogThread(StaticSwingTools.getFirstParentFrame((Component)AttributeTable.this), true, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.ListSelectionListener.text"), null, 500, true){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                protected Object doInBackground() throws Exception {
                                    this.wd.setMax(rows.length);
                                    int progress = 0;
                                    try {
                                        CismapBroker.getInstance().getMappingComponent().setSelectionInProgress(true);
                                        for (int row : rows) {
                                            FeatureServiceFeature feature = AttributeTable.this.model.getFeatureServiceFeature(AttributeTable.this.table.convertRowIndexToModel(row));
                                            if (!(feature instanceof PermissionProvider) || ((PermissionProvider)((Object)feature)).hasWritePermissions()) {
                                                AttributeTable.this.makeEditable = true;
                                                try {
                                                    AttributeTable.this.makeFeatureEditable(feature, (Component)this.wd);
                                                }
                                                finally {
                                                    AttributeTable.this.makeEditable = false;
                                                }
                                            }
                                            this.wd.setProgress(++progress);
                                            if (!this.canceled) continue;
                                            Object var7_8 = null;
                                            return var7_8;
                                        }
                                        CismapBroker.getInstance().getMappingComponent().showHandles(false);
                                    }
                                    finally {
                                        CismapBroker.getInstance().getMappingComponent().setSelectionInProgress(false);
                                        List<FeatureServiceFeature> features = AttributeTable.this.getSelectedFeatures();
                                        SelectionManager.getInstance().fireSelectionChangedEvent();
                                        AttributeTable.this.resetSelection = true;
                                        try {
                                            AttributeTable.this.setSelection(features);
                                        }
                                        finally {
                                            AttributeTable.this.resetSelection = false;
                                        }
                                    }
                                    return null;
                                }
                            };
                            try {
                                if (!EventQueue.isDispatchThread()) {
                                    boolean progress = false;
                                    for (int row : rows) {
                                        FeatureServiceFeature feature = AttributeTable.this.model.getFeatureServiceFeature(AttributeTable.this.table.convertRowIndexToModel(row));
                                        if (feature instanceof PermissionProvider && !((PermissionProvider)((Object)feature)).hasWritePermissions()) continue;
                                        AttributeTable.this.makeEditable = true;
                                        try {
                                            AttributeTable.this.makeFeatureEditable(feature, null);
                                        }
                                        finally {
                                            AttributeTable.this.makeEditable = false;
                                        }
                                    }
                                } else {
                                    wdt.start();
                                }
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Error while locking features", (Throwable)ex);
                            }
                        }
                        AttributeTable.access$1802(AttributeTable.this, rows);
                    }
                    AttributeTable.this.table.repaint();
                    for (ListSelectionListener l : AttributeTable.this.selectionListener) {
                        if (l == AttributeTable.this.selectionEventSource) continue;
                        l.valueChanged(e);
                    }
                }
            }
        };
        this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)new AttributeTableCellRenderer());
        this.table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new AttributeTableCellRenderer());
        this.table.setDefaultRenderer(Date.class, (TableCellRenderer)new AttributeTableCellRenderer());
        this.table.setDefaultRenderer(Number.class, (TableCellRenderer)new NumberCellRenderer());
        this.txtCurrentPage.setText("1");
        this.loadModel(this.currentPage);
        CustomColorHighlighter base = new CustomColorHighlighter(HighlightPredicate.ALWAYS, new Color(255, 255, 255), null);
        this.table.setHighlighters(new Highlighter[]{base});
        this.featureSelectionChangedListener = new SelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                if (AttributeTable.this.makeEditable) {
                    return;
                }
                AttributeTable.this.selectionEventSource = event.getSource();
                AttributeTable.this.selectionChangeFromMap = true;
                AttributeTable.this.setSelection(SelectionManager.getInstance().getSelectedFeatures(featureService));
                AttributeTable.this.selectionChangeFromMap = false;
                AttributeTable.this.selectionEventSource = null;
            }
        };
        SelectionManager.getInstance().addSelectionChangedListener(this.featureSelectionChangedListener);
        this.repaintListener = new RepaintListener(){

            @Override
            public void repaintStart(RepaintEvent e) {
            }

            @Override
            public void repaintComplete(RepaintEvent e) {
                if (e.getRetrievalEvent().getRetrievalService().equals(featureService)) {
                    AttributeTable.this.synchronizeTableSeletionWithMap();
                }
            }

            @Override
            public void repaintError(RepaintEvent e) {
            }
        };
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (AttributeTable.this.tableRuleSet != null && !AttributeTable.this.tbProcessing.isSelected() && (row = AttributeTable.this.table.rowAtPoint(e.getPoint())) != -1) {
                    int col = AttributeTable.this.table.getTableHeader().getColumnModel().getColumnIndexAtX(e.getX());
                    col = AttributeTable.this.table.convertColumnIndexToModel(col);
                    String columnName = AttributeTable.this.model.getColumnAttributeName(col);
                    row = AttributeTable.this.table.convertRowIndexToModel(row);
                    Object value = AttributeTable.this.model.getValueAt(row, col);
                    FeatureServiceFeature f = AttributeTable.this.model.getFeatureServiceFeature(row);
                    AttributeTable.this.tableRuleSet.mouseClicked(f, columnName, value, e.getClickCount());
                }
            }
        });
        instances.add(this);
        this.butPaste.setEnabled(this.isPasteButtonEnabled());
        boolean rowsSelected = this.table.getSelectedRows().length > 0;
        this.butCopy.setEnabled(rowsSelected);
        this.butDelete.setEnabled(rowsSelected);
        this.butClearSelection.setEnabled(rowsSelected);
        this.butMoveSelectedRows.setEnabled(rowsSelected);
        this.butZoomToSelection.setEnabled(rowsSelected);
        this.butShowCols.setEnabled(false);
    }

    private boolean isFieldCalculationAllowed() {
        int[] selectedRows;
        boolean editableColsSelected;
        boolean columnEditable = true;
        if (this.tableRuleSet != null) {
            columnEditable = this.tableRuleSet.isColumnEditable(this.model.getColumnAttributeName(this.popupColumn));
        }
        boolean bl = editableColsSelected = (selectedRows = this.table.getSelectedRows()) == null || selectedRows.length == 0;
        if (selectedRows != null) {
            for (int row : selectedRows) {
                FeatureServiceFeature feature = this.model.getFeatureServiceFeature(this.table.convertRowIndexToModel(row));
                if (!feature.isEditable()) continue;
                editableColsSelected = true;
                break;
            }
        }
        return this.tbProcessing.isSelected() && columnEditable && editableColsSelected;
    }

    private void setPartialTable(boolean partial) {
        if (partial) {
            this.pageSize = this.featureService.getMaxFeaturesPerPage();
            this.butPrintPreview.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-preview_red.png")));
            this.butPrint.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-print_red.png")));
            this.butExport.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-export_red.png")));
            this.butAttrib.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-search_red.png")));
            this.butSelectAll.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-selectionadd_red.png")));
            this.butInvertSelection.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-selectionintersect_red.png")));
            this.butMoveSelectedRows.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-thissideup_red.png")));
            this.butZoomToSelection.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-resize_red.png")));
        } else {
            this.pageSize = -1;
            this.jpControl.setVisible(false);
            this.panHint.setVisible(false);
            this.butPrintPreview.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-preview.png")));
            this.butPrint.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-print.png")));
            this.butExport.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-export.png")));
            this.butAttrib.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-search.png")));
            this.butSelectAll.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-selectionadd.png")));
            this.butInvertSelection.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-selectionintersect.png")));
            this.butMoveSelectedRows.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-thissideup.png")));
            this.butZoomToSelection.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-resize.png")));
        }
    }

    public void addModifiedFeature(DefaultFeatureServiceFeature feature) {
        this.modifiedFeatures.add(feature);
    }

    private void setSelection(List<? extends Feature> selectedFeatures) {
        if (this.model == null) {
            return;
        }
        List<FeatureServiceFeature> tableFeatures = this.model.getFeatureServiceFeatures();
        this.table.getSelectionModel().setValueIsAdjusting(true);
        int[] selectedRows = this.table.getSelectedRows();
        Arrays.sort(selectedRows);
        Comparator<Feature> featureComp = new Comparator<Feature>(){

            @Override
            public int compare(Feature o1, Feature o2) {
                if (o1 instanceof FeatureWithId && o2 instanceof FeatureWithId) {
                    return ((FeatureWithId)((Object)o1)).getId() - ((FeatureWithId)((Object)o2)).getId();
                }
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null && o2 != null) {
                    return -1;
                }
                if (o1 != null && o2 == null) {
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }
        };
        if (selectedFeatures != null) {
            Collections.sort(selectedFeatures, featureComp);
        }
        for (int index = 0; index < tableFeatures.size(); ++index) {
            boolean selected;
            FeatureServiceFeature feature = tableFeatures.get(this.table.convertRowIndexToModel(index));
            boolean contained = selectedFeatures != null && Collections.binarySearch(selectedFeatures, feature, featureComp) >= 0;
            boolean bl = selected = Arrays.binarySearch(selectedRows, index) >= 0;
            if (contained && !selected) {
                this.table.addRowSelectionInterval(index, index);
                continue;
            }
            if (contained || !selected) continue;
            this.table.removeRowSelectionInterval(index, index);
        }
        this.table.getSelectionModel().setValueIsAdjusting(false);
    }

    public void setExportEnabled(boolean enabled) {
        this.butExport.setVisible(enabled);
    }

    public boolean isPasteButtonEnabled() {
        boolean enabled = false;
        if (clipboard != null && this.tbProcessing.isSelected() && this.featureService.isEditable()) {
            for (FeatureServiceFeature feature : clipboard) {
                String geomType = this.featureService.getLayerProperties().getFeatureService().getGeometryType();
                if (geomType != null && !geomType.equals(AbstractFeatureService.UNKNOWN)) {
                    try {
                        Class<?> geomTypeClass = Class.forName("com.vividsolutions.jts.geom." + geomType);
                        if (geomTypeClass != null && feature.getGeometry() != null && geomTypeClass.isInstance(feature.getGeometry())) {
                            enabled = true;
                            break;
                        }
                        String compGeoType = geomType.startsWith("Multi") ? geomType.substring("Multi".length()) : "Multi" + geomType;
                        try {
                            Class<?> otherGeomTypeClass = Class.forName("com.vividsolutions.jts.geom." + compGeoType);
                            if (otherGeomTypeClass == null || feature.getGeometry() == null || !otherGeomTypeClass.isInstance(feature.getGeometry())) continue;
                            enabled = true;
                            break;
                        }
                        catch (ClassNotFoundException e) {
                            enabled = false;
                        }
                    }
                    catch (Exception e) {
                        if (!geomType.equals(AbstractFeatureService.NONE) || feature.getGeometry() != null) continue;
                        enabled = true;
                    }
                    continue;
                }
                if (geomType != null || feature.getGeometry() != null) continue;
                enabled = true;
                break;
            }
        }
        return enabled;
    }

    private void enableDisableButtons() {
        this.butUndo.setEnabled(this.isUndoButtonEnabled());
        this.butPaste.setEnabled(this.tbProcessing.isSelected());
        this.butDelete.setEnabled(this.isDeleteButtonEnabled());
    }

    private boolean isUndoButtonEnabled() {
        this.refreshModifiedFeaturesSet();
        return this.tbProcessing.isSelected() && !this.modifiedFeatures.isEmpty();
    }

    private boolean isDeleteButtonEnabled() {
        int[] selectedIndices;
        if (!this.tbProcessing.isSelected()) {
            return false;
        }
        boolean hasWritePermission = false;
        for (int index : selectedIndices = this.table.getSelectedRows()) {
            int modelIndex = this.table.convertRowIndexToModel(index);
            FeatureServiceFeature f = this.model.getFeatureServiceFeature(modelIndex);
            if (f == null) continue;
            if (f instanceof PermissionProvider) {
                if (!((PermissionProvider)((Object)f)).hasWritePermissions()) continue;
                hasWritePermission = true;
                break;
            }
            hasWritePermission = true;
            break;
        }
        return hasWritePermission && selectedIndices.length > 0;
    }

    private void refreshModifiedFeaturesSet() {
        for (FeatureServiceFeature feature : this.lockedFeatures) {
            if (!(feature instanceof ModifiableFeature) || !(feature instanceof DefaultFeatureServiceFeature)) continue;
            FeatureServiceFeature featureFromModel = this.model.getFeatureServiceFeatureById(feature.getId());
            if (featureFromModel != null) {
                feature = featureFromModel;
            }
            if (!((ModifiableFeature)((Object)feature)).isFeatureChanged()) continue;
            this.modifiedFeatures.add((DefaultFeatureServiceFeature)feature);
        }
    }

    private void synchronizeTableSeletionWithMap() {
        ArrayList features = new ArrayList();
        SelectionListener sl = (SelectionListener)this.mappingComponent.getInputEventListener().get("SELECT");
        features.addAll(this.featureService.getPNode().getChildrenReference());
        int[] selectedFeatures = this.table.getSelectedRows();
        int[] selectedFeatureIds = new int[selectedFeatures.length];
        for (int i = 0; i < selectedFeatures.length; ++i) {
            selectedFeatureIds[i] = this.model.getFeatureServiceFeature(this.table.convertRowIndexToModel(selectedFeatures[i])).getId();
        }
        Arrays.sort(selectedFeatureIds);
        for (PFeature pfeature : features) {
            boolean selected;
            Feature feature = pfeature.getFeature();
            if (!(feature instanceof FeatureWithId)) continue;
            boolean bl = selected = Arrays.binarySearch(selectedFeatureIds, ((FeatureWithId)((Object)feature)).getId()) >= 0;
            if (selected != pfeature.isSelected()) {
                pfeature.setSelected(selected);
            }
            if (selected) {
                sl.addSelectedFeature(pfeature);
                continue;
            }
            sl.removeSelectedFeature(pfeature);
        }
    }

    public AbstractFeatureService getFeatureService() {
        return this.featureService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispose() {
        this.refreshModifiedFeaturesSet();
        if (this.tbProcessing.isSelected() && !this.modifiedFeatures.isEmpty()) {
            int ans = JOptionPane.showConfirmDialog(this, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.addWindowListener().text", (Object)this.featureService.getName()), NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.addWindowListener().title"), 1);
            if (ans == 0) {
                if (!this.saveChangedRows(true, true)) {
                    return false;
                }
            } else {
                if (ans != 1) return false;
                this.model.setEditable(false);
                AttributeTableFactory.getInstance().processingModeChanged(this.featureService, this.tbProcessing.isSelected());
            }
        } else if (this.tbProcessing.isSelected()) {
            this.model.setEditable(false);
            AttributeTableFactory.getInstance().processingModeChanged(this.featureService, this.tbProcessing.isSelected());
        }
        SelectionManager.getInstance().removeSelectionChangedListener(this.featureSelectionChangedListener);
        this.mappingComponent.removeRepaintListener(this.repaintListener);
        instances.remove(this);
        this.table.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
        this.selectionListener.clear();
        this.model.setNewFeatureList(new ArrayList<FeatureServiceFeature>());
        this.model = null;
        if (this.calculationDialog == null) return true;
        this.calculationDialog = null;
        return true;
    }

    public void makeFeatureEditable(FeatureServiceFeature feature, Component parent) {
        PermissionProvider pp;
        if (feature instanceof PermissionProvider && feature.getId() > 0 && !(pp = (PermissionProvider)((Object)feature)).hasWritePermissions()) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.makeFeatureEditable.noPermissions.text"), NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.makeFeatureEditable.noPermissions.title"), 0);
            return;
        }
        if (feature != null && !feature.isEditable() && !this.shownAsLocked.contains(feature)) {
            try {
                if (this.locker != null && !this.tableLock && !this.lockingObjects.containsKey(feature)) {
                    this.lockingObjects.put(feature, this.locker.lock(feature, false));
                }
                feature.setEditable(true);
                if (!this.lockedFeatures.contains(feature)) {
                    this.lockedFeatures.add(feature);
                    ((DefaultFeatureServiceFeature)feature).addPropertyChangeListener(this.model);
                }
            }
            catch (LockAlreadyExistsException ex) {
                this.shownAsLocked.add(feature);
                Component c = parent;
                if (c == null) {
                    c = this;
                }
                JOptionPane.showMessageDialog(c, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.ListSelectionListener.valueChanged().lockexists.message", (Object)feature.getId(), (Object)ex.getLockMessage()), NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.ListSelectionListener.valueChanged().lockexists.title"), 0);
                this.shownAsLocked.add(feature);
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while locking feature.", (Throwable)ex);
                JOptionPane.showMessageDialog(this, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.ListSelectionListener.valueChanged().exception.message", (Object)ex.getMessage()), NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.ListSelectionListener.valueChanged().exception.title"), 0);
            }
        }
    }

    public void makeFeaturesEditable(List<FeatureServiceFeature> features) {
        boolean cannotLockAll = false;
        for (FeatureServiceFeature f : new ArrayList<FeatureServiceFeature>(features)) {
            PermissionProvider pp;
            if (!(f instanceof PermissionProvider) || f.getId() <= 0 || (pp = (PermissionProvider)((Object)f)).hasWritePermissions()) continue;
            cannotLockAll = true;
            features.remove(f);
        }
        ArrayList<FeatureServiceFeature> featuresToLock = new ArrayList<FeatureServiceFeature>();
        for (FeatureServiceFeature feature : features) {
            if (feature == null || feature.isEditable() || this.shownAsLocked.contains(feature)) continue;
            featuresToLock.add(feature);
        }
    }

    public void addFeature(FeatureServiceFeature feature) {
        if (this.model != null) {
            this.model.addFeature(feature);
            int index = this.model.getRowCount() - 1;
            this.table.getSelectionModel().addSelectionInterval(index, index);
            this.modifiedFeatures.add((DefaultFeatureServiceFeature)feature);
            this.newFeatures.add((DefaultFeatureServiceFeature)feature);
            this.butMoveSelectedRowsActionPerformed(null);
        }
    }

    public void addFeatures(List<FeatureServiceFeature> features) {
        if (this.model != null) {
            int index = this.model.getRowCount();
            this.model.addFeatures(features);
            for (FeatureServiceFeature feature : features) {
                this.modifiedFeatures.add((DefaultFeatureServiceFeature)feature);
                this.newFeatures.add((DefaultFeatureServiceFeature)feature);
            }
            this.table.getSelectionModel().addSelectionInterval(index, this.model.getRowCount() - 1);
            this.butMoveSelectedRowsActionPerformed(null);
        }
    }

    public void markFeatureAsNewFeature(DefaultFeatureServiceFeature feature) {
        this.newFeatures.add(feature);
    }

    private void loadModel(final int page) {
        if (!this.lockingObjects.isEmpty()) {
            LOG.warn((Object)"Cannot reload the model of the AttributeTable, because there are unsaved objects.");
            return;
        }
        this.panWaiting.setVisible(true);
        ((JXBusyLabel)this.labWaitingImage).setBusy(true);
        this.setNewModel = true;
        SwingWorker<List<FeatureServiceFeature>, Void> worker = new SwingWorker<List<FeatureServiceFeature>, Void>(){

            @Override
            protected List<FeatureServiceFeature> doInBackground() throws Exception {
                List featureList;
                Thread.currentThread().setName("AttributeTable loadModel");
                Object serviceQuery = AttributeTable.this.query == null ? AttributeTable.this.featureService.getQuery() : AttributeTable.this.query;
                Geometry g = ZoomToLayerWorker.getServiceBounds(AttributeTable.this.featureService);
                if (g != null) {
                    AttributeTable.this.bb = new XBoundingBox(g);
                    try {
                        CrsTransformer transformer = new CrsTransformer(CismapBroker.getInstance().getSrs().getCode());
                        AttributeTable.this.bb = transformer.transformBoundingBox(AttributeTable.this.bb);
                        AttributeTable.this.bb.increase(1);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot transform CRS.", (Throwable)e);
                    }
                } else {
                    AttributeTable.this.bb = null;
                }
                if (AttributeTable.this.pageSize != -1 && AttributeTable.this.itemCount == 0) {
                    AttributeTable.this.setItemCount(AttributeTable.this.featureService.getFeatureCount(serviceQuery, AttributeTable.this.bb));
                    if (AttributeTable.this.itemCount / AttributeTable.this.pageSize <= 1) {
                        AttributeTable.this.pageSize = -1;
                        AttributeTable.this.setPartialTable(false);
                    }
                }
                FeatureFactory factory = AttributeTable.this.featureService.getFeatureFactory();
                if (AttributeTable.this.pageSize != -1) {
                    ArrayList<FeatureServiceAttribute> orderBy = null;
                    List<RowSorter.SortKey> keys = null;
                    if (AttributeTable.this.table != null && AttributeTable.this.table.getRowSorter() != null) {
                        keys = AttributeTable.this.table.getRowSorter().getSortKeys();
                    }
                    if (keys != null && !keys.isEmpty()) {
                        orderBy = new ArrayList<FeatureServiceAttribute>();
                        for (RowSorter.SortKey key : keys) {
                            SortOrder order = key.getSortOrder();
                            int colIndex = key.getColumn();
                            String attributeName = AttributeTable.this.model.getColumnAttributeName(AttributeTable.this.table.convertColumnIndexToModel(colIndex));
                            FeatureServiceAttribute attr = AttributeTable.this.featureService.getFeatureServiceAttributes().get(attributeName);
                            attr.setAscOrder(SortOrder.ASCENDING.equals((Object)order));
                            if (AttributeTable.this.pageSize != -1 && !orderBy.isEmpty()) continue;
                            orderBy.add(attr);
                        }
                    }
                    featureList = factory.createFeatures(serviceQuery, AttributeTable.this.bb, null, (page - 1) * AttributeTable.this.pageSize, AttributeTable.this.pageSize, orderBy == null ? null : orderBy.toArray(new FeatureServiceAttribute[orderBy.size()]));
                } else {
                    featureList = factory.createFeatures(serviceQuery, AttributeTable.this.bb, null, 0, 0, null);
                }
                return new ArrayList<FeatureServiceFeature>(featureList);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    List featureList = (List)this.get();
                    if (AttributeTable.this.model == null) {
                        Map<String, FeatureServiceAttribute> featureServiceAttributes = AttributeTable.this.featureService.getFeatureServiceAttributes();
                        List<String> orderedFeatureServiceAttributes = AttributeTable.this.featureService.getOrderedFeatureServiceAttributes();
                        AttributeTable.this.model = new CustomTableModel(orderedFeatureServiceAttributes, featureServiceAttributes, featureList, AttributeTable.this.tableRuleSet);
                        ArrayList<String> columnList = new ArrayList<String>();
                        columnList.add(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.loadModel.column.none"));
                        columnList.addAll(AttributeTable.this.model.getAllColumnNames());
                        for (String key : featureServiceAttributes.keySet()) {
                            if (!featureServiceAttributes.get(key).isGeometry()) continue;
                            String geomAlias = AttributeTable.this.model.getColumnNameByAttributeName(key);
                            columnList.remove(geomAlias);
                        }
                        AttributeTable.this.cbCol1.setModel(new DefaultComboBoxModel<String>(columnList.toArray(new String[0])));
                        AttributeTable.this.cbCol2.setModel(new DefaultComboBoxModel<String>(columnList.toArray(new String[0])));
                        AttributeTable.this.cbCol3.setModel(new DefaultComboBoxModel<String>(columnList.toArray(new String[0])));
                        AttributeTable.this.cbCol4.setModel(new DefaultComboBoxModel<String>(columnList.toArray(new String[0])));
                        AttributeTable.this.table.setModel((TableModel)AttributeTable.this.model);
                        AttributeTable.setTabMapping((JTable)AttributeTable.this.table);
                        if (AttributeTable.this.pageSize != -1) {
                            AttributeTable.this.table.setRowSorter((RowSorter)new CustomRowSorter(AttributeTable.this.model));
                        }
                        AttributeTable.this.setTableSize();
                    } else {
                        AttributeTable.this.model.setNewFeatureList(featureList);
                    }
                    AttributeTable.this.setNewModel = false;
                    AttributeTable.this.applySelection();
                    if (AttributeTable.this.tableRuleSet != null) {
                        for (int i = 0; i < AttributeTable.this.table.getColumnCount(); ++i) {
                            String columnName = AttributeTable.this.model.getColumnAttributeName(i);
                            TableCellEditor editor = AttributeTable.this.tableRuleSet.getCellEditor(columnName);
                            TableCellRenderer renderer = AttributeTable.this.tableRuleSet.getCellRenderer(columnName);
                            if (editor != null) {
                                AttributeTable.this.table.getColumn(i).setCellEditor(editor);
                            } else {
                                AttributeTable.this.table.getColumn(i).setCellEditor(editor);
                            }
                            if (renderer == null) continue;
                            AttributeTable.this.table.getColumn(i).setCellRenderer(renderer);
                        }
                    }
                    AttributeTable.this.txtCurrentPage.setText(String.valueOf(page));
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while retrieving model", (Throwable)e);
                }
                finally {
                    AttributeTable.this.panWaiting.setVisible(false);
                    ((JXBusyLabel)AttributeTable.this.labWaitingImage).setBusy(false);
                    AttributeTable.this.setNewModel = false;
                }
            }
        };
        CismetConcurrency.getInstance((String)"attributeTable").getDefaultExecutor().execute(worker);
    }

    public static void setTabMapping(final JTable theTable) {
        if (theTable == null) {
            throw new IllegalArgumentException("theTable is null");
        }
        final int endCol = theTable.getModel().getColumnCount();
        InputMap im = theTable.getInputMap(1);
        ActionMap am = theTable.getActionMap();
        KeyStroke tabKey = KeyStroke.getKeyStroke(9, 0);
        am.put(im.get(tabKey), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = theTable.getSelectedRow();
                int col = theTable.getSelectedColumn();
                if (theTable.getSelectedRowCount() != 1) {
                    return;
                }
                if (theTable.getEditingRow() != -1 && theTable.getEditingColumn() != -1) {
                    theTable.getCellEditor(theTable.getEditingRow(), theTable.getEditingColumn()).stopCellEditing();
                }
                boolean editCell = false;
                int attemptions = 0;
                do {
                    ++attemptions;
                    if (++col < endCol) continue;
                    col = 0;
                } while (!(editCell = theTable.editCellAt(row, col)) && attemptions < 150);
                theTable.changeSelection(row, col, false, false);
            }
        });
        KeyStroke shiftTabKey = KeyStroke.getKeyStroke(9, 64);
        am.put(im.get(shiftTabKey), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = theTable.getSelectedRow();
                int col = theTable.getSelectedColumn();
                if (theTable.getSelectedRowCount() != 1) {
                    return;
                }
                if (theTable.getEditingRow() != -1 && theTable.getEditingColumn() != -1) {
                    theTable.getCellEditor(theTable.getEditingRow(), theTable.getEditingColumn()).stopCellEditing();
                }
                boolean editCell = false;
                int attemptions = 0;
                do {
                    ++attemptions;
                    if (--col >= 0) continue;
                    col = endCol - 1;
                } while (!(editCell = theTable.editCellAt(row, col)) && attemptions < 150);
                theTable.changeSelection(row, col, false, false);
            }
        });
    }

    public void setQuery(Object query) {
        this.query = query;
        this.currentPage = 1;
        this.itemCount = 0;
        this.loadModel(this.currentPage);
        if (query instanceof String) {
            String queryString = (String)query;
            int newLinePosition = queryString.indexOf("\n");
            boolean addPoints = false;
            if (newLinePosition != -1) {
                queryString = queryString.substring(0, newLinePosition);
                addPoints = true;
            }
            if (queryString.length() > 20) {
                queryString = queryString.substring(0, 18);
                addPoints = true;
            }
            if (addPoints) {
                queryString = queryString + "...";
            }
            AttributeTableFactory.getInstance().changeAttributeTableName(this.featureService, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.setQuery().name", (Object)this.featureService.getName(), (Object)queryString));
        } else {
            AttributeTableFactory.getInstance().changeAttributeTableName(this.featureService, NbBundle.getMessage(AttributeTableFactory.class, (String)"AttributeTableFactory.showAttributeTable().name", (Object)this.featureService.getName()));
        }
    }

    public void changeProcessingMode(boolean forceSave) {
        this.shownAsLocked.clear();
        this.tbProcessing.setSelected(!this.tbProcessing.isSelected());
        this.changeProcessingModeIntern(forceSave);
    }

    public boolean isProcessingModeActive() {
        return this.tbProcessing.isSelected();
    }

    public boolean isLoading() {
        return this.panWaiting.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeProcessingModeIntern(boolean forceSave) {
        this.lastRows = null;
        if (this.model == null) {
            this.tbProcessing.setSelected(!this.tbProcessing.isSelected());
            return;
        }
        if (this.tbProcessing.isSelected()) {
            this.model.setEditable(this.tbProcessing.isSelected());
            AttributeTableFactory.getInstance().processingModeChanged(this.featureService, this.tbProcessing.isSelected());
            ActiveLayerModel model = (ActiveLayerModel)CismapBroker.getInstance().getMappingComponent().getMappingModel();
            if (!this.featureService.isSelectable()) {
                this.featureService.setSelectable(true);
            }
            if (!this.featureService.isEnabled()) {
                this.featureService.setEnabled(true);
            }
            if (model.getMapServices().values().contains(this.featureService) && !model.isVisible(new TreePath(this.featureService))) {
                model.handleVisibility(new TreePath(this.featureService));
                this.featureService.retrieve(true);
            }
            List<FeatureServiceFeature> selectedFeatures = this.getSelectedFeatures();
            try {
                CismapBroker.getInstance().getMappingComponent().setSelectionInProgress(true);
                this.setSelection(null);
                this.setSelection(selectedFeatures);
            }
            finally {
                CismapBroker.getInstance().getMappingComponent().setSelectionInProgress(false);
            }
            CismapBroker.getInstance().getMappingComponent().showHandles(false);
        } else {
            if (this.table.getEditingColumn() != -1 && this.table.getEditingRow() != -1) {
                this.table.getCellEditor(this.table.getEditingRow(), this.table.getEditingColumn()).stopCellEditing();
            }
            this.saveChangedRows(forceSave, true);
        }
        this.enableDisableButtons();
        this.table.repaint();
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.miSortieren = new JMenuItem();
        this.miStatistik = new JMenuItem();
        this.miSpalteAusblenden = new JMenuItem();
        this.miSpaltenUmbenennen = new JMenuItem();
        this.miFeldberechnung = new JMenuItem();
        this.mniAdvancedSorting = new JMenuItem();
        this.diaStatistic = new JDialog();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.lblCountLab = new JLabel();
        this.lblMinLab = new JLabel();
        this.lblMaxLab = new JLabel();
        this.lblSumLab = new JLabel();
        this.lblMeanLab = new JLabel();
        this.lblStdDeviationLab = new JLabel();
        this.lblNullLab = new JLabel();
        this.lblCountVal = new JLabel();
        this.lblMaxVal = new JLabel();
        this.lblMinVal = new JLabel();
        this.lblSumVal = new JLabel();
        this.lblMeanVal = new JLabel();
        this.lblStdDeviationVal = new JLabel();
        this.lblNullVal = new JLabel();
        this.butOk = new JButton();
        this.jPanel3 = new JPanel();
        this.labStat = new JLabel();
        this.labStatCol = new JLabel();
        this.diaExport = new JDialog();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.lblFormat = new JLabel();
        this.jcFormat = new JComboBox();
        this.butExpOk = new JButton();
        this.butCancel = new JButton();
        this.diaSort = new JDialog();
        this.jPanel6 = new JPanel();
        this.jPanel8 = new JPanel();
        this.labSortCol1 = new JLabel();
        this.cbCol1 = new JComboBox();
        this.radOrderAsc1 = new JRadioButton();
        this.radOrderDesc1 = new JRadioButton();
        this.jPanel9 = new JPanel();
        this.butExpOk1 = new JButton();
        this.butCancel1 = new JButton();
        this.jPanel10 = new JPanel();
        this.labSortCol2 = new JLabel();
        this.cbCol2 = new JComboBox();
        this.radOrderAsc2 = new JRadioButton();
        this.radOrderDesc2 = new JRadioButton();
        this.jPanel11 = new JPanel();
        this.labSortCol3 = new JLabel();
        this.cbCol3 = new JComboBox();
        this.radOrderAsc3 = new JRadioButton();
        this.radOrderDesc3 = new JRadioButton();
        this.jPanel12 = new JPanel();
        this.labSortCol4 = new JLabel();
        this.cbCol4 = new JComboBox();
        this.radOrderAsc4 = new JRadioButton();
        this.radOrderDesc4 = new JRadioButton();
        this.bgSortOrder1 = new ButtonGroup();
        this.bgSortOrder2 = new ButtonGroup();
        this.bgSortOrder3 = new ButtonGroup();
        this.bgSortOrder4 = new ButtonGroup();
        this.panHint = new JPanel();
        this.labSegHint = new JLabel();
        this.jToolBar1 = new JToolBar();
        this.butPrintPreview = new JButton();
        this.butPrint = new JButton();
        this.butExport = new JButton();
        this.butAttrib = new JButton();
        this.butSelectAll = new JButton();
        this.butInvertSelection = new JButton();
        this.butClearSelection = new JButton();
        this.butMoveSelectedRows = new JButton();
        this.butZoomToSelection = new JButton();
        this.butColWidth = new JButton();
        this.butShowCols = new JButton();
        this.butSearch = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.tbProcessing = new JToggleButton();
        this.butUndo = new JButton();
        this.butCopy = new JButton();
        this.butPaste = new JButton();
        this.butDelete = new JButton();
        this.panWaiting = new JPanel();
        this.labWaitingImage = new JXBusyLabel();
        this.tableScrollPane = new JScrollPane();
        this.table = new JXTable();
        this.jpControl = new JPanel();
        this.btnFirstPage = new JButton();
        this.btnPrevPage = new JButton();
        this.txtCurrentPage = new JTextField();
        this.lblTotalPages = new JLabel();
        this.btnNextPage = new JButton();
        this.btnLastPage = new JButton();
        this.miSortieren.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.miSortieren.text"));
        this.jPopupMenu1.add(this.miSortieren);
        this.miStatistik.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.miStatistik.text"));
        this.miStatistik.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.miStatistikActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.miStatistik);
        this.miSpalteAusblenden.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.miSpalteAusblenden.text"));
        this.miSpalteAusblenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.miSpalteAusblendenActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.miSpalteAusblenden);
        this.miSpaltenUmbenennen.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.miSpaltenUmbenennen.text"));
        this.miSpaltenUmbenennen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.miSpaltenUmbenennenActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.miSpaltenUmbenennen);
        this.miFeldberechnung.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.miFeldberechnung.text"));
        this.miFeldberechnung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.miFeldberechnungActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.miFeldberechnung);
        this.mniAdvancedSorting.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.mniAdvancedSorting.text"));
        this.mniAdvancedSorting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.mniAdvancedSortingActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.mniAdvancedSorting);
        this.diaStatistic.setTitle(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.diaStatistic.title"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setLayout(new GridBagLayout());
        this.lblCountLab.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.lblCountLab.text"));
        this.lblCountLab.setMaximumSize(new Dimension(150, 20));
        this.lblCountLab.setMinimumSize(new Dimension(150, 20));
        this.lblCountLab.setPreferredSize(new Dimension(150, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblCountLab, gridBagConstraints);
        this.lblMinLab.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.lblMinLab.text"));
        this.lblMinLab.setMaximumSize(new Dimension(150, 20));
        this.lblMinLab.setMinimumSize(new Dimension(150, 20));
        this.lblMinLab.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblMinLab, gridBagConstraints);
        this.lblMaxLab.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.lblMaxLab.text"));
        this.lblMaxLab.setMaximumSize(new Dimension(150, 20));
        this.lblMaxLab.setMinimumSize(new Dimension(150, 20));
        this.lblMaxLab.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblMaxLab, gridBagConstraints);
        this.lblSumLab.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.lblSumLab.text"));
        this.lblSumLab.setMaximumSize(new Dimension(150, 20));
        this.lblSumLab.setMinimumSize(new Dimension(150, 20));
        this.lblSumLab.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblSumLab, gridBagConstraints);
        this.lblMeanLab.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.lblMeanLab.text"));
        this.lblMeanLab.setMaximumSize(new Dimension(150, 20));
        this.lblMeanLab.setMinimumSize(new Dimension(150, 20));
        this.lblMeanLab.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblMeanLab, gridBagConstraints);
        this.lblStdDeviationLab.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.lblStdDeviationLab.text"));
        this.lblStdDeviationLab.setMaximumSize(new Dimension(150, 20));
        this.lblStdDeviationLab.setMinimumSize(new Dimension(150, 20));
        this.lblStdDeviationLab.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblStdDeviationLab, gridBagConstraints);
        this.lblNullLab.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.lblNullLab.text"));
        this.lblNullLab.setMaximumSize(new Dimension(150, 20));
        this.lblNullLab.setMinimumSize(new Dimension(150, 20));
        this.lblNullLab.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblNullLab, gridBagConstraints);
        this.lblCountVal.setHorizontalAlignment(4);
        this.lblCountVal.setMaximumSize(new Dimension(150, 20));
        this.lblCountVal.setMinimumSize(new Dimension(150, 20));
        this.lblCountVal.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblCountVal, gridBagConstraints);
        this.lblMaxVal.setHorizontalAlignment(4);
        this.lblMaxVal.setMaximumSize(new Dimension(150, 20));
        this.lblMaxVal.setMinimumSize(new Dimension(150, 20));
        this.lblMaxVal.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblMaxVal, gridBagConstraints);
        this.lblMinVal.setHorizontalAlignment(4);
        this.lblMinVal.setMaximumSize(new Dimension(150, 20));
        this.lblMinVal.setMinimumSize(new Dimension(150, 20));
        this.lblMinVal.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblMinVal, gridBagConstraints);
        this.lblSumVal.setHorizontalAlignment(4);
        this.lblSumVal.setMaximumSize(new Dimension(150, 20));
        this.lblSumVal.setMinimumSize(new Dimension(150, 20));
        this.lblSumVal.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblSumVal, gridBagConstraints);
        this.lblMeanVal.setHorizontalAlignment(4);
        this.lblMeanVal.setMaximumSize(new Dimension(150, 20));
        this.lblMeanVal.setMinimumSize(new Dimension(150, 20));
        this.lblMeanVal.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblMeanVal, gridBagConstraints);
        this.lblStdDeviationVal.setHorizontalAlignment(4);
        this.lblStdDeviationVal.setMaximumSize(new Dimension(150, 20));
        this.lblStdDeviationVal.setMinimumSize(new Dimension(150, 20));
        this.lblStdDeviationVal.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblStdDeviationVal, gridBagConstraints);
        this.lblNullVal.setHorizontalAlignment(4);
        this.lblNullVal.setMaximumSize(new Dimension(150, 20));
        this.lblNullVal.setMinimumSize(new Dimension(150, 20));
        this.lblNullVal.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.lblNullVal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.butOk.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butOk.text"));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(20, 0, 10, 0);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        this.labStat.setFont(new Font("Ubuntu", 1, 15));
        this.labStat.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.labStat.text"));
        this.jPanel3.add(this.labStat);
        this.labStatCol.setFont(new Font("Ubuntu", 1, 15));
        this.jPanel3.add(this.labStatCol);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.diaStatistic.getContentPane().add((Component)this.jPanel1, "Center");
        this.diaExport.setTitle(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.diaExport.title"));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel5.setBorder(null);
        this.jPanel5.setLayout(new GridBagLayout());
        this.lblFormat.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.lblFormat.text"));
        this.lblFormat.setMaximumSize(new Dimension(100, 20));
        this.lblFormat.setMinimumSize(new Dimension(100, 20));
        this.lblFormat.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.lblFormat, gridBagConstraints);
        this.jcFormat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AttributeTable.this.jcFormatItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel5.add((Component)this.jcFormat, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.butExpOk.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butExpOk.text"));
        this.butExpOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butExpOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(20, 0, 10, 20);
        this.jPanel4.add((Component)this.butExpOk, gridBagConstraints);
        this.butCancel.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butCancel.text"));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 0, 10, 20);
        this.jPanel4.add((Component)this.butCancel, gridBagConstraints);
        this.diaExport.getContentPane().add((Component)this.jPanel4, "Center");
        this.diaSort.setTitle(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.diaSort.title"));
        this.diaSort.setResizable(false);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel8.setLayout(new GridBagLayout());
        this.labSortCol1.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.labSortCol1.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel8.add((Component)this.labSortCol1, gridBagConstraints);
        this.cbCol1.setPreferredSize(new Dimension(250, 27));
        this.cbCol1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AttributeTable.this.cbCol1ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel8.add((Component)this.cbCol1, gridBagConstraints);
        this.bgSortOrder1.add(this.radOrderAsc1);
        this.radOrderAsc1.setSelected(true);
        this.radOrderAsc1.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.radOrderAsc1.text", (Object[])new Object[0]));
        this.radOrderAsc1.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.radOrderAsc1, gridBagConstraints);
        this.bgSortOrder1.add(this.radOrderDesc1);
        this.radOrderDesc1.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.radOrderDesc1.text", (Object[])new Object[0]));
        this.radOrderDesc1.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.radOrderDesc1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel6.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setLayout(new GridBagLayout());
        this.butExpOk1.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butExpOk1.text"));
        this.butExpOk1.setPreferredSize(new Dimension(90, 29));
        this.butExpOk1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butExpOk1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.jPanel9.add((Component)this.butExpOk1, gridBagConstraints);
        this.butCancel1.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butCancel1.text"));
        this.butCancel1.setPreferredSize(new Dimension(90, 29));
        this.butCancel1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butCancel1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel9.add((Component)this.butCancel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanel6.add((Component)this.jPanel9, gridBagConstraints);
        this.jPanel10.setLayout(new GridBagLayout());
        this.labSortCol2.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.labSortCol2.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel10.add((Component)this.labSortCol2, gridBagConstraints);
        this.cbCol2.setPreferredSize(new Dimension(250, 27));
        this.cbCol2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AttributeTable.this.cbCol2ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel10.add((Component)this.cbCol2, gridBagConstraints);
        this.bgSortOrder2.add(this.radOrderAsc2);
        this.radOrderAsc2.setSelected(true);
        this.radOrderAsc2.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.radOrderAsc2.text", (Object[])new Object[0]));
        this.radOrderAsc2.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel10.add((Component)this.radOrderAsc2, gridBagConstraints);
        this.bgSortOrder2.add(this.radOrderDesc2);
        this.radOrderDesc2.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.radOrderDesc2.text", (Object[])new Object[0]));
        this.radOrderDesc2.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel10.add((Component)this.radOrderDesc2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel6.add((Component)this.jPanel10, gridBagConstraints);
        this.jPanel11.setLayout(new GridBagLayout());
        this.labSortCol3.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.labSortCol3.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel11.add((Component)this.labSortCol3, gridBagConstraints);
        this.cbCol3.setPreferredSize(new Dimension(250, 27));
        this.cbCol3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AttributeTable.this.cbCol3ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel11.add((Component)this.cbCol3, gridBagConstraints);
        this.bgSortOrder3.add(this.radOrderAsc3);
        this.radOrderAsc3.setSelected(true);
        this.radOrderAsc3.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.radOrderAsc3.text", (Object[])new Object[0]));
        this.radOrderAsc3.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel11.add((Component)this.radOrderAsc3, gridBagConstraints);
        this.bgSortOrder3.add(this.radOrderDesc3);
        this.radOrderDesc3.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.radOrderDesc3.text", (Object[])new Object[0]));
        this.radOrderDesc3.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel11.add((Component)this.radOrderDesc3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel6.add((Component)this.jPanel11, gridBagConstraints);
        this.jPanel12.setLayout(new GridBagLayout());
        this.labSortCol4.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.labSortCol4.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel12.add((Component)this.labSortCol4, gridBagConstraints);
        this.cbCol4.setPreferredSize(new Dimension(250, 27));
        this.cbCol4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AttributeTable.this.cbCol4ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.jPanel12.add((Component)this.cbCol4, gridBagConstraints);
        this.bgSortOrder4.add(this.radOrderAsc4);
        this.radOrderAsc4.setSelected(true);
        this.radOrderAsc4.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.radOrderAsc4.text", (Object[])new Object[0]));
        this.radOrderAsc4.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel12.add((Component)this.radOrderAsc4, gridBagConstraints);
        this.bgSortOrder4.add(this.radOrderDesc4);
        this.radOrderDesc4.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.radOrderDesc4.text", (Object[])new Object[0]));
        this.radOrderDesc4.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel12.add((Component)this.radOrderDesc4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.jPanel6.add((Component)this.jPanel12, gridBagConstraints);
        this.diaSort.getContentPane().add((Component)this.jPanel6, "Center");
        this.setLayout(new GridBagLayout());
        this.labSegHint.setFont(new Font("Ubuntu", 1, 15));
        this.labSegHint.setForeground(new Color(200, 16, 10));
        this.labSegHint.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.labSegHint.text", (Object[])new Object[0]));
        this.panHint.add(this.labSegHint);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.panHint, gridBagConstraints);
        this.jToolBar1.setRollover(true);
        this.butPrintPreview.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-preview.png")));
        this.butPrintPreview.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butPrintPreview.text"));
        this.butPrintPreview.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butPrintPreview.toolTipText"));
        this.butPrintPreview.setFocusable(false);
        this.butPrintPreview.setHorizontalTextPosition(0);
        this.butPrintPreview.setVerticalTextPosition(3);
        this.butPrintPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butPrintPreviewActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butPrintPreview);
        this.butPrint.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-print.png")));
        this.butPrint.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butPrint.text"));
        this.butPrint.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butPrint.toolTipText"));
        this.butPrint.setFocusable(false);
        this.butPrint.setHorizontalTextPosition(0);
        this.butPrint.setVerticalTextPosition(3);
        this.butPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butPrintActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butPrint);
        this.butExport.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-export.png")));
        this.butExport.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butExport.text"));
        this.butExport.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butExport.toolTipText"));
        this.butExport.setFocusable(false);
        this.butExport.setHorizontalTextPosition(0);
        this.butExport.setVerticalTextPosition(3);
        this.butExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butExportActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butExport);
        this.butAttrib.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-search.png")));
        this.butAttrib.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butAttrib.toolTipText"));
        this.butAttrib.setFocusable(false);
        this.butAttrib.setHorizontalTextPosition(0);
        this.butAttrib.setVerticalTextPosition(3);
        this.butAttrib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butAttribActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butAttrib);
        this.butSelectAll.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-selectionadd.png")));
        this.butSelectAll.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butSelectAll.text"));
        this.butSelectAll.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butSelectAll.toolTipText"));
        this.butSelectAll.setFocusable(false);
        this.butSelectAll.setHorizontalTextPosition(0);
        this.butSelectAll.setVerticalTextPosition(3);
        this.butSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butSelectAllActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butSelectAll);
        this.butInvertSelection.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-selectionintersect.png")));
        this.butInvertSelection.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butInvertSelection.text"));
        this.butInvertSelection.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butInvertSelection.toolTipText"));
        this.butInvertSelection.setFocusable(false);
        this.butInvertSelection.setHorizontalTextPosition(0);
        this.butInvertSelection.setVerticalTextPosition(3);
        this.butInvertSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butInvertSelectionActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butInvertSelection);
        this.butClearSelection.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-selectionremove.png")));
        this.butClearSelection.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butClearSelection.text"));
        this.butClearSelection.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butClearSelection.toolTipText"));
        this.butClearSelection.setFocusable(false);
        this.butClearSelection.setHorizontalTextPosition(0);
        this.butClearSelection.setVerticalTextPosition(3);
        this.butClearSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butClearSelectionActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butClearSelection);
        this.butMoveSelectedRows.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-thissideup.png")));
        this.butMoveSelectedRows.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butMoveSelectedRows.text"));
        this.butMoveSelectedRows.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butMoveSelectedRows.toolTipText"));
        this.butMoveSelectedRows.setFocusable(false);
        this.butMoveSelectedRows.setHorizontalTextPosition(0);
        this.butMoveSelectedRows.setVerticalTextPosition(3);
        this.butMoveSelectedRows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butMoveSelectedRowsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butMoveSelectedRows);
        this.butZoomToSelection.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-resize.png")));
        this.butZoomToSelection.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butZoomToSelection.text"));
        this.butZoomToSelection.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butZoomToSelection.toolTipText"));
        this.butZoomToSelection.setFocusable(false);
        this.butZoomToSelection.setHorizontalTextPosition(0);
        this.butZoomToSelection.setVerticalTextPosition(3);
        this.butZoomToSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butZoomToSelectionActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butZoomToSelection);
        this.butColWidth.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-text-width.png")));
        this.butColWidth.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butColWidth.text"));
        this.butColWidth.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butColWidth.toolTipText"));
        this.butColWidth.setFocusable(false);
        this.butColWidth.setHorizontalTextPosition(0);
        this.butColWidth.setVerticalTextPosition(3);
        this.butColWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butColWidthActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butColWidth);
        this.butShowCols.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-threecolumns.png")));
        this.butShowCols.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butShowCols.text"));
        this.butShowCols.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butShowCols.toolTipText"));
        this.butShowCols.setFocusable(false);
        this.butShowCols.setHorizontalTextPosition(0);
        this.butShowCols.setVerticalTextPosition(3);
        this.butShowCols.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butShowColsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butShowCols);
        this.butSearch.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-searchdocument.png")));
        this.butSearch.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butSearch.text"));
        this.butSearch.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butSearch.toolTipText"));
        this.butSearch.setFocusable(false);
        this.butSearch.setHorizontalTextPosition(0);
        this.butSearch.setVerticalTextPosition(3);
        this.jToolBar1.add(this.butSearch);
        this.jToolBar1.add(this.jSeparator1);
        this.tbProcessing.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-edit.png")));
        this.tbProcessing.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.tbProcessing.toolTipText"));
        this.tbProcessing.setFocusable(false);
        this.tbProcessing.setHorizontalTextPosition(0);
        this.tbProcessing.setVerticalTextPosition(3);
        this.tbProcessing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.tbProcessingActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.tbProcessing);
        this.butUndo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-undo.png")));
        this.butUndo.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butUndo.text"));
        this.butUndo.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butUndo.toolTipText"));
        this.butUndo.setFocusable(false);
        this.butUndo.setHorizontalTextPosition(0);
        this.butUndo.setVerticalTextPosition(3);
        this.butUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butUndoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butUndo);
        this.butCopy.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-copy.png")));
        this.butCopy.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butCopy.text"));
        this.butCopy.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butCopy.toolTipText"));
        this.butCopy.setFocusable(false);
        this.butCopy.setHorizontalTextPosition(0);
        this.butCopy.setVerticalTextPosition(3);
        this.butCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butCopyActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butCopy);
        this.butPaste.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-pastealt.png")));
        this.butPaste.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butPaste.text"));
        this.butPaste.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butPaste.toolTipText"));
        this.butPaste.setFocusable(false);
        this.butPaste.setHorizontalTextPosition(0);
        this.butPaste.setVerticalTextPosition(3);
        this.butPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butPasteActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butPaste);
        this.butDelete.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-remove-sign.png")));
        this.butDelete.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butDelete.text"));
        this.butDelete.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butDelete.toolTipText"));
        this.butDelete.setFocusable(false);
        this.butDelete.setHorizontalTextPosition(0);
        this.butDelete.setVerticalTextPosition(3);
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.butDeleteActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butDelete);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.panWaiting.setBackground(new Color(255, 255, 255, 150));
        this.panWaiting.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panWaiting.add((Component)this.labWaitingImage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panWaiting, gridBagConstraints);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AttributeTable.this.tableMouseClicked(evt);
            }
        });
        this.tableScrollPane.setViewportView((Component)this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tableScrollPane, gridBagConstraints);
        this.jpControl.setLayout(new GridBagLayout());
        this.btnFirstPage.setForeground(new Color(200, 16, 10));
        this.btnFirstPage.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.btnFirstPage.text"));
        this.btnFirstPage.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.btnFirstPage.toolTipText"));
        this.btnFirstPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.btnFirstPageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpControl.add((Component)this.btnFirstPage, gridBagConstraints);
        this.btnPrevPage.setForeground(new Color(200, 16, 10));
        this.btnPrevPage.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.btnPrevPage.text"));
        this.btnPrevPage.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.btnPrevPage.toolTipText"));
        this.btnPrevPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.btnPrevPageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpControl.add((Component)this.btnPrevPage, gridBagConstraints);
        this.txtCurrentPage.setForeground(new Color(200, 16, 10));
        this.txtCurrentPage.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.txtCurrentPage.text"));
        this.txtCurrentPage.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.txtCurrentPage.toolTipText"));
        this.txtCurrentPage.setMinimumSize(new Dimension(50, 27));
        this.txtCurrentPage.setPreferredSize(new Dimension(50, 27));
        this.txtCurrentPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.txtCurrentPageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpControl.add((Component)this.txtCurrentPage, gridBagConstraints);
        this.lblTotalPages.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.lblTotalPages.text"));
        this.lblTotalPages.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.lblTotalPages.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpControl.add((Component)this.lblTotalPages, gridBagConstraints);
        this.btnNextPage.setForeground(new Color(200, 16, 10));
        this.btnNextPage.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.btnNextPage.text"));
        this.btnNextPage.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.btnNextPage.toolTipText"));
        this.btnNextPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.btnNextPageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpControl.add((Component)this.btnNextPage, gridBagConstraints);
        this.btnLastPage.setForeground(new Color(200, 16, 10));
        this.btnLastPage.setText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.btnLastPage.text"));
        this.btnLastPage.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.btnLastPage.toolTipText"));
        this.btnLastPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.btnLastPageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpControl.add((Component)this.btnLastPage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.jpControl, gridBagConstraints);
    }

    private void butPrintPreviewActionPerformed(ActionEvent evt) {
        final int[] selectedRows = this.table.getSelectedRows();
        final boolean useSelectedRows = selectedRows.length > 0;
        WaitingDialogThread<JasperPrint> wdt = new WaitingDialogThread<JasperPrint>(StaticSwingTools.getParentFrame((Component)this), true, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butPrintPreviewActionPerformed.WaitingDialogThread"), null, 500){

            protected JasperPrint doInBackground() throws Exception {
                TableDataSource ds = useSelectedRows ? new TableDataSource((JTable)AttributeTable.this.table, selectedRows) : new TableDataSource((JTable)AttributeTable.this.table);
                HashMap<String, TableDataSource> map = new HashMap<String, TableDataSource>();
                map.put("table_data", ds);
                DynamicReport report = new AttributeTableReportBuilder().buildReport(AttributeTable.this.featureService.getName(), (JTable)AttributeTable.this.table);
                JasperReport jasperReport = DynamicJasperHelper.generateJasperReport((DynamicReport)report, (LayoutManager)new ClassicLayoutManager(), map);
                return JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)ds);
            }

            protected void done() {
                try {
                    JasperPrint jasperPrint = (JasperPrint)this.get();
                    CustomJrViewer aViewer = new CustomJrViewer(jasperPrint);
                    ArrayList<ContributorWrapper> contributors = new ArrayList<ContributorWrapper>();
                    for (JRSaveContributor contributor : aViewer.getSaveContributors()) {
                        if (contributor.getDescription().toLowerCase().contains("pdf")) {
                            contributors.add(new ContributorWrapper(contributor, "PDF"));
                            continue;
                        }
                        if (!contributor.getDescription().toLowerCase().contains("docx")) continue;
                        contributors.add(new ContributorWrapper(contributor, "DOCX"));
                    }
                    Collections.sort(contributors, new Comparator<JRSaveContributor>(){

                        @Override
                        public int compare(JRSaveContributor o1, JRSaveContributor o2) {
                            if (o1 != null && o2 != null) {
                                return o1.getDescription().compareTo(o2.getDescription());
                            }
                            if (o1 == null && o2 == null) {
                                return 0;
                            }
                            if (o1 == null) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                    aViewer.setSaveContributors(contributors.toArray(new JRSaveContributor[contributors.size()]));
                    JFrame aFrame = new JFrame(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butPrintPreviewActionPerformed.aFrame.title"));
                    aFrame.getContentPane().add((Component)((Object)aViewer));
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    aFrame.setSize(screenSize.width / 2, screenSize.height / 2);
                    Insets insets = aFrame.getInsets();
                    aFrame.setSize(aFrame.getWidth() + insets.left + insets.right, aFrame.getHeight() + insets.top + insets.bottom + 20);
                    aFrame.setLocationRelativeTo(AttributeTable.this);
                    aFrame.setVisible(true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while creating report", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private void btnPrevPageActionPerformed(ActionEvent evt) {
        if (this.currentPage > 1) {
            this.loadModel(--this.currentPage);
        }
    }

    private void btnFirstPageActionPerformed(ActionEvent evt) {
        this.currentPage = 1;
        this.loadModel(this.currentPage);
    }

    private void btnNextPageActionPerformed(ActionEvent evt) {
        if (this.pageSize != -1 && this.currentPage * this.pageSize < this.itemCount) {
            this.loadModel(++this.currentPage);
        }
    }

    private void btnLastPageActionPerformed(ActionEvent evt) {
        this.currentPage = this.itemCount / this.pageSize;
        if (this.pageSize != -1 && this.currentPage * this.pageSize < this.itemCount) {
            ++this.currentPage;
            this.loadModel(this.currentPage);
        }
    }

    private void miSpalteAusblendenActionPerformed(ActionEvent evt) {
        this.butShowCols.setEnabled(true);
        this.model.hideColumn(this.popupColumn);
    }

    private void miSpaltenUmbenennenActionPerformed(ActionEvent evt) {
        String newName = (String)JOptionPane.showInputDialog(this, "Geben Sie den neuen Namen der Spalte ein.", "Spalte umbenennen", 3, null, null, this.model.getColumnName(this.popupColumn));
        if (newName != null) {
            this.model.setColumnName(this.popupColumn, newName);
        }
    }

    private void butShowColsActionPerformed(ActionEvent evt) {
        this.model.showColumns();
        this.butShowCols.setEnabled(false);
        this.setTableSize();
    }

    private void butColWidthActionPerformed(ActionEvent evt) {
        this.setTableSize();
    }

    private void butSelectAllActionPerformed(ActionEvent evt) {
        this.selectAll();
    }

    private void butClearSelectionActionPerformed(ActionEvent evt) {
        this.table.getSelectionModel().clearSelection();
    }

    private void butInvertSelectionActionPerformed(ActionEvent evt) {
        int[] selectedIndices = this.table.getSelectedRows();
        this.table.clearSelection();
        Arrays.sort(selectedIndices);
        this.table.getSelectionModel().setValueIsAdjusting(true);
        for (int selectedIndex = 0; selectedIndex < this.table.getRowCount(); ++selectedIndex) {
            if (Arrays.binarySearch(selectedIndices, selectedIndex) >= 0) continue;
            this.table.addRowSelectionInterval(selectedIndex, selectedIndex);
        }
        this.table.getSelectionModel().setValueIsAdjusting(false);
    }

    private void butMoveSelectedRowsActionPerformed(ActionEvent evt) {
        int modelIndex;
        int i;
        int[] selectedRows = this.table.getSelectedRows();
        final FeatureWithIndex[] selectedFeatures = new FeatureWithIndex[selectedRows.length];
        final ArrayList<FeatureServiceFeature> allFeatures = new ArrayList<FeatureServiceFeature>(this.model.getRowCount());
        final int selectedRowCount = selectedRows.length;
        Arrays.sort(selectedRows);
        for (i = 0; i < this.model.getRowCount(); ++i) {
            modelIndex = this.table.convertRowIndexToModel(i);
            allFeatures.add(this.model.getFeatureServiceFeature(modelIndex));
        }
        for (i = 0; i < selectedRowCount; ++i) {
            modelIndex = this.table.convertRowIndexToModel(selectedRows[i]);
            selectedFeatures[i] = new FeatureWithIndex(this.model.getFeatureServiceFeature(modelIndex), selectedRows[i]);
        }
        for (i = 0; i < this.model.getColumnCount(); ++i) {
            this.table.setSortOrder(i, SortOrder.UNSORTED);
        }
        final Comparator<Integer> reverseIntComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -1 * Integer.compare(o1, o2);
            }
        };
        WaitingDialogThread wdt = new WaitingDialogThread(StaticSwingTools.getFirstParentFrame((Component)((Object)CismapBroker.getInstance().getMappingComponent())), true, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butMoveSelectedRows.waiting"), null, 250){

            protected Object doInBackground() throws Exception {
                this.wd.setMax(selectedRowCount);
                ArrayList<Integer> ts = new ArrayList<Integer>();
                AttributeTable.this.model.setNewFeatureList(allFeatures);
                for (int i = selectedRowCount - 1; i >= 0; --i) {
                    int index = -1 * (Collections.binarySearch(ts, selectedFeatures[i].getIndex(), reverseIntComparator) + 1);
                    AttributeTable.this.model.moveRowUp(selectedFeatures[i].getIndex() + index, i == 0);
                    ts.add(index, selectedFeatures[i].getIndex());
                    int count = selectedRowCount - 1 - i;
                    if (count % 10 != 1) continue;
                    this.wd.setProgress((int)((double)count / 0.9));
                }
                return null;
            }

            protected void done() {
                AttributeTable.this.table.getSelectionModel().setSelectionInterval(0, selectedRowCount - 1);
            }
        };
        if (EventQueue.isDispatchThread()) {
            wdt.start();
        } else {
            LinkedList<Integer> ts = new LinkedList<Integer>();
            for (int i2 = selectedRowCount - 1; i2 >= 0; --i2) {
                int index = -1 * (Collections.binarySearch(ts, selectedFeatures[i2].getIndex(), reverseIntComparator) + 1);
                this.model.moveRowUp(selectedFeatures[i2].getIndex() + index, i2 == 0);
                ts.add(index, selectedFeatures[i2].getIndex());
            }
            this.table.getSelectionModel().setSelectionInterval(0, selectedRowCount - 1);
        }
    }

    private void butZoomToSelectionActionPerformed(ActionEvent evt) {
        List<FeatureServiceFeature> featureList = this.getSelectedFeatures();
        ZoomToFeaturesWorker worker = new ZoomToFeaturesWorker(featureList.toArray(new Feature[featureList.size()]), 10);
        worker.execute();
    }

    private void miStatistikActionPerformed(ActionEvent evt) {
        Object val;
        int i;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double sum = 0.0;
        double mean = 0.0;
        double stdDeviation = 0.0;
        int nullCount = 0;
        List<FeatureServiceFeature> consideredFeatures = this.getSelectedFeatures();
        if (consideredFeatures == null || consideredFeatures.isEmpty()) {
            consideredFeatures = this.model.getFeatureServiceFeatures();
        }
        Double[] values = new Double[consideredFeatures.size()];
        int count = consideredFeatures.size();
        String colName = this.model.getColumnName(this.popupColumn);
        for (i = 0; i < consideredFeatures.size(); ++i) {
            val = consideredFeatures.get(i).getProperty(colName);
            if (val instanceof String) {
                try {
                    val = Double.parseDouble((String)val);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (val instanceof Number) {
                double doubleVal = ((Number)val).doubleValue();
                if (doubleVal < min) {
                    min = doubleVal;
                }
                if (doubleVal > max) {
                    max = doubleVal;
                }
                sum += doubleVal;
                values[i] = doubleVal;
                continue;
            }
            if (val != null) continue;
            ++nullCount;
            values[i] = null;
        }
        mean = sum / (double)(count - nullCount);
        for (i = 0; i < values.length; ++i) {
            val = values[i];
            if (val == null) continue;
            double doubleVal = ((Number)val).doubleValue();
            stdDeviation += Math.pow(doubleVal - mean, 2.0);
        }
        if (min == Double.POSITIVE_INFINITY) {
            min = 0.0;
        }
        if (max == Double.NEGATIVE_INFINITY) {
            max = 0.0;
        }
        stdDeviation = Math.sqrt(1.0 / (double)(count - nullCount - 1) * stdDeviation);
        this.lblCountVal.setText(String.valueOf(count));
        this.lblMinVal.setText(this.trimNumberString(this.round(min, 6)));
        this.lblMaxVal.setText(this.trimNumberString(this.round(max, 6)));
        this.lblMeanVal.setText(this.trimNumberString(this.round(mean, 6)));
        this.lblNullVal.setText(String.valueOf(nullCount));
        this.lblStdDeviationVal.setText(this.trimNumberString(this.round(stdDeviation, 6)));
        this.lblSumVal.setText(this.trimNumberString(this.round(sum, 6)));
        this.diaStatistic.pack();
        this.diaStatistic.setResizable(false);
        this.labStatCol.setText(this.model.getColumnName(this.popupColumn));
        StaticSwingTools.showDialog((JDialog)this.diaStatistic);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        this.diaStatistic.setVisible(false);
    }

    private void butExportActionPerformed(ActionEvent evt) {
        if (this.featureService.getLayerProperties().getAttributeTableRuleSet() != null && this.featureService.getLayerProperties().getAttributeTableRuleSet().hasCustomExportFeaturesMethod()) {
            this.featureService.getLayerProperties().getAttributeTableRuleSet().exportFeatures();
            return;
        }
        this.startExport(null, null);
    }

    private void butExpOkActionPerformed(ActionEvent evt) {
        this.diaExport.setVisible(false);
        this.startExport((ExportDownload)((Object)this.jcFormat.getSelectedItem()), null);
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.diaExport.setVisible(false);
    }

    private void jcFormatItemStateChanged(ItemEvent evt) {
    }

    private void butPrintActionPerformed(ActionEvent evt) {
        if (this.featureService.getLayerProperties().getAttributeTableRuleSet() != null && this.featureService.getLayerProperties().getAttributeTableRuleSet().hasCustomPrintFeaturesMethod()) {
            this.featureService.getLayerProperties().getAttributeTableRuleSet().printFeatures();
            return;
        }
        final int[] selectedRows = this.table.getSelectedRows();
        final boolean useSelectedRows = selectedRows.length > 0;
        WaitingDialogThread<JasperPrint> wdt = new WaitingDialogThread<JasperPrint>(StaticSwingTools.getParentFrame((Component)this), true, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butPrintActionPerformed.WaitingDialogThread"), null, 500){

            protected JasperPrint doInBackground() throws Exception {
                TableDataSource ds = useSelectedRows ? new TableDataSource((JTable)AttributeTable.this.table, selectedRows) : new TableDataSource((JTable)AttributeTable.this.table);
                HashMap<String, TableDataSource> map = new HashMap<String, TableDataSource>();
                map.put("table_data", ds);
                DynamicReport report = new AttributeTableReportBuilder().buildReport(AttributeTable.this.featureService.getName(), (JTable)AttributeTable.this.table);
                JasperReport jasperReport = DynamicJasperHelper.generateJasperReport((DynamicReport)report, (LayoutManager)new ClassicLayoutManager(), map);
                return JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)ds);
            }

            protected void done() {
                try {
                    JasperPrint jasperPrint = (JasperPrint)this.get();
                    jasperPrint.setOrientation(OrientationEnum.LANDSCAPE);
                    JasperPrintManager.printReport((JasperPrint)jasperPrint, (boolean)true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while creating report", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private void tbProcessingActionPerformed(ActionEvent evt) {
        this.shownAsLocked.clear();
        this.changeProcessingModeIntern(false);
        this.butPaste.setEnabled(this.isPasteButtonEnabled());
        this.featureDeleted = false;
    }

    private void butUndoActionPerformed(ActionEvent evt) {
        int ans = JOptionPane.showConfirmDialog(this, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butUndoActionPerformed().text"), NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butUndoActionPerformed().title"), 0);
        if (ans == 0) {
            for (DefaultFeatureServiceFeature defaultFeatureServiceFeature : this.modifiedFeatures) {
                defaultFeatureServiceFeature.undoAll();
            }
            for (DefaultFeatureServiceFeature defaultFeatureServiceFeature : this.newFeatures) {
                if (!(defaultFeatureServiceFeature instanceof ModifiableFeature)) continue;
                try {
                    defaultFeatureServiceFeature.setEditable(false);
                    ((ModifiableFeature)((Object)defaultFeatureServiceFeature)).delete();
                    this.model.removeFeatureServiceFeature(defaultFeatureServiceFeature);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot remove feature", (Throwable)e);
                }
            }
            this.newFeatures.clear();
            for (FeatureServiceFeature featureServiceFeature : this.allFeaturesToDelete) {
                if (!(featureServiceFeature instanceof ModifiableFeature)) continue;
                try {
                    featureServiceFeature.setEditable(false);
                    ((ModifiableFeature)((Object)featureServiceFeature)).restore();
                    this.model.addFeature(featureServiceFeature);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot restore feature", (Throwable)e);
                }
            }
            this.allFeaturesToDelete.clear();
        }
    }

    private void butAttribActionPerformed(ActionEvent evt) {
        if (this.searchPanel != null) {
            this.searchPanel.openPanel(this, this.featureService);
        }
    }

    private void butDeleteActionPerformed(ActionEvent evt) {
        this.deleteFeatures();
    }

    public void deleteFeatures() {
        int[] selectedRows = this.table.getSelectedRows();
        final ArrayList featuresToDelete = new ArrayList();
        ArrayList<Integer> rowsToDeleteList = new ArrayList<Integer>();
        final ArrayList<FeatureServiceFeature> featuresToSelect = new ArrayList<FeatureServiceFeature>();
        for (int row : selectedRows) {
            FeatureServiceFeature featureToDelete = this.model.getFeatureServiceFeature(this.table.convertRowIndexToModel(row));
            if (!(featureToDelete instanceof ModifiableFeature)) continue;
            ModifiableFeature dfsf = (ModifiableFeature)((Object)featureToDelete);
            if (!(dfsf instanceof PermissionProvider) || ((PermissionProvider)((Object)dfsf)).hasWritePermissions()) {
                rowsToDeleteList.add(row);
                continue;
            }
            featuresToSelect.add(featureToDelete);
        }
        final Integer[] selectedRowsToDelete = rowsToDeleteList.toArray(new Integer[rowsToDeleteList.size()]);
        int ans = JOptionPane.showConfirmDialog(this, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butDeleteActionPerformed().text", (Object)selectedRowsToDelete.length), NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butDeleteActionPerformed().title"), 0);
        if (ans != 0) {
            return;
        }
        WaitingDialogThread<Map<Integer, String>> wdt = new WaitingDialogThread<Map<Integer, String>>(StaticSwingTools.getParentFrame((Component)this), true, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butDeleteActionPerformed.WaitingDialogThread"), null, 500){

            /*
             * Exception decompiling
             */
            protected Map<Integer, String> doInBackground() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            protected void done() {
                try {
                    Map errors = (Map)this.get();
                    AttributeTable.this.allFeaturesToDelete.addAll(featuresToDelete);
                    for (FeatureServiceFeature fsf : featuresToDelete) {
                        AttributeTable.this.model.removeFeatureServiceFeature(fsf);
                        AttributeTable.this.modifiedFeatures.remove(fsf);
                    }
                    AttributeTable.this.featureService.retrieve(true);
                    if (errors.isEmpty()) {
                        SelectionManager.getInstance().addSelectedFeatures(featuresToSelect);
                    }
                    for (Integer id : errors.keySet()) {
                        if (id >= 0) {
                            JOptionPane.showMessageDialog(AttributeTable.this, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.ListSelectionListener.valueChanged().lockexists.message", (Object)id, errors.get(id)), NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.ListSelectionListener.valueChanged().lockexists.title"), 0);
                            continue;
                        }
                        JOptionPane.showMessageDialog(AttributeTable.this, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.ListSelectionListener.valueChanged().exception.message", errors.get(id)), NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.ListSelectionListener.valueChanged().exception.title"), 0);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while deleting objects", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    /*
     * Unable to fully structure code
     */
    private void miFeldberechnungActionPerformed(ActionEvent evt) {
        attrName = this.model.getColumnAttributeName(this.popupColumn);
        attr = this.featureService.getFeatureServiceAttributes().get(attrName);
        selectedRow = this.table.getSelectedRows();
        if (selectedRow != null && selectedRow.length > 0) {
            featureList = new ArrayList<FeatureServiceFeature>();
            for (int row : selectedRow) {
                f = this.model.getFeatureServiceFeature(this.table.convertRowIndexToModel(row));
                if (!f.isEditable()) continue;
                featureList.add(f);
            }
        } else {
            featureList = this.model.getFeatureServiceFeatures();
            features = new ArrayList<Feature>();
            for (FeatureServiceFeature f : featureList) {
                if (f instanceof PermissionProvider && ((PermissionProvider)f).hasWritePermissions()) {
                    features.add(f);
                    continue;
                }
                features.add(f);
            }
            try {
                if (this.locker == null) ** GOTO lbl37
                this.lockingObjects.put(null, this.locker.lock(features, true));
                this.tableLock = true;
            }
            catch (LockAlreadyExistsException ex) {
                featureList = null;
                JOptionPane.showMessageDialog(this, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.ListSelectionListener.miFeldberechnungActionPerformed().lockexists.message", (Object)ex.getLockMessage()), NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.ListSelectionListener.miFeldberechnungActionPerformed().lockexists.title"), 0);
            }
            catch (Exception ex) {
                featureList = null;
                AttributeTable.LOG.error((Object)"Error while locking feature.", (Throwable)ex);
                JOptionPane.showMessageDialog(this, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.ListSelectionListener.valueChanged().exception.message", (Object)ex.getMessage()), NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.ListSelectionListener.valueChanged().exception.title"), 0);
            }
        }
lbl37:
        // 5 sources

        if (featureList != null) {
            allFeatures = null;
            if (this.pageSize == -1) {
                allFeatures = this.model.getFeatureServiceFeatures();
            }
            if (changes = this.calculationDialog.openPanel(this, this.featureService, attr, featureList, allFeatures)) {
                for (FeatureServiceFeature feature : featureList) {
                    if (!this.lockedFeatures.contains(feature)) {
                        this.lockedFeatures.add(feature);
                    }
                    this.modifiedFeatures.add((DefaultFeatureServiceFeature)feature);
                }
            }
        }
    }

    private void butCopyActionPerformed(ActionEvent evt) {
        this.copySelectedFeaturesToClipboard();
    }

    private void butPasteActionPerformed(ActionEvent evt) {
        this.pasteSelectedFeaturesfromClipboard();
    }

    private void txtCurrentPageActionPerformed(ActionEvent evt) {
        try {
            Integer page = Integer.parseInt(this.txtCurrentPage.getText());
            if (page > 0 && (page - 1) * this.pageSize < this.itemCount) {
                this.currentPage = page;
                this.loadModel(this.currentPage);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void mniAdvancedSortingActionPerformed(ActionEvent evt) {
        this.diaSort.setSize(400, 400);
        this.diaSort.setResizable(false);
        this.diaSort.setModal(true);
        StaticSwingTools.showDialog((JDialog)this.diaSort);
    }

    private void cbCol1ItemStateChanged(ItemEvent evt) {
        Object o = this.cbCol1.getSelectedItem();
        boolean enableBoxes = o != null && this.model.getAllColumnNames().contains((String)o);
        this.radOrderAsc1.setEnabled(enableBoxes);
        this.radOrderDesc1.setEnabled(enableBoxes);
    }

    private void butExpOk1ActionPerformed(ActionEvent evt) {
        ArrayList<String> cols = new ArrayList<String>();
        ArrayList<Boolean> isAscOrder = new ArrayList<Boolean>();
        List<String> colNames = this.model.getAllColumnNames();
        JComboBox[] cbCols = new JComboBox[]{this.cbCol1, this.cbCol2, this.cbCol3, this.cbCol4};
        JRadioButton[] rdButtons = new JRadioButton[]{this.radOrderAsc1, this.radOrderAsc2, this.radOrderAsc3, this.radOrderAsc4};
        for (int i = 0; i < cbCols.length; ++i) {
            String tmp = (String)cbCols[i].getSelectedItem();
            if (tmp == null || !colNames.contains(tmp)) continue;
            cols.add(tmp);
            isAscOrder.add(rdButtons[i].isSelected());
        }
        if (cols.size() > 0) {
            this.model.sortOrder(cols.toArray(new String[cols.size()]), isAscOrder.toArray(new Boolean[isAscOrder.size()]));
        }
        this.diaSort.setVisible(false);
    }

    private void butCancel1ActionPerformed(ActionEvent evt) {
        this.diaSort.setVisible(false);
    }

    private void cbCol2ItemStateChanged(ItemEvent evt) {
        Object o = this.cbCol2.getSelectedItem();
        boolean enableBoxes = o != null && this.model.getAllColumnNames().contains((String)o);
        this.radOrderAsc2.setEnabled(enableBoxes);
        this.radOrderDesc2.setEnabled(enableBoxes);
    }

    private void cbCol3ItemStateChanged(ItemEvent evt) {
        Object o = this.cbCol3.getSelectedItem();
        boolean enableBoxes = o != null && this.model.getAllColumnNames().contains((String)o);
        this.radOrderAsc3.setEnabled(enableBoxes);
        this.radOrderDesc3.setEnabled(enableBoxes);
    }

    private void cbCol4ItemStateChanged(ItemEvent evt) {
        Object o = this.cbCol4.getSelectedItem();
        boolean enableBoxes = o != null && this.model.getAllColumnNames().contains((String)o);
        this.radOrderAsc4.setEnabled(enableBoxes);
        this.radOrderDesc4.setEnabled(enableBoxes);
    }

    private void tableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int selectedRow = this.table.getSelectedRow();
            Geometry g = this.model.getGeometryFromRow(this.table.convertRowIndexToModel(selectedRow));
            if (this.mappingComponent != null && g != null) {
                XBoundingBox bbox = new XBoundingBox(g);
                bbox.increase(10);
                this.mappingComponent.gotoBoundingBoxWithHistory(bbox);
            } else {
                LOG.error((Object)"MappingComponent is not set");
            }
        }
    }

    private void copySelectedFeaturesToClipboard() {
        clipboard = this.getSelectedFeatures();
        for (AttributeTable tab : instances) {
            tab.butPaste.setEnabled(tab.isPasteButtonEnabled());
        }
    }

    public static void copySelectedFeaturesToClipboard(List<FeatureServiceFeature> features) {
        clipboard = features;
        for (AttributeTable tab : instances) {
            tab.butPaste.setEnabled(tab.isPasteButtonEnabled());
        }
    }

    public void pasteSelectedFeaturesfromClipboard() {
        if (clipboard != null && this.featureService.isEditable()) {
            for (FeatureServiceFeature feature : clipboard) {
                if (feature.getGeometry() == null) continue;
                boolean hasZCoordinate = false;
                for (Coordinate c : feature.getGeometry().getCoordinates()) {
                    if (c.z == 0.0 || Double.isNaN(c.z)) continue;
                    hasZCoordinate = true;
                    break;
                }
                if (!hasZCoordinate) continue;
                feature.setGeometry(GeometryUtils.force2d(feature.getGeometry()));
            }
            WaitingDialogThread<List<FeatureServiceFeature>> wdt = new WaitingDialogThread<List<FeatureServiceFeature>>(StaticSwingTools.getParentFrame((Component)this), true, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.pasteSelectedFeaturesfromClipboard.text"), null, 500){

                protected List<FeatureServiceFeature> doInBackground() throws Exception {
                    ArrayList<FeatureServiceFeature> copiedFeatures = new ArrayList<FeatureServiceFeature>();
                    for (FeatureServiceFeature feature : clipboard) {
                        Geometry replacementGeometry;
                        boolean geometryCompatible;
                        Map<String, Object> defaultValues;
                        Map<String, FeatureServiceAttribute> attributeMap;
                        FeatureServiceFeature newFeature;
                        block17: {
                            newFeature = AttributeTable.this.featureService.getFeatureFactory().createNewFeature();
                            attributeMap = AttributeTable.this.featureService.getFeatureServiceAttributes();
                            defaultValues = AttributeTable.this.tableRuleSet.getDefaultValues();
                            geometryCompatible = false;
                            replacementGeometry = null;
                            String geomType = AttributeTable.this.featureService.getLayerProperties().getFeatureService().getGeometryType();
                            if (geomType != null && !geomType.equals(AbstractFeatureService.UNKNOWN)) {
                                try {
                                    String compGeoType;
                                    Class<?> geomTypeClass = Class.forName("com.vividsolutions.jts.geom." + geomType);
                                    if (geomTypeClass == null && feature.getGeometry() == null || geomTypeClass != null && feature.getGeometry() != null && geomTypeClass.isInstance(feature.getGeometry())) {
                                        if (geomTypeClass != null || feature.getGeometry() != null) {
                                            newFeature.setGeometry(feature.getGeometry());
                                        }
                                        geometryCompatible = true;
                                        break block17;
                                    }
                                    boolean makeMulti = false;
                                    if (geomType.startsWith("Multi")) {
                                        compGeoType = geomType.substring("Multi".length());
                                        makeMulti = true;
                                    } else {
                                        compGeoType = "Multi" + geomType;
                                    }
                                    try {
                                        Class<?> otherGeomTypeClass = Class.forName("com.vividsolutions.jts.geom." + compGeoType);
                                        if (otherGeomTypeClass == null || feature.getGeometry() == null || !otherGeomTypeClass.isInstance(feature.getGeometry())) break block17;
                                        if (makeMulti) {
                                            replacementGeometry = StaticGeometryFunctions.toMultiGeometry((Geometry)feature.getGeometry());
                                            geometryCompatible = true;
                                            break block17;
                                        }
                                        replacementGeometry = StaticGeometryFunctions.toSimpleGeometry((Geometry)feature.getGeometry());
                                        geometryCompatible = true;
                                    }
                                    catch (ClassNotFoundException otherGeomTypeClass) {}
                                }
                                catch (Exception e) {
                                    if (!geomType.equals(AbstractFeatureService.NONE) || feature.getGeometry() != null) break block17;
                                    geometryCompatible = true;
                                }
                            }
                        }
                        if (!geometryCompatible) continue;
                        if (AttributeTable.this.tableRuleSet != null) {
                            AttributeTable.this.tableRuleSet.copyProperties(feature, newFeature);
                        } else {
                            if (defaultValues != null) {
                                for (String propName : defaultValues.keySet()) {
                                    newFeature.setProperty(propName, defaultValues.get(propName));
                                }
                            }
                            boolean hasIdExpression = AttributeTable.this.featureService.getLayerProperties().getIdExpressionType() == 1;
                            for (String attrKey : attributeMap.keySet()) {
                                Object val;
                                if (hasIdExpression && AttributeTable.this.featureService.getLayerProperties().getIdExpression().equalsIgnoreCase(attrKey) || !AttributeTable.this.tableRuleSet.isColumnEditable(attrKey) || (val = AttributeTable.this.getFeaturePropertyIgnoreCase(feature, attrKey)) == null) continue;
                                newFeature.setProperty(attrKey, val);
                            }
                        }
                        if (replacementGeometry != null) {
                            newFeature.setGeometry(replacementGeometry);
                        }
                        copiedFeatures.add(newFeature);
                    }
                    return copiedFeatures;
                }

                protected void done() {
                    try {
                        List copiedFeatures = (List)this.get();
                        AttributeTable.this.addFeatures(copiedFeatures);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while paste features", (Throwable)e);
                    }
                }
            };
            wdt.start();
        }
    }

    private Object getFeaturePropertyIgnoreCase(FeatureServiceFeature feature, String name) {
        for (Object prop : feature.getProperties().keySet()) {
            String propName;
            if (!(prop instanceof String) || !(propName = (String)prop).equalsIgnoreCase(name)) continue;
            return feature.getProperty(propName);
        }
        return null;
    }

    public void selectAll() {
        this.table.getSelectionModel().setSelectionInterval(0, this.model.getRowCount() - 1);
    }

    private void startExport(ExportDownload ed, File file) {
        ArrayList<FeatureServiceFeature> features = new ArrayList<FeatureServiceFeature>();
        int[] selectedRows = this.table.getSelectedRows();
        if (this.lastExportPath == null) {
            this.lastExportPath = DownloadManager.instance().getDestinationDirectory().getAbsolutePath();
        }
        if (selectedRows != null) {
            for (int row : selectedRows) {
                FeatureServiceFeature feature = this.model.getFeatureServiceFeature(this.table.convertRowIndexToModel(row));
                if (feature == null) continue;
                features.add(feature);
            }
        }
        if (features.isEmpty()) {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                features.add(this.model.getFeatureServiceFeature(this.table.convertRowIndexToModel(i)));
            }
        }
        try {
            File outputFile = file;
            if (outputFile == null && ed == null) {
                String geometryType = this.featureService.getLayerProperties().getFeatureService().getGeometryType();
                if (geometryType == null || geometryType.equals(AbstractFeatureService.UNKNOWN) || geometryType.equals(AbstractFeatureService.NONE)) {
                    boolean first = true;
                    String featureGeometryType = null;
                    for (Feature feature : features) {
                        if (first) {
                            if (feature.getGeometry() == null) break;
                            featureGeometryType = feature.getGeometry().getGeometryType();
                            first = false;
                            continue;
                        }
                        if (feature.getGeometry() != null && feature.getGeometry().getGeometryType().equals(featureGeometryType)) continue;
                        featureGeometryType = null;
                        break;
                    }
                    outputFile = featureGeometryType == null ? StaticSwingTools.chooseFileWithMultipleFilters((String)this.lastExportPath, (boolean)true, (String[])new String[]{"dbf", "csv", "txt"}, (String[])new String[]{"dbf", "csv", "txt"}, (Component)this) : StaticSwingTools.chooseFileWithMultipleFilters((String)this.lastExportPath, (boolean)true, (String[])new String[]{"shp", "dbf", "csv", "txt"}, (String[])new String[]{"shp", "dbf", "csv", "txt"}, (Component)this);
                } else {
                    outputFile = StaticSwingTools.chooseFileWithMultipleFilters((String)this.lastExportPath, (boolean)true, (String[])new String[]{"shp", "dbf", "csv", "txt"}, (String[])new String[]{"shp", "dbf", "csv", "txt"}, (Component)this);
                }
                if (outputFile != null) {
                    ExportDownload downloader;
                    List<String[]> attributeNames = !outputFile.getName().toLowerCase().endsWith("csv") && !outputFile.getName().toLowerCase().endsWith("txt") ? this.getAliasAttributeList(true) : this.getAliasAttributeList(false);
                    if (outputFile.getName().toLowerCase().endsWith("dbf")) {
                        downloader = new ExportDbfDownload();
                        downloader.init(outputFile.getAbsolutePath(), "", features.toArray(new FeatureServiceFeature[features.size()]), this.featureService, attributeNames, null);
                    } else if (outputFile.getName().toLowerCase().endsWith("csv")) {
                        downloader = new ExportCsvDownload(outputFile.getAbsolutePath(), "", features.toArray(new FeatureServiceFeature[features.size()]), this.featureService, attributeNames);
                    } else if (outputFile.getName().toLowerCase().endsWith("txt")) {
                        downloader = new ExportTxtDownload(outputFile.getAbsolutePath(), "", features.toArray(new FeatureServiceFeature[features.size()]), this.featureService, attributeNames);
                    } else {
                        if (features.isEmpty() && this.featureService.getGeometryType().equals(AbstractFeatureService.UNKNOWN)) {
                            JOptionPane.showMessageDialog(this, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butExportActionPerformed.noFeatures.text"), NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butExportActionPerformed.noFeatures.title"), 1);
                            return;
                        }
                        downloader = new ExportShapeDownload();
                        downloader.init(outputFile.getAbsolutePath(), "", features.toArray(new FeatureServiceFeature[features.size()]), this.featureService, attributeNames, null);
                    }
                    this.lastExportPath = outputFile.getParent();
                    DownloadManager.instance().add((Download)downloader);
                }
            } else {
                ed = (ExportDownload)((Object)((Object)((Object)ed)).getClass().newInstance());
                if (outputFile == null) {
                    outputFile = StaticSwingTools.chooseFile((String)this.lastExportPath, (boolean)true, (String[])new String[]{ed.getDefaultExtension().substring(1)}, (String)ed.getDefaultExtension(), (Component)this);
                }
                if (outputFile != null) {
                    this.lastExportPath = outputFile.getParent();
                    List<String[]> attributeNames = !((Object)((Object)ed)).getClass().getName().toLowerCase().contains("csv") && !((Object)((Object)ed)).getClass().getName().toLowerCase().contains("txt") ? this.getAliasAttributeList(true) : this.getAliasAttributeList(false);
                    ed.init(outputFile.getAbsolutePath(), "", features.toArray(new FeatureServiceFeature[features.size()]), this.featureService, attributeNames, null);
                    DownloadManager.instance().add((Download)ed);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"The ExportDownload class has possibly no public constructor without arguments.", (Throwable)e);
        }
    }

    public void reload() {
        this.loadModel(this.currentPage);
    }

    public void refresh() {
        this.model.fireContentsChanged();
    }

    public boolean saveChangedRows(boolean forceSave, final boolean changeProcessingMode) {
        if (this.table.getEditingRow() != -1 && this.table.getEditingColumn() != -1) {
            this.table.getCellEditor(this.table.getEditingRow(), this.table.getEditingColumn()).stopCellEditing();
        }
        boolean save = forceSave;
        this.refreshModifiedFeaturesSet();
        if (!(save || this.modifiedFeatures.isEmpty() && !this.featureDeleted && this.newFeatures.isEmpty() && this.lockedFeatures.isEmpty())) {
            int ans = JOptionPane.showConfirmDialog(this, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.addWindowListener().text", (Object)this.featureService.getName()), NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.addWindowListener().title"), 0);
            if (ans == 0) {
                save = true;
            } else if (ans == 1) {
                save = false;
            } else {
                return false;
            }
        }
        if (save) {
            ArrayList<FeatureServiceFeature> featuresPrepareForSave = new ArrayList<FeatureServiceFeature>(this.modifiedFeatures);
            featuresPrepareForSave.removeAll(this.allFeaturesToDelete);
            if (this.tableRuleSet instanceof AttributeTableExtendedRuleSet) {
                AttributeTableExtendedRuleSet attributeTableExtendedRuleSet = (AttributeTableExtendedRuleSet)((Object)this.tableRuleSet);
                AttributeTableExtendedRuleSet.ErrorDetails details = attributeTableExtendedRuleSet.prepareForSaveWithDetails(featuresPrepareForSave);
                if (details != null) {
                    int featureIndex;
                    if (details.getFeature() != null && (featureIndex = this.table.convertRowIndexToView(this.model.getRowByFeature(details.getFeature()))) != -1) {
                        this.table.getSelectionModel().setSelectionInterval(featureIndex, featureIndex);
                        if (details.getColumn() != null) {
                            try {
                                String columnName = this.model.getColumnNameByAttributeName(details.getColumn());
                                int col = this.table.getColumnModel().getColumnIndex(columnName);
                                if (col != -1) {
                                    this.table.editCellAt(featureIndex, col);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                LOG.error((Object)"Cell not found.", (Throwable)e);
                            }
                        }
                    }
                    this.tbProcessing.setSelected(true);
                    return false;
                }
            } else if (this.tableRuleSet != null && !this.tableRuleSet.prepareForSave(featuresPrepareForSave)) {
                this.tbProcessing.setSelected(true);
                return false;
            }
            WaitingDialogThread<Void> waitingDialogThread = new WaitingDialogThread<Void>(StaticSwingTools.getParentFrame((Component)this), true, "Speichere \u00c4nderungen", null, 500){

                protected Void doInBackground() throws Exception {
                    ModifiableFeature feature;
                    if (AttributeTable.this.featureService instanceof ShapeFileFeatureService) {
                        ArrayList<FeatureServiceFeature> features = new ArrayList<FeatureServiceFeature>();
                        for (int i = 0; i < AttributeTable.this.model.getRowCount(); ++i) {
                            features.add(AttributeTable.this.model.getFeatureServiceFeature(AttributeTable.this.table.convertRowIndexToModel(i)));
                        }
                        AttributeTable.this.model.setNewFeatureList(new ArrayList<FeatureServiceFeature>());
                        try {
                            if (features.size() > 0) {
                                for (FeatureServiceFeature fsf : AttributeTable.this.modifiedFeatures) {
                                    if (!(fsf instanceof ModifiableFeature)) continue;
                                    try {
                                        feature = (ModifiableFeature)((Object)fsf);
                                        if (AttributeTable.this.tableRuleSet == null) continue;
                                        AttributeTable.this.tableRuleSet.beforeSave(fsf);
                                    }
                                    catch (Exception e) {
                                        LOG.error((Object)"Cannot save object", (Throwable)e);
                                    }
                                }
                                SimpleFeatureCollection fc = new SimpleFeatureCollection(String.valueOf(System.currentTimeMillis()), features.toArray(new FeatureServiceFeature[features.size()]), AttributeTable.this.getAliasAttributeList(true));
                                String filename = ((ShapeFileFeatureService)AttributeTable.this.featureService).getDocumentURI().getPath();
                                File shapeFile = new File(filename);
                                if (shapeFile.exists()) {
                                    File[] files;
                                    String file = shapeFile.getName();
                                    if (file.contains(".")) {
                                        file = file.substring(0, file.lastIndexOf("."));
                                    }
                                    final String nameStem = file;
                                    for (File f : files = shapeFile.getParentFile().listFiles(new FileFilter(){

                                        @Override
                                        public boolean accept(File pathname) {
                                            return pathname.getName().substring(0, nameStem.length()).equals(nameStem);
                                        }
                                    })) {
                                        if (!f.getName().endsWith(".sbx") && !f.getName().endsWith(".rti")) continue;
                                        f.delete();
                                    }
                                }
                                if (filename.contains(".")) {
                                    filename = filename.substring(0, filename.lastIndexOf("."));
                                }
                                ShapeFile shape = new ShapeFile((FeatureCollection)fc, filename);
                                ShapeFileWriter writer = new ShapeFileWriter(shape);
                                writer.write();
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while refreshing shape file.", (Throwable)e);
                        }
                    } else {
                        if (AttributeTable.this.modifiedFeatures.size() > 0) {
                            this.wd.setMax(AttributeTable.this.modifiedFeatures.size());
                        }
                        int count = 0;
                        for (FeatureServiceFeature fsf : AttributeTable.this.modifiedFeatures) {
                            if (fsf instanceof ModifiableFeature) {
                                try {
                                    feature = (ModifiableFeature)((Object)fsf);
                                    if (AttributeTable.this.tableRuleSet != null) {
                                        AttributeTable.this.tableRuleSet.beforeSave(fsf);
                                    }
                                    feature.saveChangesWithoutReload();
                                }
                                catch (Exception e) {
                                    LOG.error((Object)"Cannot save object", (Throwable)e);
                                }
                            }
                            this.wd.setProgress(++count);
                        }
                    }
                    if (changeProcessingMode) {
                        AttributeTable.this.lockedFeatures.clear();
                    }
                    AttributeTable.this.modifiedFeatures.clear();
                    for (DefaultFeatureServiceFeature f : AttributeTable.this.newFeatures) {
                        f.setEditable(false);
                    }
                    AttributeTable.this.newFeatures.clear();
                    if (AttributeTable.this.tableRuleSet != null && AttributeTable.this.allFeaturesToDelete != null && !AttributeTable.this.allFeaturesToDelete.isEmpty()) {
                        for (FeatureServiceFeature f : AttributeTable.this.allFeaturesToDelete) {
                            AttributeTable.this.model.addRemovedFeature(f);
                        }
                    }
                    AttributeTable.this.tableRuleSet.afterSave(AttributeTable.this.model);
                    AttributeTable.this.model.clearRemovedFeatures();
                    AttributeTable.this.allFeaturesToDelete.clear();
                    if (changeProcessingMode) {
                        AttributeTable.this.model.setEditable(false);
                        AttributeTableFactory.getInstance().processingModeChanged(AttributeTable.this.featureService, AttributeTable.this.tbProcessing.isSelected());
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AttributeTable.this.selectionChangeFromMap = true;
                            AttributeTable.this.model.fireContentsChanged();
                            AttributeTable.this.selectionChangeFromMap = false;
                        }
                    });
                    if (CismapBroker.getInstance().getMappingComponent() != null) {
                        CismapBroker.getInstance().getMappingComponent().refresh();
                    }
                    if (changeProcessingMode && AttributeTable.this.featureService != null) {
                        AttributeTable.this.loadModel(AttributeTable.this.currentPage);
                    }
                    AttributeTable.this.butUndo.setEnabled(AttributeTable.this.isUndoButtonEnabled());
                    return null;
                }
            };
            waitingDialogThread.start();
        } else {
            for (FeatureServiceFeature featureServiceFeature : this.modifiedFeatures) {
                if (!(featureServiceFeature instanceof DefaultFeatureServiceFeature)) continue;
                ((DefaultFeatureServiceFeature)featureServiceFeature).undoAll();
            }
            this.allFeaturesToDelete.removeAll(this.newFeatures);
            for (DefaultFeatureServiceFeature defaultFeatureServiceFeature : this.newFeatures) {
                if (!(defaultFeatureServiceFeature instanceof ModifiableFeature)) continue;
                try {
                    defaultFeatureServiceFeature.setEditable(false);
                    ((ModifiableFeature)((Object)defaultFeatureServiceFeature)).delete();
                    this.model.removeFeatureServiceFeature(defaultFeatureServiceFeature);
                    SelectionManager.getInstance().removeSelectedFeatures(defaultFeatureServiceFeature);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot remove feature", (Throwable)e);
                }
            }
            this.rejectedNewFeatures.addAll(this.newFeatures);
            this.newFeatures.clear();
            for (FeatureServiceFeature featureServiceFeature : this.allFeaturesToDelete) {
                if (!(featureServiceFeature instanceof ModifiableFeature)) continue;
                try {
                    featureServiceFeature.setEditable(false);
                    ((ModifiableFeature)((Object)featureServiceFeature)).restore();
                    this.model.addFeature(featureServiceFeature);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot restore feature", (Throwable)e);
                }
            }
            this.allFeaturesToDelete.clear();
            this.model.setEditable(false);
            AttributeTableFactory.getInstance().processingModeChanged(this.featureService, this.tbProcessing.isSelected());
            this.rejectedNewFeatures.clear();
            if (CismapBroker.getInstance().getMappingComponent() != null) {
                CismapBroker.getInstance().getMappingComponent().refresh();
            }
            if (this.featureService != null) {
                this.featureService.retrieve(true);
            }
        }
        this.butUndo.setEnabled(this.isUndoButtonEnabled());
        return true;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.selectionListener.add(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.selectionListener.remove(listener);
    }

    public void removeFeature(FeatureServiceFeature f) {
        if (f instanceof ModifiableFeature) {
            try {
                f.setEditable(false);
                ((ModifiableFeature)((Object)f)).delete();
                this.model.removeFeatureServiceFeature(f);
                this.modifiedFeatures.remove((DefaultFeatureServiceFeature)f);
                this.allFeaturesToDelete.add(f);
                this.featureDeleted = true;
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot remove feature", (Throwable)e);
            }
        }
    }

    public void removeFeatureFromModel(DefaultFeatureServiceFeature f) {
        this.model.removeFeatureServiceFeature(f);
        this.newFeatures.remove(f);
        this.modifiedFeatures.remove(f);
        this.allFeaturesToDelete.remove(f);
        if (f.isEditable()) {
            f.setEditable(false);
        }
    }

    public List<FeatureServiceFeature> getSelectedFeatures() {
        int[] selectedFeatureRows = this.table.getSelectedRows();
        ArrayList<FeatureServiceFeature> features = new ArrayList<FeatureServiceFeature>(selectedFeatureRows.length);
        for (int i = 0; i < selectedFeatureRows.length; ++i) {
            features.add(this.model.getFeatureServiceFeature(this.table.convertRowIndexToModel(selectedFeatureRows[i])));
        }
        return features;
    }

    public int getSelectedFeatureCount() {
        return this.table.getSelectedRows().length;
    }

    private List<String[]> getAliasAttributeList(boolean withGeometryColumn) {
        FeatureServiceAttribute attr;
        ArrayList<String[]> attrNames = new ArrayList<String[]>();
        Map<String, FeatureServiceAttribute> attributeMap = this.featureService.getFeatureServiceAttributes();
        boolean addGeomField = true;
        for (int i = 0; i < this.table.getColumnCount(false); ++i) {
            int modelCol = this.table.convertColumnIndexToModel(i);
            if (!withGeometryColumn) {
                attr = attributeMap.get(this.model.getColumnAttributeName(modelCol));
                if (attr != null && attr.isGeometry()) {
                    continue;
                }
            } else {
                attr = attributeMap.get(this.model.getColumnAttributeName(modelCol));
                if (attr != null && attr.isGeometry()) {
                    addGeomField = false;
                }
            }
            String[] aliasAttr = new String[]{this.model.getColumnName(modelCol), this.model.getColumnAttributeName(modelCol)};
            attrNames.add(aliasAttr);
        }
        if (withGeometryColumn && addGeomField) {
            for (String name : attributeMap.keySet()) {
                attr = attributeMap.get(name);
                if (attr == null || !attr.isGeometry()) continue;
                String[] aliasAttr = new String[]{name, name};
                attrNames.add(aliasAttr);
                break;
            }
        }
        return attrNames;
    }

    private String trimNumberString(String val) {
        String res = String.valueOf(val);
        if (res.indexOf(".") != -1) {
            char c;
            for (int i = res.length() - 1; i > 0 && ((c = res.charAt(i)) == '0' || c == '.'); --i) {
                res = res.substring(0, i);
                if (c == '.') break;
            }
        }
        return res.replace('.', ',');
    }

    private String round(double value, int digits) {
        if (Double.compare(value, Double.NaN) == 0) {
            return "";
        }
        BigDecimal tmpValue = new BigDecimal(value);
        return tmpValue.setScale(digits, RoundingMode.HALF_UP).toPlainString();
    }

    private void setTableSize() {
        TableColumnModel columnModel = this.table.getColumnModel();
        FontMetrics fmetrics = this.table.getFontMetrics(this.table.getFont());
        TableModel model = this.table.getModel();
        int columnCount = model.getColumnCount();
        int totalSize = 0;
        for (int i = 0; i < columnCount; ++i) {
            int size = (int)fmetrics.getStringBounds(model.getColumnName(i), this.table.getGraphics()).getWidth();
            for (int row = 0; row < model.getRowCount() && row < 50; ++row) {
                int tmpSize = (int)fmetrics.getStringBounds(String.valueOf(model.getValueAt(row, i)), this.table.getGraphics()).getWidth();
                if (tmpSize > size && tmpSize < 200) {
                    size = tmpSize;
                    continue;
                }
                if (tmpSize <= size || tmpSize < 200) continue;
                size = 200;
            }
            totalSize += size;
            columnModel.getColumn(i).setPreferredWidth(size + 30);
        }
        this.table.setMinimumSize(new Dimension(totalSize + 20, 50));
        this.butColWidth.setEnabled(false);
    }

    public void setItemCount(int count) {
        this.itemCount = count;
        int pageCount = this.itemCount / this.pageSize;
        if (pageCount * this.pageSize < this.itemCount) {
            ++pageCount;
        }
        if (this.pageSize == -1) {
            pageCount = 1;
        }
        this.lblTotalPages.setText(" / " + pageCount);
    }

    public MappingComponent getMappingComponent() {
        return this.mappingComponent;
    }

    public void setMappingComponent(MappingComponent mappingComponent) {
        this.mappingComponent = mappingComponent;
        if (this.model != null) {
            this.applySelection();
        }
    }

    private void applySelection() {
        this.applySelection(null, null, false);
    }

    public void applySelection(Object origin, List<Feature> selectedFeatures, boolean removeOldSelection) {
        this.selectionChangeFromMap = true;
        this.selectionEventSource = origin;
        if (selectedFeatures == null) {
            selectedFeatures = SelectionManager.getInstance().getSelectedFeatures(this.featureService);
        }
        if (removeOldSelection) {
            this.table.getSelectionModel().clearSelection();
        }
        if (this.model != null) {
            int[] selectedRows;
            for (int i : selectedRows = this.table.getSelectedRows()) {
                FeatureServiceFeature f = this.model.getFeatureServiceFeature(this.table.convertRowIndexToModel(i));
                if (selectedFeatures.contains(f)) continue;
                selectedFeatures.add(f);
            }
        }
        if (selectedFeatures != null) {
            this.setSelection(selectedFeatures);
        }
        this.selectionEventSource = null;
        this.selectionChangeFromMap = false;
    }

    public FeatureServiceFeature getFeatureByRow(int row) {
        this.model.getFeatureServiceFeature(this.table.convertRowIndexToModel(row));
        return this.model.getFeatureServiceFeature(this.table.convertRowIndexToModel(row));
    }

    public int getFeatureCount() {
        return this.model.getRowCount();
    }

    public FeatureServiceFeature getFeatureById(int id) {
        if (this.model == null) {
            return null;
        }
        return this.model.getFeatureServiceFeatureById(id);
    }

    public String getColumnName(int col) {
        return this.model.getColumnAttributeName(col);
    }

    public void unlockAll() {
        boolean allLocksRemoved = true;
        for (FeatureServiceFeature f : this.lockingObjects.keySet()) {
            try {
                Object tmp = this.lockingObjects.get(f);
                if (tmp == null) continue;
                this.locker.unlock(tmp);
            }
            catch (Exception e) {
                LOG.error((Object)"Locking object can't be removed.", (Throwable)e);
                allLocksRemoved = false;
            }
        }
        if (!allLocksRemoved) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.CustomTableModel.setEditable.message"), NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.CustomTableModel.setEditable.title"), 0);
        }
        this.lockingObjects.clear();
        this.lockedFeatures.clear();
        this.modifiedFeatures.clear();
        this.allFeaturesToDelete.clear();
        this.newFeatures.clear();
        this.butUndo.setEnabled(this.isUndoButtonEnabled());
    }

    public TreeSet<DefaultFeatureServiceFeature> getRejectedNewFeatures() {
        return this.rejectedNewFeatures;
    }

    static /* synthetic */ int[] access$1802(AttributeTable x0, int[] x1) {
        x0.lastRows = x1;
        return x1;
    }

    static /* synthetic */ FeatureLockingInterface access$7900(AttributeTable x0) {
        return x0.locker;
    }

    static /* synthetic */ Map access$8000(AttributeTable x0) {
        return x0.lockingObjects;
    }

    static {
        instances = new ArrayList<AttributeTable>();
    }

    private static class FeatureWithIndex
    implements Comparable<FeatureWithIndex> {
        private FeatureServiceFeature feature;
        private int index;

        public FeatureWithIndex(FeatureServiceFeature feature, int index) {
            this.feature = feature;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public FeatureServiceFeature getFeature() {
            return this.feature;
        }

        @Override
        public int compareTo(FeatureWithIndex o) {
            return Integer.compare(this.getIndex(), o.getIndex());
        }
    }

    private class TxtSaveContributor
    extends ExportSaveContributor {
        private TxtSaveContributor() {
        }

        @Override
        public ExportDownload getExportDownload() {
            return new ExportTxtDownload();
        }

        public String getDescription() {
            return "TXT (*.txt)";
        }

        public boolean accept(File f) {
            return f != null && f.getAbsolutePath().toLowerCase().endsWith(".txt");
        }
    }

    private class DbfSaveContributor
    extends ExportSaveContributor {
        private DbfSaveContributor() {
        }

        @Override
        public ExportDownload getExportDownload() {
            return new ExportDbfDownload();
        }

        public String getDescription() {
            return "DBF (*.dbf)";
        }

        public boolean accept(File f) {
            return f != null && f.getAbsolutePath().toLowerCase().endsWith(".dbf");
        }
    }

    private class CsvSaveContributor
    extends ExportSaveContributor {
        private CsvSaveContributor() {
        }

        @Override
        public ExportDownload getExportDownload() {
            return new ExportCsvDownload();
        }

        public String getDescription() {
            return "CSV (*.csv)";
        }

        public boolean accept(File f) {
            return f != null && f.getAbsolutePath().toLowerCase().endsWith(".csv");
        }
    }

    private class ContributorWrapper
    extends JRSaveContributor {
        private final JRSaveContributor contributor;
        private final String description;

        public ContributorWrapper(JRSaveContributor contributor, String description) {
            this.contributor = contributor;
            this.description = description;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContributorWrapper) {
                return this.contributor.equals(((ContributorWrapper)((Object)obj)).contributor);
            }
            return this.contributor.equals(obj);
        }

        public void save(JasperPrint jp, File file) throws JRException {
            this.contributor.save(jp, file);
        }

        public String getDescription() {
            return this.description;
        }

        public boolean accept(File f) {
            return this.contributor.accept(f);
        }
    }

    private class ShpSaveContributor
    extends ExportSaveContributor {
        private ShpSaveContributor() {
        }

        @Override
        public ExportDownload getExportDownload() {
            return new ExportShapeDownload();
        }

        public String getDescription() {
            return "Shape (*.shp)";
        }

        public boolean accept(File f) {
            return f != null && f.getAbsolutePath().toLowerCase().endsWith(".shp");
        }
    }

    private abstract class ExportSaveContributor
    extends JRSaveContributor {
        protected boolean withGeometries;

        private ExportSaveContributor() {
        }

        public abstract ExportDownload getExportDownload();

        public void save(JasperPrint jp, File file) throws JRException {
            AttributeTable.this.startExport(this.getExportDownload(), file);
        }
    }

    private class CustomJrViewer
    extends JRViewer {
        public CustomJrViewer(JasperPrint jrPrint) {
            super(jrPrint);
            this.btnReload.setVisible(false);
            this.btnSave.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butExport.toolTipText"));
            this.btnSave.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-export.png")));
            this.btnSave.setToolTipText(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butExport.toolTipText"));
            this.btnPrint.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-print.png")));
        }

        protected void loadReport(JasperPrint jrPrint) {
            super.loadReport(jrPrint);
            this.btnReload.setVisible(false);
        }
    }

    private class CustomRowSorter
    extends RowSorter<CustomTableModel> {
        private static final int MAX_SORT_KEYS = 3;
        private CustomTableModel tableModel;
        private List<RowSorter.SortKey> sortKeys = Collections.emptyList();

        public CustomRowSorter(CustomTableModel model) {
        }

        @Override
        public CustomTableModel getModel() {
            return AttributeTable.this.model;
        }

        @Override
        public void toggleSortOrder(int column) {
            this.checkColumn(column);
            if (this.isSortable(column)) {
                int sortIndex;
                List<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
                for (sortIndex = keys.size() - 1; sortIndex >= 0 && ((RowSorter.SortKey)keys.get(sortIndex)).getColumn() != column; --sortIndex) {
                }
                if (sortIndex == -1) {
                    RowSorter.SortKey sortKey = new RowSorter.SortKey(column, SortOrder.ASCENDING);
                    keys.add(0, sortKey);
                } else if (sortIndex == 0) {
                    keys.set(0, this.toggle((RowSorter.SortKey)keys.get(0)));
                } else {
                    keys.remove(sortIndex);
                    keys.add(0, new RowSorter.SortKey(column, SortOrder.ASCENDING));
                }
                if (keys.size() > 3) {
                    keys = keys.subList(0, 3);
                }
                this.setSortKeys(keys);
            }
        }

        private void checkColumn(int column) {
            if (column < 0 || column >= AttributeTable.this.model.getColumnCount()) {
                throw new IndexOutOfBoundsException("column beyond range of TableModel");
            }
        }

        private RowSorter.SortKey toggle(RowSorter.SortKey key) {
            if (key.getSortOrder() == SortOrder.ASCENDING) {
                return new RowSorter.SortKey(key.getColumn(), SortOrder.DESCENDING);
            }
            return new RowSorter.SortKey(key.getColumn(), SortOrder.ASCENDING);
        }

        private boolean isSortable(int column) {
            return true;
        }

        @Override
        public int convertRowIndexToModel(int index) {
            return index;
        }

        @Override
        public int convertRowIndexToView(int index) {
            return index;
        }

        @Override
        public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
            List<RowSorter.SortKey> old = this.sortKeys;
            if (sortKeys != null && sortKeys.size() > 0) {
                int max = AttributeTable.this.model != null ? AttributeTable.this.model.getColumnCount() : 0;
                for (RowSorter.SortKey sortKey : sortKeys) {
                    if (sortKey != null && sortKey.getColumn() >= 0 && sortKey.getColumn() < max) continue;
                    throw new IllegalArgumentException("Invalid SortKey");
                }
                this.sortKeys = Collections.unmodifiableList(new ArrayList<RowSorter.SortKey>(sortKeys));
            } else {
                this.sortKeys = Collections.emptyList();
            }
            if (!this.sortKeys.equals(old)) {
                this.fireSortOrderChanged();
                AttributeTable.this.loadModel(AttributeTable.this.currentPage);
            }
        }

        @Override
        public List<? extends RowSorter.SortKey> getSortKeys() {
            return this.sortKeys;
        }

        @Override
        public int getViewRowCount() {
            if (AttributeTable.this.model != null) {
                return AttributeTable.this.model.getRowCount();
            }
            return 0;
        }

        @Override
        public int getModelRowCount() {
            if (AttributeTable.this.model != null) {
                return AttributeTable.this.model.getRowCount();
            }
            return 0;
        }

        @Override
        public void modelStructureChanged() {
        }

        @Override
        public void allRowsChanged() {
        }

        @Override
        public void rowsInserted(int firstRow, int endRow) {
        }

        @Override
        public void rowsDeleted(int firstRow, int endRow) {
        }

        @Override
        public void rowsUpdated(int firstRow, int endRow) {
        }

        @Override
        public void rowsUpdated(int firstRow, int endRow, int column) {
        }
    }

    private static class TableDataSource
    implements JRDataSource {
        private int index = -1;
        private TableModel model;
        private JTable table;
        private int[] selectedRows = null;

        public TableDataSource(JTable table) {
            this.model = table.getModel();
            this.table = table;
        }

        public TableDataSource(JTable table, int[] selectedRows) {
            this.model = table.getModel();
            this.table = table;
            this.selectedRows = selectedRows;
        }

        public boolean next() throws JRException {
            boolean ret;
            if (this.selectedRows == null) {
                boolean ret2;
                boolean bl = ret2 = ++this.index < this.model.getRowCount();
                if (!ret2) {
                    this.index = -1;
                }
                return ret2;
            }
            boolean bl = ret = ++this.index < this.selectedRows.length;
            if (!ret) {
                this.index = -1;
            }
            return ret;
        }

        public Object getFieldValue(JRField jrField) throws JRException {
            int col = 0;
            try {
                col = Integer.parseInt(jrField.getName());
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Cannot parse column name", (Throwable)e);
            }
            Object result = this.selectedRows == null ? this.model.getValueAt(this.table.convertRowIndexToModel(this.index), col) : this.model.getValueAt(this.table.convertRowIndexToModel(this.selectedRows[this.index]), col);
            if (result != null) {
                if (result instanceof Float || result instanceof Double) {
                    return FeatureTools.FORMATTER.format(result);
                }
                return String.valueOf(result);
            }
            return null;
        }
    }

    private class NumberCellRenderer
    extends AttributeTableCellRenderer {
        private DecimalFormat format;

        public NumberCellRenderer() {
            this.format = new DecimalFormat();
            this.format.setGroupingUsed(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Number) {
                value = this.format.format(value);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class AttributeTableCellRenderer
    extends DefaultTableCellRenderer {
        private AttributeTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color backgroundColor;
            Object formattedValue = value;
            if (value instanceof java.sql.Date) {
                long dateInMillis = ((java.sql.Date)value).getTime();
                formattedValue = DateFormat.getDateInstance().format(new Date(dateInMillis));
            }
            Component c = super.getTableCellRendererComponent(table, formattedValue, isSelected, hasFocus, row, column);
            FeatureServiceFeature feature = AttributeTable.this.model.getFeatureServiceFeature(table.convertRowIndexToModel(row));
            if (feature.isEditable() && feature.getClass().getName().endsWith("CidsLayerFeature")) {
                try {
                    Method m = feature.getClass().getMethod("getBackgroundColor", new Class[0]);
                    Color backgroundColor2 = (Color)m.invoke((Object)feature, new Object[0]);
                    if (backgroundColor2 != null) {
                        c.setBackground(backgroundColor2);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot determine the background color.", (Throwable)e);
                }
            } else if (feature.isEditable() && feature instanceof JDBCFeature && (backgroundColor = ((JDBCFeature)feature).getBackgroundColor()) != null) {
                c.setBackground(backgroundColor);
            }
            if (AttributeTable.this.tbProcessing.isSelected() && AttributeTable.this.tableRuleSet != null && !AttributeTable.this.tableRuleSet.isColumnEditable(AttributeTable.this.model.getColumnAttributeName(table.convertColumnIndexToModel(column)))) {
                JLabel lab = new JLabel(((JLabel)c).getText(), ((JLabel)c).getIcon(), ((JLabel)c).getHorizontalAlignment());
                lab.setBackground(((JLabel)c).getBackground());
                lab.setForeground(new Color(96, 96, 96));
                lab.setOpaque(true);
                return lab;
            }
            return c;
        }
    }

    private class CustomColorHighlighter
    extends ColorHighlighter {
        public CustomColorHighlighter(HighlightPredicate predicate, Color cellBackground, Color cellForeground) {
            super(predicate, cellBackground, cellForeground);
        }

        protected void applyForeground(Component renderer, ComponentAdapter adapter) {
            super.applyForeground(renderer, adapter);
            if (AttributeTable.this.tbProcessing.isSelected()) {
                if (AttributeTable.this.tableRuleSet != null && !AttributeTable.this.tableRuleSet.isColumnEditable(AttributeTable.this.model.getColumnAttributeName(AttributeTable.this.table.convertColumnIndexToModel(adapter.column)))) {
                    renderer.setForeground(new Color(96, 96, 96));
                } else {
                    renderer.setForeground(Color.BLACK);
                }
                FeatureServiceFeature f = AttributeTable.this.model.getFeatureServiceFeature(AttributeTable.this.table.convertRowIndexToModel(adapter.row));
                if (f instanceof PermissionProvider && !((PermissionProvider)((Object)f)).hasWritePermissions()) {
                    renderer.setForeground(new Color(96, 96, 96));
                }
            } else {
                renderer.setForeground(Color.BLACK);
            }
        }

        protected void applyBackground(Component renderer, ComponentAdapter adapter) {
            block8: {
                Color backgroundColor;
                super.applyBackground(renderer, adapter);
                FeatureServiceFeature feature = AttributeTable.this.model.getFeatureServiceFeature(AttributeTable.this.table.convertRowIndexToModel(adapter.row));
                if (feature.isEditable() && feature.getClass().getName().endsWith("CidsLayerFeature")) {
                    try {
                        Method m = feature.getClass().getMethod("getBackgroundColor", new Class[0]);
                        Color backgroundColor2 = (Color)m.invoke((Object)feature, new Object[0]);
                        if (backgroundColor2 == null) break block8;
                        if (adapter.isSelected()) {
                            renderer.setBackground(backgroundColor2);
                            break block8;
                        }
                        renderer.setBackground(BasicStyle.lighten(backgroundColor2));
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot determine the background color.", (Throwable)e);
                    }
                } else if (feature.isEditable() && feature instanceof JDBCFeature && (backgroundColor = ((JDBCFeature)feature).getBackgroundColor()) != null) {
                    if (adapter.isSelected()) {
                        renderer.setBackground(backgroundColor);
                    } else {
                        renderer.setBackground(BasicStyle.lighten(backgroundColor));
                    }
                }
            }
        }
    }

    private class CustomTableModel
    extends SimpleAttributeTableModel
    implements PropertyChangeListener {
        protected List<FeatureServiceFeature> selectedFeatures;
        private boolean editable;

        public CustomTableModel(List<String> orderedFeatureServiceAttributes, Map<String, FeatureServiceAttribute> featureServiceAttributes, List<FeatureServiceFeature> propertyContainer, AttributeTableRuleSet tableRuleSet) {
            super(orderedFeatureServiceAttributes, featureServiceAttributes, propertyContainer, tableRuleSet);
            this.editable = false;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public void sortOrder(final String[] columns, final Boolean[] isAscOrder) {
            for (int i = 0; i < AttributeTable.this.model.getColumnCount(); ++i) {
                AttributeTable.this.table.setSortOrder(i, SortOrder.UNSORTED);
            }
            Collections.sort(this.featureList, new Comparator<FeatureServiceFeature>(){

                @Override
                public int compare(FeatureServiceFeature o1, FeatureServiceFeature o2) {
                    for (int i = 0; i < columns.length; ++i) {
                        int result = this.compareObjects(o1.getProperty(columns[i]), o2.getProperty(columns[i]), isAscOrder[i]);
                        if (result == 0) continue;
                        return result;
                    }
                    return 0;
                }

                private int compareObjects(Object o1, Object o2, boolean isAscOrder2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        if (isAscOrder2) {
                            return -1;
                        }
                        return 1;
                    }
                    if (o2 == null) {
                        if (isAscOrder2) {
                            return 1;
                        }
                        return -1;
                    }
                    if (o1 instanceof Comparable && o2 instanceof Comparable) {
                        Comparable c1 = (Comparable)o1;
                        Comparable c2 = (Comparable)o2;
                        if (isAscOrder2) {
                            return c1.compareTo(c2);
                        }
                        return c1.compareTo(c2) * -1;
                    }
                    LOG.error((Object)"Sort table with non comparable types");
                    return 0;
                }
            });
            this.fireContentsChanged();
        }

        public void setEditable(boolean editable) {
            if (this.editable && !editable) {
                for (FeatureServiceFeature fsf : this.featureList) {
                    fsf.setEditable(false);
                }
                AttributeTable.this.unlockAll();
            }
            this.editable = editable;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex < this.attributeAlias.length) {
                if (this.tableRuleSet != null) {
                    return this.editable && this.tableRuleSet.isColumnEditable(this.attributeNames[columnIndex]) && this.getFeatureServiceFeature(rowIndex).isEditable();
                }
                return this.editable && this.getFeatureServiceFeature(rowIndex).isEditable();
            }
            return false;
        }

        public List<String> getAllColumnNames() {
            return Arrays.asList(this.attributeAlias);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Object newObject;
            FeatureServiceFeature feature = (FeatureServiceFeature)this.featureList.get(rowIndex);
            String attrName = this.attributeNames[columnIndex];
            Object object = newObject = aValue != null && aValue.equals("") ? null : aValue;
            if (this.tableRuleSet != null) {
                newObject = this.tableRuleSet.afterEdit(feature, attrName, rowIndex, feature.getProperty(attrName), newObject);
            }
            feature.setProperty(attrName, newObject);
            AttributeTable.this.modifiedFeatures.add((DefaultFeatureServiceFeature)feature);
            AttributeTable.this.butUndo.setEnabled(AttributeTable.this.isUndoButtonEnabled());
            AttributeTable.this.table.repaint();
        }

        @Override
        protected void fireContentsChanged(TableModelEvent e) {
            for (TableModelListener tmp : this.listener) {
                tmp.tableChanged(e);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int eCol = AttributeTable.this.table.getEditingColumn();
            int eRow = AttributeTable.this.table.getEditingRow();
            if (eRow != -1 && eCol != -1) {
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    if (i == eCol) continue;
                    TableModelEvent e = new TableModelEvent(this, eRow, eRow, i);
                    AttributeTable.this.selectionChangeFromMap = true;
                    this.fireContentsChanged(e);
                    AttributeTable.this.selectionChangeFromMap = false;
                }
            } else {
                AttributeTable.this.table.repaint();
            }
        }
    }
}

