/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.attributetable;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.SubReportBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.swing.JRViewer;
import org.openide.util.NbBundle;

public class AttributeTableReportBuilder {
    public static final String DATASOURCE_NAME = "table_data";
    private static final int PAGE_WIDTH = 560;
    private final Style titleStyle = new Style("HeaderStyle");
    private final Style columnHeaderStyle = new Style("TableHeaderStyle");
    private final Style columnDetailStyle = new Style("DetailStyle");
    private final Style oddRowStyle = new Style();

    public AttributeTableReportBuilder() {
        this.oddRowStyle.setBorder(Border.NO_BORDER());
        Color lightGrey = new Color(230, 230, 230);
        this.oddRowStyle.setBackgroundColor(lightGrey);
        this.oddRowStyle.setTransparency(Transparency.OPAQUE);
        this.columnHeaderStyle.setBorderBottom(Border.PEN_2_POINT());
        this.columnHeaderStyle.setBorderColor(Color.BLACK);
        this.columnHeaderStyle.setPaddingBottom(Integer.valueOf(2));
        this.columnDetailStyle.setTransparency(Transparency.OPAQUE);
    }

    public DynamicReport buildReport(String title, JTable table) throws Exception {
        int col;
        DynamicReportBuilder drb = new DynamicReportBuilder();
        int totalWidth = 0;
        int lastCol = 0;
        boolean firstPart = true;
        drb.setTitle(title).setUseFullPageWidth(true).setTemplateFile("de/cismet/cismap/commons/gui/attributetable/AttributeTableTemplate.jrxml").setPrintBackgroundOnOddRows(true).setOddRowBackgroundStyle(this.oddRowStyle).setDefaultStyles(this.titleStyle, this.titleStyle, this.columnHeaderStyle, this.columnDetailStyle);
        for (col = 0; col < table.getColumnCount(); ++col) {
            int width = table.getColumn(table.getColumnName(col)).getWidth();
            if ((totalWidth += width) <= 560) continue;
            Subreport subreport = new SubReportBuilder().setStartInNewPage(!firstPart).setDataSource(0, 10, DATASOURCE_NAME).setDynamicReport(this.createSubreport(table, lastCol, col), (LayoutManager)new ClassicLayoutManager()).build();
            drb.addConcatenatedReport(subreport);
            firstPart = false;
            lastCol = col;
            totalWidth = width;
        }
        Subreport subreport = new SubReportBuilder().setStartInNewPage(!firstPart).setDataSource(0, 10, DATASOURCE_NAME).setDynamicReport(this.createSubreport(table, lastCol, col), (LayoutManager)new ClassicLayoutManager()).build();
        drb.addConcatenatedReport(subreport);
        return drb.build();
    }

    private DynamicReport createSubreport(JTable table, int fromCol, int untilCol) throws Exception {
        TableModel model = table.getModel();
        DynamicReportBuilder drb = new DynamicReportBuilder();
        AbstractColumn[] abstractColumns = new AbstractColumn[model.getColumnCount()];
        for (int col = fromCol; col < untilCol; ++col) {
            int width = table.getColumn(table.getColumnName(col)).getWidth();
            int modelCol = table.convertColumnIndexToModel(col);
            abstractColumns[col] = ColumnBuilder.getNew().setColumnProperty(String.valueOf(modelCol), String.class.getName()).setTitle(model.getColumnName(modelCol)).setWidth(width).build();
            drb.addColumn(abstractColumns[col]);
        }
        drb.setMargins(20, 20, 20, 20).setDefaultStyles(this.titleStyle, this.titleStyle, this.columnHeaderStyle, this.columnDetailStyle).setPrintBackgroundOnOddRows(true).setOddRowBackgroundStyle(this.oddRowStyle);
        return drb.build();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(500, 500);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
        try {
            TableDataSource ds = new TableDataSource(new CustomTableModel());
            HashMap<String, TableDataSource> map = new HashMap<String, TableDataSource>();
            map.put(DATASOURCE_NAME, ds);
            DynamicReport report = new AttributeTableReportBuilder().buildReport("Titel", new JTable(new CustomTableModel()));
            JasperReport jasperReport = DynamicJasperHelper.generateJasperReport((DynamicReport)report, (LayoutManager)new ClassicLayoutManager(), map);
            for (Object key : map.keySet()) {
                Object o = map.get(key);
                if (!(o instanceof JasperReport)) continue;
                JasperReport jr = (JasperReport)o;
                DynamicJasperHelper.generateJRXML((JasperReport)jr, (String)"UTF-8", (String)(System.getProperty("user.dir") + "/target/reports/" + key + ".jrxml"));
            }
            DynamicJasperHelper.generateJRXML((JasperReport)jasperReport, (String)"UTF-8", (String)(System.getProperty("user.dir") + "/target/reports/table_report.jrxml"));
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)ds);
            JRViewer aViewer = new JRViewer(jasperPrint);
            JFrame aFrame = new JFrame(NbBundle.getMessage(AttributeTable.class, (String)"AttributeTable.butPrintPreviewActionPerformed.aFrame.title"));
            aFrame.getContentPane().add((Component)aViewer);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            aFrame.setSize(screenSize.width / 2, screenSize.height / 2);
            Insets insets = aFrame.getInsets();
            aFrame.setSize(aFrame.getWidth() + insets.left + insets.right, aFrame.getHeight() + insets.top + insets.bottom + 20);
            aFrame.setLocationRelativeTo(frame);
            aFrame.setVisible(true);
        }
        catch (Exception e) {
            System.out.println("Error");
            e.printStackTrace();
        }
    }

    private static class CustomTableModel
    implements TableModel {
        String[] cols = new String[]{"ab", "cd", "ef", "gh"};
        String[][] attr = new String[][]{{"a", "b", "c", "d"}, {"a1", "b1", "c1", "d1"}, {"a2", "b2", "c2", "d2"}, {"a3", "b3", "c3", "d3"}, {"a4", "4b", "c4", "4d"}};

        private CustomTableModel() {
        }

        @Override
        public int getRowCount() {
            return 5;
        }

        @Override
        public int getColumnCount() {
            return this.cols.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.cols[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.attr[rowIndex][columnIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }

    private static class TableDataSource
    implements JRDataSource {
        private int index = -1;
        private TableModel model;

        public TableDataSource(TableModel model) {
            this.model = model;
        }

        public boolean next() throws JRException {
            boolean ret;
            boolean bl = ret = ++this.index < this.model.getRowCount();
            if (!ret) {
                this.index = -1;
            }
            return ret;
        }

        public Object getFieldValue(JRField jrField) throws JRException {
            int col = 0;
            try {
                col = Integer.parseInt(jrField.getName());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            Object result = this.model.getValueAt(this.index, col);
            if (result != null) {
                return String.valueOf(result);
            }
            return null;
        }
    }
}

