/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.attributetable;

import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.attributetable.FeatureLockingInterface;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.Lookup;

public class FeatureLockerFactory {
    private final Map<Class, FeatureLockingInterface> locker = new HashMap<Class, FeatureLockingInterface>();

    private FeatureLockerFactory() {
        Collection lockerList = Lookup.getDefault().lookupAll(FeatureLockingInterface.class);
        for (FeatureLockingInterface tmp : lockerList) {
            Class[] c;
            for (Class featureServiceClass : c = tmp.getSupportedFeatureServiceClasses()) {
                this.locker.put(featureServiceClass, tmp);
            }
        }
    }

    public static FeatureLockerFactory getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public FeatureLockingInterface getLockerForFeatureService(AbstractFeatureService featureService) {
        return this.locker.get(featureService.getClass());
    }

    private static final class LazyInitialiser {
        static final FeatureLockerFactory INSTANCE = new FeatureLockerFactory();

        private LazyInitialiser() {
        }
    }
}

