/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.featureinfowidget;

import de.cismet.cismap.commons.LayerInfoProvider;
import de.cismet.cismap.commons.gui.featureinfowidget.FeatureInfoDisplay;
import de.cismet.cismap.commons.gui.featureinfowidget.FeatureInfoDisplayKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openide.util.Lookup;

public final class FeatureInfoDisplayRepository {
    private static final transient Logger LOG = Logger.getLogger(FeatureInfoDisplayRepository.class);
    private final transient Map<FeatureInfoDisplayKey, FeatureInfoDisplay> repo;

    public FeatureInfoDisplayRepository() {
        Lookup.Result result = Lookup.getDefault().lookupResult(FeatureInfoDisplay.class);
        Collection instances = result.allInstances();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("found " + instances.size() + " instances of FeatureInfoDisplay"));
        }
        HashMap<FeatureInfoDisplayKey, FeatureInfoDisplay> map = new HashMap<FeatureInfoDisplayKey, FeatureInfoDisplay>(instances.size());
        for (FeatureInfoDisplay display : instances) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("found entry: " + display.getDisplayKey() + " -> " + display.getClass()));
            }
            map.put(display.getDisplayKey(), display);
        }
        this.repo = Collections.unmodifiableMap(map);
    }

    public FeatureInfoDisplay getDisplay(Class layerclass, LayerInfoProvider layerinfo) {
        String layer;
        String server = layerinfo.getServerURI();
        FeatureInfoDisplay display = this.repo.get(new FeatureInfoDisplayKey(layerclass, server, layer = layerinfo.getLayerURI()));
        if (display == null && (display = this.repo.get(new FeatureInfoDisplayKey(layerclass, server, FeatureInfoDisplayKey.ANY_SERVER))) == null && (display = this.repo.get(new FeatureInfoDisplayKey(layerclass, FeatureInfoDisplayKey.ANY_SERVER, FeatureInfoDisplayKey.ANY_SERVER))) == null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("did not find any registered repo: layerclass: " + layerclass + " || layerinfo: " + layerinfo));
        }
        try {
            return (FeatureInfoDisplay)display.getClass().newInstance();
        }
        catch (Exception ex) {
            LOG.error((Object)("Cannot instantiate the required display class: " + display.getClass().getName() + ". The origin object will be used."), (Throwable)ex);
            return display;
        }
    }
}

