/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.featureinfowidget;

import de.cismet.cismap.commons.ChildrenProvider;
import de.cismet.cismap.commons.LayerInfoProvider;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.featureinfowidget.AggregateableFeatureInfoDisplay;
import de.cismet.cismap.commons.gui.featureinfowidget.FeatureInfoDisplay;
import de.cismet.cismap.commons.gui.featureinfowidget.FeatureInfoDisplayRepository;
import de.cismet.cismap.commons.gui.featureinfowidget.MultipleFeatureInfoRequestsDisplay;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.GetFeatureInfoClickDetectionListener;
import de.cismet.cismap.commons.interaction.ActiveLayerListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.MapClickListener;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.interaction.events.MapClickedEvent;
import de.cismet.cismap.commons.raster.wms.SlidableWMSServiceLayerGroup;
import de.cismet.cismap.commons.raster.wms.WMSLayer;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.gui.GUIWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class FeatureInfoWidget
extends JPanel
implements ActiveLayerListener,
MapClickListener,
GUIWindow {
    private static final transient Logger LOG = Logger.getLogger(FeatureInfoWidget.class);
    private final transient Map<Object, FeatureInfoDisplay> displays = new HashMap<Object, FeatureInfoDisplay>();
    private final transient FeatureInfoDisplayRepository displayRepo = new FeatureInfoDisplayRepository();
    private final transient Map<String, List<AggregateableFeatureInfoDisplay>> aggregatableDisplayMap = new HashMap<String, List<AggregateableFeatureInfoDisplay>>();
    private JButton jButton1;
    private JTabbedPane tbpFeatureInfos;

    public FeatureInfoWidget() {
        this.initComponents();
        this.tbpFeatureInfos.putClientProperty("jgoodies.noContentBorder", Boolean.FALSE);
        this.tbpFeatureInfos.setRequestFocusEnabled(true);
        this.tbpFeatureInfos.setTabLayoutPolicy(1);
        CismapBroker.getInstance().addActiveLayerListener(this);
        CismapBroker.getInstance().addMapClickListener(this);
    }

    @Override
    public void layerVisibilityChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerAvailabilityChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerSelectionChanged(ActiveLayerEvent e) {
        Object o = e.getLayer();
        if (o instanceof WMSLayer && this.displays.get(o) != null) {
            this.tbpFeatureInfos.setSelectedComponent(this.displays.get(o).getDisplayComponent());
        } else if (o instanceof WMSServiceLayer && ((WMSServiceLayer)o).getWMSLayers().size() == 1) {
            FeatureInfoDisplay displ = this.displays.get(((WMSServiceLayer)o).getWMSLayers().get(0));
            if (displ != null) {
                this.tbpFeatureInfos.setSelectedComponent(displ.getDisplayComponent());
            }
        } else if (o instanceof SlidableWMSServiceLayerGroup && this.displays.get(o) != null) {
            this.tbpFeatureInfos.setSelectedComponent(this.displays.get(o).getDisplayComponent());
        }
    }

    @Override
    public void layerRemoved(ActiveLayerEvent e) {
        this.handleInformationStatusChanged(e, true);
    }

    @Override
    public void layerPositionChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerInformationStatusChanged(ActiveLayerEvent e) {
        this.handleInformationStatusChanged(e, false);
    }

    @Override
    public void layerAdded(ActiveLayerEvent e) {
        this.handleInformationStatusChanged(e, false);
    }

    private void handleInformationStatusChanged(ActiveLayerEvent e, boolean remove) {
        block13: {
            FeatureInfoDisplay display;
            LayerInfoProvider layer;
            block14: {
                Object o;
                block12: {
                    o = e.getLayer();
                    if (!(o instanceof ChildrenProvider)) break block12;
                    Collection c = ((ChildrenProvider)o).getChildren();
                    for (Object childlayer : c) {
                        ActiveLayerEvent ale = new ActiveLayerEvent();
                        ale.setLayer(childlayer);
                        this.handleInformationStatusChanged(ale, remove);
                    }
                    break block13;
                }
                if (!(o instanceof LayerInfoProvider) || !((LayerInfoProvider)o).isQueryable()) break block13;
                layer = (LayerInfoProvider)o;
                display = this.displays.get(layer);
                if (display == null || layer.isLayerQuerySelected() && !remove) break block14;
                FeatureInfoDisplay d = this.displays.get(layer);
                if (d instanceof AggregateableFeatureInfoDisplay) {
                    AggregateableFeatureInfoDisplay aggrDisplay = (AggregateableFeatureInfoDisplay)((Object)d);
                    String aggregateType = aggrDisplay.getAggregateTypeID();
                    this.aggregatableDisplayMap.get(aggregateType).remove(aggrDisplay);
                    for (AggregateableFeatureInfoDisplay displ : this.aggregatableDisplayMap.get(aggregateType)) {
                        displ.setAggregatableDisplayList(this.aggregatableDisplayMap.get(aggregateType));
                    }
                }
                try {
                    this.tbpFeatureInfos.remove(display.getDisplayComponent());
                    this.displays.remove(layer);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"Workaround for style changes(there is no refresh, but only remove/add)", (Throwable)ex);
                }
                break block13;
            }
            if (display != null || !layer.isLayerQuerySelected() || remove) break block13;
            try {
                MappingComponent mc;
                GetFeatureInfoClickDetectionListener listener;
                display = this.displayRepo.getDisplay(layer.getClass(), layer);
                if (display == null) {
                    throw new IllegalStateException("dispay info for layer is null: " + layer);
                }
                display.init(layer, this.tbpFeatureInfos);
                if (display instanceof AggregateableFeatureInfoDisplay) {
                    String aggregateType = ((AggregateableFeatureInfoDisplay)((Object)display)).getAggregateTypeID();
                    if (!this.aggregatableDisplayMap.containsKey(aggregateType)) {
                        ArrayList displayList = new ArrayList();
                        this.aggregatableDisplayMap.put(aggregateType, displayList);
                    }
                    this.aggregatableDisplayMap.get(aggregateType).add((AggregateableFeatureInfoDisplay)((Object)display));
                    for (AggregateableFeatureInfoDisplay d : this.aggregatableDisplayMap.get(aggregateType)) {
                        d.setAggregatableDisplayList(this.aggregatableDisplayMap.get(aggregateType));
                    }
                }
                if ((listener = (GetFeatureInfoClickDetectionListener)(mc = CismapBroker.getInstance().getMappingComponent()).getInputListener("FEATURE_INFO")) != null && display instanceof MultipleFeatureInfoRequestsDisplay) {
                    ((MultipleFeatureInfoRequestsDisplay)((Object)display)).addHoldListener(listener);
                }
                this.tbpFeatureInfos.add(layer.toString(), display.getDisplayComponent());
                this.displays.put(layer, display);
            }
            catch (Exception exception) {
                LOG.error((Object)"Exception in creating featureInfoDisplay component", (Throwable)exception);
                layer.setLayerQuerySelected(false);
            }
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.tbpFeatureInfos = new JTabbedPane();
        this.jButton1.setText(null);
        this.tbpFeatureInfos.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FeatureInfoWidget.this.tbpFeatureInfosStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.tbpFeatureInfos, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.tbpFeatureInfos, -1, 300, Short.MAX_VALUE));
    }

    private void tbpFeatureInfosStateChanged(ChangeEvent evt) {
        block8: {
            for (FeatureInfoDisplay d : this.displays.values()) {
                if (d == null || !(d instanceof MultipleFeatureInfoRequestsDisplay)) continue;
                MultipleFeatureInfoRequestsDisplay multiRequestDisplay = (MultipleFeatureInfoRequestsDisplay)((Object)d);
                multiRequestDisplay.setDisplayVisble(false);
            }
            Component c = this.tbpFeatureInfos.getSelectedComponent();
            if (c != null && c instanceof MultipleFeatureInfoRequestsDisplay) {
                MultipleFeatureInfoRequestsDisplay multiRequestDisplay = (MultipleFeatureInfoRequestsDisplay)((Object)c);
                MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
                GetFeatureInfoClickDetectionListener listener = (GetFeatureInfoClickDetectionListener)mc.getInputListener("FEATURE_INFO");
                if (listener != null) {
                    multiRequestDisplay.removeHoldListener(listener);
                    multiRequestDisplay.addHoldListener(listener);
                }
                multiRequestDisplay.setDisplayVisble(true);
            } else {
                MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
                GetFeatureInfoClickDetectionListener listener = (GetFeatureInfoClickDetectionListener)mc.getInputListener("FEATURE_INFO");
                listener.addFeatureInfoIconForLastClick();
            }
            for (int i = 0; i < this.tbpFeatureInfos.getTabCount(); ++i) {
                this.tbpFeatureInfos.setForegroundAt(i, null);
            }
            int selectedindex = this.tbpFeatureInfos.getSelectedIndex();
            if (selectedindex >= 0 && this.tbpFeatureInfos.getTabCount() != 0) {
                try {
                    this.tbpFeatureInfos.setForegroundAt(selectedindex, Color.blue);
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug((Object)"Error. Feeling not blue.", (Throwable)ex);
                }
            }
        }
    }

    public Map<Object, FeatureInfoDisplay> getDisplays() {
        return this.displays;
    }

    @Override
    public void clickedOnMap(MapClickedEvent mce) {
        if (mce.getMode().equals("FEATURE_INFO_CLICK")) {
            Set<Object> layers = this.displays.keySet();
            for (Object layer : layers) {
                this.displays.get(layer).showFeatureInfo(mce);
            }
        }
    }

    public JComponent getGuiComponent() {
        return this;
    }

    public String getPermissionString() {
        return "NoPermissionRequired";
    }

    public String getViewTitle() {
        return NbBundle.getMessage(FeatureInfoWidget.class, (String)"FeatureInfoWidget.getViewTitle");
    }

    public Icon getViewIcon() {
        ImageIcon icoMap = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/featureinfowidget/res/featureInfo16.png"));
        return Static2DTools.borderIcon((Icon)icoMap, (int)0, (int)3, (int)0, (int)1);
    }
}

