/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.infowidgets;

import de.cismet.cismap.commons.interaction.ActiveLayerListener;
import de.cismet.cismap.commons.interaction.CapabilityListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.interaction.events.CapabilityEvent;
import de.cismet.cismap.commons.wfs.capabilities.WFSCapabilities;
import de.cismet.commons.capabilities.Service;
import de.cismet.commons.wms.capabilities.WMSCapabilities;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.gui.GUIWindow;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class ServerInfo
extends JPanel
implements CapabilityListener,
ActiveLayerListener,
GUIWindow {
    private JList cboKeywords;
    private JLabel lblContact;
    private JLabel lblContactTitle;
    private JLabel lblFees;
    private JLabel lblFeesTitle;
    private JLabel lblInfo;
    private JLabel lblKeywords;
    private JLabel lblName;
    private JLabel lblOrganisation;
    private JLabel lblRestrictions;
    private JLabel lblRestrictionsTitle;
    private JLabel lblTitle;
    private JPanel panMain;
    private JScrollPane scpKeywords;
    private JScrollPane scpMain;
    private JSeparator sepContact;
    private JSeparator sepFees;
    private JSeparator sepKeywords;
    private JSeparator sepRestrictions;

    public ServerInfo() {
        this.initComponents();
        StaticSwingTools.setNiftyScrollBars((JScrollPane)this.scpMain);
        CismapBroker.getInstance().addCapabilityListener(this);
        CismapBroker.getInstance().addActiveLayerListener(this);
    }

    @Override
    public void serverChanged(CapabilityEvent e) {
        Object serverInfo = e.getCapabilityObject();
        if (serverInfo instanceof WMSCapabilities) {
            this.setValues(((WMSCapabilities)serverInfo).getService());
        } else if (serverInfo instanceof WFSCapabilities) {
            this.setValues(((WFSCapabilities)serverInfo).getService());
        }
    }

    @Override
    public void layerChanged(CapabilityEvent e) {
    }

    private void initComponents() {
        this.scpMain = new JScrollPane();
        this.panMain = new JPanel();
        this.lblTitle = new JLabel();
        this.lblInfo = new JLabel();
        this.lblName = new JLabel();
        this.sepKeywords = new JSeparator();
        this.scpKeywords = new JScrollPane();
        this.cboKeywords = new JList();
        this.lblKeywords = new JLabel();
        this.sepContact = new JSeparator();
        this.lblContactTitle = new JLabel();
        this.lblContact = new JLabel();
        this.lblOrganisation = new JLabel();
        this.sepFees = new JSeparator();
        this.lblFeesTitle = new JLabel();
        this.lblFees = new JLabel();
        this.sepRestrictions = new JSeparator();
        this.lblRestrictionsTitle = new JLabel();
        this.lblRestrictions = new JLabel();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.scpMain.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.lblTitle.setFont(new Font("Tahoma", 1, 14));
        this.lblTitle.setText(null);
        this.lblInfo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/infowidgets/res/info.png")));
        this.lblName.setText(null);
        this.cboKeywords.setBackground(this.panMain.getBackground());
        this.scpKeywords.setViewportView(this.cboKeywords);
        this.lblKeywords.setText(null);
        this.lblContactTitle.setText(null);
        this.lblContact.setText(null);
        this.lblOrganisation.setText(null);
        this.lblFeesTitle.setText(null);
        this.lblFees.setText(null);
        this.lblRestrictionsTitle.setText(null);
        this.lblRestrictions.setText(null);
        GroupLayout panMainLayout = new GroupLayout((Container)this.panMain);
        this.panMain.setLayout((LayoutManager)panMainLayout);
        panMainLayout.setHorizontalGroup((GroupLayout.Group)panMainLayout.createParallelGroup(1).add(2, (GroupLayout.Group)panMainLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panMainLayout.createParallelGroup(2).add(1, (Component)this.sepKeywords, -1, 338, Short.MAX_VALUE).add(1, (Component)this.sepRestrictions, -1, 338, Short.MAX_VALUE).add(1, (Component)this.sepContact, -1, 338, Short.MAX_VALUE).add(1, (Component)this.sepFees, -1, 338, Short.MAX_VALUE).add(1, (GroupLayout.Group)panMainLayout.createSequentialGroup().add((Component)this.lblName).addPreferredGap(0).add((Component)this.lblInfo)).add(1, (GroupLayout.Group)panMainLayout.createSequentialGroup().add((Component)this.lblKeywords).addPreferredGap(0).add((Component)this.scpKeywords, -1, 322, Short.MAX_VALUE).add(12, 12, 12)).add(1, (Component)this.lblTitle).add(1, (Component)this.lblContactTitle).add(1, (Component)this.lblOrganisation).add(1, (Component)this.lblFeesTitle).add(1, (Component)this.lblFees).add(1, (Component)this.lblRestrictionsTitle).add(1, (Component)this.lblRestrictions).add(1, (Component)this.lblContact, -1, 338, Short.MAX_VALUE)).addContainerGap()));
        panMainLayout.setVerticalGroup((GroupLayout.Group)panMainLayout.createParallelGroup(1).add((GroupLayout.Group)panMainLayout.createSequentialGroup().addContainerGap().add((Component)this.lblTitle).addPreferredGap(0).add((GroupLayout.Group)panMainLayout.createParallelGroup(3).add((Component)this.lblName).add((Component)this.lblInfo)).add(18, 18, 18).add((Component)this.sepKeywords, -2, -1, -2).add(8, 8, 8).add((GroupLayout.Group)panMainLayout.createParallelGroup(1).add((Component)this.lblKeywords).add((Component)this.scpKeywords, -2, 44, -2)).add(8, 8, 8).add((Component)this.sepContact, -2, -1, -2).addPreferredGap(0).add((Component)this.lblContactTitle).addPreferredGap(0).add((Component)this.lblContact).addPreferredGap(0).add((Component)this.lblOrganisation).add(12, 12, 12).add((Component)this.sepFees, -2, -1, -2).addPreferredGap(0).add((Component)this.lblFeesTitle).addPreferredGap(0).add((Component)this.lblFees).addPreferredGap(0).add((Component)this.sepRestrictions, -2, 2, -2).addPreferredGap(0).add((Component)this.lblRestrictionsTitle).addPreferredGap(0).add((Component)this.lblRestrictions).addContainerGap(229, Short.MAX_VALUE)));
        this.scpMain.setViewportView(this.panMain);
        this.add((Component)this.scpMain, "Center");
    }

    private void setValues(Service service) {
        Values v = new Values();
        try {
            v.name = service.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v.title = service.getTitle();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v.abstractText = service.getAbstract();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Values.access$302(v, service.getKeywordList());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v.contactName = service.getContactPerson();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v.contactOrganisation = service.getContactOrganization();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v.fees = service.getFees();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v.restrictions = service.getAccessConstraints();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setValues(v);
    }

    private void setValues(Values v) {
        if (v.title.trim().equals("")) {
            this.lblTitle.setText(NbBundle.getMessage(ServerInfo.class, (String)"ServerInfo.lblTitle.text"));
        } else {
            this.lblTitle.setText(v.title.trim());
        }
        this.lblName.setText(v.name.trim());
        if (v.abstractText != null && !v.abstractText.trim().equals("")) {
            this.lblInfo.setToolTipText(v.abstractText.trim());
        } else {
            this.lblInfo.setToolTipText("");
        }
        if (v.keywords != null && v.keywords.length > 0) {
            this.cboKeywords.setModel(new DefaultComboBoxModel<String>(v.keywords));
            this.setKeywordSectionVisible(true);
        } else {
            this.setKeywordSectionVisible(false);
        }
        if (v.contactName != null && v.contactName.trim().length() > 0 || v.contactOrganisation != null && v.contactOrganisation.trim().length() > 0) {
            this.setContactSectionVisible(true);
            if (v.contactName != null && v.contactName.trim().length() > 0) {
                this.lblContact.setText(v.contactName.trim());
            } else {
                this.lblContact.setVisible(false);
            }
            if (v.contactOrganisation != null && v.contactOrganisation.trim().length() > 0) {
                this.lblOrganisation.setText(v.contactOrganisation.trim());
            } else {
                this.lblOrganisation.setVisible(false);
            }
        } else {
            this.setContactSectionVisible(false);
        }
        if (v.fees != null && v.fees.trim().length() > 0) {
            this.setFeesSectionVisible(true);
            this.lblFees.setText(v.fees.trim());
        } else {
            this.setFeesSectionVisible(false);
        }
        if (v.restrictions != null && v.restrictions.trim().length() > 0) {
            this.setRestrictionsSectionVisible(true);
            this.lblRestrictions.setText(v.restrictions.trim());
        } else {
            this.setRestrictionsSectionVisible(false);
        }
    }

    private void setKeywordSectionVisible(boolean visible) {
        this.sepKeywords.setVisible(visible);
        this.lblKeywords.setVisible(visible);
        this.scpKeywords.setVisible(visible);
    }

    private void setContactSectionVisible(boolean visible) {
        this.sepContact.setVisible(visible);
        this.lblContactTitle.setVisible(visible);
        this.lblContact.setVisible(visible);
        this.lblOrganisation.setVisible(visible);
    }

    private void setFeesSectionVisible(boolean visible) {
        this.sepFees.setVisible(visible);
        this.lblFeesTitle.setVisible(visible);
        this.lblFees.setVisible(visible);
    }

    private void setRestrictionsSectionVisible(boolean visible) {
        this.sepRestrictions.setVisible(visible);
        this.lblRestrictionsTitle.setVisible(visible);
        this.lblRestrictions.setVisible(visible);
    }

    @Override
    public void layerVisibilityChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerAvailabilityChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerSelectionChanged(ActiveLayerEvent e) {
        WMSCapabilities serverInfo = e.getCapabilities();
        if (serverInfo instanceof WMSCapabilities) {
            this.setValues(serverInfo.getService());
        } else if (serverInfo instanceof WFSCapabilities) {
            this.setValues(((WFSCapabilities)serverInfo).getService());
        }
    }

    @Override
    public void layerRemoved(ActiveLayerEvent e) {
    }

    @Override
    public void layerPositionChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerInformationStatusChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerAdded(ActiveLayerEvent e) {
    }

    public JComponent getGuiComponent() {
        return this;
    }

    public String getPermissionString() {
        return "NoPermissionRequired";
    }

    public String getViewTitle() {
        return NbBundle.getMessage(ServerInfo.class, (String)"ServerInfo.getViewTitle");
    }

    public Icon getViewIcon() {
        ImageIcon icoMap = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/serverInfo.png"));
        return Static2DTools.borderIcon((Icon)icoMap, (int)0, (int)3, (int)0, (int)1);
    }

    class Values {
        private String title;
        private String name;
        private String abstractText;
        private String fees;
        private String restrictions;
        private String contactName;
        private String contactPosition;
        private String contactOrganisation;
        private String[] keywords;

        Values() {
        }

        static /* synthetic */ String[] access$302(Values x0, String[] x1) {
            x0.keywords = x1;
            return x1;
        }
    }
}

