/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.layerwidget;

import de.cismet.cismap.commons.LayerInfoProvider;
import de.cismet.cismap.commons.ModeLayer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.QueryEditorDialog;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.featureservice.factory.AbstractFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.featureservice.style.BasicStyle;
import de.cismet.cismap.commons.featureservice.style.StyleDialogInterface;
import de.cismet.cismap.commons.featureservice.style.StyleDialogStarter;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerTableCellRenderer;
import de.cismet.cismap.commons.gui.layerwidget.StyleChooserCellRenderer;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.raster.wms.AbstractWMS;
import de.cismet.cismap.commons.raster.wms.WMSLayer;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.retrieval.RetrievalService;
import de.cismet.cismap.commons.util.SLDStyleUtil;
import de.cismet.commons.wms.capabilities.Style;
import de.cismet.tools.gui.StaticSwingTools;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellEditor;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ActiveLayerTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor,
PropertyChangeListener {
    protected static final boolean DEBUG = false;
    private final Logger logger = Logger.getLogger(this.getClass());
    private JCheckBox informationBox;
    private Object value;
    private JTable table;
    private JComboBox cbbStyleChooser;
    private StyleDialogInterface styleDialog;
    private JButton moreButton = new JButton(". .");
    private ImageIcon unselectedStyleIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/disabledStyle.png"));
    private JButton wfsStyleButton = new JButton(){

        @Override
        protected void paintComponent(Graphics g) {
            de.cismet.cismap.commons.featureservice.style.Style style = null;
            AbstractFeatureService service = (AbstractFeatureService)ActiveLayerTableCellEditor.this.value;
            FeatureFactory ff = service.getFeatureFactory();
            BasicStyle basicStyle = null;
            if (ff instanceof AbstractFeatureFactory) {
                AbstractFeatureFactory aff = (AbstractFeatureFactory)ff;
                List<org.deegree.style.se.unevaluated.Style> styleList = aff.getStyle(aff.layerName);
                basicStyle = SLDStyleUtil.getBasicStyleFromSLDStyle(styleList);
            }
            if (basicStyle != null) {
                style = basicStyle;
            } else if (((AbstractFeatureService)ActiveLayerTableCellEditor.this.value).getLayerProperties() != null) {
                style = ((AbstractFeatureService)ActiveLayerTableCellEditor.this.value).getLayerProperties().getStyle();
            }
            try {
                Graphics2D g2d = (Graphics2D)g;
                if (style.isDrawFill() && style.getFillColor() != null) {
                    g2d.setColor(style.getFillColor());
                    g2d.fillRect(10, 4, this.getWidth() - 20, this.getHeight() - 8);
                }
                if (style.isDrawLine() && style.getLineColor() != null) {
                    g2d.setColor(style.getLineColor());
                    float width = new Float(Math.min(3.0f, (float)style.getLineWidth())).intValue();
                    g2d.setStroke(new BasicStroke(width));
                    g2d.drawRect(10, 4, this.getWidth() - 20, this.getHeight() - 8);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private JLabel customStyleLab = new JLabel();
    private DefaultCellEditor informationCellEditor;
    private DefaultCellEditor stylesCellEditor;
    private JProgressBar progress = new JProgressBar(0, 100);
    private JSlider slider = new JSlider(0, 100);
    private JLabel visibilityLabel = new JLabel("", 0);
    private JLabel emptyLabel = new JLabel();
    private RetrievalServiceLayer wmsServiceLayerThatFiresPropertyChangeEvents = null;

    public ActiveLayerTableCellEditor() {
        this.progress.setString("");
        this.progress.setStringPainted(true);
        this.progress.setLayout(new BorderLayout(2, 2));
        this.visibilityLabel.setOpaque(false);
        this.visibilityLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ActiveLayerTableCellEditor.this.value instanceof RetrievalServiceLayer) {
                    RetrievalServiceLayer layer;
                    boolean flag = (layer = (RetrievalServiceLayer)ActiveLayerTableCellEditor.this.value).getPNode().getVisible();
                    layer.setEnabled(!flag);
                    if (!flag) {
                        layer.retrieve(true);
                    }
                    if (layer instanceof AbstractFeatureService) {
                        ((AbstractFeatureService)layer).setVisible(!flag);
                    } else if (layer instanceof AbstractWMS) {
                        ((AbstractWMS)((Object)layer)).setVisible(!flag);
                    } else if (layer instanceof ModeLayer) {
                        ((ModeLayer)layer).setVisible(!flag);
                    }
                    layer.getPNode().setVisible(!flag);
                    ActiveLayerEvent ale = new ActiveLayerEvent();
                    ale.setLayer(ActiveLayerTableCellEditor.this.value);
                    CismapBroker.getInstance().fireLayerVisibilityChanged(ale);
                    ActiveLayerTableCellEditor.this.table.repaint();
                }
            }
        });
        this.informationBox = new JCheckBox();
        this.informationBox.setHorizontalAlignment(0);
        this.informationCellEditor = new DefaultCellEditor(this.informationBox);
        this.cbbStyleChooser = new JComboBox();
        this.stylesCellEditor = new DefaultCellEditor(this.cbbStyleChooser);
        this.cbbStyleChooser.setEditable(false);
        this.cbbStyleChooser.setRenderer(new StyleChooserCellRenderer());
        this.informationBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (ActiveLayerTableCellEditor.this.value instanceof LayerInfoProvider) {
                        ((LayerInfoProvider)ActiveLayerTableCellEditor.this.value).setLayerQuerySelected(ActiveLayerTableCellEditor.this.informationBox.isSelected());
                        ActiveLayerEvent ale = new ActiveLayerEvent();
                        ale.setLayer(ActiveLayerTableCellEditor.this.value);
                        CismapBroker.getInstance().fireLayerInformationStatusChanged(ale);
                    }
                    ActiveLayerTableCellEditor.this.table.getColumnModel().getColumn(3).getCellEditor().stopCellEditing();
                }
                catch (Exception ex) {
                    ActiveLayerTableCellEditor.this.logger.error((Object)"Error in actionPerformed of the informationCheckBos", (Throwable)ex);
                }
            }
        });
        this.cbbStyleChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ActiveLayerEvent ale;
                    WMSLayer l = null;
                    if (ActiveLayerTableCellEditor.this.value instanceof WMSLayer) {
                        l = (WMSLayer)ActiveLayerTableCellEditor.this.value;
                    } else if (ActiveLayerTableCellEditor.this.value instanceof WMSServiceLayer && ((WMSServiceLayer)ActiveLayerTableCellEditor.this.value).getWMSLayers().size() == 1) {
                        l = (WMSLayer)((WMSServiceLayer)ActiveLayerTableCellEditor.this.value).getWMSLayers().get(0);
                    }
                    if (l != null && !l.getSelectedStyle().equals((Style)ActiveLayerTableCellEditor.this.cbbStyleChooser.getSelectedItem())) {
                        ale = new ActiveLayerEvent();
                        ale.setLayer(l.getParentServiceLayer());
                        CismapBroker.getInstance().fireLayerRemoved(ale);
                        l.setSelectedStyle((Style)ActiveLayerTableCellEditor.this.cbbStyleChooser.getSelectedItem());
                        ((RetrievalService)ActiveLayerTableCellEditor.this.value).retrieve(true);
                        CismapBroker.getInstance().fireLayerAdded(ale);
                    }
                    l.setSelectedStyle((Style)ActiveLayerTableCellEditor.this.cbbStyleChooser.getSelectedItem());
                    ale = new ActiveLayerEvent();
                    ale.setLayer(l.getParentServiceLayer());
                    ((RetrievalService)ActiveLayerTableCellEditor.this.value).retrieve(true);
                    CismapBroker.getInstance().fireLayerRemoved(ale);
                    CismapBroker.getInstance().fireLayerAdded(ale);
                }
                catch (Exception ex) {
                    ActiveLayerTableCellEditor.this.logger.error((Object)"Error while changing the style", (Throwable)ex);
                }
            }
        });
        this.moreButton.setFocusPainted(false);
        this.moreButton.setEnabled(false);
        this.moreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryEditorDialog dia = new QueryEditorDialog(StaticSwingTools.getParentFrame((Component)ActiveLayerTableCellEditor.this.moreButton), true, ((WebFeatureService)ActiveLayerTableCellEditor.this.value).getQuery());
                StaticSwingTools.showDialog((JDialog)dia);
                if (dia.getReturnStatus() == 1) {
                    ((WebFeatureService)ActiveLayerTableCellEditor.this.value).setQuery(dia.getQueryString());
                }
            }
        });
        this.customStyleLab.addMouseListener(new StyleMouseListener());
        this.wfsStyleButton.setFocusPainted(false);
        this.wfsStyleButton.setEnabled(true);
        this.wfsStyleButton.setBorderPainted(false);
        this.wfsStyleButton.setContentAreaFilled(false);
        this.wfsStyleButton.addMouseListener(new StyleMouseListener());
        this.progress.add((Component)this.slider, "Center");
        this.slider.setOpaque(false);
        this.slider.setValueIsAdjusting(true);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                if (ActiveLayerTableCellEditor.this.value instanceof RetrievalServiceLayer) {
                    float f = (float)((double)slider.getValue() * 0.01);
                    ((RetrievalServiceLayer)ActiveLayerTableCellEditor.this.value).setTranslucency(f);
                    PNode pi = ((RetrievalServiceLayer)ActiveLayerTableCellEditor.this.value).getPNode();
                    if (pi != null) {
                        pi.setTransparency(f);
                        pi.repaint();
                    }
                    if (!slider.getValueIsAdjusting()) {
                        ((RetrievalServiceLayer)ActiveLayerTableCellEditor.this.value).setTranslucency(f);
                    }
                }
            }
        });
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ActiveLayerTableCellEditor.this.stopCellEditing();
            }
        });
        this.slider.dispatchEvent(new MouseEvent(this.slider, 500, System.currentTimeMillis(), 16, 3, 2, 1, false, 1));
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        JTextField treeEditorTextField = new JTextField();
        treeEditorTextField.setEditable(true);
        DefaultCellEditor treeEditor = new DefaultCellEditor(treeEditorTextField);
        return treeEditor.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        int realColumn = table.convertColumnIndexToModel(column);
        this.value = value;
        this.table = table;
        WMSLayer wmsLayer = null;
        LayerInfoProvider layer = null;
        if (value instanceof ModeLayer) {
            return this.getTableCellEditorComponent(table, ((ModeLayer)value).getCurrentLayer(), isSelected, row, column);
        }
        if (value instanceof WMSLayer) {
            wmsLayer = (WMSLayer)value;
        } else if (value instanceof WMSServiceLayer) {
            wmsLayer = (WMSLayer)((WMSServiceLayer)value).getWMSLayers().get(0);
        }
        if (value instanceof LayerInfoProvider) {
            layer = (LayerInfoProvider)value;
        }
        if (realColumn == 0) {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            this.visibilityLabel.setIcon(((JLabel)renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column)).getIcon());
            return this.visibilityLabel;
        }
        if (realColumn == 2) {
            if (value instanceof WMSServiceLayer) {
                try {
                    DefaultComboBoxModel<Style> model = new DefaultComboBoxModel<Style>(wmsLayer.getOgcCapabilitiesLayer().getStyles());
                    this.cbbStyleChooser.setModel(model);
                    this.cbbStyleChooser.setSelectedItem(wmsLayer.getSelectedStyle());
                    return this.stylesCellEditor.getTableCellEditorComponent(table, wmsLayer.getSelectedStyle(), isSelected, row, column);
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Error while setting the StyleEditor", (Throwable)e);
                    return null;
                }
            }
            AbstractFeatureService service = (AbstractFeatureService)value;
            if (service.getLayerProperties() != null && service.getLayerProperties().getAttributeTableRuleSet() != null && service.getLayerProperties().getAttributeTableRuleSet().getFeatureClass() != null) {
                this.customStyleLab.setHorizontalAlignment(2);
                this.customStyleLab.setText(NbBundle.getMessage(ActiveLayerTableCellRenderer.class, (String)"ActiveLayerTableCellRenderer.getTableCellRendererComponent().customStyle"));
                this.customStyleLab.setIcon(this.unselectedStyleIcon);
                return this.customStyleLab;
            }
            return this.wfsStyleButton;
        }
        if (realColumn == 3) {
            return this.informationCellEditor.getTableCellEditorComponent(table, layer.isLayerQuerySelected(), isSelected, row, column);
        }
        if (realColumn == 4) {
            if (this.wmsServiceLayerThatFiresPropertyChangeEvents != null) {
                this.wmsServiceLayerThatFiresPropertyChangeEvents.removePropertyChangeListener(this);
            }
            ((RetrievalServiceLayer)value).addPropertyChangeListener(this);
            this.wmsServiceLayerThatFiresPropertyChangeEvents = (RetrievalServiceLayer)value;
            this.slider.setValue((int)(((RetrievalServiceLayer)value).getTranslucency() * 100.0f));
            this.slider.requestFocus();
            if (((RetrievalServiceLayer)value).getProgress() == -1) {
                this.progress.setIndeterminate(true);
            } else {
                this.progress.setIndeterminate(false);
            }
            this.progress.setValue(((RetrievalServiceLayer)value).getProgress());
            this.slider.updateUI();
            return this.progress;
        }
        if (realColumn == 5) {
            if (value instanceof WMSServiceLayer) {
                this.moreButton.setEnabled(false);
            } else if (value instanceof WebFeatureService) {
                this.moreButton.setEnabled(true);
            }
            return this.moreButton;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof RetrievalServiceLayer && evt.getPropertyName().equals("progress")) {
            int newValue = (Integer)evt.getNewValue();
            if (newValue == 0) {
                this.progress.setIndeterminate(true);
            } else {
                this.progress.setIndeterminate(false);
                this.progress.setValue(newValue);
            }
        }
    }

    @Override
    public void cancelCellEditing() {
        if (this.wmsServiceLayerThatFiresPropertyChangeEvents != null) {
            this.wmsServiceLayerThatFiresPropertyChangeEvents.removePropertyChangeListener(this);
        }
        super.cancelCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        if (this.wmsServiceLayerThatFiresPropertyChangeEvents != null) {
            this.wmsServiceLayerThatFiresPropertyChangeEvents.removePropertyChangeListener(this);
        }
        boolean retValue = super.stopCellEditing();
        return retValue;
    }

    private class StyleMouseListener
    extends MouseAdapter {
        private StyleMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                AbstractFeatureService selectedService = (AbstractFeatureService)ActiveLayerTableCellEditor.this.value;
                Frame parentFrame = StaticSwingTools.getParentFrame((Component)ActiveLayerTableCellEditor.this.wfsStyleButton);
                ArrayList<String> args = new ArrayList<String>();
                args.add("Allgemein");
                args.add("Darstellung");
                args.add("Massstab");
                args.add("Thematische Farbgebung");
                args.add("Beschriftung");
                args.add("TextEditor");
                StyleDialogStarter starter = new StyleDialogStarter(parentFrame, selectedService, args, 500);
                starter.start();
            }
        }
    }
}

