/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.layerwidget;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import de.cismet.cismap.commons.LayerConfig;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DocumentFeatureServiceFactory;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.LayerAlreadyAddedException;
import de.cismet.cismap.commons.featureservice.ShapeFileFeatureService;
import de.cismet.cismap.commons.featureservice.WFSCapabilitiesTreeCellRenderer;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.capabilitywidget.CidsLayerTransferable;
import de.cismet.cismap.commons.gui.capabilitywidget.SelectionAndCapabilities;
import de.cismet.cismap.commons.gui.capabilitywidget.TreeFolder;
import de.cismet.cismap.commons.gui.capabilitywidget.WFSSelectionAndCapabilities;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.LayerCollection;
import de.cismet.cismap.commons.gui.layerwidget.LayerWidget;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.internaldb.DBTableInformation;
import de.cismet.cismap.commons.raster.wms.SlidableWMSServiceLayerGroup;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.rasterservice.ImageFileUtils;
import de.cismet.cismap.commons.rasterservice.ImageRasterService;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.cismap.commons.util.DnDUtils;
import de.cismet.cismap.commons.wfs.capabilities.FeatureType;
import de.cismet.commons.cismap.io.converters.GeometriesFromGPXConverter;
import de.cismet.commons.cismap.io.converters.MultiGeometriesProvider;
import de.cismet.commons.wms.capabilities.Layer;
import de.cismet.commons.wms.capabilities.deegree.DeegreeLayer;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDropEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class LayerDropUtils {
    public static final Logger LOG = Logger.getLogger(LayerDropUtils.class);

    public static boolean drop(Collection<File> data, ActiveLayerModel activeLayerModel, JComponent parent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Drag&Drop File List: " + data));
        }
        if (data != null) {
            if (LayerDropUtils.handleFiles(data, activeLayerModel, -1, parent)) {
                return true;
            }
        } else {
            LOG.warn((Object)"No files available");
        }
        return false;
    }

    public static void drop(DropTargetDropEvent dtde, ActiveLayerModel activeLayerModel, JComponent parent) {
        LayerDropUtils.drop(new DnDUtils.TransferSupportWrapper(dtde), activeLayerModel, parent, -1);
    }

    public static boolean drop(TransferHandler.TransferSupport support, ActiveLayerModel activeLayerModel, int index, JComponent parent) {
        return LayerDropUtils.drop(new DnDUtils.TransferSupportWrapper(support), activeLayerModel, parent, index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean drop(DnDUtils.TransferSupportWrapper dtde, ActiveLayerModel activeLayerModel, JComponent parent, int index) {
        DataFlavor TREEPATH_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "SelectionAndCapabilities");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Drop with this flavors:" + dtde.getCurrentDataFlavorsAsList()));
        }
        if (DnDUtils.isFilesOrUriList(dtde)) {
            dtde.acceptDrop(1);
            try {
                List<File> data = DnDUtils.getFilesFrom(dtde);
                LayerDropUtils.drop(data, activeLayerModel, parent);
                return false;
            }
            catch (Exception ex) {
                LOG.error((Object)"Failure during drag & drop opertation", (Throwable)ex);
            }
            return false;
        } else if (dtde.isDataFlavorSupported(TREEPATH_FLAVOR)) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("There are " + dtde.getTransferable().getTransferDataFlavors().length + " DataFlavours"));
                }
                for (int i = 0; i < dtde.getTransferable().getTransferDataFlavors().length; ++i) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("DataFlavour" + i + ": " + dtde.getTransferable().getTransferDataFlavors()[i]));
                }
                Object o = dtde.getTransferable().getTransferData(TREEPATH_FLAVOR);
                ArrayList<TreePath> v = new ArrayList<TreePath>();
                dtde.dropComplete(true);
                if (o instanceof SelectionAndCapabilities) {
                    TreePath[] tpa = ((SelectionAndCapabilities)o).getSelection();
                    for (int i = 0; i < tpa.length; ++i) {
                        v.add(tpa[i]);
                    }
                    if (LayerDropUtils.isSlidableWMSServiceLayerGroup(((TreePath)v.get(0)).getLastPathComponent())) {
                        SlidableWMSServiceLayerGroup l = new SlidableWMSServiceLayerGroup(v);
                        l.setWmsCapabilities(((SelectionAndCapabilities)o).getCapabilities());
                        l.setCapabilitiesUrl(((SelectionAndCapabilities)o).getUrl());
                        if (index != -1) {
                            activeLayerModel.addLayer(l, activeLayerModel.layers.size() - index);
                            return true;
                        } else {
                            activeLayerModel.addLayer(l);
                        }
                        return true;
                    }
                    WMSServiceLayer l = ((SelectionAndCapabilities)o).getUrl().contains("cismap.dont.touch.ordering=true") ? new WMSServiceLayer(v, false, false) : new WMSServiceLayer(v, true, true);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("((SelectionAndCapabilities)o).getUrl()" + ((SelectionAndCapabilities)o).getUrl()));
                    }
                    l.setWmsCapabilities(((SelectionAndCapabilities)o).getCapabilities());
                    l.setCapabilitiesUrl(((SelectionAndCapabilities)o).getUrl());
                    if (CismapBroker.getInstance().isWMSLayerNamesWithPath() && v.size() == 1) {
                        ArrayList<Layer> parents = new ArrayList<Layer>();
                        TreePath tp = (TreePath)v.get(0);
                        if (tp.getLastPathComponent() instanceof Layer) {
                            parents.add((Layer)tp.getLastPathComponent());
                        }
                        while (tp.getParentPath() != null && tp.getParentPath().getLastPathComponent() instanceof Layer) {
                            parents.add((Layer)tp.getParentPath().getLastPathComponent());
                            tp = tp.getParentPath();
                        }
                        Collections.reverse(parents);
                        StringBuffer parentsString = null;
                        for (Layer p : parents) {
                            if (parentsString == null) {
                                parentsString = new StringBuffer(p.getTitle());
                                continue;
                            }
                            parentsString.append("->").append(p.getTitle());
                        }
                        l.setName(parentsString.toString());
                    }
                    if (index != -1) {
                        activeLayerModel.addLayer(l, activeLayerModel.layers.size() - index);
                        return true;
                    } else {
                        activeLayerModel.addLayer(l);
                    }
                    return true;
                }
                if (o instanceof WFSSelectionAndCapabilities) {
                    WFSSelectionAndCapabilities sac = (WFSSelectionAndCapabilities)o;
                    for (FeatureType feature : sac.getFeatures()) {
                        try {
                            String hostname = feature.getWFSCapabilities().getOriginalLink() != null ? feature.getWFSCapabilities().getOriginalLink() : feature.getWFSCapabilities().getURL().toString();
                            WebFeatureService wfs = new WebFeatureService(WFSCapabilitiesTreeCellRenderer.showTitle && feature.getTitle() != null ? feature.getTitle() : feature.getPrefixedNameString(), hostname, feature.getWFSQuery(), feature.getFeatureAttributes(), feature, sac.isReverseAxisOrder());
                            if (sac.getIdentifier() != null && sac.getIdentifier().length() > 0) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("setting PrimaryAnnotationExpression of WFS Layer to '" + sac.getIdentifier() + "' (EXPRESSIONTYPE_PROPERTYNAME)"));
                                }
                                wfs.getLayerProperties().setPrimaryAnnotationExpression(sac.getIdentifier(), 1);
                            } else {
                                LOG.warn((Object)"could not determine PrimaryAnnotationExpression");
                            }
                            if (index != -1) {
                                activeLayerModel.addLayer(wfs, activeLayerModel.layers.size() - index);
                                continue;
                            }
                            activeLayerModel.addLayer(wfs);
                        }
                        catch (IllegalArgumentException schonVorhanden) {
                            JOptionPane.showMessageDialog(parent, NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.drop(DropTargetDropEvent).JOptionPane.message"), NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.drop(DropTargetDropEvent).JOptionPane.title"), 0);
                            return false;
                        }
                    }
                    return true;
                }
                if (o instanceof CidsLayerTransferable[]) {
                    for (int i = ((CidsLayerTransferable[])o).length - 1; i >= 0; --i) {
                        CidsLayerTransferable transferable = ((CidsLayerTransferable[])o)[i];
                        if (transferable.isFolder()) {
                            TreeFolder folder = transferable.getFolder();
                            LayerCollection lc = LayerDropUtils.createTreeFolder(folder);
                            lc.setModel(activeLayerModel);
                            if (index != -1) {
                                activeLayerModel.addLayer(lc, activeLayerModel.layers.size() - index);
                                continue;
                            }
                            activeLayerModel.addLayer(lc, 0);
                            continue;
                        }
                        LayerConfig config = transferable.getLayerConfig();
                        if (index != -1) {
                            activeLayerModel.addLayer(config.createConfiguredLayer(), activeLayerModel.layers.size() - index);
                            continue;
                        }
                        activeLayerModel.addLayer(config.createConfiguredLayer());
                    }
                    return true;
                }
                if (o instanceof File) {
                    ArrayList<File> list = new ArrayList<File>(1);
                    list.add((File)o);
                    if (!LayerDropUtils.handleFiles(list, activeLayerModel, index, parent)) return false;
                    return true;
                }
                if (!(o instanceof DBTableInformation[])) return false;
                DBTableInformation[] infos = (DBTableInformation[])o;
                for (int n = infos.length - 1; n >= 0; --n) {
                    DBTableInformation i = infos[n];
                    if (i.isFolder()) {
                        LayerCollection lc = LayerDropUtils.createH2Folder(i);
                        lc.setModel(activeLayerModel);
                        if (index != -1) {
                            activeLayerModel.addLayer(lc, activeLayerModel.layers.size() - index);
                            continue;
                        }
                        activeLayerModel.addLayer(lc, 0);
                        continue;
                    }
                    H2FeatureService layer = new H2FeatureService(i.getName(), i.getDatabasePath(), i.getDatabaseTable(), null);
                    if (index != -1) {
                        activeLayerModel.addLayer(layer, activeLayerModel.layers.size() - index);
                        continue;
                    }
                    activeLayerModel.addLayer(layer);
                }
                return false;
            }
            catch (IllegalArgumentException schonVorhanden) {
                JOptionPane.showMessageDialog(parent, NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.drop(DropTargetDropEvent).JOptionPane.message"), NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.drop(DropTargetDropEvent).JOptionPane.title"), 0);
                return false;
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                return false;
            }
        } else {
            LOG.warn((Object)("No Matching dataFlavour: " + dtde.getCurrentDataFlavorsAsList()));
        }
        return false;
    }

    private static LayerCollection createH2Folder(DBTableInformation i) throws Exception {
        LayerCollection lc = new LayerCollection();
        lc.setName(i.getName());
        for (DBTableInformation tmp : i.getChildren()) {
            if (tmp.isFolder()) {
                lc.add(LayerDropUtils.createH2Folder(tmp));
                continue;
            }
            H2FeatureService layer = new H2FeatureService(tmp.getName(), tmp.getDatabasePath(), tmp.getDatabaseTable(), null);
            lc.add(layer);
        }
        return lc;
    }

    private static LayerCollection createTreeFolder(TreeFolder folder) throws Exception {
        LayerCollection lc = new LayerCollection();
        lc.setName(folder.getName());
        for (Object tmp : folder) {
            if (tmp instanceof TreeFolder) {
                lc.add(LayerDropUtils.createTreeFolder((TreeFolder)tmp));
                continue;
            }
            lc.add(((LayerConfig)tmp).createConfiguredLayer());
        }
        return lc;
    }

    public static boolean handleFiles(Collection<File> data, ActiveLayerModel activeLayerModel, int index, Component parent) {
        boolean success = false;
        for (File currentFile : data) {
            if (!LayerDropUtils.handleFile(currentFile, activeLayerModel, index, parent)) continue;
            success = true;
        }
        return success;
    }

    public static boolean handleFile(File currentFile, ActiveLayerModel activeLayerModel, int index, Component parent) {
        LOG.info((Object)("DocumentUri: " + currentFile.toURI()));
        if (ImageFileUtils.isImageFileEnding(currentFile.getName())) {
            return LayerDropUtils.handleImageFile(currentFile, activeLayerModel, index, parent, ImageFileUtils.determineMode(currentFile));
        }
        return LayerDropUtils.handleFeatureServiceFile(currentFile, activeLayerModel, index, parent);
    }

    public static boolean handleImageFile(File currentFile, ActiveLayerModel activeLayerModel, int index, Component parent, ImageFileUtils.Mode imageFileMode) {
        ImageRasterService irs = new ImageRasterService(currentFile, imageFileMode);
        if (index != -1) {
            activeLayerModel.addLayer(irs, activeLayerModel.layers.size() - index);
        } else {
            activeLayerModel.addLayer(irs);
        }
        return true;
    }

    public static boolean handleGPXFile(final File currentFile, ActiveLayerModel activeLayerModel, int index, Component parent) {
        final GeometriesFromGPXConverter converter = new GeometriesFromGPXConverter();
        WaitingDialogThread<Geometry> wdt = new WaitingDialogThread<Geometry>(StaticSwingTools.getFirstParentFrame((Component)parent), true, NbBundle.getMessage(LayerDropUtils.class, (String)"LayerDropUtils.handleGPXFile().waitingDialogThread.message"), null, 50){

            protected Geometry doInBackground() throws Exception {
                String line;
                BufferedReader fileReader = new BufferedReader(new FileReader(currentFile));
                StringBuilder sb = new StringBuilder();
                while ((line = fileReader.readLine()) != null) {
                    sb.append(line).append('\n');
                }
                Geometry geom = converter.convertForward(sb.toString(), CismapBroker.getInstance().getSrs().getCode());
                return geom;
            }

            protected void done() {
                try {
                    Geometry geom = (Geometry)this.get();
                    MappingComponent map = CismapBroker.getInstance().getMappingComponent();
                    ArrayList<PureNewFeature> featureList = new ArrayList<PureNewFeature>();
                    String featureName = currentFile.getName();
                    if (featureName.contains(".")) {
                        featureName = featureName.substring(0, currentFile.getName().indexOf("."));
                    }
                    if (converter instanceof MultiGeometriesProvider && geom instanceof GeometryCollection) {
                        GeometryCollection gc = (GeometryCollection)geom;
                        for (int i = 0; i < gc.getNumGeometries(); ++i) {
                            PureNewFeature feature = new PureNewFeature(gc.getGeometryN(i));
                            feature.setGeometryType(FeatureTools.getGeomType(gc.getGeometryN(i)));
                            feature.setEditable(true);
                            feature.setName(featureName + "-" + i);
                            featureList.add(feature);
                        }
                    } else {
                        PureNewFeature feature = new PureNewFeature(geom);
                        feature.setGeometryType(FeatureTools.getGeomType(geom));
                        feature.setEditable(true);
                        feature.setName(featureName);
                        featureList.add(feature);
                    }
                    map.getFeatureCollection().addFeatures(featureList);
                    for (PureNewFeature feature : featureList) {
                        map.getFeatureCollection().holdFeature(feature);
                    }
                    if (!map.isFixedMapExtent()) {
                        map.zoomToAFeatureCollection(featureList, true, map.isFixedMapScale());
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error whiel parsing gpx file");
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            wdt.start();
        } else {
            EventQueue.invokeLater(new Thread("GPXParser-Thread", (WaitingDialogThread)wdt){
                final /* synthetic */ WaitingDialogThread val$wdt;
                {
                    this.val$wdt = waitingDialogThread;
                    super(x0);
                }

                @Override
                public void run() {
                    this.val$wdt.start();
                }
            });
        }
        return true;
    }

    public static boolean handleFeatureServiceFile(File currentFile, ActiveLayerModel activeLayerModel, int index, final Component parent) {
        try {
            final AbstractFeatureService dfs = DocumentFeatureServiceFactory.createDocumentFeatureService(currentFile);
            try {
                if (index != -1) {
                    activeLayerModel.addLayer(dfs, activeLayerModel.layers.size() - index);
                } else {
                    activeLayerModel.addLayer(dfs);
                }
            }
            catch (IllegalArgumentException ex) {
                JOptionPane.showMessageDialog(parent, NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.drop(DropTargetDropEvent).JOptionPane.message"), NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.drop(DropTargetDropEvent).JOptionPane.title"), 0);
                throw ex;
            }
            if (dfs instanceof ShapeFileFeatureService) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        do {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (!dfs.isInitialized());
                        if (((ShapeFileFeatureService)dfs).isErrorInGeometryFound()) {
                            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)parent), NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.drop().errorInShapeGeometryFoundMessage"), NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.drop().errorInShapeGeometryFoundTitle"), 0);
                        } else if (((ShapeFileFeatureService)dfs).isNoGeometryRecognised()) {
                            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)parent), NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.drop().noGeometryFoundInShapeMessage"), NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.drop().noGeometryFoundInShapeTitle"), 2);
                        }
                    }
                }).start();
            }
        }
        catch (LayerAlreadyAddedException dfs) {
        }
        catch (Exception ex) {
            LOG.error((Object)"Error during creation of a FeatureServices", (Throwable)ex);
            return false;
        }
        return true;
    }

    private static boolean isSlidableWMSServiceLayerGroup(Object lastPathComponent) {
        DeegreeLayer layer = null;
        if (!(lastPathComponent instanceof DeegreeLayer)) {
            return false;
        }
        layer = (DeegreeLayer)lastPathComponent;
        List<String> keywords = Arrays.asList(layer.getKeywords());
        return keywords.contains("cismapSlidingLayerGroup");
    }
}

