/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.layerwidget;

import de.cismet.cismap.commons.MappingModelEvent;
import de.cismet.cismap.commons.MappingModelListener;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.featureservice.GMLFeatureService;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.ShapeFileFeatureService;
import de.cismet.cismap.commons.featureservice.SimplePostgisFeatureService;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerTableCellEditor;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerTableCellRenderer;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerTreeCellRenderer;
import de.cismet.cismap.commons.gui.layerwidget.LayerDropUtils;
import de.cismet.cismap.commons.gui.layerwidget.Tester;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToLayerWorker;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.raster.wms.WMSLayer;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.commons.wms.capabilities.deegree.DeegreeLayer;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.GUIWindow;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.imagetooltip.ImageToolTip;
import de.cismet.tools.gui.treetable.JTreeTable;
import de.cismet.tools.gui.treetable.TreeTableCellEditor;
import de.cismet.tools.gui.treetable.TreeTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class LayerWidget
extends JPanel
implements DropTargetListener,
Configurable,
GUIWindow {
    private static final Logger LOG = Logger.getLogger(LayerWidget.class);
    private static final Map<String, String[]> URL_TRANSFORMATION_RULES = new HashMap<String, String[]>();
    private static final String SEARCH_STRING = "_search";
    private static final String EXTRACTION_STRING = "_extraction";
    private static final String PREFIX_STRING = "_prefix";
    private static final String POSTFIX_STRING = "_postfix";
    private static final String CONCAT_STRING = "_concat";
    private static final List<String> URL_TRANSFORMATION_RULES_ORDER = new ArrayList<String>();
    private final Logger log = Logger.getLogger(this.getClass());
    private final ActiveLayerModel activeLayerModel = new ActiveLayerModel();
    private JTreeTable treeTable;
    private final int acceptableActions = 3;
    private Image errorImage;
    private MappingComponent mapC = null;
    private JButton cmdCopyToClipboard;
    private JButton cmdDisable;
    private JButton cmdDown;
    private JButton cmdMakeInvisible;
    private JButton cmdRefreshSingleLayer;
    private JButton cmdRemove;
    private JButton cmdTreeCollapse;
    private JButton cmdUp;
    private JButton cmdZoomToFullExtent;
    private JPanel jPanel1;
    private JToolBar jToolBar1;
    private JScrollPane scpMain;

    public LayerWidget() {
    }

    public LayerWidget(MappingComponent mapC) {
        this.init(mapC);
    }

    public void init(MappingComponent mapC) {
        LayerWidget.hackDragAndDropDataFlavors();
        this.initComponents();
        this.mapC = mapC;
        this.log.info((Object)("LayerWidget: " + this.activeLayerModel));
        DropTarget dt = new DropTarget(this, 3, this);
        this.treeTable = new JTreeTable((TreeTableModel)this.activeLayerModel){

            public JToolTip createToolTip() {
                if (LayerWidget.this.log.isDebugEnabled()) {
                    LayerWidget.this.log.debug((Object)"Tooltip");
                }
                if (LayerWidget.this.getErrorImage() != null) {
                    return new ImageToolTip(LayerWidget.this.getErrorImage());
                }
                return super.createToolTip();
            }

            public String getToolTipText(MouseEvent event) {
                int row = this.rowAtPoint(event.getPoint());
                int column = this.columnAtPoint(event.getPoint());
                if (row == -1 || column == -1) {
                    return null;
                }
                if (column == 1) {
                    JTree tree = this.getTree();
                    TreePath path = tree.getPathForLocation(event.getX(), event.getY());
                    if (path != null) {
                        Object node = path.getLastPathComponent();
                        String url = null;
                        url = LayerWidget.this.extractUrlFromServie(node);
                        if (url != null) {
                            return LayerWidget.transformURL(url);
                        }
                    }
                    return null;
                }
                return super.getToolTipText(event);
            }
        };
        this.treeTable.setAutoCreateColumnsFromModel(true);
        this.treeTable.setShowGrid(true);
        this.treeTable.getTableHeader().setReorderingAllowed(true);
        this.treeTable.getTree().setShowsRootHandles(true);
        this.treeTable.getTree().setRootVisible(false);
        this.treeTable.getTree().setCellRenderer(new ActiveLayerTreeCellRenderer());
        ActiveLayerTableCellEditor cellEditor = new ActiveLayerTableCellEditor();
        TreeTableCellEditor treeTableCellEditor = new TreeTableCellEditor(this.treeTable, this.treeTable.getTree());
        treeTableCellEditor.setClickCountToStart(2);
        this.treeTable.setDefaultEditor(TreeTableModel.class, (TableCellEditor)treeTableCellEditor);
        this.treeTable.getColumnModel().getColumn(0).setMaxWidth(20);
        this.treeTable.getColumnModel().getColumn(3).setMaxWidth(50);
        this.treeTable.getColumnModel().getColumn(5).setMaxWidth(50);
        this.treeTable.getColumnModel().getColumn(0).setCellEditor(cellEditor);
        this.treeTable.getColumnModel().getColumn(2).setCellEditor(cellEditor);
        this.treeTable.getColumnModel().getColumn(3).setCellEditor(cellEditor);
        this.treeTable.getColumnModel().getColumn(4).setCellEditor(cellEditor);
        this.treeTable.getColumnModel().getColumn(5).setCellEditor(cellEditor);
        ActiveLayerTableCellRenderer tableCellRenderer = new ActiveLayerTableCellRenderer();
        this.treeTable.getColumnModel().getColumn(0).setCellRenderer(tableCellRenderer);
        this.treeTable.getColumnModel().getColumn(2).setCellRenderer(tableCellRenderer);
        this.treeTable.getColumnModel().getColumn(3).setCellRenderer(tableCellRenderer);
        this.treeTable.getColumnModel().getColumn(4).setCellRenderer(tableCellRenderer);
        this.treeTable.getColumnModel().getColumn(5).setCellRenderer(tableCellRenderer);
        this.treeTable.setSelectionMode(2);
        this.scpMain.setViewportView((Component)this.treeTable);
        this.treeTable.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (LayerWidget.this.treeTable.getTree().getSelectionPath() != null) {
                    if (LayerWidget.this.log.isDebugEnabled()) {
                        LayerWidget.this.log.debug((Object)("ActiveLayerWidget: selectionChanged()\n" + e));
                    }
                    try {
                        ActiveLayerEvent ale = new ActiveLayerEvent();
                        ale.setLayer(LayerWidget.this.treeTable.getTree().getSelectionPath().getLastPathComponent());
                        if (ale.getLayer() instanceof WMSServiceLayer) {
                            ale.setCapabilities(((WMSServiceLayer)ale.getLayer()).getWmsCapabilities());
                        }
                        CismapBroker.getInstance().fireLayerSelectionChanged(ale);
                    }
                    catch (Exception ex) {
                        LayerWidget.this.log.error((Object)"error while changing the selected layer", (Throwable)ex);
                    }
                }
            }
        });
        this.treeTable.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    LayerWidget.this.cmdRemoveActionPerformed(null);
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TreePath[] tps = LayerWidget.this.treeTable.getTree().getSelectionPaths();
                boolean zoomToLayerAllowd = false;
                if (tps != null) {
                    for (TreePath tp : tps) {
                        if (tp.getLastPathComponent() instanceof WMSServiceLayer) {
                            WMSServiceLayer rsl = (WMSServiceLayer)tp.getLastPathComponent();
                            if (rsl.getLayerInformation() == null || rsl.getLayerInformation().getAbstract() == null || !rsl.getLayerInformation().getAbstract().contains("Ma\u00dfstabsbegrenzung:")) {
                                zoomToLayerAllowd = true;
                                break;
                            }
                            try {
                                String abstr = rsl.getLayerInformation().getAbstract();
                                String relevantSubString = abstr.substring(abstr.indexOf("Ma\u00dfstabsbegrenzung:") + "Ma\u00dfstabsbegrenzung:".length());
                                StringTokenizer st = new StringTokenizer(relevantSubString, ",");
                                ArrayList<String> relevantLayerNames = new ArrayList<String>();
                                while (st.hasMoreTokens()) {
                                    String token = st.nextToken();
                                    if (!token.contains("\"") || token.indexOf("\"") == token.lastIndexOf("\"")) continue;
                                    relevantLayerNames.add(token.substring(token.indexOf("\"") + 1, token.lastIndexOf("\"")).toLowerCase());
                                }
                                List layers = rsl.getWMSLayers();
                                if (layers == null) continue;
                                for (WMSLayer l : layers) {
                                    if (relevantLayerNames.contains(l.getStyleName().toLowerCase())) continue;
                                    zoomToLayerAllowd = true;
                                }
                            }
                            catch (Throwable throwable) {}
                            continue;
                        }
                        zoomToLayerAllowd = true;
                        break;
                    }
                }
                LayerWidget.this.cmdZoomToFullExtent.setEnabled(zoomToLayerAllowd);
            }
        });
        this.treeTable.setGridColor(this.getBackground());
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.activeLayerModel.addMappingModelListener(new MappingModelListener(){

            @Override
            public void mapServiceLayerStructureChanged(MappingModelEvent mme) {
                LayerWidget.this.treeTable.getColumnModel().getColumn(3).getCellEditor().stopCellEditing();
            }

            @Override
            public void mapServiceAdded(MapService mapService) {
                LayerWidget.this.treeTable.getColumnModel().getColumn(3).getCellEditor().stopCellEditing();
            }

            @Override
            public void mapServiceRemoved(MapService mapService) {
                LayerWidget.this.treeTable.getColumnModel().getColumn(3).getCellEditor().stopCellEditing();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private String extractUrlFromServie(Object node) {
        String url = null;
        if (node instanceof RetrievalServiceLayer) {
            RetrievalServiceLayer layer = (RetrievalServiceLayer)node;
            if (node instanceof WMSServiceLayer) {
                WMSServiceLayer wmsLayer = (WMSServiceLayer)node;
                return wmsLayer.getServerURI();
            }
            if (node instanceof SimpleWMS) {
                return ((SimpleWMS)layer).getServerURI();
            }
            if (node instanceof WebFeatureService) {
                return ((WebFeatureService)layer).getServerURI();
            }
            if (node instanceof GMLFeatureService) {
                return ((GMLFeatureService)layer).getServerURI();
            }
            if (node instanceof ShapeFileFeatureService) {
                return ((ShapeFileFeatureService)layer).getDocumentURI().toString();
            }
            if (node instanceof SimplePostgisFeatureService) {
                return url;
            }
        } else {
            if (node instanceof WMSLayer) {
                return ((WMSLayer)node).getServerURI();
            }
            if (!(node instanceof SimpleWMS)) return url;
            return ((SimpleWMS)node).getServerURI();
        }
        if (!(node instanceof H2FeatureService)) return url;
        return url;
    }

    private static String transformURL(String url) {
        String result = url;
        for (String key : URL_TRANSFORMATION_RULES_ORDER) {
            Pattern searchPattern;
            Matcher searchMatcher;
            String[] rule = URL_TRANSFORMATION_RULES.get(key);
            if (rule[0] == null || rule[1] == null || !(searchMatcher = (searchPattern = Pattern.compile(rule[0])).matcher(url)).find()) continue;
            Pattern pattern = Pattern.compile(rule[1]);
            Matcher matcher = pattern.matcher(result);
            if (matcher.find()) {
                result = "";
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    result = result + (!result.equals("") && rule[4] != null ? rule[4] : "") + matcher.group(i);
                }
                return result;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Kein Match gefunden f\u00fcr: " + url));
        }
        return result;
    }

    private void initComponents() {
        this.scpMain = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.cmdTreeCollapse = new JButton();
        this.cmdRefreshSingleLayer = new JButton();
        this.cmdDown = new JButton();
        this.cmdUp = new JButton();
        this.cmdZoomToFullExtent = new JButton();
        this.cmdDisable = new JButton();
        this.cmdRemove = new JButton();
        this.cmdMakeInvisible = new JButton();
        this.cmdCopyToClipboard = new JButton();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.setPreferredSize(new Dimension(211, 114));
        this.setLayout(new BorderLayout());
        this.scpMain.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.scpMain.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)this.scpMain, "Center");
        this.jPanel1.setLayout(new BorderLayout());
        this.jToolBar1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jToolBar1.setRollover(true);
        this.cmdTreeCollapse.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/collapseTree.png")));
        this.cmdTreeCollapse.setToolTipText(NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.cmdTreeCollapse.toolTipText"));
        this.cmdTreeCollapse.setMargin(new Insets(2, 1, 2, 1));
        this.cmdTreeCollapse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWidget.this.cmdTreeCollapseActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdTreeCollapse);
        this.cmdRefreshSingleLayer.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/refresh.png")));
        this.cmdRefreshSingleLayer.setToolTipText(NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.cmdRefreshSingleLayer.toolTipText"));
        this.cmdRefreshSingleLayer.setMargin(new Insets(2, 1, 2, 1));
        this.cmdRefreshSingleLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWidget.this.cmdRefreshSingleLayerActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdRefreshSingleLayer);
        this.cmdDown.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/down.png")));
        this.cmdDown.setToolTipText(NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.cmdDown.toolTipText"));
        this.cmdDown.setMargin(new Insets(2, 1, 2, 1));
        this.cmdDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWidget.this.cmdDownActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdDown);
        this.cmdUp.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/up.png")));
        this.cmdUp.setToolTipText(NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.cmdUp.toolTipText"));
        this.cmdUp.setMargin(new Insets(2, 1, 2, 1));
        this.cmdUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWidget.this.cmdUpActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdUp);
        this.cmdZoomToFullExtent.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerZoom.png")));
        this.cmdZoomToFullExtent.setToolTipText(NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.cmdZoomToFullExtent.toolTipText"));
        this.cmdZoomToFullExtent.setMargin(new Insets(2, 1, 2, 1));
        this.cmdZoomToFullExtent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWidget.this.cmdZoomToFullExtentActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdZoomToFullExtent);
        this.cmdDisable.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/disable.png")));
        this.cmdDisable.setToolTipText(NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.cmdDisable.toolTipText"));
        this.cmdDisable.setMargin(new Insets(2, 1, 2, 1));
        this.cmdDisable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWidget.this.cmdDisableActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdDisable);
        this.cmdRemove.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/removeLayer.png")));
        this.cmdRemove.setToolTipText(NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.cmdRemove.toolTipText"));
        this.cmdRemove.setMargin(new Insets(2, 1, 2, 1));
        this.cmdRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWidget.this.cmdRemoveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdRemove);
        this.cmdMakeInvisible.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/layerDLinvisible.png")));
        this.cmdMakeInvisible.setToolTipText(NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.cmdMakeInvisible.toolTipText"));
        this.cmdMakeInvisible.setMargin(new Insets(2, 1, 2, 1));
        this.cmdMakeInvisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWidget.this.cmdMakeInvisibleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdMakeInvisible);
        this.cmdCopyToClipboard.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/layerwidget/res/clipboard16.png")));
        this.cmdCopyToClipboard.setToolTipText(NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.cmdCopyToClipboard.toolTipText"));
        this.cmdCopyToClipboard.setFocusable(false);
        this.cmdCopyToClipboard.setHorizontalTextPosition(0);
        this.cmdCopyToClipboard.setMargin(new Insets(2, 1, 2, 1));
        this.cmdCopyToClipboard.setVerticalTextPosition(3);
        this.cmdCopyToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerWidget.this.cmdCopyToClipboardActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdCopyToClipboard);
        this.jPanel1.add((Component)this.jToolBar1, "Center");
        this.add((Component)this.jPanel1, "North");
    }

    public void removeAllLayers() {
        this.activeLayerModel.removeAllLayers();
    }

    private void cmdRefreshSingleLayerActionPerformed(ActionEvent evt) {
        final TreePath[] tps = this.treeTable.getTree().getSelectionPaths();
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                if (tps != null) {
                    for (TreePath tp : tps) {
                        if (tp != null && tp.getLastPathComponent() instanceof RetrievalServiceLayer) {
                            ((MapService)tp.getLastPathComponent()).setBoundingBox(LayerWidget.this.mapC.getCurrentBoundingBoxFromCamera());
                            ((RetrievalServiceLayer)tp.getLastPathComponent()).retrieve(true);
                            continue;
                        }
                        if (tp == null || !(tp.getParentPath().getLastPathComponent() instanceof RetrievalServiceLayer)) continue;
                        ((RetrievalServiceLayer)tp.getParentPath().getLastPathComponent()).retrieve(true);
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                LayerWidget.this.treeTable.getTree().setSelectionPaths(tps);
                StaticSwingTools.jTableScrollToVisible((JTable)LayerWidget.this.treeTable, (int)LayerWidget.this.treeTable.getSelectedRow(), (int)0);
                LayerWidget.this.treeTable.getTree().setSelectionPaths(tps);
            }
        };
        worker.execute();
    }

    private void cmdDownActionPerformed(ActionEvent evt) {
        final TreePath[] tps = this.treeTable.getTree().getSelectionPaths();
        if (tps != null) {
            Arrays.sort(tps, new Comparator<TreePath>(){

                @Override
                public int compare(TreePath o1, TreePath o2) {
                    Integer pos = LayerWidget.this.activeLayerModel.getLayerPosition(o1);
                    return pos.compareTo(LayerWidget.this.activeLayerModel.getLayerPosition(o2));
                }
            });
            for (TreePath tp : tps) {
                if (tp != null) {
                    this.activeLayerModel.moveLayerDown(tp);
                }
                if (!EventQueue.isDispatchThread()) continue;
                this.log.warn((Object)"InvokeLater in EDT");
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayerWidget.this.treeTable.getTree().setSelectionPaths(tps);
                StaticSwingTools.jTableScrollToVisible((JTable)LayerWidget.this.treeTable, (int)LayerWidget.this.treeTable.getSelectedRow(), (int)0);
            }
        });
    }

    private void cmdUpActionPerformed(ActionEvent evt) {
        final TreePath[] tps = this.treeTable.getTree().getSelectionPaths();
        if (tps != null) {
            Arrays.sort(tps, new Comparator<TreePath>(){

                @Override
                public int compare(TreePath o1, TreePath o2) {
                    Integer pos = LayerWidget.this.activeLayerModel.getLayerPosition(o1);
                    return pos.compareTo(LayerWidget.this.activeLayerModel.getLayerPosition(o2)) * -1;
                }
            });
            for (TreePath tp : tps) {
                if (tp != null) {
                    this.activeLayerModel.moveLayerUp(tp);
                }
                if (!EventQueue.isDispatchThread()) continue;
                this.log.warn((Object)"InvokeLater in EDT");
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayerWidget.this.treeTable.getTree().setSelectionPaths(tps);
                StaticSwingTools.jTableScrollToVisible((JTable)LayerWidget.this.treeTable, (int)LayerWidget.this.treeTable.getSelectedRow(), (int)0);
            }
        });
    }

    private void cmdMakeInvisibleActionPerformed(ActionEvent evt) {
        final TreePath[] tps = this.treeTable.getTree().getSelectionPaths();
        if (tps != null) {
            for (TreePath tp : tps) {
                if (tp == null) continue;
                this.activeLayerModel.handleVisibility(tp);
            }
        }
        if (EventQueue.isDispatchThread()) {
            this.log.warn((Object)"InvokeLater in EDT");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayerWidget.this.treeTable.getTree().setSelectionPaths(tps);
            }
        });
    }

    private void cmdDisableActionPerformed(ActionEvent evt) {
        final TreePath[] tps = this.treeTable.getTree().getSelectionPaths();
        if (tps != null) {
            for (TreePath tp : tps) {
                if (tp != null) {
                    this.activeLayerModel.disableLayer(tp);
                }
                if (!EventQueue.isDispatchThread()) continue;
                this.log.warn((Object)"InvokeLater in EDT");
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayerWidget.this.treeTable.getTree().setSelectionPaths(tps);
            }
        });
    }

    private void cmdTreeCollapseActionPerformed(ActionEvent evt) {
        this.treeTable.getColumnModel().getColumn(3).getCellEditor().stopCellEditing();
    }

    private void cmdRemoveActionPerformed(ActionEvent evt) {
        try {
            TreePath[] tps = this.treeTable.getTree().getSelectionPaths();
            if (tps != null) {
                int row = -1;
                for (TreePath tp : tps) {
                    row = this.treeTable.getSelectedRow();
                    if (tp == null) continue;
                    this.activeLayerModel.removeLayer(tp);
                }
                final int lastSelectedRow = row;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        int selectedRow = lastSelectedRow;
                        if (selectedRow >= LayerWidget.this.treeTable.getRowCount()) {
                            selectedRow = LayerWidget.this.treeTable.getRowCount() - 1;
                        }
                        if (selectedRow != -1) {
                            LayerWidget.this.treeTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                        }
                    }
                };
                EventQueue.invokeLater(r);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error during removal of layer", (Throwable)e);
        }
    }

    private void cmdZoomToFullExtentActionPerformed(ActionEvent evt) {
        TreePath[] tps = this.treeTable.getTree().getSelectionPaths();
        ZoomToLayerWorker worker = new ZoomToLayerWorker(tps, 10);
        worker.execute();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            Class<?> classInfo = ClassLoader.getSystemClassLoader().loadClass("de.cismet.cismap.cidslayer.CidsLayer");
            this.activeLayerModel.addLayer((RetrievalServiceLayer)classInfo.newInstance());
        }
        catch (ClassNotFoundException ex) {
            this.log.error((Object)"ClassNotFound", (Throwable)ex);
        }
        catch (InstantiationException ex) {
            this.log.error((Object)"InstantiationException", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            this.log.error((Object)"IllegalAccessException", (Throwable)ex);
        }
    }

    private void cmdCopyToClipboardActionPerformed(ActionEvent evt) {
        String url;
        TreePath tp = this.treeTable.getTree().getSelectionPath();
        if (tp != null && (url = this.extractUrlFromServie(tp.getLastPathComponent())) != null) {
            StringSelection selection = new StringSelection(url);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, null);
        }
    }

    public ActiveLayerModel getMappingModel() {
        return this.activeLayerModel;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Tester().setVisible(true);
            }
        });
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        LayerDropUtils.drop(dtde, this.activeLayerModel, (JComponent)this);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public double getScale() {
        return 2.0;
    }

    public Image getErrorImage() {
        return this.errorImage;
    }

    public void setErrorImage(Image errorImage) {
        this.errorImage = errorImage;
    }

    @Deprecated
    public Element getConfiguration() throws NoWriteError {
        return this.activeLayerModel.getConfiguration();
    }

    @Deprecated
    public void masterConfigure(Element e) {
        this.activeLayerModel.masterConfigure(e);
    }

    @Deprecated
    public void configure(Element e) {
        this.activeLayerModel.configure(e);
    }

    public void configure(Element e, boolean merge) {
        this.activeLayerModel.configure(e, true);
    }

    public static List<String> getCapabilities(Element e, List<String> v) {
        try {
            if (e.getName().equals("capabilities") && e.getAttribute("type") != null && (e.getAttribute("type").getValue().equals("OGC") || e.getAttribute("type").getValue().equals("OGC-WMS"))) {
                String url = e.getTextTrim();
                if (!v.contains(url)) {
                    v.add(url);
                    return v;
                }
            } else {
                for (Object elem : e.getChildren()) {
                    if (!(elem instanceof Element)) continue;
                    LayerWidget.getCapabilities((Element)elem, v);
                }
            }
            return v;
        }
        catch (Exception ex) {
            return new ArrayList<String>(0);
        }
    }

    public JTreeTable getTreeTable() {
        return this.treeTable;
    }

    private boolean isSlidableWMSServiceLayerGroup(Object lastPathComponent) {
        if (!(lastPathComponent instanceof DeegreeLayer)) {
            return false;
        }
        DeegreeLayer layer = (DeegreeLayer)lastPathComponent;
        List<String> keywords = Arrays.asList(layer.getKeywords());
        return keywords.contains("cismapSlidingLayerGroup");
    }

    private static void hackDragAndDropDataFlavors() {
        SystemFlavorMap sfm = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
        String nativeValue = "application/x-java-file-list";
        DataFlavor dataFlavor = new DataFlavor("application/x-java-file-list; charset=ASCII; class=java.util.List", "File List");
        sfm.addUnencodedNativeForFlavor(dataFlavor, "application/x-java-file-list");
        sfm.addFlavorForUnencodedNative("application/x-java-file-list", dataFlavor);
    }

    public JComponent getGuiComponent() {
        return this;
    }

    public String getPermissionString() {
        return "NoPermissionRequired";
    }

    public String getViewTitle() {
        return NbBundle.getMessage(LayerWidget.class, (String)"LayerWidget.getViewTitle");
    }

    public Icon getViewIcon() {
        ImageIcon icoMap = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/layers.png"));
        return Static2DTools.borderIcon((Icon)icoMap, (int)0, (int)3, (int)0, (int)1);
    }

    static {
        try {
            ResourceBundle transformkRules = ResourceBundle.getBundle("UrlDisplayTransform", Locale.getDefault());
            if (transformkRules != null) {
                for (String key : transformkRules.keySet()) {
                    String transformKey = null;
                    int index = -1;
                    if (key.endsWith(SEARCH_STRING)) {
                        transformKey = key.substring(0, key.length() - SEARCH_STRING.length());
                        index = 0;
                    } else if (key.endsWith(EXTRACTION_STRING)) {
                        transformKey = key.substring(0, key.length() - EXTRACTION_STRING.length());
                        index = 1;
                    } else if (key.endsWith(PREFIX_STRING)) {
                        transformKey = key.substring(0, key.length() - PREFIX_STRING.length());
                        index = 2;
                    } else if (key.endsWith(POSTFIX_STRING)) {
                        transformKey = key.substring(0, key.length() - POSTFIX_STRING.length());
                        index = 3;
                    } else if (key.endsWith(CONCAT_STRING)) {
                        transformKey = key.substring(0, key.length() - CONCAT_STRING.length());
                        index = 4;
                    }
                    if (transformKey == null) continue;
                    String[] rule = URL_TRANSFORMATION_RULES.get(transformKey);
                    if (rule == null) {
                        rule = new String[5];
                        URL_TRANSFORMATION_RULES.put(transformKey, rule);
                        URL_TRANSFORMATION_RULES_ORDER.add(transformKey);
                    }
                    rule[index] = transformkRules.getString(key);
                }
                Collections.sort(URL_TRANSFORMATION_RULES_ORDER);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"No rules found to transform urls", (Throwable)e);
        }
    }
}

